/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ExtendedProperty;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ExtendedPropertyEditorComposite
extends Composite
implements SelectionListener {
    private transient LinkedHashMap propMap = null;
    private transient Table table = null;
    private transient TableEditor editorValue = null;
    private transient Text txtNewKey = null;
    private transient Button btnAdd = null;
    private transient Button btnRemove = null;
    private transient EList extendedProperties;
    private transient ChartWizardContext context;

    public ExtendedPropertyEditorComposite(Composite parent, int style, EList extendedProperties, ChartWizardContext context) {
        super(parent, style);
        this.extendedProperties = extendedProperties;
        this.context = context;
        this.init();
        this.placeComponents();
    }

    private void init() {
        this.propMap = new LinkedHashMap(6);
        for (int i = 0; i < this.extendedProperties.size(); ++i) {
            ExtendedProperty property = (ExtendedProperty)this.extendedProperties.get(i);
            this.propMap.put(property.getName(), property);
        }
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.setLayout((Layout)glContent);
        this.table = new Table((Composite)this, 67588);
        GridData gdTable = new GridData(1808);
        this.table.setLayoutData((Object)gdTable);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tcKey = new TableColumn(this.table, 0x1000000);
        tcKey.setWidth(186);
        tcKey.setText(Messages.getString("PropertyEditorDialog.Lbl.Key"));
        TableColumn tcValue = new TableColumn(this.table, 16384);
        tcValue.setWidth(186);
        tcValue.setText(Messages.getString("PropertyEditorDialog.Lbl.Value"));
        this.editorValue = new TableEditor(this.table);
        this.editorValue.setColumn(1);
        this.editorValue.grabHorizontal = true;
        this.editorValue.minimumWidth = 30;
        this.table.addSelectionListener((SelectionListener)this);
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = 3;
        glButtons.horizontalSpacing = 5;
        glButtons.verticalSpacing = 5;
        glButtons.marginWidth = 0;
        glButtons.marginHeight = 0;
        Composite cmpButtons = new Composite((Composite)this, 0);
        GridData gdCMPButtons = new GridData(768);
        cmpButtons.setLayoutData((Object)gdCMPButtons);
        cmpButtons.setLayout((Layout)glButtons);
        this.txtNewKey = new Text(cmpButtons, 2052);
        GridData gdTXTNewKey = new GridData(768);
        gdTXTNewKey.grabExcessHorizontalSpace = true;
        this.txtNewKey.setLayoutData((Object)gdTXTNewKey);
        this.btnAdd = new Button(cmpButtons, 8);
        GridData gdBTNAdd = new GridData(128);
        gdBTNAdd.grabExcessHorizontalSpace = false;
        this.btnAdd.setLayoutData((Object)gdBTNAdd);
        this.btnAdd.setText(Messages.getString("PropertyEditorDialog.Lbl.Add"));
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnRemove = new Button(cmpButtons, 8);
        GridData gdBTNRemove = new GridData(128);
        gdBTNRemove.grabExcessHorizontalSpace = false;
        this.btnRemove.setLayoutData((Object)gdBTNRemove);
        this.btnRemove.setText(Messages.getString("PropertyEditorDialog.Lbl.Remove"));
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.populateTable();
    }

    private void populateTable() {
        Iterator keys = this.propMap.keySet().iterator();
        while (keys.hasNext()) {
            ExtendedProperty property = (ExtendedProperty)this.propMap.get(keys.next());
            String[] sProperty = new String[]{property.getName(), property.getValue()};
            TableItem tiProp = new TableItem(this.table, 0);
            tiProp.setBackground(this.getSelectionColor());
            tiProp.setText(sProperty);
        }
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
        } else {
            this.txtNewKey.forceFocus();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnAdd)) {
            String sKey = this.txtNewKey.getText();
            if (sKey.length() > 0 && !this.propMap.containsKey(sKey)) {
                String[] sProperty = new String[]{sKey, ""};
                TableItem tiProp = new TableItem(this.table, 0);
                tiProp.setBackground(this.getSelectionColor());
                tiProp.setText(sProperty);
                this.updateModel(sProperty[0], sProperty[1]);
                this.txtNewKey.setText("");
            }
        } else if (e.getSource().equals(this.btnRemove)) {
            if (this.table.getSelection().length != 0) {
                Control editor;
                String key = this.table.getSelection()[0].getText(0);
                ExtendedProperty property = (ExtendedProperty)this.propMap.get(key);
                if (property != null) {
                    this.extendedProperties.remove((Object)property);
                    this.propMap.remove(key);
                    this.table.remove(this.table.getSelectionIndex());
                }
                if ((editor = this.editorValue.getEditor()) != null) {
                    editor.dispose();
                }
            }
        } else if (e.getSource().equals(this.table)) {
            TableItem item;
            Control oldEditor = this.editorValue.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
            if ((item = (TableItem)e.item) == null) {
                return;
            }
            Text newEditor = new Text((Composite)this.table, 0);
            newEditor.setText(item.getText(1));
            newEditor.addListener(16, new Listener(){

                public void handleEvent(Event event) {
                    Text text = (Text)event.widget;
                    ExtendedPropertyEditorComposite.this.editorValue.getItem().setText(1, text.getText());
                    ExtendedPropertyEditorComposite.this.updateModel(item.getText(0), text.getText());
                }
            });
            newEditor.selectAll();
            newEditor.setFocus();
            this.editorValue.setEditor((Control)newEditor, item, 1);
        }
    }

    private void updateModel(String key, String value) {
        ExtendedProperty property = (ExtendedProperty)this.propMap.get(key);
        if (property == null) {
            property = AttributeFactory.eINSTANCE.createExtendedProperty();
            property.setName(key);
            property.setValue(value);
            property.eAdapters().addAll((Collection)this.context.getModel().eAdapters());
            this.extendedProperties.add((Object)property);
            this.propMap.put(key, property);
        } else {
            property.setValue(value);
        }
    }

    private Color getSelectionColor() {
        return this.getDisplay().getSystemColor(27);
    }
}

