/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class InsetsComposite
extends Composite
implements ModifyListener {
    private transient String sUnits = null;
    public static final int INSETS_CHANGED_EVENT = 1;
    private transient Insets insets = null;
    private transient Group grpInsets = null;
    private transient Label lblTop = null;
    private transient Label lblLeft = null;
    private transient Label lblBottom = null;
    private transient Label lblRight = null;
    private transient LocalizedNumberEditorComposite txtTop = null;
    private transient LocalizedNumberEditorComposite txtLeft = null;
    private transient LocalizedNumberEditorComposite txtBottom = null;
    private transient LocalizedNumberEditorComposite txtRight = null;
    private transient Vector vListeners = null;
    private transient IUIServiceProvider serviceprovider = null;
    private transient boolean bEnabled = true;
    private transient int numberRows = 2;

    public InsetsComposite(Composite parent, int style, Insets insets, String sUnits, IUIServiceProvider serviceprovider) {
        this(parent, style, 2, insets, sUnits, serviceprovider);
    }

    public InsetsComposite(Composite parent, int style, int numberRows, Insets insets, String sUnits, IUIServiceProvider serviceprovider) {
        super(parent, style);
        this.numberRows = numberRows;
        this.insets = insets;
        this.sUnits = sUnits;
        this.serviceprovider = serviceprovider;
        this.init();
        this.placeComponents();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        GridLayout glGroup = new GridLayout();
        glGroup.horizontalSpacing = 5;
        glGroup.verticalSpacing = 5;
        glGroup.marginHeight = 4;
        glGroup.marginWidth = 4;
        glGroup.numColumns = 8 / this.numberRows;
        this.setLayout((Layout)flMain);
        this.grpInsets = new Group((Composite)this, 0);
        this.grpInsets.setLayout((Layout)glGroup);
        this.grpInsets.setText(Messages.getFormattedString("InsetsComposite.Lbl.Insets", LiteralHelper.unitsOfMeasurementSet.getDisplayNameByName(this.sUnits)));
        this.lblTop = new Label((Composite)this.grpInsets, 0);
        GridData gdLTop = new GridData(4);
        gdLTop.heightHint = 20;
        this.lblTop.setLayoutData((Object)gdLTop);
        this.lblTop.setText(Messages.getString("InsetsComposite.Lbl.Top"));
        this.txtTop = new LocalizedNumberEditorComposite((Composite)this.grpInsets, 2048);
        GridData gdTTop = new GridData(1808);
        gdTTop.heightHint = 20;
        gdTTop.widthHint = 45;
        this.txtTop.setLayoutData(gdTTop);
        double dblPoints = this.insets.getTop();
        double dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", this.sUnits);
        this.txtTop.setValue(dblCurrent);
        this.txtTop.addModifyListener(this);
        this.lblLeft = new Label((Composite)this.grpInsets, 0);
        GridData gdLLeft = new GridData(4);
        gdLLeft.heightHint = 20;
        this.lblLeft.setLayoutData((Object)gdLLeft);
        this.lblLeft.setText(Messages.getString("InsetsComposite.Lbl.Left"));
        this.txtLeft = new LocalizedNumberEditorComposite((Composite)this.grpInsets, 2048);
        GridData gdTLeft = new GridData(1808);
        gdTLeft.heightHint = 20;
        gdTLeft.widthHint = 45;
        this.txtLeft.setLayoutData(gdTLeft);
        dblPoints = this.insets.getLeft();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", this.sUnits);
        this.txtLeft.setValue(dblCurrent);
        this.txtLeft.addModifyListener(this);
        this.lblBottom = new Label((Composite)this.grpInsets, 0);
        GridData gdLBottom = new GridData(4);
        gdLBottom.heightHint = 20;
        this.lblBottom.setLayoutData((Object)gdLBottom);
        this.lblBottom.setText(Messages.getString("InsetsComposite.Lbl.Bottom"));
        this.txtBottom = new LocalizedNumberEditorComposite((Composite)this.grpInsets, 2048);
        GridData gdTBottom = new GridData(1808);
        gdTBottom.heightHint = 20;
        gdTBottom.widthHint = 45;
        this.txtBottom.setLayoutData(gdTBottom);
        dblPoints = this.insets.getBottom();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", this.sUnits);
        this.txtBottom.setValue(dblCurrent);
        this.txtBottom.addModifyListener(this);
        this.lblRight = new Label((Composite)this.grpInsets, 0);
        GridData gdLRight = new GridData(4);
        gdLRight.heightHint = 20;
        this.lblRight.setLayoutData((Object)gdLRight);
        this.lblRight.setText(Messages.getString("InsetsComposite.Lbl.Right"));
        this.txtRight = new LocalizedNumberEditorComposite((Composite)this.grpInsets, 2048);
        GridData gdTRight = new GridData(1808);
        gdTRight.heightHint = 20;
        gdTRight.widthHint = 45;
        this.txtRight.setLayoutData(gdTRight);
        dblPoints = this.insets.getRight();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", this.sUnits);
        this.txtRight.setValue(dblCurrent);
        this.txtRight.addModifyListener(this);
    }

    public void setEnabled(boolean bState) {
        this.lblTop.setEnabled(bState);
        this.txtTop.setEnabled(bState);
        this.lblLeft.setEnabled(bState);
        this.txtLeft.setEnabled(bState);
        this.lblBottom.setEnabled(bState);
        this.txtBottom.setEnabled(bState);
        this.lblRight.setEnabled(bState);
        this.txtRight.setEnabled(bState);
        this.grpInsets.setEnabled(bState);
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public void setInsets(Insets insets, String sUnits) {
        if (insets == null) {
            return;
        }
        this.insets = insets;
        this.sUnits = sUnits;
        double dblPoints = insets.getBottom();
        double dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", sUnits);
        this.txtBottom.setValue(dblCurrent);
        dblPoints = insets.getLeft();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", sUnits);
        this.txtLeft.setValue(dblCurrent);
        dblPoints = insets.getTop();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", sUnits);
        this.txtTop.setValue(dblCurrent);
        dblPoints = insets.getRight();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", sUnits);
        this.txtRight.setValue(dblCurrent);
        this.grpInsets.setText(Messages.getFormattedString("InsetsComposite.Lbl.Insets", LiteralHelper.unitsOfMeasurementSet.getDisplayNameByName(sUnits)));
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    public Point getPreferredSize() {
        return new Point(300, 70);
    }

    public void modifyText(ModifyEvent event) {
        double dblCurrent = -1.0;
        double dblPoints = -1.0;
        if (event.widget.equals((Object)this.txtTop)) {
            dblCurrent = this.txtTop.getValue();
            dblPoints = this.serviceprovider.getConvertedValue(dblCurrent, this.sUnits, "Points");
            this.insets.setTop(dblPoints);
        } else if (event.widget.equals((Object)this.txtLeft)) {
            dblCurrent = this.txtLeft.getValue();
            dblPoints = this.serviceprovider.getConvertedValue(dblCurrent, this.sUnits, "Points");
            this.insets.setLeft(dblPoints);
        } else if (event.widget.equals((Object)this.txtBottom)) {
            dblCurrent = this.txtBottom.getValue();
            dblPoints = this.serviceprovider.getConvertedValue(dblCurrent, this.sUnits, "Points");
            this.insets.setBottom(dblPoints);
        } else if (event.widget.equals((Object)this.txtRight)) {
            dblCurrent = this.txtRight.getValue();
            dblPoints = this.serviceprovider.getConvertedValue(dblCurrent, this.sUnits, "Points");
            this.insets.setRight(dblPoints);
        }
    }
}

