/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class TextComboChoiceCanvas
extends Canvas
implements PaintListener,
FocusListener {
    String comboText;
    Font textFont;
    boolean isFocusIn = false;

    public TextComboChoiceCanvas(Composite parent, int iStyle, String comboText) {
        super(parent, iStyle);
        this.comboText = comboText;
        this.addPaintListener(this);
        this.addFocusListener(this);
    }

    public String getText() {
        return this.comboText;
    }

    public void setText(String comboText) {
        this.comboText = comboText;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void paintControl(PaintEvent pe) {
        if (this.isEnabled() && this.isFocusControl()) {
            this.isFocusIn = true;
        }
        Color cForeground = null;
        Color cBackground = null;
        if (this.isEnabled()) {
            cForeground = this.getDisplay().getSystemColor(24);
            cBackground = this.getDisplay().getSystemColor(25);
        } else {
            cForeground = this.getDisplay().getSystemColor(16);
            cBackground = this.getDisplay().getSystemColor(22);
        }
        GC gc = pe.gc;
        if (this.isFocusIn) {
            gc.setBackground(this.getDisplay().getSystemColor(26));
            gc.setForeground(this.getDisplay().getSystemColor(27));
        } else {
            gc.setBackground(cBackground);
            gc.setForeground(cForeground);
        }
        gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
        if (this.textFont != null) {
            gc.setFont(this.textFont);
        }
        gc.drawText(this.comboText, 2, 2);
    }

    public void focusGained(FocusEvent e) {
        this.isFocusIn = true;
    }

    public void focusLost(FocusEvent e) {
        this.isFocusIn = false;
    }
}

