/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.TriggerDataComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class TriggerEditorComposite
extends Composite
implements SelectionListener {
    private transient List lstTriggers = null;
    private transient TriggerDataComposite tdcSelected = null;
    private transient Button btnAdd = null;
    private transient Button btnUpdate = null;
    private transient Button btnRemove = null;
    private static final String TRIGGER_SEPARATOR = " - ";
    private transient int iCurrentSelection = -1;
    private transient EList triggers = null;
    private transient ChartWizardContext wizardContext;
    private transient boolean bEnableURLParameters;
    private transient boolean bEnableShowTooltipValue;

    public TriggerEditorComposite(Composite parent, int style, EList triggers, ChartWizardContext wizardContext, boolean bEnableURLParameters, boolean bEnableShowTooltipValue) {
        super(parent, style);
        this.triggers = triggers;
        this.wizardContext = wizardContext;
        this.bEnableURLParameters = bEnableURLParameters;
        this.bEnableShowTooltipValue = bEnableShowTooltipValue;
        this.init();
        this.placeComponents();
    }

    public TriggerEditorComposite(Composite parent, int style, EList triggers) {
        super(parent, style);
        this.triggers = triggers;
        this.bEnableURLParameters = false;
        this.bEnableShowTooltipValue = false;
        this.init();
        this.placeComponents();
    }

    private void init() {
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginHeight = 2;
        glContent.marginWidth = 4;
        this.setLayout((Layout)glContent);
        GridLayout glCMPList = new GridLayout();
        glCMPList.numColumns = 2;
        glCMPList.verticalSpacing = 5;
        glCMPList.horizontalSpacing = 5;
        Composite cmpList = new Composite((Composite)this, 0);
        GridData gdCMPList = new GridData(1808);
        cmpList.setLayoutData((Object)gdCMPList);
        cmpList.setLayout((Layout)glCMPList);
        this.lstTriggers = new List(cmpList, 2308);
        GridData gdLSTTriggers = new GridData(1808);
        gdLSTTriggers.horizontalSpan = 2;
        gdLSTTriggers.widthHint = 150;
        gdLSTTriggers.grabExcessVerticalSpace = true;
        this.lstTriggers.setLayoutData((Object)gdLSTTriggers);
        this.lstTriggers.addSelectionListener((SelectionListener)this);
        GridLayout glCMPTrigger = new GridLayout();
        glCMPTrigger.verticalSpacing = 5;
        glCMPTrigger.horizontalSpacing = 5;
        Composite cmpTrigger = new Composite((Composite)this, 0);
        GridData gdCMPTrigger = new GridData(1808);
        cmpTrigger.setLayoutData((Object)gdCMPTrigger);
        cmpTrigger.setLayout((Layout)glCMPTrigger);
        this.tdcSelected = new TriggerDataComposite(cmpTrigger, 0, null, this.wizardContext, this.bEnableURLParameters, this.bEnableShowTooltipValue);
        GridData gdTDCSelected = new GridData(770);
        this.tdcSelected.setLayoutData(gdTDCSelected);
        this.btnRemove = new Button(cmpList, 8);
        GridData gdBTNRemove = new GridData(32);
        gdBTNRemove.grabExcessVerticalSpace = false;
        this.btnRemove.setLayoutData((Object)gdBTNRemove);
        this.btnRemove.setText(Messages.getString("TriggerEditorComposite.Lbl.Remove"));
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnAdd = new Button(cmpList, 8);
        GridData gdBTNAdd = new GridData(32);
        gdBTNAdd.grabExcessVerticalSpace = false;
        this.btnAdd.setLayoutData((Object)gdBTNAdd);
        this.btnAdd.setText(Messages.getString("TriggerEditorComposite.Lbl.Add"));
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnUpdate = new Button(cmpTrigger, 8);
        GridData gdBTNUpdate = new GridData(34);
        gdBTNUpdate.grabExcessVerticalSpace = false;
        this.btnUpdate.setLayoutData((Object)gdBTNUpdate);
        this.btnUpdate.setText(Messages.getString("TriggerEditorComposite.Lbl.Update"));
        this.btnUpdate.addSelectionListener((SelectionListener)this);
        this.populateList();
        this.refreshButtons();
    }

    private void refreshButtons() {
        this.btnRemove.setEnabled(this.lstTriggers.getSelectionIndex() != -1);
        this.btnUpdate.setEnabled(this.lstTriggers.getSelectionIndex() != -1);
    }

    private void populateList() {
        this.lstTriggers.removeAll();
        int i = this.triggers.size();
        for (int iT = 0; iT < i; ++iT) {
            this.lstTriggers.add(this.getTriggerAsString((Trigger)this.triggers.get(iT)));
        }
        if (i > 0) {
            this.lstTriggers.select(0);
            this.iCurrentSelection = this.lstTriggers.getSelectionIndex();
            this.tdcSelected.setTrigger((Trigger)this.triggers.get(this.iCurrentSelection));
        }
    }

    private String getTriggerAsString(Trigger trigger) {
        StringBuffer sbTrigger = new StringBuffer();
        sbTrigger.append(LiteralHelper.triggerConditionSet.getDisplayNameByName(trigger.getCondition().getName()));
        sbTrigger.append(TRIGGER_SEPARATOR);
        sbTrigger.append(LiteralHelper.actionTypeSet.getDisplayNameByName(trigger.getAction().getType().getName()));
        return sbTrigger.toString();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.lstTriggers)) {
            this.iCurrentSelection = this.lstTriggers.getSelectionIndex();
            this.tdcSelected.setTrigger((Trigger)this.triggers.get(this.iCurrentSelection));
            this.refreshButtons();
            return;
        }
        if (e.getSource().equals(this.btnRemove)) {
            if (this.iCurrentSelection == -1) {
                this.refreshButtons();
                return;
            }
            this.tdcSelected.clear();
            this.triggers.remove(this.iCurrentSelection);
            this.iCurrentSelection = -1;
        } else if (e.getSource().equals(this.btnAdd)) {
            this.triggers.add((Object)this.tdcSelected.getTrigger());
            this.tdcSelected.clear();
            this.iCurrentSelection = -1;
        } else if (e.getSource().equals(this.btnUpdate)) {
            if (this.iCurrentSelection != -1) {
                this.triggers.set(this.lstTriggers.getSelectionIndex(), (Object)this.tdcSelected.getTrigger());
                this.tdcSelected.clear();
            }
            this.iCurrentSelection = -1;
        }
        this.populateList();
        this.refreshButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

