/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.IChangeWithoutNotification;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.MultipleSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class MultipleSeriesComponent
extends DefaultSelectDataComponent {
    private transient EList[] seriesDefnsArray;
    private transient ChartWizardContext context = null;
    private transient String sTitle = null;
    private static final String LABEL_GROUPING_YSERIES = Messages.getString("MultipleSeriesComponent.Label.OptionalYSeriesGrouping");
    private static final String LABEL_GROUPING_OVERLAY = Messages.getString("MultipleSeriesComponent.Label.OptionalOverlayGrouping");
    private static final String LABEL_GROUPING_WITHOUTAXIS = Messages.getString("MultipleSeriesComponent.Label.OptionalGrouping");
    private transient ISelectDataCustomizeUI selectDataUI = null;
    private transient ArrayList components = new ArrayList();
    private transient boolean isSingle = false;
    private transient boolean useFirstOnly = true;

    public MultipleSeriesComponent(EList[] seriesDefnsArray, ChartWizardContext context, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this.seriesDefnsArray = seriesDefnsArray;
        this.context = context;
        this.sTitle = sTitle;
        this.selectDataUI = selectDataUI;
    }

    public MultipleSeriesComponent(EList seriesDefns, ChartWizardContext context, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this(new EList[]{seriesDefns}, context, sTitle, selectDataUI);
        this.isSingle = true;
    }

    public Composite createArea(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        cmp.setLayout((Layout)gridLayout);
        cmp.setLayoutData((Object)new GridData(768));
        Label topAngle = new Label(cmp, 0);
        topAngle.setImage(UIHelper.getImage((String)"icons/obj16/ra_topleft.gif"));
        for (int i = 0; i < this.seriesDefnsArray.length; ++i) {
            this.createRightGroupArea(cmp, i, this.seriesDefnsArray[i]);
            if (this.useFirstOnly) break;
        }
        Label bottomAngle = new Label(cmp, 0);
        bottomAngle.setImage(UIHelper.getImage((String)"icons/obj16/ra_bottomleft.gif"));
        return cmp;
    }

    private void createRightGroupArea(Composite parent, final int axisIndex, final EList seriesDefn) {
        final String strDesc = this.getGroupingDescription(axisIndex);
        DefaultSelectDataComponent subUIGroupY = new DefaultSelectDataComponent(){

            public Composite createArea(Composite parent) {
                Composite cmpGroup = ChartUIUtil.createCompositeWrapper((Composite)parent);
                cmpGroup.setLayoutData((Object)new GridData(768));
                Label lblRightYGrouping = new Label(cmpGroup, 64);
                GridData gd = new GridData();
                gd.widthHint = MultipleSeriesComponent.this.getStandardWidth() * 16;
                lblRightYGrouping.setLayoutData((Object)gd);
                lblRightYGrouping.setText(strDesc);
                int selectedSeriesIndex = 0;
                if (!MultipleSeriesComponent.this.useFirstOnly) {
                    selectedSeriesIndex = MultipleSeriesComponent.this.selectDataUI.getSeriesIndex()[axisIndex];
                }
                SeriesDefinition sd = (SeriesDefinition)seriesDefn.get(selectedSeriesIndex);
                if (seriesDefn != null && !seriesDefn.isEmpty()) {
                    ISelectDataComponent subUI = MultipleSeriesComponent.this.selectDataUI.getAreaComponent(2, sd, MultipleSeriesComponent.this.context, MultipleSeriesComponent.this.sTitle);
                    subUI.addListener(new Listener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void handleEvent(Event event) {
                            String query = event.text;
                            ChartAdapter.changeChartWithoutNotification((IChangeWithoutNotification)new IChangeWithoutNotification(this, query){
                                private final /* synthetic */ String val$query;
                                private final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$query = val$query;
                                }

                                public Object run() {
                                    ChartUIUtil.setAllGroupingQueryExceptFirst((Chart)MultipleSeriesComponent.access$300(1.access$600(2.access$500(this.this$2))).getModel(), (String)this.val$query);
                                    return null;
                                }
                            });
                        }

                        static /* synthetic */ 1 access$500(2 x0) {
                            return x0.this$1;
                        }
                    });
                    subUI.createArea(cmpGroup);
                    MultipleSeriesComponent.this.components.add(subUI);
                }
                Label lblSorting = new Label(cmpGroup, 0);
                lblSorting.setText(Messages.getString("MultipleSeriesComponent.Label.GroupSorting"));
                Combo cmbSorting = new Combo(cmpGroup, 12);
                cmbSorting.setLayoutData((Object)new GridData(768));
                String[] nss = LiteralHelper.sortOptionSet.getDisplayNames();
                for (int i = 0; i < nss.length; ++i) {
                    cmbSorting.add(nss[i]);
                }
                if (!sd.eIsSet((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting())) {
                    MultipleSeriesComponent.this.initSorting();
                }
                cmbSorting.select(LiteralHelper.sortOptionSet.getNameIndex(sd.getSorting().getName()));
                cmbSorting.addListener(13, new Listener(this, sd, cmbSorting){
                    private final /* synthetic */ SeriesDefinition val$sd;
                    private final /* synthetic */ Combo val$cmbSorting;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$sd = val$sd;
                        this.val$cmbSorting = val$cmbSorting;
                    }

                    public void handleEvent(Event event) {
                        this.val$sd.setSorting(SortOption.getByName((String)LiteralHelper.sortOptionSet.getNameByDisplayName(this.val$cmbSorting.getText())));
                        ChartAdapter.changeChartWithoutNotification((IChangeWithoutNotification)new IChangeWithoutNotification(this){
                            private final /* synthetic */ 4 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public Object run() {
                                List sds = ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)MultipleSeriesComponent.access$300(1.access$600(4.access$900(this.this$2))).getModel());
                                for (int i = 0; i < sds.size(); ++i) {
                                    if (i == 0) continue;
                                    SeriesDefinition sdf = (SeriesDefinition)sds.get(i);
                                    sdf.setSorting(SortOption.getByName((String)LiteralHelper.sortOptionSet.getNameByDisplayName(4.access$1000(this.this$2).getText())));
                                }
                                return null;
                            }
                        });
                    }

                    static /* synthetic */ 1 access$900(4 x0) {
                        return x0.this$1;
                    }

                    static /* synthetic */ Combo access$1000(4 x0) {
                        return x0.val$cmbSorting;
                    }
                });
                return cmpGroup;
            }

            static /* synthetic */ MultipleSeriesComponent access$600(1 x0) {
                return x0.MultipleSeriesComponent.this;
            }
        };
        subUIGroupY.createArea(parent);
        this.components.add(subUIGroupY);
    }

    private void initSorting() {
        ChartAdapter.changeChartWithoutNotification((IChangeWithoutNotification)new IChangeWithoutNotification(){

            public Object run() {
                List sds = ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)MultipleSeriesComponent.this.context.getModel());
                for (int i = 0; i < sds.size(); ++i) {
                    SeriesDefinition sdf = (SeriesDefinition)sds.get(i);
                    sdf.setSorting(SortOption.ASCENDING_LITERAL);
                }
                return null;
            }
        });
    }

    private int getStandardWidth() {
        GC gc = new GC((Drawable)Display.getCurrent());
        int width = gc.textExtent((String)"X").x;
        gc.dispose();
        return width;
    }

    public void selectArea(boolean selected, Object data) {
        for (int i = 0; i < this.components.size(); ++i) {
            ((ISelectDataComponent)this.components.get(i)).selectArea(selected, data);
        }
    }

    public void dispose() {
        for (int i = 0; i < this.components.size(); ++i) {
            ((ISelectDataComponent)this.components.get(i)).dispose();
        }
        super.dispose();
    }

    private String getGroupingDescription(int axisIndex) {
        if (this.isSingle) {
            return LABEL_GROUPING_WITHOUTAXIS;
        }
        if (axisIndex == 0) {
            return LABEL_GROUPING_YSERIES;
        }
        return LABEL_GROUPING_OVERLAY;
    }
}

