/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.dialogs;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.util.Properties;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DriverPropertySourceProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class EditDriverDialog
extends TitleAreaDialog {
    public static final String MEMENTO_ROOT = "Drivers Edit Driver_Dialog_Root";
    public static final String MEMENTO_DIALOG_SIZE_HEIGHT = "Dialog_Size_Height";
    public static final String MEMENTO_DIALOG_SIZE_WIDTH = "Dialog_Size_Width";
    private static String previouslyBrowsedDirectory = "";
    private PageBook book = null;
    private IPropertySet mPropertySet = null;
    private TemplateDescriptor descriptor = null;
    private List list;
    private Text mDriverNameText;
    private Text mDriverTypeText;
    private Button mAddJar;
    private Button mEditJar;
    private Button mRemoveJar;
    private Button mClearAll;
    private Button mOKButton;
    private String mDriverName;
    private String mJarList;
    private String mDriverTypeID;

    public EditDriverDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x860);
    }

    public EditDriverDialog(Shell parentShell, String driverTypeID) {
        this(parentShell);
        this.mDriverTypeID = driverTypeID;
        this.descriptor = TemplateDescriptor.getDriverTemplateDescriptor((String)this.mDriverTypeID);
    }

    public EditDriverDialog(Shell parentShell, IPropertySet pset) {
        this(parentShell);
        this.mPropertySet = pset;
        if (this.mPropertySet.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType") != null) {
            String driverType;
            this.mDriverTypeID = driverType = this.mPropertySet.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
            this.descriptor = TemplateDescriptor.getDriverTemplateDescriptor((String)this.mDriverTypeID);
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        PropertySheetPage page = new PropertySheetPage();
        page.createControl((Composite)book);
        return page;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout((Layout)new GridLayout());
        Composite contents = new Composite(area, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(contents, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.label.driverNameText"));
        this.mDriverNameText = new Text(composite, 2048);
        this.mDriverNameText.setLayoutData((Object)new GridData(768));
        this.mDriverNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditDriverDialog.this.mDriverName = EditDriverDialog.this.mDriverNameText.getText();
                EditDriverDialog.this.validateName();
            }
        });
        label = new Label(composite, 0);
        label.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.label.driverTypeText"));
        this.mDriverTypeText = new Text(composite, 2048);
        this.mDriverTypeText.setLayoutData((Object)new GridData(768));
        this.mDriverTypeText.setEnabled(false);
        label = new Label(composite, 0);
        label.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.label.driverFileList"));
        Composite composite_1 = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = -5;
        gridData.horizontalSpan = 2;
        composite_1.setLayoutData((Object)gridData);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_1.setLayout((Layout)gridLayout_1);
        this.list = new List(composite_1, 2816);
        GridData gridData_1 = new GridData(1808);
        gridData_1.verticalSpan = 4;
        gridData_1.horizontalSpan = 2;
        this.list.setLayoutData((Object)gridData_1);
        this.list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = EditDriverDialog.this.list.getSelectionCount() > 0;
                EditDriverDialog.this.mEditJar.setEnabled(enabled);
                EditDriverDialog.this.mRemoveJar.setEnabled(enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mAddJar = new Button(composite_1, 0);
        this.mAddJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDriverDialog.this.handleLocationBrowseButtonPressed();
                EditDriverDialog.this.updateJarList();
            }
        });
        this.mAddJar.setLayoutData((Object)new GridData(256));
        this.mAddJar.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.addJar"));
        this.mEditJar = new Button(composite_1, 0);
        this.mEditJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditDriverDialog.this.list.getSelectionCount() > 0) {
                    String selectedItem = EditDriverDialog.this.list.getItem(EditDriverDialog.this.list.getSelectionIndex());
                    EditDriverDialog.this.handleLocationEditButtonPressed(selectedItem);
                    EditDriverDialog.this.updateJarList();
                }
            }
        });
        this.mEditJar.setLayoutData((Object)new GridData(256));
        this.mEditJar.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.editJar"));
        this.mRemoveJar = new Button(composite_1, 0);
        this.mRemoveJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditDriverDialog.this.list.getSelectionCount() > 0) {
                    String[] selected = EditDriverDialog.this.list.getSelection();
                    for (int i = 0; i < selected.length; ++i) {
                        EditDriverDialog.this.list.remove(selected[i]);
                    }
                    EditDriverDialog.this.updateJarList();
                }
            }
        });
        this.mRemoveJar.setLayoutData((Object)new GridData(256));
        this.mRemoveJar.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.removeJar"));
        this.mClearAll = new Button(composite_1, 0);
        this.mClearAll.setLayoutData((Object)new GridData(258));
        this.mClearAll.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.clearAllJars"));
        this.mClearAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDriverDialog.this.list.removeAll();
                EditDriverDialog.this.updateJarList();
            }
        });
        if (this.hasVisibleProperties()) {
            label = new Label(composite, 0);
            label.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.label.properties"));
            Composite composite_2 = new Composite(composite, 0);
            GridData gridData2 = new GridData(1808);
            gridData2.horizontalIndent = -5;
            gridData2.horizontalSpan = 2;
            composite_2.setLayoutData((Object)gridData2);
            GridLayout gridLayout_2 = new GridLayout();
            gridLayout_2.numColumns = 1;
            composite_2.setLayout((Layout)gridLayout_2);
            this.book = new PageBook(composite_2, 0);
            this.book.setLayoutData((Object)new GridData(1808));
            PropertySheetPage page = new PropertySheetPage();
            page.createControl((Composite)this.book);
            DriverPropertySourceProvider mpsp = null;
            mpsp = this.mPropertySet != null ? new DriverPropertySourceProvider(this.mPropertySet, this.descriptor) : new DriverPropertySourceProvider();
            page.setPropertySourceProvider((IPropertySourceProvider)mpsp);
            this.book.showPage(page.getControl());
            page.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.mPropertySet));
        }
        this.setTitle(DriverMgmtMessages.getString((String)"EditDriverDialog.title"));
        this.setMessage(DriverMgmtMessages.getString((String)"EditDriverDialog.message"));
        boolean enabled = this.list.getSelectionCount() > 0;
        this.mEditJar.setEnabled(enabled);
        this.mRemoveJar.setEnabled(enabled);
        this.updateFromPropertySet();
        this.isValid(true);
        return area;
    }

    private void validateName() {
        boolean isOk = false;
        String testName = this.mDriverName;
        DriverInstance obj = DriverManager.getInstance().getDriverInstanceByName(testName);
        if (obj == null && !testName.equals(this.mPropertySet.getName()) || obj != null && testName.equals(this.mPropertySet.getName())) {
            isOk = true;
            this.setErrorMessage(null);
        } else {
            String errorMessage = DriverMgmtMessages.getString((String)"NewDriverDialog.driverExistsWithName");
            this.setErrorMessage(errorMessage);
        }
        if (this.mOKButton != null) {
            this.mOKButton.setEnabled(isOk);
        }
    }

    private void updateJarList() {
        this.mJarList = this.createList(this.list.getItems());
        this.isValid();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.mOKButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        IDialogSettings dSection;
        super.configureShell(newShell);
        newShell.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.windowTitle"));
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null && (dSection = dset.getSection(MEMENTO_ROOT)) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT).trim().length() > 0) {
            int height = dSection.getInt(MEMENTO_DIALOG_SIZE_HEIGHT);
            int width = dSection.getInt(MEMENTO_DIALOG_SIZE_WIDTH);
            Point newsize = new Point(height, width);
            newShell.setSize(newsize);
        }
    }

    private void handleLocationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.title.filebrowse"));
        String dirName = previouslyBrowsedDirectory;
        if (dirName.length() == 0) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.list.add(selectedDirectory);
        }
    }

    private void handleLocationEditButtonPressed(String editLocation) {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.title.filebrowse"));
        String dirName = editLocation;
        dialog.setFileName(dirName);
        if (dirName.length() == 0) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            } else {
                dialog.setFilterPath(dirName);
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.list.remove(editLocation);
            this.list.add(selectedDirectory);
            if (this.list.getItemCount() > 1 && MessageDialog.openQuestion((Shell)this.getShell(), (String)DriverMgmtMessages.getString((String)"EditDriverDialog.msg.updateAllJarsToSamePath.title"), (String)DriverMgmtMessages.getString((String)"EditDriverDialog.msg.updateAllJarsToSamePath.message"))) {
                int location;
                String[] items = this.list.getItems();
                String separator = "\\";
                if (selectedDirectory.indexOf("/") > -1) {
                    separator = "/";
                }
                if ((location = selectedDirectory.lastIndexOf(separator)) > -1 && location < selectedDirectory.length() - 1) {
                    String path = selectedDirectory.substring(0, location);
                    for (int i = 0; i < items.length; ++i) {
                        String directory = items[i];
                        if (directory.equals(selectedDirectory)) continue;
                        int location2 = directory.lastIndexOf(separator);
                        String filename = directory;
                        if (location2 > -1 && location2 < directory.length() - 1) {
                            filename = directory.substring(location2 + 1, directory.length());
                        }
                        String newdirectory = path + separator + filename;
                        this.list.remove(directory);
                        this.list.add(newdirectory);
                    }
                }
            }
        }
    }

    protected void okPressed() {
        String propIdPrefix = DriverMgmtMessages.getString((String)"EditDriverDialog.text.id_prefix");
        String propId = propIdPrefix + this.mDriverName;
        if (this.mPropertySet == null) {
            this.mPropertySet = new PropertySetImpl(propId, this.mDriverName);
        }
        this.mPropertySet.setName(this.mDriverName);
        Properties props = new Properties();
        props.setProperty("jarList", this.mJarList);
        IConfigurationElement[] templateprops = this.descriptor.getProperties();
        if (templateprops != null && templateprops.length > 0) {
            for (int i = 0; i < templateprops.length; ++i) {
                IConfigurationElement prop = templateprops[i];
                String id = prop.getAttribute("id");
                String value = this.mPropertySet.getBaseProperties().getProperty(id);
                if (value == null) {
                    value = prop.getAttribute("value");
                }
                props.setProperty(id, value);
            }
        }
        props.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", this.descriptor.getId());
        this.mPropertySet.setBaseProperties(props);
        this.saveState();
        super.okPressed();
    }

    private IPropertySet createTestPSet() {
        String propIdPrefix = DriverMgmtMessages.getString((String)"EditDriverDialog.text.id_test_prefix");
        String propId = propIdPrefix + this.mDriverName;
        PropertySetImpl testPropertySet = new PropertySetImpl(propId, this.mDriverName);
        testPropertySet.setName(this.mDriverName);
        Properties props = new Properties();
        props.setProperty("jarList", this.mJarList);
        IConfigurationElement[] templateprops = this.descriptor.getProperties();
        if (templateprops != null && templateprops.length > 0) {
            for (int i = 0; i < templateprops.length; ++i) {
                IConfigurationElement prop = templateprops[i];
                String id = prop.getAttribute("id");
                String value = null;
                if (this.mPropertySet.getBaseProperties() != null) {
                    value = this.mPropertySet.getBaseProperties().getProperty(id);
                }
                if (value == null) {
                    value = prop.getAttribute("value");
                }
                props.setProperty(id, value);
            }
        }
        props.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", this.descriptor.getId());
        testPropertySet.setBaseProperties(props);
        return testPropertySet;
    }

    public IPropertySet getPropertySet() {
        return this.mPropertySet;
    }

    public CategoryDescriptor getCategoryDescriptor() {
        if (this.descriptor != null) {
            CategoryDescriptor category = CategoryDescriptor.getCategoryDescriptor((String)this.descriptor.getParentCategory());
            return category;
        }
        return null;
    }

    private void updateFromPropertySet() {
        if (this.descriptor != null) {
            this.mDriverTypeText.setText(this.descriptor.getName());
            if (this.descriptor.getJarList() != null && this.descriptor.getJarList().length() > 0) {
                String[] jarListArray = this.parseString(this.descriptor.getJarList());
                this.list.removeAll();
                for (int i = 0; i < jarListArray.length; ++i) {
                    this.list.add(jarListArray[i]);
                }
            }
        }
        if (this.mPropertySet != null) {
            String jarList;
            this.mDriverNameText.setText(this.mPropertySet.getName());
            this.mDriverName = this.mPropertySet.getName();
            this.mJarList = jarList = this.mPropertySet.getBaseProperties().getProperty("jarList");
            String[] jarListArray = this.parseString(jarList);
            this.list.removeAll();
            for (int i = 0; i < jarListArray.length; ++i) {
                this.list.add(jarListArray[i]);
            }
        }
        this.isValid();
    }

    public void setPropertySet(IPropertySet propset) {
        this.mPropertySet = propset;
    }

    private String createList(String[] items) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            buffer.append(items[i]);
            if (i + 1 >= items.length) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private String[] parseString(String str_list) {
        StringTokenizer tk = new StringTokenizer(str_list, ",");
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    private boolean hasVisibleProperties() {
        return this.descriptor == null ? false : this.descriptor.hasVisibleProperties();
    }

    private void isValid() {
        this.isValid(false);
    }

    private void isValid(boolean inflag) {
        IPropertySet testSet = null;
        testSet = inflag ? this.mPropertySet : this.createTestPSet();
        if (testSet != null) {
            DriverValidator testValidator = new DriverValidator(this.descriptor, testSet);
            boolean flag = testValidator.isValid();
            if (!flag) {
                this.setErrorMessage(testValidator.getMessage());
            } else {
                this.setErrorMessage(null);
            }
        }
    }

    private void saveState() {
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null) {
            IDialogSettings dSection = dset.getSection(MEMENTO_ROOT);
            if (dSection == null) {
                dSection = dset.addNewSection(MEMENTO_ROOT);
            }
            if (dSection != null) {
                Point size = this.getShell().getSize();
                dSection.put(MEMENTO_DIALOG_SIZE_HEIGHT, size.x);
                dSection.put(MEMENTO_DIALOG_SIZE_WIDTH, size.y);
            }
        }
    }
}

