/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.IHelpConstants;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource;
import org.eclipse.datatools.connectivity.internal.ui.wizards.SummaryWizardPage;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ConnectionProfileSummaryPage
extends SummaryWizardPage {
    private ISummaryDataSource dataSource;

    public ConnectionProfileSummaryPage(ISummaryDataSource source) {
        super(source);
        this.dataSource = source;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite container = (Composite)this.getControl();
        Button button = new Button(container, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionProfileSummaryPage.this.testConnection();
            }
        });
        button.setLayoutData((Object)new GridData(128));
        button.setText(ConnectivityUIPlugin.getDefault().getResourceString("ConnectionProfileSummaryPage.button.testConnection"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IHelpConstants.CONTEXT_ID_CONNECTION_PROFILE_SUMMARY_PAGE);
    }

    protected void testConnection() {
        if (this.dataSource instanceof NewConnectionProfileWizard) {
            NewConnectionProfileWizard wizard = (NewConnectionProfileWizard)this.dataSource;
            ConnectionProfile profile = new ConnectionProfile(wizard.getProfileName(), wizard.getProfileDescription(), wizard.getProfileProviderID(), wizard.getParentProfile(), wizard.getProfileIsAutoConnect());
            profile.setBaseProperties(wizard.getProfileProperties());
            final PingJob pingJob = new PingJob(this.getShell(), (IConnectionProfile)profile);
            pingJob.schedule();
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        pingJob.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

