/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.actions.PreviewAction;
import org.eclipse.birt.report.designer.ui.preview.Activator;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class PreviewToolbarMenuAction
extends PreviewAction
implements IWorkbenchWindowPulldownDelegate {
    private Image previewIcon = Activator.getImageDescriptor("icons/etool16/preview.gif").createImage();
    private Image previewPDFIcon = Activator.getImageDescriptor("icons/etool16/preview_pdf.gif").createImage();

    public void dispose() {
        this.previewIcon.dispose();
        this.previewPDFIcon.dispose();
    }

    public Menu getMenu(Control parent) {
        ReportEngine engine = new ReportEngine(new EngineConfig());
        String[] supportedFormats = engine.getSupportedFormats();
        Menu menu = new Menu(parent);
        MenuItem previewWebViewer = new MenuItem(menu, 8);
        previewWebViewer.setText(Messages.getString((String)"designer.preview.previewaction.label.webviewer"));
        previewWebViewer.setImage(this.previewIcon);
        previewWebViewer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewToolbarMenuAction.this.preview("html", true);
            }
        });
        for (int i = 0; i < supportedFormats.length; ++i) {
            final String format = supportedFormats[i];
            MenuItem previewOption = new MenuItem(menu, 8);
            previewOption.setText("View report as " + format.toUpperCase());
            if (format.equals("pdf")) {
                previewOption.setImage(this.previewPDFIcon);
            } else {
                previewOption.setImage(this.previewIcon);
            }
            previewOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreviewToolbarMenuAction.this.preview(format, false);
                }
            });
        }
        return menu;
    }
}

