/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.preview.editors.ReportPreviewEditor;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class ReportPreviewFormPage
extends ReportPreviewEditor
implements IReportEditorPage {
    public static final String ID = "org.eclipse.birt.report.designer.ui.editors.preview";
    private Control control;
    private int staleType;
    private FormEditor editor;
    public static final String SUFFIX_TEMPLATE_FILE = "rpttemplate";
    public static final String SUFFIX_DESIGN_CONFIG = "rptconfig";
    public static final String PROP_TYPE = "type";

    public boolean onBroughtToTop(IReportEditorPage prePage) {
        boolean isDisplay = false;
        if (this.getEditorInput() != prePage.getEditorInput()) {
            this.setInput(prePage.getEditorInput());
        }
        if (this.isDirtyModel()) {
            this.doSave(null);
        }
        if (prePage.isDirty()) {
            prePage.doSave(null);
        }
        if (this.isMissingParameter()) {
            if (this.parameterDialog != null) {
                this.parameterDialog.open();
                if (this.parameterDialog.getReturnCode() == 1001) {
                    isDisplay = true;
                    if (this.isMissingParameter()) {
                        this.editor.setActivePage(prePage.getId());
                        return false;
                    }
                }
            }
        } else {
            isDisplay = true;
        }
        if (isDisplay) {
            this.display();
        }
        ReportRequest request = new ReportRequest((Object)this);
        ArrayList list = new ArrayList();
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
        return true;
    }

    private boolean isDirtyModel() {
        if (this.getModel() != null && this.getModel() instanceof ModuleHandle) {
            return ((ModuleHandle)this.getModel()).needsSave();
        }
        return false;
    }

    public Control getPartControl() {
        return this.control;
    }

    public String getId() {
        return ID;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.control = children[children.length - 1];
    }

    public void markPageStale(int type) {
        this.staleType = type;
    }

    public int getStaleType() {
        return this.staleType;
    }

    public boolean isDirty() {
        return false;
    }

    protected IReportProvider getProvider() {
        IReportProvider provider = (IReportProvider)this.editor.getAdapter(IReportProvider.class);
        if (provider == null) {
            provider = super.getProvider();
        }
        return provider;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ActionRegistry.class)) {
            return new ActionRegistry();
        }
        return super.getAdapter(adapter);
    }

    public void initialize(FormEditor editor) {
        this.editor = editor;
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public void setActive(boolean active) {
    }

    public boolean isActive() {
        return false;
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public int getIndex() {
        return 0;
    }

    public void setIndex(int index) {
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        return false;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
    }

    private Map getConfigVars() {
        HashMap<String, String> configVars = new HashMap<String, String>();
        String configFileName = this.getConfigFileName(this.getFileUri());
        if (configFileName == null) {
            return configVars;
        }
        ReportDesignHandle handle = null;
        try {
            SessionHandle sessionHandle = SessionHandleAdapter.getInstance().getSessionHandle();
            File configFile = new File(configFileName);
            if (configFile != null && configFile.exists() && configFile.isFile() && (handle = sessionHandle.openDesign(configFileName)) != null) {
                Iterator it = handle.configVariablesIterator();
                while (it != null && it.hasNext()) {
                    ConfigVariableHandle configVar = (ConfigVariableHandle)it.next();
                    if (configVar == null || configVar.getName() == null) continue;
                    String paramName = this.getParameterName(configVar.getName());
                    ScalarParameterHandle parameter = this.findParameter(paramName);
                    if (parameter != null) {
                        String typeVarName = configVar.getName() + "_" + PROP_TYPE;
                        ConfigVariable typeVar = handle.findConfigVariable(typeVarName);
                        String dataType = null;
                        if (typeVar != null) {
                            dataType = typeVar.getValue();
                        }
                        if (dataType == null || !dataType.equalsIgnoreCase(parameter.getDataType())) continue;
                    }
                    if (paramName == null || paramName.length() <= 0) continue;
                    configVars.put(paramName, configVar.getValue());
                }
                handle.close();
            }
        }
        catch (DesignFileException e) {
            e.printStackTrace();
            try {
                if (handle != null) {
                    handle.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return configVars;
    }

    private String getParameterName(String configVarName) {
        String paramName = null;
        List parameters = null;
        ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (model != null) {
            parameters = model.getFlattenParameters();
        }
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                ScalarParameterHandle parameter = null;
                if (parameters.get(i) instanceof ScalarParameterHandle) {
                    parameter = (ScalarParameterHandle)parameters.get(i);
                }
                String curName = null;
                if (parameter != null && parameter.getName() != null) {
                    curName = parameter.getName() + "_" + parameter.getID();
                }
                if (curName == null || !curName.equalsIgnoreCase(configVarName)) continue;
                paramName = parameter.getName();
                break;
            }
        }
        return paramName;
    }

    private ScalarParameterHandle findParameter(String paramName) {
        if (paramName == null) {
            return null;
        }
        ScalarParameterHandle parameter = null;
        List parameters = null;
        ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (model != null) {
            parameters = model.getFlattenParameters();
        }
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                if (parameters.get(i) instanceof ScalarParameterHandle) {
                    parameter = (ScalarParameterHandle)parameters.get(i);
                }
                if (parameter != null && paramName.equalsIgnoreCase(parameter.getName())) break;
            }
        }
        return parameter;
    }

    public boolean isMissingParameter() {
        boolean missingParameter = false;
        ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
        HashMap params = (HashMap)this.getConfigVars();
        List parameters = model.getFlattenParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                Object curVal;
                ScalarParameterHandle parameter;
                if (!(parameters.get(i) instanceof ScalarParameterHandle) || (parameter = (ScalarParameterHandle)parameters.get(i)).isHidden()) continue;
                String paramValue = null;
                if (params != null && params.containsKey(parameter.getName()) && (curVal = params.get(parameter.getName())) != null) {
                    paramValue = curVal.toString();
                }
                if (paramValue == null && !parameter.allowNull()) {
                    missingParameter = true;
                    break;
                }
                if (paramValue == null || paramValue.trim().length() > 0 || parameter.allowBlank() || !parameter.getDataType().equalsIgnoreCase("string")) continue;
                missingParameter = true;
                break;
            }
        }
        return missingParameter;
    }

    private String getConfigFileName(String reportDesignName) {
        if (reportDesignName == null) {
            return null;
        }
        String[] result = reportDesignName.split("\\.");
        String extensionName = result[result.length - 1];
        String configFileName = reportDesignName.substring(0, reportDesignName.length() - extensionName.length()) + SUFFIX_DESIGN_CONFIG;
        return configFileName;
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.editor.editorDirtyStateChanged();
        } else {
            super.firePropertyChange(type);
        }
    }

    protected void finalize() throws Throwable {
        if (Policy.TRACING_PAGE_CLOSE) {
            System.out.println("Report preview page finalized");
        }
        super.finalize();
    }
}

