/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.launcher.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.LaunchListener;
import org.osgi.framework.Bundle;

public class DebugUtil {
    public static void importProject(String prjFilePath) throws Exception {
        Path path = new Path(prjFilePath + File.separator + ".project");
        IProjectDescription newDescription = DebugUtil.loadProjectDescription((IPath)path);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(newDescription.getName());
        if (project == null) {
            throw new Exception("DebugUtil.importProject.fail");
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        project.create(newDescription, (IProgressMonitor)monitor);
        project.open((IProgressMonitor)monitor);
    }

    private static IProjectDescription loadProjectDescription(IPath path) throws IOException {
        ProjectDescription result = null;
        result = new ProjectDescriptionReader().read(path);
        if (result != null) {
            IPath user = path.removeLastSegments(1);
            IPath platform = Platform.getLocation().append(result.getName());
            if (!user.toFile().equals(platform.toFile())) {
                result.setLocation(user);
            }
        }
        return result;
    }

    public static String copyToWorkspace(String folderPath) throws Exception {
        File folder = new File(folderPath);
        if (!folder.isDirectory()) {
            throw new Exception();
        }
        String newFolderName = folder.getName();
        String workspaceRootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String newFolderPath = workspaceRootPath + File.separator + newFolderName;
        File newFolder = new File(newFolderPath);
        if (!newFolder.exists()) {
            newFolder.mkdir();
        }
        DebugUtil.copyFiles(folder, newFolder);
        return newFolderPath;
    }

    private static void copyFiles(File folder, File newFolder) throws IOException {
        File[] folderFiles = folder.listFiles();
        if (folderFiles != null) {
            for (int i = 0; i < folderFiles.length; ++i) {
                if (folderFiles[i].isFile()) {
                    File newFile = new File(newFolder, folderFiles[i].getName());
                    if (!newFile.exists()) {
                        newFile.createNewFile();
                    }
                    DebugUtil.copyFile(folderFiles[i], newFile);
                    continue;
                }
                File newSubFolder = new File(newFolder, folderFiles[i].getName());
                if (!newSubFolder.exists()) {
                    newSubFolder.mkdir();
                }
                DebugUtil.copyFiles(folderFiles[i], newSubFolder);
            }
        }
    }

    private static void copyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = Platform.getResourceBundle((Bundle)PDEPlugin.getDefault().getBundleContext().getBundle());
        if (bundle != null) {
            try {
                String bundleString = bundle.getString(key);
                return bundleString;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return key;
    }

    public static LaunchListener getPDEPluginLaunchListener(PDEPlugin in) {
        Method method = null;
        try {
            method = PDEPlugin.class.getDeclaredMethod("getLaunchesListener", new Class[0]);
            return (LaunchListener)method.invoke((Object)in, new Object[0]);
        }
        catch (Exception e) {
            if (method == null) {
                try {
                    method = PDEPlugin.class.getDeclaredMethod("getLaunchListener", new Class[0]);
                    return (LaunchListener)method.invoke((Object)in, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static void runCreatePlatformConfigurationArea(TreeMap pluginMap, File configDir, String primaryFeatureId, HashMap autoStartPlugins) {
        Method method = null;
        try {
            method = TargetPlatform.class.getDeclaredMethod("createPlatformConfigurationArea", TreeMap.class, File.class, String.class, HashMap.class);
            method.invoke((Object)TargetPlatform.class, pluginMap, configDir, primaryFeatureId, autoStartPlugins);
            return;
        }
        catch (Exception e) {
            method = null;
            if (method == null) {
                try {
                    method = TargetPlatform.class.getDeclaredMethod("createPlatformConfigurationArea", TreeMap.class, File.class, String.class);
                    method.invoke((Object)TargetPlatform.class, pluginMap, configDir, primaryFeatureId);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            return;
        }
    }
}

