/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.launcher.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.viewer.utilities.IWorkspaceClasspathFinder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class WorkspaceClassPathFinder
implements IWorkspaceClasspathFinder {
    private static final String PROPERTYSEPARATOR = ";";

    public String getClassPath(String projects) {
        if (projects == null || projects.length() == 0) {
            return null;
        }
        StringBuffer wbuf = new StringBuffer();
        StringTokenizer token = new StringTokenizer(projects, PROPERTYSEPARATOR);
        boolean hasHeader = false;
        while (token.hasMoreTokens()) {
            String projectName = token.nextToken();
            List paths = this.getProjectPaths(projectName);
            for (int i = 0; i < paths.size(); ++i) {
                String url = (String)paths.get(i);
                if (url == null || url.length() == 0) continue;
                if (i == 0 && !hasHeader) {
                    wbuf.append(url);
                    hasHeader = true;
                    continue;
                }
                wbuf.append(PROPERTYSEPARATOR + url);
            }
        }
        return wbuf.toString();
    }

    public String getClassPath() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        String projectString = "";
        for (int i = 0; i < projects.length; ++i) {
            IProject proj = projects[i];
            projectString = projectString + proj.getName() + PROPERTYSEPARATOR;
        }
        return this.getClassPath(projectString);
    }

    private List getProjectPaths(String projectName) {
        ArrayList<String> retValue = new ArrayList<String>();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (projectName == null) {
            return retValue;
        }
        List paths = this.getProjectPath(project);
        for (int j = 0; j < paths.size(); ++j) {
            URL url = (URL)paths.get(j);
            if (url == null) continue;
            retValue.add(url.getPath());
        }
        String url = this.getProjectOutClassPath(project);
        if (url != null) {
            retValue.add(url);
        }
        return retValue;
    }

    private String getProjectOutClassPath(IProject project) {
        boolean projectExists;
        if (!this.hasJavaNature(project)) {
            return null;
        }
        IJavaProject fCurrJProject = JavaCore.create((IProject)project);
        IPath path = null;
        boolean bl = projectExists = project.exists() && project.getFile(".classpath").exists();
        if (projectExists && path == null) {
            path = fCurrJProject.readOutputLocation();
            String curPath = path.toOSString();
            String directPath = project.getLocation().toOSString();
            int index = directPath.lastIndexOf(File.separator);
            String absPath = directPath.substring(0, index) + curPath;
            return absPath;
        }
        return null;
    }

    private List getProjectPath(IProject project) {
        boolean projectExists;
        List retValue = new ArrayList();
        if (!this.hasJavaNature(project)) {
            return retValue;
        }
        IJavaProject fCurrJProject = JavaCore.create((IProject)project);
        IClasspathEntry[] classpathEntries = null;
        boolean bl = projectExists = project.exists() && project.getFile(".classpath").exists();
        if (projectExists && classpathEntries == null) {
            classpathEntries = fCurrJProject.readRawClasspath();
        }
        if (classpathEntries != null) {
            retValue = this.getExistingEntries(classpathEntries);
        }
        return retValue;
    }

    private List getExistingEntries(IClasspathEntry[] classpathEntries) {
        ArrayList<URL> newClassPath = new ArrayList<URL>();
        for (int i = 0; i < classpathEntries.length; ++i) {
            IClasspathEntry curr = classpathEntries[i];
            if (curr.getEntryKind() != 1) continue;
            try {
                newClassPath.add(curr.getPath().toFile().toURL());
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return newClassPath;
    }

    private boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

