/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.ui.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.debug.internal.ui.launcher.IReportLauncherSettings;
import org.eclipse.birt.report.debug.internal.ui.launcher.util.WorkspaceClassPathFinder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.pde.ui.launcher.EclipseApplicationLaunchConfiguration;

public class ReportLaunchConfigurationDelegate
extends EclipseApplicationLaunchConfiguration
implements IReportLauncherSettings {
    private static final String PROJECT_NAMES_KEY = "user.projectname";
    private static final String PROJECT_CLASSPATH_KEY = "user.projectclasspath";
    private static final String PROJECT_OPENFILES_KEY = "user.openfiles";
    private static WorkspaceClassPathFinder finder = new WorkspaceClassPathFinder();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.cofigLaunch(launch, configuration);
        super.launch(configuration, mode, launch, monitor);
    }

    private void cofigLaunch(ILaunch launch, ILaunchConfiguration configuration) {
        if (launch.getSourceLocator() instanceof JavaSourceLookupDirector) {
            JavaSourceLookupDirector director = (JavaSourceLookupDirector)launch.getSourceLocator();
            ISourceContainer[] contains = director.getSourceContainers();
            ArrayList<Object> list = new ArrayList<Object>();
            if (contains != null && contains.length != 0) {
                for (int i = 0; i < contains.length; ++i) {
                    list.add(contains[i]);
                }
            }
            try {
                List sourcePaths = this.getAllProjectSourcePaths(configuration.getAttribute("importprojectnames", ""));
                for (int i = 0; i < sourcePaths.size(); ++i) {
                    IJavaProject source = (IJavaProject)sourcePaths.get(i);
                    JavaProjectSourceContainer temp = new JavaProjectSourceContainer(source);
                    list.add(i, temp);
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
            ISourceContainer[] retValue = new ISourceContainer[list.size()];
            retValue = list.toArray(retValue);
            director.setSourceContainers(retValue);
        }
    }

    private List getAllProjectSourcePaths(String path) {
        ArrayList<IJavaProject> retValue = new ArrayList<IJavaProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects == null || projects.length == 0) {
            return retValue;
        }
        for (int i = 0; i < projects.length; ++i) {
            IProject project = projects[i];
            if (project == null || !this.hasJavaNature(project)) continue;
            retValue.add(JavaCore.create((IProject)project));
        }
        return retValue;
    }

    private boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        int i;
        String[] temp = super.getVMArguments(configuration);
        String[] othersArguments = this.getOthersVMArguments(configuration);
        if (temp == null || temp.length == 0) {
            temp = othersArguments;
        }
        ArrayList<String> list = new ArrayList<String>();
        int size = temp.length;
        for (i = 0; i < size; ++i) {
            list.add(temp[i]);
        }
        size = othersArguments.length;
        for (i = 0; i < size; ++i) {
            list.add(othersArguments[i]);
        }
        temp = list.toArray(temp);
        return temp;
    }

    private String[] getOthersVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String path = configuration.getAttribute("importproject", "");
        String append = "-Duser.projectname=" + path;
        String projectClassPaths = finder.getClassPath();
        String classPath = "";
        if (projectClassPaths != null && projectClassPaths.length() != 0) {
            classPath = "-Duser.projectclasspath=" + projectClassPaths;
        }
        String openFiles = "-Duser.openfiles=" + configuration.getAttribute("openfilenames", "");
        return new String[]{append, classPath, openFiles};
    }
}

