/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import org.eclipse.birt.chart.device.swt.SwtRendererImpl;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;

public final class RegionAction {
    private final StructureSource _oSource;
    private final Region _sh;
    private final Path _ph;
    private final Action _ac;

    private RegionAction(StructureSource source, Region rg, Path ph, Action ac) {
        this._oSource = source;
        this._sh = rg;
        this._ac = ac;
        this._ph = ph;
    }

    RegionAction(StructureSource oSource, Location[] loa, Action ac, double dTranslateX, double dTranslateY, double dScale, Region clipping) {
        this._oSource = oSource;
        int[] i2a = SwtRendererImpl.getCoordinatesAsInts(loa, 2, dTranslateX, dTranslateY, dScale);
        this._sh = new Region();
        this._sh.add(i2a);
        if (clipping != null) {
            this._sh.intersect(clipping);
        }
        this._ac = ac;
        this._ph = null;
    }

    RegionAction(StructureSource oSource, Bounds bo, Action ac, double dTranslateX, double dTranslateY, double dScale, Region clipping) {
        this._oSource = oSource;
        bo = BoundsImpl.copyInstance((Bounds)bo);
        bo.translate(dTranslateX, dTranslateY);
        bo.scale(dScale);
        Rectangle rect = new Rectangle((int)bo.getLeft(), (int)bo.getTop(), (int)bo.getWidth(), (int)bo.getHeight());
        this._sh = new Region();
        this._sh.add(rect);
        if (clipping != null) {
            this._sh.intersect(clipping);
        }
        this._ac = ac;
        this._ph = null;
    }

    RegionAction(StructureSource oSource, Bounds boEllipse, double dStart, double dExtent, boolean bSector, Action ac, double dTranslateX, double dTranslateY, double dScale, Region clipping) {
        this._oSource = oSource;
        boEllipse = BoundsImpl.copyInstance((Bounds)boEllipse);
        boEllipse.translate(dTranslateX, dTranslateY);
        boEllipse.scale(dScale);
        double x = boEllipse.getLeft();
        double y = boEllipse.getTop();
        double width = boEllipse.getWidth();
        double height = boEllipse.getHeight();
        Path ph = new Path((Device)Display.getDefault());
        ph.addArc((float)x, (float)y, (float)width, (float)height, (float)dStart, (float)dExtent);
        if (bSector) {
            ph.lineTo((float)(x + width / 2.0), (float)(y + height / 2.0));
        }
        ph.close();
        if (clipping != null) {
            // empty if block
        }
        this._ph = ph;
        this._ac = ac;
        this._sh = null;
    }

    RegionAction(StructureSource oSource, Location[] loa, Action ac, double dTranslateX, double dTranslateY, double dScale) {
        this(oSource, loa, ac, dTranslateX, dTranslateY, dScale, null);
    }

    RegionAction(StructureSource oSource, Bounds bo, Action ac, double dTranslateX, double dTranslateY, double dScale) {
        this(oSource, bo, ac, dTranslateX, dTranslateY, dScale, null);
    }

    RegionAction(StructureSource oSource, Bounds boEllipse, double dStart, double dExtent, boolean bSector, Action ac, double dTranslateX, double dTranslateY, double dScale) {
        this(oSource, boEllipse, dStart, dExtent, bSector, ac, dTranslateX, dTranslateY, dScale, null);
    }

    public final Action getAction() {
        return this._ac;
    }

    public final StructureSource getSource() {
        return this._oSource;
    }

    public RegionAction copy() {
        Region nrg = null;
        Path nph = null;
        if (this._sh != null) {
            nrg = new Region();
            nrg.add(this._sh);
        }
        if (this._ph != null) {
            nph = new Path((Device)Display.getDefault());
            nph.addPath(this._ph);
        }
        return new RegionAction(this._oSource, nrg, nph, this._ac);
    }

    public boolean contains(Point p, GC gc) {
        if (this._sh != null && !this._sh.isDisposed()) {
            return this._sh.contains(p);
        }
        if (this._ph != null && !this._ph.isDisposed()) {
            return this._ph.contains((float)p.x, (float)p.y, gc, false);
        }
        return false;
    }

    public boolean contains(double x, double y, GC gc) {
        if (this._sh != null && !this._sh.isDisposed()) {
            return this._sh.contains((int)x, (int)y);
        }
        if (this._ph != null && !this._ph.isDisposed()) {
            return this._ph.contains((float)x, (float)y, gc, false);
        }
        return false;
    }

    public void dispose() {
        if (this._sh != null && !this._sh.isDisposed()) {
            this._sh.dispose();
        }
        if (this._ph != null && !this._ph.isDisposed()) {
            this._ph.dispose();
        }
    }

    public boolean isEmpty() {
        if (this._sh != null) {
            return this._sh.isDisposed() || this._sh.isEmpty();
        }
        if (this._ph != null) {
            return this._ph.isDisposed();
        }
        return true;
    }
}

