/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.chart.device.DisplayAdapter;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.device.swt.SwtTextMetrics;
import org.eclipse.birt.chart.device.swt.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public final class SwtDisplayServer
extends DisplayAdapter {
    private Device _d = null;
    private double dScale = 1.0;
    private int iDpiResolution = 0;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swt");

    public SwtDisplayServer() {
        try {
            this._d = Display.getDefault();
        }
        catch (Exception ex) {
            logger.log(ex);
            logger.log(8, Messages.getString("SwtDisplayServer.exception.display.server", this.getULocale()));
        }
        logger.log(1, Messages.getString("SwtDisplayServer.info.display.server", new Object[]{SWT.getPlatform(), new Integer(SWT.getVersion())}, this.getULocale()));
    }

    public Object createFont(FontDefinition fd) {
        int iStyle = 0;
        if (fd.isBold()) {
            iStyle |= 1;
        }
        if (fd.isItalic()) {
            iStyle |= 2;
        }
        return new Font(this._d, fd.getName(), (int)Math.round((double)fd.getSize() * this.dScale), iStyle);
    }

    public Object getColor(ColorDefinition cd) {
        return new Color(this._d, cd.getRed(), cd.getGreen(), cd.getBlue());
    }

    public final int getDpiResolution() {
        if (this.iDpiResolution == 0) {
            this.iDpiResolution = this._d.getDPI().x;
        }
        return this.iDpiResolution;
    }

    public final void setDpiResolution(int dpi) {
        this.iDpiResolution = dpi;
    }

    public Object loadImage(URL url) throws ChartException {
        try {
            InputStream is = url.openStream();
            Image img = new Image(this._d, is);
            is.close();
            return img;
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.device.swt", 4, (Throwable)ex);
        }
    }

    public Size getSize(Object oImage) {
        Image img = (Image)oImage;
        Rectangle r = img.getBounds();
        return SizeImpl.create((double)r.width, (double)r.height);
    }

    public Object getObserver() {
        return null;
    }

    public ITextMetrics getTextMetrics(Label la) {
        return new SwtTextMetrics((IDisplayServer)this, la);
    }

    final Device getDevice() {
        return this._d;
    }

    final double pointsToPixels(double dPoints) {
        return dPoints * (double)this.getDpiResolution() / 72.0;
    }

    final void setScale(double dScale) {
        this.dScale = dScale;
    }
}

