/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.render.ActionRendererAdapter;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.SearchKeyHandle;

public class BIRTActionRenderer
extends ActionRendererAdapter {
    private IHTMLActionHandler handler;
    private DesignElementHandle eih;
    private Object context;
    private IDataRowExpressionEvaluator evaluator;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public BIRTActionRenderer(DesignElementHandle eih, IHTMLActionHandler handler, IDataRowExpressionEvaluator evaluator, Object context) {
        this.eih = eih;
        this.handler = handler;
        this.evaluator = evaluator;
        this.context = "html".equals(((IReportContext)context).getOutputFormat()) ? ((IReportContext)context).getAppContext().get("HTML_RENDER_CONTEXT") : ((IReportContext)context).getAppContext().get("PDF_RENDER_CONTEXT");
    }

    public void processAction(Action action, StructureSource source) {
        if (ActionType.URL_REDIRECT_LITERAL.equals(action.getType())) {
            URLValue uv = (URLValue)action.getValue();
            String sa = uv.getBaseUrl();
            String target = null;
            if (StructureType.SERIES_DATA_POINT.equals(source.getType())) {
                final DataPointHints dph = (DataPointHints)source.getSource();
                try {
                    final ActionHandle handle = ModuleUtil.deserializeAction((String)sa);
                    target = handle.getTargetWindow();
                    sa = this.handler.getURL(new IAction(){

                        public int getType() {
                            if ("hyperlink".equals(handle.getLinkType())) {
                                return 1;
                            }
                            if ("bookmark-link".equals(handle.getLinkType())) {
                                return 2;
                            }
                            if ("drill-through".equals(handle.getLinkType())) {
                                return 3;
                            }
                            return 0;
                        }

                        public String getBookmark() {
                            return ChartUtil.stringValue((Object)dph.getUserValue(handle.getTargetBookmark()));
                        }

                        public String getActionString() {
                            if ("hyperlink".equals(handle.getLinkType())) {
                                return ChartUtil.stringValue((Object)dph.getUserValue(handle.getURI()));
                            }
                            if ("bookmark-link".equals(handle.getLinkType())) {
                                return ChartUtil.stringValue((Object)dph.getUserValue(handle.getTargetBookmark()));
                            }
                            return null;
                        }

                        public String getReportName() {
                            return handle.getReportName();
                        }

                        public Map getParameterBindings() {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            Iterator itr = handle.getParamBindings().iterator();
                            while (itr.hasNext()) {
                                ParamBindingHandle pbh = (ParamBindingHandle)itr.next();
                                map.put(pbh.getParamName(), dph.getUserValue(pbh.getExpression()));
                            }
                            return map;
                        }

                        public Map getSearchCriteria() {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            Iterator itr = handle.getSearch().iterator();
                            while (itr.hasNext()) {
                                SearchKeyHandle skh = (SearchKeyHandle)itr.next();
                                map.put(skh.getExpression(), dph.getUserValue(skh.getExpression()));
                            }
                            return map;
                        }

                        public String getTargetWindow() {
                            return handle.getTargetWindow();
                        }

                        public String getFormat() {
                            return handle.getFormatType();
                        }

                        public boolean isBookmark() {
                            return "bookmark".equals(handle.getTargetBookmarkType());
                        }

                        public String getSystemId() {
                            ModuleHandle mod = BIRTActionRenderer.this.eih.getRoot();
                            if (mod != null) {
                                return mod.getFileName();
                            }
                            return null;
                        }
                    }, this.context);
                }
                catch (Exception e) {
                    sa = "";
                    logger.log(e);
                }
            } else {
                try {
                    final ActionHandle handle = ModuleUtil.deserializeAction((String)sa);
                    target = handle.getTargetWindow();
                    sa = this.handler.getURL(new IAction(){

                        public int getType() {
                            if ("hyperlink".equals(handle.getLinkType())) {
                                return 1;
                            }
                            if ("bookmark-link".equals(handle.getLinkType())) {
                                return 2;
                            }
                            if ("drill-through".equals(handle.getLinkType())) {
                                return 3;
                            }
                            return 0;
                        }

                        public String getBookmark() {
                            return ChartUtil.stringValue((Object)BIRTActionRenderer.this.evaluator.evaluate(handle.getTargetBookmark()));
                        }

                        public String getActionString() {
                            if ("hyperlink".equals(handle.getLinkType())) {
                                return ChartUtil.stringValue((Object)BIRTActionRenderer.this.evaluator.evaluate(handle.getURI()));
                            }
                            if ("bookmark-link".equals(handle.getLinkType())) {
                                return ChartUtil.stringValue((Object)BIRTActionRenderer.this.evaluator.evaluate(handle.getTargetBookmark()));
                            }
                            return null;
                        }

                        public String getReportName() {
                            return handle.getReportName();
                        }

                        public Map getParameterBindings() {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            Iterator itr = handle.getParamBindings().iterator();
                            while (itr.hasNext()) {
                                ParamBindingHandle pbh = (ParamBindingHandle)itr.next();
                                map.put(pbh.getParamName(), BIRTActionRenderer.this.evaluator.evaluate(pbh.getExpression()));
                            }
                            return map;
                        }

                        public Map getSearchCriteria() {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            Iterator itr = handle.getSearch().iterator();
                            while (itr.hasNext()) {
                                SearchKeyHandle skh = (SearchKeyHandle)itr.next();
                                map.put(skh.getExpression(), BIRTActionRenderer.this.evaluator.evaluate(skh.getExpression()));
                            }
                            return map;
                        }

                        public String getTargetWindow() {
                            return handle.getTargetWindow();
                        }

                        public String getFormat() {
                            return handle.getFormatType();
                        }

                        public boolean isBookmark() {
                            return "bookmark".equals(handle.getTargetBookmarkType());
                        }

                        public String getSystemId() {
                            ModuleHandle mod = BIRTActionRenderer.this.eih.getRoot();
                            if (mod != null) {
                                return mod.getFileName();
                            }
                            return null;
                        }
                    }, this.context);
                }
                catch (Exception e) {
                    sa = "";
                    logger.log(e);
                }
            }
            uv.setBaseUrl(sa);
            uv.setTarget(target);
        } else if (ActionType.SHOW_TOOLTIP_LITERAL.equals(action.getType())) {
            TooltipValue tv = (TooltipValue)action.getValue();
            if (StructureType.SERIES_DATA_POINT.equals(source.getType())) {
                DataPointHints dph = (DataPointHints)source.getSource();
                tv.setText(ChartUtil.stringValue((Object)dph.getUserValue(tv.getText())));
            }
        }
    }
}

