/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.birt.chart.device.EmptyUpdateNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IImageMapEmitter;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.IMessageLookup;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.render.IActionRenderer;
import org.eclipse.birt.chart.reportitem.BIRTActionEvaluator;
import org.eclipse.birt.chart.reportitem.BIRTActionRenderer;
import org.eclipse.birt.chart.reportitem.BIRTDataRowEvaluator;
import org.eclipse.birt.chart.reportitem.BIRTExternalContext;
import org.eclipse.birt.chart.reportitem.BIRTMessageLookup;
import org.eclipse.birt.chart.reportitem.BIRTScriptClassLoader;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportStyleProcessor;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.script.IExternalContext;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.ReportItemPresentationBase;
import org.eclipse.birt.report.engine.extension.Size;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class ChartReportItemPresentationImpl
extends ReportItemPresentationBase {
    private InputStream fis = null;
    private String imageMap = null;
    private String sExtension = null;
    private String sSupportedFormats = null;
    private String outputFormat = null;
    private Chart cm = null;
    private IDeviceRenderer idr = null;
    private ExtendedItemHandle handle;
    private RunTimeContext rtc = null;
    private List registeredDevices = new ArrayList();
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public ChartReportItemPresentationImpl() {
        try {
            String[][] formats = PluginSettings.instance().getRegisteredOutputFormats();
            for (int i = 0; i < formats.length; ++i) {
                this.registeredDevices.add(formats[i][0]);
            }
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
        }
    }

    private boolean isOutputRendererSupported(String format) {
        if (format != null && this.sSupportedFormats != null && this.sSupportedFormats.indexOf(format) != -1) {
            return this.registeredDevices.contains(format);
        }
        return false;
    }

    private String getFirstSupportedFormat(String formats) {
        if (formats != null && formats.length() > 0) {
            int idx = formats.indexOf(59);
            if (idx == -1) {
                if (this.isOutputRendererSupported(formats)) {
                    return formats;
                }
            } else {
                String ext = formats.substring(0, idx);
                if (this.isOutputRendererSupported(ext)) {
                    return ext;
                }
                return this.getFirstSupportedFormat(formats.substring(idx + 1));
            }
        }
        return "PNG";
    }

    public void setModelObject(ExtendedItemHandle eih) {
        IReportItem item = null;
        try {
            item = eih.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log((Exception)((Object)e));
        }
        if (item == null) {
            try {
                eih.loadExtendedElement();
                item = eih.getReportItem();
            }
            catch (ExtendedElementException eeex) {
                logger.log((Exception)((Object)eeex));
            }
            if (item == null) {
                logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.UnableToLocateWrapper"));
                return;
            }
        }
        this.cm = (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
        this.handle = eih;
        Object of = this.handle.getProperty("outputFormat");
        if (of instanceof String) {
            this.outputFormat = (String)of;
        }
    }

    public final void setLocale(Locale lcl) {
        if (this.rtc == null) {
            this.rtc = new RunTimeContext();
        }
        this.rtc.setLocale(lcl);
    }

    public void setOutputFormat(String sOutputFormat) {
        this.sExtension = sOutputFormat.equalsIgnoreCase("HTML") ? (this.isOutputRendererSupported(this.outputFormat) ? this.outputFormat : (this.outputFormat != null && this.outputFormat.toUpperCase().equals("GIF") && this.isOutputRendererSupported("PNG") ? "PNG" : (this.isOutputRendererSupported("SVG") ? "SVG" : this.getFirstSupportedFormat(this.sSupportedFormats)))) : (sOutputFormat.equalsIgnoreCase("PDF") ? (this.isOutputRendererSupported(this.outputFormat) ? this.outputFormat : (this.isOutputRendererSupported("PNG") ? "PNG" : this.getFirstSupportedFormat(this.sSupportedFormats))) : (this.isOutputRendererSupported(this.outputFormat) ? this.outputFormat : this.getFirstSupportedFormat(this.sSupportedFormats)));
    }

    public void setSupportedImageFormats(String sSupportedFormats) {
        this.sSupportedFormats = sSupportedFormats;
    }

    public void deserialize(InputStream is) {
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            Object o = ois.readObject();
            if (o instanceof RunTimeContext) {
                RunTimeContext drtc = (RunTimeContext)o;
                if (this.rtc != null) {
                    drtc.setLocale(this.rtc.getLocale());
                }
                this.rtc = drtc;
                this.cm = this.rtc.getScriptContext().getChartInstance();
                if (this.cm != null && this.handle != null) {
                    IReportItem item = this.handle.getReportItem();
                    ((ChartReportItemImpl)item).setModel(this.cm);
                }
            }
            ois.close();
        }
        catch (Exception e) {
            logger.log(e);
        }
    }

    public int getOutputType() {
        if ("SVG".equals(this.sExtension)) {
            return 1;
        }
        return 6;
    }

    public String getImageMIMEType() {
        if (this.idr instanceof IImageMapEmitter) {
            return ((IImageMapEmitter)this.idr).getMimeType();
        }
        if ("SVG".equals(this.sExtension)) {
            return "image/svg+xml";
        }
        return "image";
    }

    public Object getOutputContent() {
        return null;
    }

    public Object onRowSets(IRowSet[] irsa) throws BirtException {
        if (irsa == null || irsa.length != 1 || irsa[0] == null) {
            logger.log((Exception)((Object)new ChartException("org.eclipse.birt.chart.reportitem", 3, "ChartReportItemPresentationImpl.error.NoData", Messages.getResourceBundle(this.rtc.getULocale()))));
            return null;
        }
        logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsStart"));
        try {
            IRenderOption renderOption;
            String javaHandlerClass = this.handle.getEventHandlerClass();
            if (javaHandlerClass != null && javaHandlerClass.length() > 0) {
                this.cm.setScript(javaHandlerClass);
            }
            BIRTDataRowEvaluator rowAdapter = new BIRTDataRowEvaluator(irsa[0]);
            Generator.instance().bindData((IDataRowExpressionEvaluator)rowAdapter, (IActionEvaluator)new BIRTActionEvaluator(), this.cm, this.rtc);
            logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsBuilding"));
            this.idr = PluginSettings.instance().getDevice("dv." + this.sExtension.toUpperCase(Locale.US));
            this.idr.setProperty("device.resolution", (Object)new Integer(this.dpi));
            if ("SVG".equalsIgnoreCase(this.sExtension)) {
                this.idr.setProperty("resize.svg", (Object)Boolean.TRUE);
            }
            Bounds originalBounds = this.cm.getBlock().getBounds();
            Bounds bo = (Bounds)EcoreUtil.copy((EObject)originalBounds);
            logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.PresentationUsesBoundsBo", bo));
            Generator gr = Generator.instance();
            GeneratedChartState gcs = null;
            this.rtc.setScriptClassLoader((IScriptClassLoader)new BIRTScriptClassLoader(this.appClassLoader));
            this.rtc.setActionRenderer((IActionRenderer)new BIRTActionRenderer((DesignElementHandle)this.handle, this.ah, (IDataRowExpressionEvaluator)rowAdapter, this.context));
            this.rtc.setMessageLookup((IMessageLookup)new BIRTMessageLookup(this.context));
            Object renderContext = this.context.getAppContext().get("HTML_RENDER_CONTEXT");
            if (renderContext instanceof HTMLRenderContext && (renderOption = ((HTMLRenderContext)renderContext).getRenderOption()) instanceof HTMLRenderOption && ((HTMLRenderOption)renderOption).getHtmlRtLFlag()) {
                this.rtc.setRightToLeft(true);
            }
            gcs = gr.build(this.idr.getDisplayServer(), this.cm, bo, (IExternalContext)new BIRTExternalContext(this.context), this.rtc, (IStyleProcessor)new ChartReportStyleProcessor((DesignElementHandle)this.handle, this.style));
            logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsRendering"));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            this.idr.setProperty("device.file.identifier", (Object)bos);
            this.idr.setProperty("device.component", (Object)new EmptyUpdateNotifier(this.cm, gcs.getChartModel()));
            gr.render(this.idr, gcs);
            rowAdapter.close();
            try {
                bos.close();
                this.fis = new ByteArrayInputStream(baos.toByteArray());
            }
            catch (Exception ioex) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 3, (Throwable)ioex);
            }
            if (!"SVG".equals(this.sExtension) && this.idr instanceof IImageMapEmitter) {
                this.imageMap = ((IImageMapEmitter)this.idr).getImageMap();
            }
        }
        catch (BirtException birtException) {
            Throwable ex = birtException;
            while (ex.getCause() != null) {
                ex = ex.getCause();
            }
            if (ex instanceof ChartException && ((ChartException)ex).getType() == 16) {
                return null;
            }
            if (ex instanceof ChartException && ((ChartException)ex).getType() == 20) {
                return null;
            }
            if (ex instanceof ChartException && ((ChartException)ex).getType() == 18) {
                logger.log((Exception)((Object)birtException));
                return null;
            }
            logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsFailed"));
            logger.log((Exception)((Object)birtException));
            throw birtException;
        }
        catch (RuntimeException ex) {
            logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsFailed"));
            logger.log((Exception)ex);
            throw new ChartException("org.eclipse.birt.chart.reportitem", 3, (Throwable)ex);
        }
        logger.log(1, Messages.getString("ChartReportItemPresentationImpl.onRowSetsEnd"));
        if ("SVG".equals(this.sExtension)) {
            return this.fis;
        }
        return new Object[]{this.fis, this.imageMap};
    }

    public Size getSize() {
        if (this.cm != null) {
            logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.getSizeStart"));
            Size sz = new Size();
            sz.setWidth((float)this.cm.getBlock().getBounds().getWidth());
            sz.setHeight((float)this.cm.getBlock().getBounds().getHeight());
            sz.setUnit("pt");
            logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.getSizeEnd"));
            return sz;
        }
        return super.getSize();
    }

    public void finish() {
        logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.finishStart"));
        try {
            this.imageMap = null;
            if (this.fis != null) {
                this.fis.close();
                this.fis = null;
            }
        }
        catch (IOException ioex) {
            logger.log((Exception)ioex);
        }
        if (this.idr != null) {
            this.idr.dispose();
            this.idr = null;
        }
        logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.finishEnd"));
    }
}

