/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.QueryHelper;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.report.engine.extension.ReportItemQueryBase;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;

public final class ChartReportItemQueryImpl
extends ReportItemQueryBase {
    private Chart cm = null;
    private ExtendedItemHandle eih = null;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public void setModelObject(ExtendedItemHandle eih) {
        IReportItem item;
        block5: {
            try {
                item = eih.getReportItem();
                if (item != null) break block5;
                try {
                    eih.loadExtendedElement();
                }
                catch (ExtendedElementException eeex) {
                    logger.log((Exception)((Object)eeex));
                }
                item = eih.getReportItem();
                if (item == null) {
                    logger.log(4, Messages.getString("ChartReportItemQueryImpl.log.UnableToLocate"));
                    return;
                }
            }
            catch (ExtendedElementException e) {
                logger.log(4, Messages.getString("ChartReportItemQueryImpl.log.UnableToLocate"));
                return;
            }
        }
        this.cm = (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
        this.eih = eih;
    }

    public IBaseQueryDefinition[] getReportQueries(IBaseQueryDefinition ibqdParent) throws BirtException {
        logger.log(1, Messages.getString("ChartReportItemQueryImpl.log.getReportQueries.start"));
        IBaseQueryDefinition ibqd = null;
        try {
            ibqd = new QueryHelper().build(this.eih, ibqdParent, this.cm);
        }
        catch (RuntimeException gex) {
            logger.log((Exception)gex);
            logger.log(1, Messages.getString("ChartReportItemQueryImpl.log.getReportQueries.exception"));
            throw new ChartException("org.eclipse.birt.chart.reportitem", 3, (Throwable)gex);
        }
        logger.log(1, Messages.getString("ChartReportItemQueryImpl.log.getReportQueries.end"));
        return new IBaseQueryDefinition[]{ibqd};
    }
}

