/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.editors;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.ISQLSyntax;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Column;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ConnectionMetaData;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ConnectionMetaDataManager;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Schema;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Table;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class JdbcSQLContentAssistProcessor
implements IContentAssistProcessor,
ISQLSyntax {
    private transient DataSetDesign handle = null;
    private transient ConnectionMetaData metaData = null;
    private transient ICompletionProposal[] lastProposals = null;

    public JdbcSQLContentAssistProcessor(DataSetDesign ds) {
        this.handle = ds;
        DataSourceDesign dataSourceDesign = this.handle.getDataSourceDesign();
        this.setDataSourceHandle(dataSourceDesign);
    }

    public void setDataSourceHandle(DataSourceDesign dataSourceHandle) {
        if (this.metaData != null) {
            this.metaData.clearCache();
            this.metaData = null;
        }
        String driverClass = dataSourceHandle.getPublicProperties().findProperty("odaDriverClass").getValue();
        String url = dataSourceHandle.getPublicProperties().findProperty("odaURL").getValue();
        String user = dataSourceHandle.getPublicProperties().findProperty("odaUser").getValue();
        String password = dataSourceHandle.getPublicProperties().findProperty("odaPassword").getValue();
        this.metaData = ConnectionMetaDataManager.getInstance().getMetaData(driverClass, url, user, password, null);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            if (offset > viewer.getTopIndexStartOffset()) {
                char ch = viewer.getDocument().getChar(offset - 1);
                if (ch == '.') {
                    this.lastProposals = this.getTableOrColumnCompletionProposals(viewer, offset);
                    return this.lastProposals;
                }
                return this.getRelevantProposals(viewer, offset);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private ICompletionProposal[] getTableOrColumnCompletionProposals(ITextViewer viewer, int offset) {
        if (offset > viewer.getTopIndexStartOffset() + 2) {
            try {
                String tableName = this.stripQuotes(this.findWord(viewer, offset - 2));
                String schemaName = null;
                int startOffset = offset - tableName.length() - 2;
                if (startOffset > viewer.getTopIndexStartOffset() && viewer.getDocument().getChar(startOffset) == '.') {
                    schemaName = this.findWord(viewer, startOffset - 1);
                }
                if (schemaName == null) {
                    Schema schema = this.metaData.getSchema(tableName);
                    if (schema != null) {
                        return this.convertTablesToCompletionProposals(schema.getTables(), offset);
                    }
                    ArrayList schemas = this.metaData.getSchemas();
                    Iterator iter = schemas.iterator();
                    while (iter.hasNext()) {
                        schema = (Schema)iter.next();
                        Table table = schema.getTable(tableName);
                        if (table == null) continue;
                        return this.convertColumnsToCompletionProposals(table.getColumns(), offset);
                    }
                } else {
                    Table table;
                    Schema schema = this.metaData.getSchema(schemaName = this.stripQuotes(schemaName));
                    if (schema != null && (table = schema.getTable(tableName)) != null) {
                        return this.convertColumnsToCompletionProposals(table.getColumns(), offset);
                    }
                }
            }
            catch (BadLocationException e) {
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    private ICompletionProposal[] getRelevantProposals(ITextViewer viewer, int offset) throws BadLocationException {
        if (this.lastProposals != null) {
            ArrayList<CompletionProposal> relevantProposals = new ArrayList<CompletionProposal>(10);
            String word = this.findWord(viewer, offset - 1).toLowerCase();
            for (int n = 0; n < this.lastProposals.length; ++n) {
                if (!this.stripQuotes(this.lastProposals[n].getDisplayString().toLowerCase()).startsWith(word)) continue;
                CompletionProposal proposal = new CompletionProposal(this.lastProposals[n].getDisplayString(), offset - word.length(), word.length(), this.lastProposals[n].getDisplayString().length());
                relevantProposals.add(proposal);
            }
            if (relevantProposals.size() > 0) {
                return relevantProposals.toArray(new ICompletionProposal[0]);
            }
        }
        return null;
    }

    private ICompletionProposal[] convertColumnsToCompletionProposals(ArrayList columns, int offset) {
        if (columns.size() > 0) {
            ICompletionProposal[] proposals = new ICompletionProposal[columns.size()];
            Iterator iter = columns.iterator();
            int n = 0;
            while (iter.hasNext()) {
                Column column = (Column)iter.next();
                proposals[n++] = new CompletionProposal(this.addQuotes(column.getName()), offset, 0, column.getName().length());
            }
            return proposals;
        }
        return null;
    }

    private ICompletionProposal[] convertTablesToCompletionProposals(ArrayList tables, int offset) {
        if (tables.size() > 0) {
            ICompletionProposal[] proposals = new ICompletionProposal[tables.size()];
            Iterator iter = tables.iterator();
            int n = 0;
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                proposals[n++] = new CompletionProposal(this.addQuotes(table.getName()), offset, 0, table.getName().length());
            }
            return proposals;
        }
        return null;
    }

    private String findWord(ITextViewer viewer, int offset) throws BadLocationException {
        int startOffset;
        char ch = viewer.getDocument().getChar(offset);
        if (this.isClosingQuoteChar(ch)) {
            --startOffset;
            char quoteChar = ch;
            if (quoteChar != '\'' || quoteChar != '\"') {
                quoteChar = this.getOpeningQuoteChar();
            }
            while (startOffset > viewer.getTopIndexStartOffset() && (ch = viewer.getDocument().getChar(startOffset)) != quoteChar) {
                --startOffset;
            }
        } else {
            for (startOffset = offset; startOffset > viewer.getTopIndexStartOffset() && viewer.getDocument().getChar(startOffset) != '.' && viewer.getDocument().getChar(startOffset) != ' '; --startOffset) {
            }
            ++startOffset;
        }
        return viewer.getDocument().get(startOffset, offset - startOffset + 1);
    }

    private String stripQuotes(String string) {
        if (string.length() > 0 && this.isOpeningQuoteChar(string.charAt(0)) && this.isClosingQuoteChar(string.charAt(string.length() - 1))) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private String addQuotes(String string) {
        try {
            if (string.indexOf(32) != -1) {
                if ("ACCESS".equalsIgnoreCase(this.metaData.getDatabaseProductName())) {
                    return "[" + string + "]";
                }
                return "\"" + string + "\"";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private boolean isOpeningQuoteChar(char ch) {
        try {
            if ("ACCESS".equalsIgnoreCase(this.metaData.getDatabaseProductName())) {
                return ch == '[';
            }
            return ch == '\'' || ch == '\"';
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isClosingQuoteChar(char ch) {
        try {
            if ("ACCESS".equalsIgnoreCase(this.metaData.getDatabaseProductName())) {
                return ch == ']';
            }
            return ch == '\'' || ch == '\"';
        }
        catch (Exception exception) {
            return false;
        }
    }

    private char getOpeningQuoteChar() {
        try {
            if ("ACCESS".equalsIgnoreCase(this.metaData.getDatabaseProductName())) {
                return '[';
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return '\"';
    }
}

