/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JarFile;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.ui.PlatformUI;

public class JdbcDriverConfigUtil {
    private JdbcDriverConfigUtil() {
    }

    public static List getDriverFiles() {
        try {
            List fileList = OdaJdbcDriver.getDriverFileList();
            Map deletedJars = Utility.getPreferenceStoredMap("Deleted Jar List");
            ArrayList<File> filteredFileList = new ArrayList<File>();
            for (int i = 0; i < fileList.size(); ++i) {
                File f = (File)fileList.get(i);
                if (deletedJars.containsKey(f.getName())) continue;
                filteredFileList.add(f);
            }
            return filteredFileList;
        }
        catch (OdaException e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
        return null;
    }

    static {
        Map map = Utility.getPreferenceStoredMap("Deleted Jar List");
        Set entrySet = map.entrySet();
        Iterator it = entrySet.iterator();
        if (it.hasNext()) {
            Map.Entry entry = it.next();
            it = entrySet.iterator();
            while (it.hasNext()) {
                entry = it.next();
                JarFile jarFile = (JarFile)entry.getValue();
                jarFile.deleteJarFromODADir();
            }
        }
        Utility.setPreferenceStoredMap("Deleted Jar List", new HashMap());
    }
}

