/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Column;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DbObject;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverInfo;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JarFile;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Procedure;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ProcedureParameter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class Utility {
    private static boolean updatedOfJarInfo = false;
    private static boolean updatedOfDriverInfo = false;

    private Utility() {
    }

    public static TreeItem[] createTreeItems(TreeItem parentItem, ArrayList dataSource, int style, Image image) {
        if (dataSource == null) {
            return null;
        }
        TreeItem[] item = new TreeItem[dataSource.size()];
        boolean addDummyNode = false;
        for (int i = 0; i < dataSource.size(); ++i) {
            Object column;
            item[i] = new TreeItem(parentItem, style);
            Object source = dataSource.get(i);
            String displayName = "";
            String name = "";
            if (source instanceof String) {
                name = displayName = (String)source;
                item[i].setData((Object)name);
            } else if (source instanceof TableItem) {
                displayName = ((TableItem)source).getText();
                name = (String)((TableItem)source).getData();
                item[i].setData((Object)name);
            } else if (source instanceof DbObject) {
                DbObject dbObject = (DbObject)source;
                name = dbObject.getName();
                displayName = dbObject.getDisplayName();
                image = dbObject.getImage();
                addDummyNode = true;
                item[i].setData((Object)dbObject);
            } else if (source instanceof Column) {
                column = (Column)source;
                displayName = ((Column)column).getName();
                name = ((Column)column).getTableName() + "." + displayName;
                String type = ((Column)column).getDbType();
                displayName = displayName + " (" + type + ")";
                if (((Column)column).getSchemaName() != null) {
                    name = ((Column)column).getSchemaName() + "." + name;
                }
                item[i].setData((Object)name);
            } else if (source instanceof Procedure) {
                column = (Procedure)source;
                displayName = name = ((Procedure)column).getProcedureName();
                addDummyNode = true;
                if (((Procedure)column).getSchema() != null) {
                    name = ((Procedure)column).getSchema() + "." + displayName;
                }
                item[i].setData(column);
            } else if (source instanceof ProcedureParameter) {
                column = (ProcedureParameter)source;
                displayName = name = ((ProcedureParameter)column).getName();
                if (((ProcedureParameter)column).getSchema() != null) {
                    name = ((ProcedureParameter)column).getSchema() + "." + displayName;
                }
                int type = ((ProcedureParameter)column).getModeType();
                String mode = Utility.toModeType(type);
                String dataType = ((ProcedureParameter)column).getDataTypeName();
                displayName = displayName + " (" + dataType + ", " + mode + ")";
                item[i].setData(column);
            }
            item[i].setText(displayName);
            item[i].setImage(image);
            item[i].setExpanded(false);
            if (!addDummyNode) continue;
            new TreeItem(item[i], style);
        }
        return item;
    }

    public static String toModeType(int type) {
        switch (type) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Input";
            }
            case 2: {
                return "Input/Output";
            }
            case 4: {
                return "Output";
            }
            case 5: {
                return "Return Value";
            }
        }
        return "Unknown";
    }

    public static String getTreeItemsName(TreeItem selectedItem) {
        if (selectedItem == null) {
            return null;
        }
        String name = "";
        Object source = selectedItem.getData();
        if (source instanceof String) {
            name = (String)source;
        } else if (source instanceof TableItem) {
            name = (String)((TableItem)source).getData();
        } else if (source instanceof DbObject) {
            DbObject dbObject = (DbObject)source;
            name = dbObject.getName();
        } else if (source instanceof Column) {
            Column column = (Column)source;
            String displayName = column.getName();
            name = column.getTableName() + "." + displayName;
            String type = column.getDbType();
            displayName = displayName + " (" + type + ")";
            if (column.getSchemaName() != null) {
                name = column.getSchemaName() + "." + name;
            }
        } else if (source instanceof Procedure) {
            Procedure column = (Procedure)source;
            name = column.getProcedureName();
            if (column.getSchema() != null) {
                name = column.getSchema() + "." + name;
            }
        }
        return name;
    }

    public static void setMinScrollPosition(Tree tree) {
        ScrollBar verticalScrollBar;
        if (tree == null) {
            return;
        }
        ScrollBar horizontalScrollBar = tree.getHorizontalBar();
        if (horizontalScrollBar != null) {
            horizontalScrollBar.setThumb(0);
        }
        if ((verticalScrollBar = tree.getVerticalBar()) != null) {
            verticalScrollBar.setThumb(0);
        }
    }

    public static boolean isTableNode(TreeItem item, boolean isSchemaSupported, TreeItem rootNode) {
        if (item != null) {
            if (isSchemaSupported) {
                return item.getParentItem().getParentItem().getParentItem() == null;
            }
            return item.getParentItem().getParentItem() == null;
        }
        return false;
    }

    public static boolean isSchemaNode(TreeItem item, boolean isSchemaSupported, TreeItem rootNode) {
        return item != null && isSchemaSupported && item.getParentItem().getParentItem() == null;
    }

    public static boolean isCatalogNode(TreeItem item) {
        return item != null && item.getParentItem() == null;
    }

    public static Map getPreferenceStoredMap(String mapKey) {
        String driverMap64 = JdbcPlugin.getDefault().getPreferenceStore().getString(mapKey);
        try {
            byte[] bytes;
            ByteArrayInputStream bis;
            Object obj;
            if (driverMap64 != null && (obj = new ObjectInputStream(bis = new ByteArrayInputStream(bytes = Base64.decodeBase64((byte[])driverMap64.getBytes()))).readObject()) instanceof Map) {
                return Utility.updatePreferenceMap((Map)obj, mapKey);
            }
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
        return new HashMap();
    }

    private static Map updatePreferenceMap(Map map, String mapKey) {
        if ("JDBC Driver Map".equals(mapKey)) {
            if (updatedOfDriverInfo) {
                return map;
            }
            updatedOfDriverInfo = true;
        } else if ("JDBC Jar List".equals(mapKey)) {
            if (updatedOfJarInfo) {
                return map;
            }
            updatedOfJarInfo = true;
        } else {
            return map;
        }
        Set entrySet = map.entrySet();
        Iterator it = entrySet.iterator();
        if (!it.hasNext()) {
            return map;
        }
        Map.Entry entry = it.next();
        if (entry.getValue() instanceof DriverInfo || entry.getValue() instanceof JarFile) {
            return map;
        }
        it = entrySet.iterator();
        HashMap rMap = new HashMap();
        if ("JDBC Driver Map".equals(mapKey)) {
            while (it.hasNext()) {
                entry = it.next();
                String[] entryValue = (String[])entry.getValue();
                DriverInfo driverInfo = new DriverInfo(entry.getKey().toString(), entryValue[0], entryValue[1]);
                rMap.put(entry.getKey(), driverInfo);
            }
        } else if ("JDBC Jar List".equals(mapKey)) {
            while (it.hasNext()) {
                entry = it.next();
                String[] entryValue = (String[])entry.getValue();
                JarFile jarFile = new JarFile(Utility.getFileNameFromFilePath(entryValue[0]), entryValue[0], "", false);
                rMap.put(entry.getKey(), jarFile);
            }
        }
        Utility.setPreferenceStoredMap("JDBC Driver Map", rMap);
        return rMap;
    }

    private static String getFileNameFromFilePath(String filePath) {
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + File.separator.length());
        return fileName;
    }

    public static void putPreferenceStoredMapValue(String keyOfPreference, String keyInMap, Object value) {
        Map map = Utility.getPreferenceStoredMap(keyOfPreference);
        map.put(keyInMap, value);
        Utility.setPreferenceStoredMap(keyOfPreference, map);
    }

    public static void removeMapEntryFromPreferenceStoredMap(String keyOfPreference, String keyInMap) {
        Map map = Utility.getPreferenceStoredMap(keyOfPreference);
        if (map.containsKey(keyInMap)) {
            map.remove(keyInMap);
        }
        Utility.setPreferenceStoredMap(keyOfPreference, map);
    }

    public static void setPreferenceStoredMap(String keyOfPreference, Map map) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            new ObjectOutputStream(bos).writeObject(map);
            byte[] bytes = bos.toByteArray();
            bytes = Base64.encodeBase64((byte[])bytes);
            JdbcPlugin.getDefault().getPreferenceStore().setValue(keyOfPreference, new String(bytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setSystemHelp(Control control, String contextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, contextId);
    }
}

