/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.script.EngineClassField;
import org.eclipse.birt.report.designer.internal.ui.editors.script.EngineClassMethod;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSObjectMetaData;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;

class EngineClassJSObject
implements JSObjectMetaData {
    private JSObjectMetaData.JSMethod[] noMthods = new JSObjectMetaData.JSMethod[0];
    private JSObjectMetaData.JSField[] noFields = new JSObjectMetaData.JSField[0];
    private IClassInfo classInfo;
    private boolean showPublic;

    public EngineClassJSObject(IClassInfo classInfo) {
        this.classInfo = classInfo;
        this.showPublic = "DataSet".equals(classInfo.getName()) || "DataSource".equals(classInfo.getName());
    }

    public String getName() {
        if (this.classInfo == null) {
            return "";
        }
        return this.classInfo.getName();
    }

    public JSObjectMetaData.JSMethod[] getMethods() {
        if (this.classInfo == null) {
            return this.noMthods;
        }
        List methods = this.classInfo.getMethods();
        ArrayList<EngineClassMethod> all = new ArrayList<EngineClassMethod>();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            IMethodInfo method = (IMethodInfo)iter.next();
            if (!this.showPublic && !method.isStatic()) continue;
            all.add(new EngineClassMethod(method, this.classInfo));
        }
        Collections.sort(all);
        return all.toArray(new JSObjectMetaData.JSMethod[all.size()]);
    }

    public JSObjectMetaData.JSField[] getFields() {
        if (this.classInfo == null) {
            return this.noFields;
        }
        List members = this.classInfo.getMembers();
        ArrayList<EngineClassField> all = new ArrayList<EngineClassField>();
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            IMemberInfo member = (IMemberInfo)iter.next();
            if (!this.showPublic && !member.isStatic()) continue;
            all.add(new EngineClassField(member, this.classInfo));
        }
        Collections.sort(all);
        return all.toArray(new JSObjectMetaData.JSField[all.size()]);
    }

    public String getDescription() {
        return null;
    }

    public int getVisibility() {
        return 0;
    }
}

