/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.script;

import java.util.Iterator;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSObjectMetaData;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSSyntaxContext;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;

class EngineClassMethod
implements JSObjectMetaData.JSMethod,
Comparable {
    private IMethodInfo method;
    private String displayText;
    private IClassInfo classInfo;

    public EngineClassMethod(IMethodInfo method, IClassInfo classInfo) {
        this.method = method;
        this.classInfo = classInfo;
    }

    public String getName() {
        return this.method.getDisplayName();
    }

    public JSObjectMetaData getReturn() {
        JSObjectMetaData meta = JSSyntaxContext.getEnginJSObject(this.method.getReturnType());
        if (meta == null) {
            try {
                return JSSyntaxContext.getJavaClassMeta(this.method.getReturnType());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return meta;
    }

    public String getDisplayText() {
        if (this.displayText == null) {
            StringBuffer strbuf = new StringBuffer(this.getName());
            strbuf.append("(");
            Iterator iter = this.method.argumentListIterator();
            if (iter.hasNext()) {
                IArgumentInfoList element = (IArgumentInfoList)iter.next();
                int i = 0;
                Iterator iterator = element.argumentsIterator();
                while (iterator.hasNext()) {
                    if (i++ > 0) {
                        strbuf.append(", ");
                    }
                    IArgumentInfo argument = (IArgumentInfo)iterator.next();
                    strbuf.append(argument.getType()).append(" ").append(argument.getName());
                }
            }
            strbuf.append(") ");
            strbuf.append(this.classInfo.getName());
            this.displayText = strbuf.toString();
            Object var1_1 = null;
        }
        return this.displayText;
    }

    public String getDescription() {
        return null;
    }

    public int getVisibility() {
        if (this.method.isStatic()) {
            return 3;
        }
        return 0;
    }

    public int compareTo(Object obj) {
        if (obj instanceof EngineClassMethod && ((EngineClassMethod)obj).getName() != null) {
            return this.getName().compareToIgnoreCase(((EngineClassMethod)obj).getName());
        }
        return 0;
    }
}

