/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.script;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.script.EngineClassJSObject;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSObjectMetaData;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JavaClassJSObject;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;

public class JSSyntaxContext {
    private static Map engineObjectMap = new HashMap();
    private static Map classMap = new HashMap();
    private Map objectMetaMap = new HashMap();

    public static JSObjectMetaData getEnginJSObject(String classType) {
        return engineObjectMap.containsKey(classType) ? (JSObjectMetaData)engineObjectMap.get(classType) : null;
    }

    public static JSObjectMetaData[] getAllEnginJSObjects() {
        return engineObjectMap.values().toArray(new JSObjectMetaData[engineObjectMap.values().size()]);
    }

    public static JSObjectMetaData getJavaClassMeta(String className) throws ClassNotFoundException {
        JSObjectMetaData meta = null;
        if (!classMap.containsKey(className)) {
            meta = new JavaClassJSObject(className);
            classMap.put(className, meta);
        } else {
            meta = (JSObjectMetaData)classMap.get(className);
        }
        return meta;
    }

    public void setVariable(String name, String className) {
        try {
            this.objectMetaMap.put(name, JSSyntaxContext.getJavaClassMeta(className));
        }
        catch (Exception e) {
            if (JSSyntaxContext.getEnginJSObject(className) != null) {
                this.objectMetaMap.put(name, JSSyntaxContext.getEnginJSObject(className));
            }
            this.removeVariable(name);
        }
    }

    public void setVariable(String name, Class clazz) throws ClassNotFoundException {
        this.objectMetaMap.put(name, new JavaClassJSObject(clazz.getName()));
    }

    public void removeVariable(String name) {
        this.objectMetaMap.remove(name);
    }

    public void clear() {
        this.objectMetaMap.clear();
    }

    public JSObjectMetaData getVariableMeta(String variableName) {
        if (this.objectMetaMap.containsKey(variableName)) {
            return (JSObjectMetaData)this.objectMetaMap.get(variableName);
        }
        return JSSyntaxContext.getEnginJSObject(variableName);
    }

    static {
        List engineClassesList = DesignEngine.getMetaDataDictionary().getClasses();
        Iterator iter = engineClassesList.iterator();
        while (iter.hasNext()) {
            IClassInfo element = (IClassInfo)iter.next();
            engineObjectMap.put(element.getName(), new EngineClassJSObject(element));
        }
    }
}

