/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.script;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSObjectMetaData;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSSyntaxContext;

class JavaClassJSObject
implements JSObjectMetaData {
    private Class clazz;

    JavaClassJSObject(Class clazz) {
        this.clazz = clazz;
    }

    public JavaClassJSObject(String className) throws ClassNotFoundException {
        this.clazz = Class.forName(className);
        if (this.clazz.isArray()) {
            this.clazz = this.clazz.getComponentType();
        }
    }

    public String getName() {
        return this.clazz.getName();
    }

    public JSObjectMetaData.JSMethod[] getMethods() {
        ArrayList jsMehods = new ArrayList();
        jsMehods.addAll(this.getMethods(this.clazz.getMethods()));
        Collections.sort(jsMehods);
        return jsMehods.toArray(new JSObjectMetaData.JSMethod[jsMehods.size()]);
    }

    private List getMethods(Method[] methods) {
        int i;
        ArrayList<JavaClassMethod> jsMehods = new ArrayList<JavaClassMethod>();
        ArrayList<String> setMethodList = new ArrayList<String>();
        ArrayList<String> getMethodList = new ArrayList<String>();
        for (i = 0; i < methods.length; ++i) {
            if (methods[i].getName().startsWith("set") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 1) {
                setMethodList.add(methods[i].getName().substring(3));
                continue;
            }
            if (methods[i].getName().startsWith("get") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 0) {
                getMethodList.add(methods[i].getName().substring(3));
                continue;
            }
            jsMehods.add(new JavaClassMethod(methods[i]));
        }
        for (i = 0; i < methods.length; ++i) {
            if (methods[i].getName().startsWith("set") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 1) {
                if (getMethodList.contains(methods[i].getName().substring(3))) continue;
                jsMehods.add(new JavaClassMethod(methods[i]));
                continue;
            }
            if (!methods[i].getName().startsWith("get") || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 0 || setMethodList.contains(methods[i].getName().substring(3))) continue;
            jsMehods.add(new JavaClassMethod(methods[i]));
        }
        return jsMehods;
    }

    public JSObjectMetaData.JSField[] getFields() {
        ArrayList jsFields = new ArrayList();
        jsFields.addAll(this.getFields(this.clazz));
        Collections.sort(jsFields);
        return jsFields.toArray(new JSObjectMetaData.JSField[jsFields.size()]);
    }

    private List getFields(Class clazz) {
        String methodName;
        int i;
        Method[] methods = clazz.getMethods();
        ArrayList<JavaClassField> jsFields = new ArrayList<JavaClassField>();
        ArrayList<String> setMethodList = new ArrayList<String>();
        for (i = 0; i < methods.length; ++i) {
            methodName = methods[i].getName();
            if (!methodName.startsWith("set") || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 1) continue;
            setMethodList.add(methodName.substring(3));
        }
        for (i = 0; i < methods.length; ++i) {
            methodName = methods[i].getName();
            if (!methods[i].getName().startsWith("get") || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 0 || !setMethodList.contains(methodName.substring(3))) continue;
            Class<?> type = methods[i].getReturnType();
            JavaClassField field = new JavaClassField(methods[i].getDeclaringClass(), this.getFieldName(methodName), type.getName(), type.isArray());
            if (jsFields.contains(field)) continue;
            jsFields.add(field);
        }
        Field[] fields = clazz.getFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            jsFields.add(new JavaClassField(fields[i2]));
        }
        return jsFields;
    }

    private String getFieldName(String methodName) {
        if (methodName.length() == 3) {
            return "";
        }
        return Introspector.decapitalize(methodName.substring(3));
    }

    public String toString() {
        return this.clazz.getName();
    }

    public String getDescription() {
        return null;
    }

    public int getVisibility() {
        return 0;
    }

    private String getSimpleName(Class clazz) {
        String simpleName = null;
        if (clazz.isArray()) {
            simpleName = clazz.getComponentType().getName();
            if (!clazz.getComponentType().isPrimitive()) {
                simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1);
            }
            simpleName = simpleName + "[]";
        } else {
            simpleName = clazz.getName();
            if (!clazz.isPrimitive()) {
                simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1);
            }
        }
        return simpleName;
    }

    private Object getSimpleName(String name) {
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private class JavaClassField
    implements JSObjectMetaData.JSField,
    Comparable {
        private String name;
        private JSObjectMetaData type;
        private Field field;
        private Class declareClazz;
        private String displayText;
        private boolean isArray;

        public JavaClassField(Field field) {
            this.field = field;
            this.name = field.getName();
            try {
                this.type = JSSyntaxContext.getJavaClassMeta(field.getType().getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        public JavaClassField(Class declareClazz, String name, String type, boolean isArray) {
            this.declareClazz = declareClazz;
            this.name = name;
            try {
                this.type = JSSyntaxContext.getJavaClassMeta(type);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            this.isArray = isArray;
        }

        public String getName() {
            return this.name;
        }

        public JSObjectMetaData getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof JavaClassField) || ((JavaClassField)obj).getName() == null) {
                return false;
            }
            return ((JavaClassField)obj).getName().equals(this.name);
        }

        public String getDisplayText() {
            if (this.displayText == null) {
                StringBuffer strbuf = new StringBuffer(this.getName());
                strbuf.append(" ");
                if (this.field != null && this.field.getType() != null) {
                    strbuf.append(JavaClassJSObject.this.getSimpleName(this.field.getType()));
                    strbuf.append(" - ");
                } else if (this.type != null) {
                    strbuf.append(JavaClassJSObject.this.getSimpleName(this.type.getName()));
                    if (this.isArray) {
                        strbuf.append("[]");
                    }
                    strbuf.append(" - ");
                }
                if (this.field == null) {
                    strbuf.append(JavaClassJSObject.this.getSimpleName(this.declareClazz));
                } else {
                    strbuf.append(JavaClassJSObject.this.getSimpleName(this.field.getDeclaringClass()));
                }
                this.displayText = strbuf.toString();
                Object var1_1 = null;
            }
            return this.displayText;
        }

        public String getDescription() {
            return null;
        }

        public int getVisibility() {
            if (this.field == null) {
                return 0;
            }
            if ((this.field.getModifiers() & 8) != 0) {
                return 3;
            }
            if ((this.field.getModifiers() & 1) != 0) {
                return 0;
            }
            if ((this.field.getModifiers() & 2) != 0) {
                return 2;
            }
            if ((this.field.getModifiers() & 4) != 0) {
                return 1;
            }
            return 0;
        }

        public int compareTo(Object obj) {
            if (obj instanceof JavaClassField && ((JavaClassField)obj).getName() != null) {
                if (this.getVisibility() == 3 && ((JavaClassField)obj).getVisibility() == 0) {
                    return 1;
                }
                return this.getName().compareToIgnoreCase(((JavaClassField)obj).getName());
            }
            return 0;
        }
    }

    private class JavaClassMethod
    implements JSObjectMetaData.JSMethod,
    Comparable {
        private Method method;
        private String displayText;

        public JavaClassMethod(Method method) {
            this.method = method;
        }

        public String getName() {
            return this.method.getName();
        }

        public JSObjectMetaData getReturn() {
            try {
                return JSSyntaxContext.getJavaClassMeta(this.method.getReturnType().getName());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public String getDisplayText() {
            if (this.displayText == null) {
                StringBuffer strbuf = new StringBuffer(this.getName());
                strbuf.append("(");
                Class<?>[] parameters = this.method.getParameterTypes();
                for (int i = 0; i < parameters.length; ++i) {
                    if (i > 0) {
                        strbuf.append(", ");
                    }
                    strbuf.append(JavaClassJSObject.this.getSimpleName(parameters[i])).append(" ").append("arg").append(i + 1);
                }
                strbuf.append(") ");
                strbuf.append(JavaClassJSObject.this.getSimpleName(this.method.getReturnType()));
                strbuf.append(" - ");
                strbuf.append(JavaClassJSObject.this.getSimpleName(this.method.getDeclaringClass()));
                this.displayText = strbuf.toString();
                Object var1_1 = null;
            }
            return this.displayText;
        }

        public String getDescription() {
            return null;
        }

        public int getVisibility() {
            if ((this.method.getModifiers() & 8) != 0) {
                return 3;
            }
            if ((this.method.getModifiers() & 1) != 0) {
                return 0;
            }
            if ((this.method.getModifiers() & 2) != 0) {
                return 2;
            }
            if ((this.method.getModifiers() & 4) != 0) {
                return 1;
            }
            return 0;
        }

        public int compareTo(Object obj) {
            if (obj instanceof JavaClassMethod && ((JavaClassMethod)obj).getName() != null) {
                if (this.getVisibility() == 3 && ((JavaClassMethod)obj).getVisibility() == 0) {
                    return 1;
                }
                return this.getName().compareToIgnoreCase(((JavaClassMethod)obj).getName());
            }
            return 0;
        }
    }
}

