/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors.pages;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.xml.XMLEditor;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class ReportXMLSourceEditorFormPage
extends XMLEditor
implements IReportEditorPage {
    public static final String ID = "org.eclipse.birt.report.designer.ui.editors.xmlsource";
    private ActionRegistry registry;
    private FormEditor editor;
    private Control control;
    private int staleType;
    private int index;
    private ErrorDetail errorDetail;

    public void initialize(FormEditor editor) {
        this.editor = editor;
        this.setRangeIndicator(new Annotation(){});
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        IReportProvider provider = this.getProvider();
        if (provider != null && this.getErrorLIine() == -1) {
            ModuleHandle model = provider.getReportModuleHandle((Object)this.getEditorInput(), true);
            SessionHandleAdapter.getInstance().setReportDesignHandle(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getErrorLIine() {
        this.errorDetail = null;
        IEditorInput input = this.getEditorInput();
        if (!(input instanceof IPathEditorInput)) {
            return 0;
        }
        IPath path = ((IPathEditorInput)input).getPath();
        try {
            if (path.toOSString().endsWith(".rptlibrary")) {
                LibraryHandle library = null;
                try {
                    library = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(path.toOSString());
                    return -1;
                }
                catch (DesignFileException e) {
                    int n = this.getExpetionErrorLine(e);
                    return n;
                }
                finally {
                    if (library != null) {
                        library.close();
                    }
                }
            }
            ReportDesignHandle report = null;
            try {
                report = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(path.toOSString(), (InputStream)new FileInputStream(path.toFile()));
                return -1;
            }
            catch (DesignFileException e) {
                int n = this.getExpetionErrorLine(e);
                return n;
            }
            finally {
                if (report != null) {
                    report.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            return 0;
        }
    }

    private int getExpetionErrorLine(DesignFileException e) {
        List errorList = e.getErrorList();
        Iterator iter = errorList.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof ErrorDetail)) continue;
            this.errorDetail = (ErrorDetail)element;
            return ((ErrorDetail)element).getLineNo();
        }
        return 0;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public void setActive(boolean active) {
    }

    public boolean isActive() {
        return false;
    }

    public boolean canLeaveThePage() {
        int errorLine;
        if (this.isDirty()) {
            MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"XMLSourcePage.Error.Dialog.title"), null, Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.PromptMsg"), 2, new String[]{Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.Yes"), Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.No"), Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.Cancel")}, 0);
            int ret = prefDialog.open();
            switch (ret) {
                case 0: {
                    this.doSave(null);
                    break;
                }
                case 1: {
                    if (this.getEditorInput() == null) break;
                    this.setInput(this.getEditorInput());
                    break;
                }
                case 2: {
                    return false;
                }
            }
        }
        if ((errorLine = this.getErrorLIine()) > -1) {
            if (this.errorDetail != null && this.errorDetail.getErrorCode().equals("Error.DesignParserException.UNSUPPORTED_VERSION")) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString((String)"XMLSourcePage.Error.Dialog.title"), (String)this.errorDetail.getMessage());
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString((String)"XMLSourcePage.Error.Dialog.title"), (String)Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.InvalidFile"));
            }
            this.setFocus();
            this.setHighlightLine(errorLine);
            return false;
        }
        return true;
    }

    private void setHighlightLine(int errorLine) {
        try {
            IRegion region = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineInformation(errorLine);
            this.setHighlightRange(region.getOffset(), region.getLength(), true);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Control getPartControl() {
        return this.control;
    }

    public String getId() {
        return ID;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        return false;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.control = children[children.length - 1];
    }

    public boolean onBroughtToTop(IReportEditorPage prePage) {
        if (this.getEditorInput() != prePage.getEditorInput()) {
            this.setInput(prePage.getEditorInput());
        }
        if (prePage.isDirty() || prePage.getStaleType() != 0) {
            prePage.doSave(null);
            prePage.markPageStale(0);
            this.refreshDocument();
            this.markPageStale(0);
        }
        ReportRequest request = new ReportRequest((Object)this);
        ArrayList list = new ArrayList();
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
        return true;
    }

    public void markPageStale(int type) {
        this.staleType = type;
    }

    public int getStaleType() {
        return this.staleType;
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            if (this.editor != null) {
                this.markPageStale(2);
                this.editor.editorDirtyStateChanged();
            }
        } else {
            super.firePropertyChange(type);
        }
    }

    public Object getAdapter(Class required) {
        if (required.equals(ActionRegistry.class)) {
            if (this.registry == null) {
                this.registry = new ActionRegistry();
            }
            return this.registry;
        }
        return super.getAdapter(required);
    }

    protected IReportProvider getProvider() {
        IReportProvider provider = (IReportProvider)this.editor.getAdapter(IReportProvider.class);
        if (provider == null) {
            provider = super.getProvider();
        }
        return provider;
    }

    protected void finalize() throws Throwable {
        if (Policy.TRACING_PAGE_CLOSE) {
            System.out.println("Report source page finalized");
        }
        super.finalize();
    }
}

