/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.ui.dse.DSEPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class DeleteAction
implements IActionDelegate {
    private Shell mParentShell = null;
    private Iterator mIterator = null;

    public DeleteAction() {
        Display display = Display.getCurrent();
        this.mParentShell = display.getActiveShell();
    }

    public void run(IAction action) {
        while (this.mIterator != null && this.mIterator.hasNext()) {
            Object object = this.mIterator.next();
            if (!(object instanceof IConnectionProfile)) continue;
            IConnectionProfile profile = (IConnectionProfile)object;
            boolean ret = MessageDialog.openQuestion((Shell)this.mParentShell, (String)DSEPlugin.getDefault().getResourceString("actions.delete.title"), (String)DSEPlugin.getDefault().getResourceString("actions.delete.confirm", new String[]{profile.getName()}));
            if (!ret) {
                return;
            }
            try {
                ProfileManager.getInstance().deleteProfile(profile);
            }
            catch (ConnectionProfileException e) {
                ExceptionHandler.showException((Shell)this.mParentShell, (String)DSEPlugin.getDefault().getResourceString("dialog.title.error"), (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mIterator = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            action.setEnabled(structuredSelection.size() > 0);
            if (structuredSelection.size() > 0) {
                this.mIterator = structuredSelection.iterator();
            }
        }
    }
}

