/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.ui.dse.DSEPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;

public class ViewPropertyAction
extends Action {
    private TreeViewer mViewer;

    public ViewPropertyAction(Viewer viewer) {
        this.mViewer = (TreeViewer)viewer;
        this.setText(DSEPlugin.getDefault().getResourceString("ServersView.action.showproperties"));
    }

    public static boolean hasContributors(Object selected) {
        if (selected == null || !(selected instanceof IAdaptable)) {
            return false;
        }
        return PropertyPageContributorManager.getManager().hasContributorsFor(selected);
    }

    public void run() {
        Object selected = this.getSelectedObject();
        if (selected == null || !(selected instanceof IAdaptable)) {
            return;
        }
        IAdaptable adaptable = (IAdaptable)selected;
        PropertyPageManager pageManager = new PropertyPageManager();
        String title = DSEPlugin.getDefault().getResourceString("properties.dialog");
        PropertyPageContributorManager.getManager().contribute(pageManager, (Object)adaptable);
        PropertyDialog propertyDialog = new PropertyDialog(this.mViewer.getControl().getShell(), (PreferenceManager)pageManager, this.mViewer.getSelection());
        propertyDialog.create();
        propertyDialog.getShell().setText(title);
        propertyDialog.open();
        this.mViewer.setSelection(this.mViewer.getSelection());
    }

    public Object getSelectedObject() {
        ISelection selection = this.mViewer.getSelection();
        Object selectedObj = null;
        if (selection == null) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selectedObj = structuredSelection.getFirstElement();
        }
        return selectedObj;
    }
}

