/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.gef.commands.Command;

public class MoveGuideCommand
extends Command {
    private int pDelta;
    private String propertyName;

    public MoveGuideCommand(int delta, String propertyName) {
        this.pDelta = delta;
        this.propertyName = propertyName;
    }

    public void execute() {
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        MasterPageHandle page = SessionHandleAdapter.getInstance().getMasterPageHandle();
        String unit = handle.getDefaultUnits();
        double value = MetricUtility.pixelToPixelInch(this.pDelta);
        if (value < 0.0) {
            value = 0.0;
        }
        DimensionValue dim = DimensionUtil.convertTo((double)value, (String)"in", (String)unit);
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("MoveGuideCommand >>  Starts. Target: " + page.getDisplayLabel() + ",Property: " + this.propertyName + ",Value: " + dim.toDisplayString());
        }
        try {
            page.setProperty(this.propertyName, (Object)dim);
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("MoveGuideCommand >> Finished.");
            }
        }
        catch (SemanticException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("MoveGuideCommand >> Failed.");
            }
            e.printStackTrace();
        }
    }
}

