/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.views.outline.EmbeddedImageNode;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.gef.commands.Command;

public class PasteStructureCommand
extends Command {
    private IStructure copyData;
    private Object container;

    public PasteStructureCommand(IStructure copyData, Object container) {
        this.copyData = copyData;
        this.container = container;
    }

    public boolean canExecute() {
        return DNDUtil.handleValidateTargetCanContain(this.container, this.copyData);
    }

    public void execute() {
        if (this.container instanceof EmbeddedImageNode) {
            this.container = ((EmbeddedImageNode)this.container).getReportDesignHandle();
        }
        try {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("PasteStructureCommand >>  Starts. Source: " + this.copyData.getStructName() + ",Target: " + DEUtil.getDisplayLabel(this.container));
            }
            EmbeddedImage image = (EmbeddedImage)this.copyData.copy();
            ((ModuleHandle)this.container).rename(image);
            ((ModuleHandle)this.container).addImage(image);
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("PasteStructureCommand >>  Finished");
            }
        }
        catch (SemanticException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("PasteStructureCommand >>  Failed");
            }
            e.printStackTrace();
        }
    }
}

