/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;

public abstract class DesignElementHandleAdapter {
    private DesignElementHandle elementHandle;
    private IModelAdapterHelper helper;

    public DesignElementHandleAdapter(DesignElementHandle element, IModelAdapterHelper mark) {
        this.elementHandle = element;
        this.helper = mark;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public String getDisplayName() {
        return this.getHandle().getDisplayLabel();
    }

    public DesignElementHandle getHandle() {
        return this.elementHandle;
    }

    public ReportDesignHandle getReportDesignHandle() {
        return this.elementHandle.getDesignHandle();
    }

    public ModuleHandle getModuleHandle() {
        if (this.elementHandle != null) {
            return this.elementHandle.getModuleHandle();
        }
        return null;
    }

    public void reload() {
    }

    public boolean checkDirty() {
        if (this.helper != null) {
            return this.helper.isDirty();
        }
        return true;
    }

    protected IModelAdapterHelper getModelAdaptHelper() {
        return this.helper;
    }

    protected Dimension getDefaultSize() {
        return this.helper.getPreferredSize().shrink(this.helper.getInsets().getWidth(), this.helper.getInsets().getHeight());
    }

    public void setElementHandle(DesignElementHandle handle) {
        this.elementHandle = handle;
    }

    public void transStar(String name) {
        CommandStack stack = this.getModuleHandle().getCommandStack();
        stack.startTrans(name);
    }

    public void transEnd() {
        CommandStack stack = this.getModuleHandle().getCommandStack();
        stack.commit();
    }

    public Insets getPadding(Insets retValue) {
        retValue = retValue == null ? new Insets() : new Insets(retValue);
        int fontSize = DEUtil.getFontSizeIntValue(this.getHandle());
        DimensionValue dimensionValue = (DimensionValue)this.getHandle().getProperty("paddingTop");
        double px = DEUtil.convertToPixel(dimensionValue, fontSize);
        dimensionValue = (DimensionValue)this.getHandle().getProperty("paddingBottom");
        double py = DEUtil.convertToPixel(dimensionValue, fontSize);
        retValue.top = (int)px;
        retValue.bottom = (int)py;
        dimensionValue = (DimensionValue)this.getHandle().getProperty("paddingLeft");
        px = DEUtil.convertToPixel(dimensionValue, fontSize);
        dimensionValue = (DimensionValue)this.getHandle().getProperty("paddingRight");
        py = DEUtil.convertToPixel(dimensionValue, fontSize);
        retValue.left = (int)px;
        retValue.right = (int)py;
        return retValue;
    }

    public Insets getMargin(Insets retValue) {
        retValue = retValue == null ? new Insets() : new Insets(retValue);
        int fontSize = DEUtil.getFontSizeIntValue(this.getHandle());
        double px = 0.0;
        Object prop = this.getHandle().getProperty("marginTop");
        if (!"auto".equals(prop)) {
            px = DEUtil.convertToPixel(prop, fontSize);
        }
        double py = 0.0;
        prop = this.getHandle().getProperty("marginBottom");
        if (!"auto".equals(prop)) {
            py = DEUtil.convertToPixel(prop, fontSize);
        }
        retValue.top = (int)px;
        retValue.bottom = (int)py;
        py = 0.0;
        px = 0.0;
        prop = this.getHandle().getProperty("marginLeft");
        if (!"auto".equals(prop)) {
            px = DEUtil.convertToPixel(prop, fontSize);
        }
        if (!"auto".equals(prop = this.getHandle().getProperty("marginRight"))) {
            py = DEUtil.convertToPixel(prop, fontSize);
        }
        retValue.left = (int)px;
        retValue.right = (int)py;
        return retValue;
    }

    public int getForegroundColor(DesignElementHandle handle) {
        Object obj = handle.getProperty("color");
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return ColorUtil.parseColor((String)((String)obj));
        }
        return (Integer)obj;
    }

    public int getBackgroundColor(DesignElementHandle handle) {
        Object obj = handle.getProperty("backgroundColor");
        if (obj == null) {
            return 0xFFFFFF;
        }
        if (obj instanceof String) {
            return ColorUtil.parseColor((String)((String)obj));
        }
        return (Integer)obj;
    }

    public String getBackgroundImage(DesignElementHandle handle) {
        return handle.getStringProperty("backgroundImage");
    }

    public Object getBackgroundPosition(DesignElementHandle handle) {
        int x = 0;
        int y = 0;
        Object px = handle.getProperty("backgroundPositionX");
        Object py = handle.getProperty("backgroundPositionY");
        if (px instanceof String && py instanceof String) {
            return new int[]{this.getPosition((String)px), this.getPosition((String)py)};
        }
        if (px instanceof DimensionValue && py instanceof DimensionValue) {
            if ("%".equals(((DimensionValue)px).getUnits())) {
                if (!"%".equals(((DimensionValue)py).getUnits())) {
                    return new int[]{2, 2};
                }
                return new DimensionValue[]{(DimensionValue)px, (DimensionValue)py};
            }
            x = (int)DEUtil.convertoToPixel(px);
            y = (int)DEUtil.convertoToPixel(py);
            return new Point(x, y);
        }
        return new int[]{2, 2};
    }

    public int getBackgroundRepeat(DesignElementHandle handle) {
        return this.getRepeat(handle.getStringProperty("backgroundRepeat"));
    }

    private int getPosition(String position) {
        if ("left".equals(position)) {
            return 8;
        }
        if ("right".equals(position)) {
            return 16;
        }
        if ("top".equals(position)) {
            return 1;
        }
        if ("bottom".equals(position)) {
            return 4;
        }
        return 2;
    }

    private int getRepeat(String repeat) {
        if ("repeat-x".equals(repeat)) {
            return 1;
        }
        if ("repeat-y".equals(repeat)) {
            return 2;
        }
        if ("repeat".equals(repeat)) {
            return 3;
        }
        return 0;
    }

    public boolean isChildren(DesignElementHandle handle) {
        while (handle != null) {
            if (handle.equals(this.elementHandle)) {
                return true;
            }
            handle = handle.getContainer();
        }
        return false;
    }
}

