/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.LibRootModel;
import org.eclipse.birt.report.designer.core.model.ReportDesignHandleAdapter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;

public class LibraryHandleAdapter
extends ReportDesignHandleAdapter {
    private Object currentEditorModel;
    public static final String CURRENTMODEL = "current model";
    public static final String CREATE_ELEMENT = "create element";
    private List listeners = new ArrayList();

    public LibraryHandleAdapter(ModuleHandle handle) {
        super(handle);
        this.setCurrentEditorModel(handle, CURRENTMODEL);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void firePropertyChangeEvent(PropertyChangeEvent event) {
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            PropertyChangeListener listener = (PropertyChangeListener)this.listeners.get(i);
            listener.propertyChange(event);
        }
    }

    public List getChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getTopContainer(this.getCurrentEditorModel()));
        return list;
    }

    private Object getTopContainer(Object currentModel) {
        Object obj = currentModel;
        if (currentModel instanceof DesignElementHandle) {
            DesignElementHandle handle = (DesignElementHandle)currentModel;
            while (handle.getContainer() != null) {
                if (handle.getContainer() instanceof ModuleHandle) {
                    obj = handle;
                    break;
                }
                handle = handle.getContainer();
            }
        }
        return obj;
    }

    public Object getCurrentEditorModel() {
        return this.currentEditorModel;
    }

    public void setCurrentEditorModel(Object current, String type) {
        Object old = this.currentEditorModel;
        this.currentEditorModel = current == null || current instanceof LibraryHandle ? new LibRootModel(current) : current;
        PropertyChangeEvent event = new PropertyChangeEvent(this, type, old, this.currentEditorModel);
        this.firePropertyChangeEvent(event);
    }
}

