/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ReportItemtHandleAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;

public class ImageHandleAdapter
extends ReportItemtHandleAdapter {
    public ImageHandleAdapter(ImageHandle image, IModelAdapterHelper mark) {
        super((ReportItemHandle)image, mark);
    }

    public Image getImage() {
        String imageSource = this.getImageHandle().getSource();
        if ("embed".equalsIgnoreCase(imageSource)) {
            return ImageManager.getInstance().getImage(this.getImageHandle().getModuleHandle(), this.getImageHandle().getImageName());
        }
        if ("url".equalsIgnoreCase(imageSource) || "file".equalsIgnoreCase(imageSource)) {
            if (URIUtil.isValidResourcePath((String)this.getImageHandle().getURI())) {
                return ImageManager.getInstance().getImage(URIUtil.getLocalPath((String)this.removeQuoteString(this.getImageHandle().getURI())));
            }
            return ImageManager.getInstance().getImage(this.removeQuoteString(this.getImageHandle().getURI()));
        }
        if ("expr".equalsIgnoreCase(imageSource)) {
            // empty if block
        }
        return null;
    }

    private String removeQuoteString(String value) {
        if (value != null && value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private ImageHandle getImageHandle() {
        return (ImageHandle)this.getHandle();
    }

    public Dimension getSize() {
        DimensionHandle handle = this.getImageHandle().getWidth();
        int px = (int)DEUtil.convertoToPixel(handle);
        handle = this.getImageHandle().getHeight();
        int py = (int)DEUtil.convertoToPixel(handle);
        if (px != 0 && py != 0) {
            return new Dimension(px, py);
        }
        return null;
    }

    public Dimension getRawSize() {
        DimensionHandle handle = this.getImageHandle().getWidth();
        int px = (int)DEUtil.convertoToPixel(handle);
        handle = this.getImageHandle().getHeight();
        int py = (int)DEUtil.convertoToPixel(handle);
        return new Dimension(Math.max(px, 0), Math.max(py, 0));
    }

    public void setSize(Dimension size) throws SemanticException {
        String w = size.width + "px";
        String h = size.height + "px";
        this.getImageHandle().setWidth(w);
        this.getImageHandle().setHeight(h);
    }
}

