/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.eclipse.birt.report.designer.core.CorePlugin;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ImageManager {
    private static final String EMBEDDED_SUFFIX = ".Embedded.";
    private static final ImageManager instance = new ImageManager();
    private List invalidUrlList = new ArrayList();

    private ImageManager() {
    }

    public static ImageManager getInstance() {
        return instance;
    }

    public Image getImage(String uri, boolean refresh) {
        Image image;
        URL url = null;
        try {
            url = this.generateURL(uri);
            if (url == null) {
                return null;
            }
            if (!refresh && this.invalidUrlList.contains(url.toString())) {
                return null;
            }
            String key = url.toString();
            image = this.getImageRegistry().get(key);
            if (image == null) {
                image = this.loadImage(url);
            }
            if (image == null) {
                if (!this.invalidUrlList.contains(url.toString())) {
                    this.invalidUrlList.add(url.toString());
                }
            } else {
                this.invalidUrlList.remove(url.toString());
            }
        }
        catch (Exception e) {
            if (url != null && !this.invalidUrlList.contains(url.toString())) {
                this.invalidUrlList.add(url.toString());
            }
            return null;
        }
        return image;
    }

    public Image getImage(String uri) {
        return this.getImage(uri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Image getImage(ModuleHandle handle, String name) {
        block19: {
            key = this.generateKey(handle, name);
            embeddedImage = handle.findImage(name);
            if (embeddedImage == null) {
                this.removeCachedImage(key);
                return null;
            }
            image = this.getImageRegistry().get(key);
            if (image != null) {
                return image;
            }
            in = null;
            try {
                if (key.toLowerCase().endsWith(".svg")) {
                    transcoder = new JPEGTranscoder();
                    transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
                    input = new TranscoderInput((InputStream)new ByteArrayInputStream(embeddedImage.getData(handle.getModule())));
                    input.setURI(this.generateURL(handle.getFileName()).toString());
                    ostream = new ByteArrayOutputStream();
                    output = new TranscoderOutput((OutputStream)ostream);
                    try {
                        transcoder.transcode(input, output);
                    }
                    catch (TranscoderException e) {
                        // empty catch block
                    }
                    ostream.flush();
                    in = new ByteArrayInputStream(ostream.toByteArray());
                } else {
                    in = new ByteArrayInputStream(embeddedImage.getData(handle.getModule()));
                }
                image = new Image(null, in);
                var13_13 = null;
                ** if (in == null) goto lbl-1000
            }
            catch (Throwable var12_19) {
                var13_15 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var12_19;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block19;
                catch (Exception e) {
                    var13_14 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        if (image != null) {
            this.getImageRegistry().put(key, image);
            if (DesignerConstants.TRACING_IMAGE_MANAGER_IMAGE_ADD) {
                System.out.println("Image Manager >> " + key + " added");
            }
        }
        return image;
    }

    public void removeCachedImage(String key) {
        this.getImageRegistry().remove(key);
        if (DesignerConstants.TRACING_IMAGE_MANAGER_IMAGE_REMOVE) {
            System.out.println("Image Manager >> " + key + " removed");
        }
    }

    public Image loadImage(String uri) throws IOException {
        URL url = this.generateURL(uri);
        if (url == null) {
            throw new FileNotFoundException(uri);
        }
        return this.loadImage(url);
    }

    private Image loadImage(URL url) throws IOException {
        String key = url.toString();
        Image image = this.getImageRegistry().get(key);
        if (image != null) {
            return image;
        }
        InputStream in = null;
        try {
            if (url.toString().toLowerCase().endsWith(".svg")) {
                JPEGTranscoder transcoder = new JPEGTranscoder();
                transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
                String svgURI = url.toString();
                TranscoderInput input = new TranscoderInput(svgURI);
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
                try {
                    transcoder.transcode(input, output);
                }
                catch (TranscoderException e) {
                    // empty catch block
                }
                ostream.flush();
                in = new ByteArrayInputStream(ostream.toByteArray());
            } else {
                in = url.openStream();
            }
            image = new Image(null, in);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (image != null) {
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    private ImageRegistry getImageRegistry() {
        return CorePlugin.getDefault().getImageRegistry();
    }

    private URL generateURL(String uri) throws MalformedURLException {
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            String path = URIUtil.getLocalPath((String)uri);
            if (path != null) {
                ModuleHandle designHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                return designHandle.findResource(path, 1);
            }
            return URI.create(uri).toURL();
        }
    }

    public String generateKey(ModuleHandle reportDesignHandle, String name) {
        return reportDesignHandle.hashCode() + EMBEDDED_SUFFIX + name;
    }
}

