/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.Calendar;
import java.util.Arrays;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.RotatedRectangle;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.factory.DateFormatWrapperFactory;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;

public final class AutoScale
extends Methods
implements Cloneable {
    private final int iType;
    private Object oMinimum;
    private Object oMaximum;
    private Object oStep;
    private Object oUnit;
    private double dStartShift;
    private double dEndShift;
    private double dZoomFactor = 1.0;
    private transient double dStart;
    private transient double dEnd;
    private transient double[] daTickCoordinates;
    private transient boolean[] baTickLabelVisible;
    private transient boolean[] baTickLabelStaggered;
    private transient DataSetIterator dsiData;
    private transient boolean bCategoryScale = false;
    private RunTimeContext rtc;
    private static final String sNumericPattern = "0";
    private static int[] iaLinearDeltas = new int[]{1, 2, 5, 10};
    private static int[] iaLogarithmicDeltas = new int[]{10};
    private static int[] iaCalendarUnits = new int[]{13, 12, 11, 5, 2, 1};
    private static int[] iaSecondDeltas = new int[]{1, 5, 10, 15, 20, 30};
    private static int[] iaMinuteDeltas = new int[]{1, 5, 10, 15, 20, 30};
    private static int[] iaHourDeltas = new int[]{1, 2, 3, 4, 12};
    private static int[] iaDayDeltas = new int[]{1, 7, 14};
    private static int[] iaMonthDeltas = new int[]{1, 2, 3, 4, 6};
    private static int[][] iaCalendarDeltas = new int[][]{iaSecondDeltas, iaMinuteDeltas, iaHourDeltas, iaDayDeltas, iaMonthDeltas, null};
    private boolean bIntegralZoom = true;
    private boolean bMinimumFixed = false;
    private boolean bMaximumFixed = false;
    private boolean bStepFixed = false;
    private int iScaleDirection = 0;
    private boolean bAxisLabelStaggered = false;
    private int iLabelShowingInterval = 0;
    private FormatSpecifier fs = null;
    private double dPrecision = 0.0;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/computation.withaxes");

    AutoScale(int _iType) {
        this.iType = _iType;
    }

    public AutoScale(int _iType, Object _oMinimum, Object _oMaximum, Object _oStep) {
        this.oMinimum = _oMinimum;
        this.oMaximum = _oMaximum;
        this.oStep = _oStep;
        this.iType = _iType;
    }

    AutoScale(int _iType, Object _oMinimum, Object _oMaximum, Object _oUnit, Object _oStep) {
        this.oMinimum = _oMinimum;
        this.oMaximum = _oMaximum;
        this.oUnit = _oUnit;
        this.oStep = _oStep;
        this.iType = _iType;
    }

    final void setFixed(boolean _bMinimum, boolean _bMaximum, boolean _bStep) {
        this.bMinimumFixed = _bMinimum;
        this.bMaximumFixed = _bMaximum;
        this.bStepFixed = _bStep;
    }

    public final void setDirection(int iValue) {
        this.iScaleDirection = iValue;
    }

    public int getDirection() {
        return this.iScaleDirection;
    }

    public final Object clone() {
        AutoScale sc = new AutoScale(this.iType, this.oMinimum, this.oMaximum, this.oStep);
        sc.dStart = this.dStart;
        sc.dEnd = this.dEnd;
        sc.daTickCoordinates = this.daTickCoordinates;
        sc.dStartShift = this.dStartShift;
        sc.dEndShift = this.dEndShift;
        sc.dsiData = this.dsiData;
        sc.oStep = this.oStep;
        sc.oUnit = this.oUnit;
        sc.bMaximumFixed = this.bMaximumFixed;
        sc.bMinimumFixed = this.bMinimumFixed;
        sc.bStepFixed = this.bStepFixed;
        sc.fs = this.fs;
        sc.rtc = this.rtc;
        sc.bIntegralZoom = this.bIntegralZoom;
        sc.bCategoryScale = this.bCategoryScale;
        sc.iScaleDirection = this.iScaleDirection;
        sc.baTickLabelVisible = this.baTickLabelVisible;
        sc.baTickLabelStaggered = this.baTickLabelStaggered;
        sc.bAxisLabelStaggered = this.bAxisLabelStaggered;
        sc.iLabelShowingInterval = this.iLabelShowingInterval;
        return sc;
    }

    public final boolean zoomIn() {
        block19: {
            block16: {
                double dStep;
                block17: {
                    double dStep2;
                    block18: {
                        if (this.bStepFixed) {
                            return false;
                        }
                        if (ChartUtil.mathEqual(0.0, ((Number)this.oStep).doubleValue())) {
                            return false;
                        }
                        if ((this.iType & 1) != 1) break block16;
                        if ((this.iType & 4) != 4) break block17;
                        dStep2 = AutoScale.asDouble(this.oStep);
                        if (!(Math.log(dStep2) / LOG_10 > 1.0)) break block18;
                        this.oStep = new Double(dStep2 / 10.0);
                        break block19;
                    }
                    int n = iaLogarithmicDeltas.length;
                    for (int i = n - 1; i >= 0; --i) {
                        if ((int)dStep2 != iaLogarithmicDeltas[i]) continue;
                        if (i > 0) {
                            this.oStep = new Double(iaLogarithmicDeltas[i - 1]);
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                if ((this.iType & 2) != 2) break block19;
                double oldStep = dStep = AutoScale.asDouble(this.oStep).doubleValue();
                if (this.bIntegralZoom) {
                    double dPower = Math.log(dStep) / LOG_10;
                    dPower = Math.floor(dPower);
                    dPower = Math.pow(10.0, dPower);
                    dStep /= dPower;
                    dStep = Math.round(dStep);
                    int n = iaLinearDeltas.length;
                    for (int i = 0; i < n; ++i) {
                        if ((int)dStep != iaLinearDeltas[i]) continue;
                        if (i > 0) {
                            dStep = (double)iaLinearDeltas[i - 1] * dPower;
                            break;
                        }
                        dStep = (double)iaLinearDeltas[n - 2] * (dPower /= 10.0);
                        break;
                    }
                    if (dStep == oldStep) {
                        dStep /= 2.0;
                    }
                    this.oStep = new Double(dStep);
                } else {
                    this.oStep = new Double(dStep /= 2.0);
                }
                if (((Number)this.oStep).doubleValue() < this.dPrecision) {
                    this.oStep = new Double(oldStep);
                    return false;
                }
                break block19;
            }
            if ((this.iType & 8) == 8) {
                int[] ia = null;
                int iStep = AutoScale.asInteger(this.oStep);
                int iUnit = AutoScale.asInteger(this.oUnit);
                for (int icu = 0; icu < iaCalendarUnits.length; ++icu) {
                    int i;
                    if (iUnit != iaCalendarUnits[icu]) continue;
                    ia = iaCalendarDeltas[icu];
                    if (ia == null) {
                        if (--iStep != 0) continue;
                        this.oStep = new Integer(iaMonthDeltas[iaMonthDeltas.length - 1]);
                        this.oUnit = new Integer(2);
                        continue;
                    }
                    for (i = 0; i < ia.length && ia[i] != iStep; ++i) {
                    }
                    if (i == 0) {
                        if (icu == 0) {
                            return false;
                        }
                        ia = iaCalendarDeltas[icu - 1];
                        i = ia.length;
                        this.oUnit = new Integer(iaCalendarUnits[icu - 1]);
                    }
                    this.oStep = new Integer(ia[i - 1]);
                    break;
                }
            }
        }
        return true;
    }

    public final boolean zoomOut() {
        block19: {
            block16: {
                block17: {
                    double dStep;
                    block18: {
                        if (this.bStepFixed) {
                            return false;
                        }
                        if (((Number)this.oStep).doubleValue() >= Double.MAX_VALUE) {
                            return false;
                        }
                        if ((this.iType & 1) != 1) break block16;
                        if ((this.iType & 4) != 4) break block17;
                        dStep = AutoScale.asDouble(this.oStep);
                        if (!(Math.log(dStep) / LOG_10 >= 1.0)) break block18;
                        this.oStep = new Double(dStep * 10.0);
                        break block19;
                    }
                    int n = iaLogarithmicDeltas.length;
                    for (int i = 0; i < n; ++i) {
                        if ((int)dStep != iaLogarithmicDeltas[i]) continue;
                        this.oStep = new Double(iaLogarithmicDeltas[i + 1]);
                        return true;
                    }
                    return false;
                }
                if ((this.iType & 2) != 2) break block19;
                double dStep = AutoScale.asDouble(this.oStep);
                if (this.bIntegralZoom) {
                    int i;
                    double dPower = Math.log(dStep) / LOG_10;
                    if (dPower < 0.0) {
                        dPower = Math.floor(dPower);
                    }
                    dPower = Math.pow(10.0, dPower);
                    dStep /= dPower;
                    dStep = Math.round(dStep);
                    int n = iaLinearDeltas.length;
                    for (i = 0; i < n; ++i) {
                        if (dStep != (double)iaLinearDeltas[i]) continue;
                        if (i < n - 1) {
                            dStep = (double)iaLinearDeltas[i + 1] * dPower;
                            if (!(dStep > 1.0)) break;
                            dStep = Math.round(dStep);
                            break;
                        }
                        dStep = (double)iaLinearDeltas[0] * (dPower *= 20.0);
                        if (!(dStep > 1.0)) break;
                        dStep = Math.round(dStep);
                        break;
                    }
                    if (i == n) {
                        throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 15, "exception.step.zoom.out", new Object[]{new Double(dStep)}, Messages.getResourceBundle(this.rtc.getULocale()))));
                    }
                    if (((Number)this.oStep).doubleValue() == dStep) {
                        return false;
                    }
                    this.oStep = new Double(dStep);
                } else {
                    this.oStep = new Double(dStep *= 2.0);
                }
                break block19;
            }
            if ((this.iType & 8) == 8) {
                int[] ia = null;
                int iStep = AutoScale.asInteger(this.oStep);
                int iUnit = AutoScale.asInteger(this.oUnit);
                for (int icu = 0; icu < iaCalendarUnits.length; ++icu) {
                    int i;
                    if (iUnit != iaCalendarUnits[icu]) continue;
                    ia = iaCalendarDeltas[icu];
                    if (ia == null) {
                        this.oStep = new Integer(++iStep);
                        continue;
                    }
                    int n = ia.length;
                    for (i = 0; i < n && ia[i] != iStep; ++i) {
                    }
                    if (i == n - 1) {
                        ia = iaCalendarDeltas[icu + 1];
                        this.oUnit = new Integer(iaCalendarUnits[icu + 1]);
                        if (ia == null) {
                            this.oStep = new Integer(1);
                            return false;
                        }
                        i = -1;
                    }
                    this.oStep = new Integer(ia[i + 1]);
                    break;
                }
            }
        }
        return true;
    }

    public final String getNumericPattern(double dValue) {
        if (dValue - (double)((int)dValue) == 0.0) {
            return sNumericPattern;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        String sMinimum = String.valueOf(dValue);
        int iDecimalPosition = sMinimum.indexOf(dfs.getDecimalSeparator());
        if (iDecimalPosition >= 0) {
            int n = sMinimum.length();
            for (int i = n - 1; i > 0 && sMinimum.charAt(i) == '0'; --i) {
                --n;
            }
            int iMantissaCount = n - 1 - iDecimalPosition;
            StringBuffer sb = new StringBuffer(sNumericPattern);
            sb.append('.');
            for (int i = 0; i < iMantissaCount; ++i) {
                sb.append('0');
            }
            return sb.toString();
        }
        return sNumericPattern;
    }

    public final String getNumericPattern() {
        if (this.oMinimum == null || this.oStep == null) {
            return "0.00";
        }
        double dMinValue = AutoScale.asDouble(this.oMinimum);
        double dStep = AutoScale.asDouble(this.oStep);
        if ((this.iType & 4) == 4) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            String sMinimum = this.oMinimum.toString();
            int iDecimalPosition = sMinimum.indexOf(dfs.getDecimalSeparator());
            if (iDecimalPosition >= 0) {
                int n = sMinimum.length();
                for (int i = n - 1; i > 0 && sMinimum.charAt(i) == '0'; --i) {
                    --n;
                }
                int iMantissaCount = n - 1 - iDecimalPosition;
                StringBuffer sb = new StringBuffer(sNumericPattern);
                sb.append('.');
                for (int i = 0; i < iMantissaCount; ++i) {
                    sb.append('0');
                }
                return sb.toString();
            }
            return sNumericPattern;
        }
        if (dMinValue - (double)((int)dMinValue) == 0.0 && dStep - (double)((int)dStep) == 0.0) {
            return sNumericPattern;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        String sStep = this.oStep.toString();
        int iDecimalPosition = sStep.indexOf(dfs.getDecimalSeparator());
        if (iDecimalPosition >= 0) {
            int n = sStep.length();
            for (int i = n - 1; i > 0 && sStep.charAt(i) == '0'; --i) {
                --n;
            }
            int iMantissaCount = n - 1 - iDecimalPosition;
            StringBuffer sb = new StringBuffer(sNumericPattern);
            sb.append('.');
            for (int i = 0; i < iMantissaCount; ++i) {
                sb.append('0');
            }
            return sb.toString();
        }
        return sNumericPattern;
    }

    public final int getType() {
        return this.iType;
    }

    public final void setData(DataSetIterator _oaData) {
        this.dsiData = _oaData;
    }

    public final FormatSpecifier getFormatSpecifier() {
        return this.fs;
    }

    public final void setFormatSpecifier(FormatSpecifier fs) {
        this.fs = fs;
    }

    public final Object getUnit() {
        return this.oUnit;
    }

    public final DataSetIterator getData() {
        return this.dsiData;
    }

    final void setTickCordinates(double[] da) {
        if (da != null && da.length == 1) {
            throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 15, "exception.tick.computations", Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        this.daTickCoordinates = da;
    }

    public final boolean isTickLabelVisible(int index) {
        if (this.baTickLabelVisible == null || index < 0 || index > this.baTickLabelVisible.length - 1) {
            return false;
        }
        return this.baTickLabelVisible[index];
    }

    public final boolean isTickLabelStaggered(int index) {
        if (this.baTickLabelStaggered == null || index < 0 || index > this.baTickLabelStaggered.length - 1) {
            return false;
        }
        return this.baTickLabelStaggered[index];
    }

    public final boolean isAxisLabelStaggered() {
        return this.bAxisLabelStaggered;
    }

    public final double[] getTickCordinates() {
        return this.daTickCoordinates;
    }

    public final double[] getNormalizedTickCoordinates() {
        if (this.daTickCoordinates != null) {
            double[] daNomTickCoordinates = new double[this.daTickCoordinates.length];
            for (int i = 0; i < daNomTickCoordinates.length; ++i) {
                daNomTickCoordinates[i] = this.daTickCoordinates[i] - this.daTickCoordinates[0];
            }
            return daNomTickCoordinates;
        }
        return null;
    }

    public final double getNormalizedStart() {
        return 0.0;
    }

    public final double getNormalizedEnd() {
        return this.dEnd - this.dStart;
    }

    public final double[] getNormalizedEndPoints() {
        return new double[]{0.0, this.dEnd - this.dStart};
    }

    public final double[] getEndPoints() {
        return new double[]{this.dStart, this.dEnd};
    }

    final void setEndPoints(double _dStart, double _dEnd) {
        if (_dStart != -1.0) {
            this.dStart = _dStart;
        }
        if (_dEnd != -1.0) {
            this.dEnd = _dEnd;
        }
        if (this.daTickCoordinates != null) {
            int n = this.daTickCoordinates.length - 1;
            double dDelta = (this.dEnd - this.dStart) / (double)n;
            double d = this.dStart;
            for (int i = 0; i < n; ++i) {
                this.daTickCoordinates[i] = d;
                d += dDelta;
            }
            this.daTickCoordinates[n] = this.dEnd;
        }
    }

    public final int getTickCount() {
        CDateTime cdt1;
        CDateTime cdt2;
        int nTicks = 2;
        if ((this.iType & 0x10) == 16 || this.bCategoryScale) {
            if (this.dsiData != null) {
                nTicks = this.dsiData.size() + 1;
            }
        } else if ((this.iType & 1) == 1) {
            if ((this.iType & 2) == 2) {
                double dStep;
                double dMin;
                double dMax = AutoScale.asDouble(this.oMaximum);
                nTicks = (int)Math.ceil((dMax - (dMin = AutoScale.asDouble(this.oMinimum).doubleValue())) / (dStep = AutoScale.asDouble(this.oStep).doubleValue())) + 1;
                if (nTicks < 2) {
                    nTicks = 2;
                }
            } else if ((this.iType & 4) == 4) {
                double dStepLog;
                double dMinLog;
                double dMax = AutoScale.asDouble(this.oMaximum);
                double dMin = AutoScale.asDouble(this.oMinimum);
                double dStep = AutoScale.asDouble(this.oStep);
                double dMaxLog = Math.log(dMax) / LOG_10;
                nTicks = (int)Math.ceil((dMaxLog - (dMinLog = Math.log(dMin) / LOG_10)) / (dStepLog = Math.log(dStep) / LOG_10)) + 1;
                if (nTicks < 2) {
                    nTicks = 2;
                }
            }
        } else if ((this.iType & 8) == 8 && (nTicks = (int)(Math.ceil(CDateTime.computeDifference(cdt2 = (CDateTime)((Object)this.oMaximum), cdt1 = (CDateTime)((Object)this.oMinimum), AutoScale.asInteger(this.oUnit))) / (double)AutoScale.asInteger(this.oStep)) + 1) < 2) {
            nTicks = 2;
        }
        return nTicks;
    }

    public final double getUnitSize() {
        if (this.daTickCoordinates == null) {
            throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 15, "exception.unit.size.failure", Messages.getResourceBundle(this.rtc.getULocale()))));
        }
        return Math.abs(this.daTickCoordinates[1] - this.daTickCoordinates[0]);
    }

    public final Object getMinimum() {
        return this.oMinimum;
    }

    public final void setMinimum(Object o) {
        this.oMinimum = o;
    }

    public final Object getMaximum() {
        return this.oMaximum;
    }

    public final void setMaximum(Object o) {
        this.oMaximum = o;
    }

    public final Object getStep() {
        return this.oStep;
    }

    public final void setStep(Object o) {
        this.oStep = o;
    }

    final void adjustAxisMinMax(CDateTime cdtMinValue, CDateTime cdtMaxValue) {
        int iUnit = AutoScale.asInteger(this.oUnit);
        int iStep = AutoScale.asInteger(this.oStep);
        if (!this.bMinimumFixed) {
            this.oMinimum = cdtMinValue.backward(iUnit, iStep);
        }
        if (!this.bMaximumFixed) {
            this.oMaximum = cdtMaxValue.forward(iUnit, iStep);
        }
        ((CDateTime)((Object)this.oMinimum)).clearBelow(iUnit);
        ((CDateTime)((Object)this.oMaximum)).clearBelow(iUnit);
    }

    final Object[] getMinMax() throws ChartException {
        Object oValue = null;
        try {
            if ((this.iType & 1) == 1) {
                double dMinValue = Double.MAX_VALUE;
                double dMaxValue = -1.7976931348623157E308;
                this.dsiData.reset();
                while (this.dsiData.hasNext()) {
                    oValue = this.dsiData.next();
                    if (oValue == null) continue;
                    double dValue = (Double)oValue;
                    if (dValue < dMinValue) {
                        dMinValue = dValue;
                    }
                    if (!(dValue > dMaxValue)) continue;
                    dMaxValue = dValue;
                }
                return new Object[]{new Double(dMinValue), new Double(dMaxValue)};
            }
            if ((this.iType & 8) == 8) {
                Calendar caMin = null;
                Calendar caMax = null;
                this.dsiData.reset();
                while (this.dsiData.hasNext()) {
                    oValue = this.dsiData.next();
                    Calendar cValue = (Calendar)oValue;
                    if (caMin == null) {
                        caMin = cValue;
                    }
                    if (caMax == null) {
                        caMax = cValue;
                    }
                    if (cValue == null) continue;
                    if (cValue.before((Object)caMin)) {
                        caMin = cValue;
                        continue;
                    }
                    if (!cValue.after((Object)caMax)) continue;
                    caMax = cValue;
                }
                return new Object[]{new CDateTime(caMin), new CDateTime(caMax)};
            }
        }
        catch (ClassCastException ex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.axis.data.type", new Object[]{oValue}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        return null;
    }

    public final void updateAxisMinMax(Object oMinValue, Object oMaxValue) {
        if ((this.iType & 4) == 4) {
            if ((this.iType & 0x20) == 32) {
                this.oMaximum = new Double(100.0);
                this.oMinimum = new Double(1.0);
                this.oStep = new Double(10.0);
                this.bMaximumFixed = true;
                this.bMinimumFixed = true;
                this.bStepFixed = true;
                return;
            }
            double dMinValue = AutoScale.asDouble(oMinValue);
            double dMaxValue = AutoScale.asDouble(oMaxValue);
            double dAbsMax = Math.abs(dMaxValue);
            double dAbsMin = Math.abs(dMinValue);
            double dStep = AutoScale.asDouble(this.oStep);
            double dStepLog = Math.log(dStep);
            int iPow = (int)Math.floor(Math.log(dAbsMax) / dStepLog) + 1;
            double dMaxAxis = Math.pow(dStep, iPow);
            iPow = (int)Math.floor(Math.log(dAbsMin) / dStepLog) - 1;
            double dMinAxis = Math.pow(dStep, iPow + 1);
            if (!this.bMaximumFixed) {
                this.oMaximum = new Double(dMaxAxis);
            }
            if (!this.bMinimumFixed) {
                this.oMinimum = new Double(dMinAxis);
            }
        } else if ((this.iType & 8) == 8) {
            int iUnit = AutoScale.asInteger(this.oUnit);
            int iStep = AutoScale.asInteger(this.oStep);
            CDateTime cdtMinValue = AutoScale.asDateTime(oMinValue);
            CDateTime cdtMaxValue = AutoScale.asDateTime(oMaxValue);
            if (!this.bMinimumFixed) {
                this.oMinimum = cdtMinValue.backward(iUnit, iStep);
            }
            ((CDateTime)((Object)this.oMinimum)).clearBelow(iUnit);
            if (!this.bMaximumFixed) {
                this.oMaximum = cdtMaxValue.forward(iUnit, iStep);
            }
            ((CDateTime)((Object)this.oMaximum)).clearBelow(iUnit);
        } else {
            double dMaxAxis;
            double dMinAxis;
            double dMinValue = AutoScale.asDouble(oMinValue);
            double dMaxValue = AutoScale.asDouble(oMaxValue);
            double dAbsMax = Math.abs(dMaxValue);
            double dAbsMin = Math.abs(dMinValue);
            double dStep = AutoScale.asDouble(this.oStep);
            double d = dMinAxis = dStep > 1.0 ? Math.floor(dAbsMin / dStep) : (double)Math.round(dAbsMin / dStep);
            if ((dMinAxis *= dStep) == dAbsMin) {
                dMinAxis += dStep;
                if (dMinValue < 0.0) {
                    dMinAxis = -dMinAxis;
                } else if (dMinValue == 0.0) {
                    dMinAxis = 0.0;
                }
            } else if (dMinValue < 0.0) {
                dMinAxis = -(dMinAxis + dStep);
            } else if (dMinAxis >= dMinValue && dMinAxis != 0.0) {
                dMinAxis -= dStep;
            }
            double d2 = dMaxAxis = dStep > 1.0 ? Math.floor(dAbsMax / dStep) : (double)Math.round(dAbsMax / dStep);
            if ((dMaxAxis *= dStep) == dAbsMax) {
                dMaxAxis += dStep;
                if (dMaxValue == 0.0) {
                    dMaxAxis = 0.0;
                }
            } else if (dMinAxis != dMaxValue) {
                if (dMaxValue < 0.0) {
                    dMaxAxis = -(dMaxAxis - dStep);
                } else if (dMaxValue > 0.0 && dMaxAxis < dMaxValue) {
                    dMaxAxis += dStep;
                }
            }
            if (dMinValue < 0.0 && dMaxValue < 0.0 && dMaxAxis <= dMaxValue - dStep) {
                dMaxAxis += 2.0 * dStep;
            }
            if (dMinValue > 0.0 && dMaxValue > 0.0 && dMinAxis >= dMinValue + dStep) {
                dMinAxis -= 2.0 * dStep;
            }
            if (dMinValue == 0.0 && dMaxValue == 0.0) {
                if (dMinAxis >= 0.0) {
                    dMinAxis = -1.0;
                }
                if (dMaxAxis <= 0.0) {
                    dMaxAxis = 1.0;
                }
            }
            if ((this.iType & 0x20) == 32) {
                if (dMaxAxis > 0.0) {
                    dMaxAxis = 100.0;
                }
                if (dMinAxis < 0.0) {
                    dMinAxis = -100.0;
                }
            }
            if (!this.bMaximumFixed) {
                this.oMaximum = new Double(dMaxAxis);
            }
            if (!this.bMinimumFixed) {
                this.oMinimum = new Double(dMinAxis);
            }
        }
    }

    public final boolean checkFit(IDisplayServer xs, Label la, int iLabelLocation) throws ChartException {
        block41: {
            RotatedRectangle rrPrev2;
            RotatedRectangle rrPrev;
            double[] da;
            int iPointToCheck;
            double y;
            double x;
            block42: {
                block40: {
                    if (this.iType == 16 || this.bCategoryScale) {
                        return true;
                    }
                    double dAngleInDegrees = la.getCaption().getFont().getRotation();
                    x = 0.0;
                    y = 0.0;
                    iPointToCheck = 0;
                    if (iLabelLocation == 3 || iLabelLocation == 4) {
                        iPointToCheck = this.iScaleDirection == -1 ? (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 1 : 2) : (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 3 : 0);
                    } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                        iPointToCheck = this.iScaleDirection == 1 ? (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 0 : 1) : (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 2 : 3);
                    }
                    da = this.daTickCoordinates;
                    rrPrev = null;
                    rrPrev2 = null;
                    if ((this.iType & 3) != 3) break block40;
                    double dAxisValue = AutoScale.asDouble(this.getMinimum());
                    double dAxisStep = AutoScale.asDouble(this.getStep());
                    DecimalFormat df = null;
                    if (this.fs == null) {
                        df = new DecimalFormat(this.getNumericPattern());
                    }
                    NumberDataElement nde = NumberDataElementImpl.create(0.0);
                    for (int i = 0; i < da.length - 1; ++i) {
                        RotatedRectangle rr;
                        String sText;
                        nde.setValue(dAxisValue);
                        try {
                            sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                        }
                        catch (ChartException dfex) {
                            logger.log((Exception)((Object)dfex));
                            sText = NULL_STRING;
                        }
                        if (iLabelLocation == 3 || iLabelLocation == 4) {
                            x = da[i] * this.dZoomFactor;
                        } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                            y = da[i] * this.dZoomFactor;
                        }
                        la.getCaption().setValue(sText);
                        try {
                            rr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                        }
                        Point p = rr.getPoint(iPointToCheck);
                        if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                            if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                                return false;
                            }
                            rrPrev2 = rr;
                        } else {
                            if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev))) {
                                return false;
                            }
                            rrPrev = rr;
                        }
                        dAxisValue += dAxisStep;
                    }
                    break block41;
                }
                if ((this.iType & 5) != 5) break block42;
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                DecimalFormat df = null;
                for (int i = 0; i < da.length - 1; ++i) {
                    RotatedRectangle rr;
                    String sText;
                    nde.setValue(dAxisValue);
                    if (this.fs == null) {
                        df = new DecimalFormat(this.getNumericPattern(dAxisValue));
                    }
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = NULL_STRING;
                    }
                    if (iLabelLocation == 3 || iLabelLocation == 4) {
                        x = da[i] * this.dZoomFactor;
                    } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                        y = da[i] * this.dZoomFactor;
                    }
                    la.getCaption().setValue(sText);
                    try {
                        rr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                    }
                    Point p = rr.getPoint(iPointToCheck);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                            return false;
                        }
                        rrPrev2 = rr;
                    } else {
                        if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p))) {
                            return false;
                        }
                        rrPrev = rr;
                    }
                    dAxisValue *= dAxisStep;
                }
                break block41;
            }
            if (this.iType != 8) break block41;
            CDateTime cdtAxisValue = AutoScale.asDateTime(this.oMinimum);
            int iUnit = AutoScale.asInteger(this.oUnit);
            int iStep = AutoScale.asInteger(this.oStep);
            IDateFormatWrapper sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
            CDateTime cdt = cdtAxisValue;
            for (int i = 0; i < da.length - 1; ++i) {
                RotatedRectangle rr;
                String sText = ValueFormatter.format((Object)cdt, this.fs, this.rtc.getULocale(), sdf);
                if (iLabelLocation == 3 || iLabelLocation == 4) {
                    x = da[i] * this.dZoomFactor;
                } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                    y = da[i] * this.dZoomFactor;
                }
                la.getCaption().setValue(sText);
                try {
                    rr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                Point p = rr.getPoint(iPointToCheck);
                if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                    if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects(rr, rrPrev2))) {
                        return false;
                    }
                    rrPrev2 = rr;
                } else {
                    if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p))) {
                        return false;
                    }
                    rrPrev = rr;
                }
                cdt = cdtAxisValue.forward(iUnit, iStep * (i + 1));
            }
        }
        return true;
    }

    protected final boolean[] checkTickLabelsVisibility(IDisplayServer xs, Label la, int iLabelLocation) throws ChartException {
        int i;
        boolean[] ba = new boolean[this.daTickCoordinates.length];
        boolean vis = la.isSetVisible() && la.isVisible();
        Arrays.fill(ba, vis);
        this.baTickLabelStaggered = new boolean[this.daTickCoordinates.length];
        boolean staggerEnabled = this.isAxisLabelStaggered();
        if (!vis) {
            return ba;
        }
        if (this.iLabelShowingInterval >= 2) {
            int c = 0;
            for (i = 0; i < ba.length; ++i) {
                boolean bl = ba[i] = i % this.iLabelShowingInterval == 0;
                if (!staggerEnabled || !ba[i]) continue;
                this.baTickLabelStaggered[i] = ++c % 2 == 0;
            }
        } else if (staggerEnabled) {
            for (i = 0; i < ba.length; ++i) {
                this.baTickLabelStaggered[i] = i % 2 != 0;
            }
        }
        if (this.iType != 16 && !this.bCategoryScale) {
            return ba;
        }
        double dAngleInDegrees = la.getCaption().getFont().getRotation();
        double x = 0.0;
        double y = 0.0;
        int iNewPointToCheck = 0;
        int iPrevPointToCheck = 0;
        boolean isNegativeRotation = dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0;
        switch (iLabelLocation) {
            case 3: {
                iNewPointToCheck = isNegativeRotation ? 3 : 0;
                iPrevPointToCheck = isNegativeRotation ? 1 : 3;
                break;
            }
            case 4: {
                int n = isNegativeRotation ? (this.iScaleDirection == -1 ? 1 : 3) : (iNewPointToCheck = this.iScaleDirection == -1 ? 2 : 0);
                iPrevPointToCheck = isNegativeRotation ? (this.iScaleDirection == -1 ? 2 : 0) : (this.iScaleDirection == -1 ? 0 : 2);
                break;
            }
            case 1: {
                iNewPointToCheck = this.iScaleDirection == 1 ? 1 : 2;
                iPrevPointToCheck = this.iScaleDirection == 1 ? 2 : 1;
                break;
            }
            case 2: {
                iNewPointToCheck = this.iScaleDirection == 1 ? 0 : 3;
                iPrevPointToCheck = this.iScaleDirection == 1 ? 3 : 0;
            }
        }
        RotatedRectangle[] rrPrev = new RotatedRectangle[2];
        DataSetIterator dsi = this.getData();
        dsi.reset();
        int iDateTimeUnit = this.iType == 8 ? CDateTime.computeUnit(dsi) : 0;
        String sText = null;
        dsi.reset();
        for (int i2 = 0; i2 < this.daTickCoordinates.length - 1; ++i2) {
            Object oValue = null;
            if (dsi.hasNext()) {
                oValue = dsi.next();
            }
            if (!ba[i2]) continue;
            sText = this.formatCategoryValue(this.iType, oValue, iDateTimeUnit);
            if (iLabelLocation == 3 || iLabelLocation == 4) {
                x = this.daTickCoordinates[i2] * this.dZoomFactor;
            } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                y = this.daTickCoordinates[i2] * this.dZoomFactor;
            }
            la.getCaption().setValue(sText);
            ba[i2] = this.isAxisLabelStaggered() && this.baTickLabelStaggered[i2] ? this.checkOneTickLabelVisibility(rrPrev, 1, iLabelLocation, x, y, iNewPointToCheck, iPrevPointToCheck, la, xs, i2) : this.checkOneTickLabelVisibility(rrPrev, 0, iLabelLocation, x, y, iNewPointToCheck, iPrevPointToCheck, la, xs, i2);
        }
        return ba;
    }

    protected final boolean checkOneTickLabelVisibility(RotatedRectangle[] rrPrev, int arrayIndex, int iLabelLocation, double x, double y, int iNewPointToCheck, int iPrevPointToCheck, Label la, IDisplayServer xs, int tickIndex) {
        if (rrPrev[arrayIndex] == null) {
            rrPrev[arrayIndex] = AutoScale.computePolygon(xs, iLabelLocation, la, x, y);
            return true;
        }
        Point previousPoint = rrPrev[arrayIndex].getPoint(iPrevPointToCheck);
        if (this.quickCheckVisibility(iLabelLocation, previousPoint, x, y)) {
            boolean visible;
            RotatedRectangle rr = AutoScale.computePolygon(xs, iLabelLocation, la, x, y);
            Point p = rr.getPoint(iNewPointToCheck);
            boolean bl = visible = !rrPrev[arrayIndex].contains(p) && !ChartUtil.intersects(rr, rrPrev[arrayIndex]);
            if (visible) {
                rrPrev[arrayIndex] = rr;
                return true;
            }
        }
        return false;
    }

    protected boolean quickCheckVisibility(int iLabelLocation, Point previousPoint, double x, double y) {
        return !(iLabelLocation == 3 || iLabelLocation == 4 ? this.iScaleDirection == -1 && previousPoint.getX() < x || this.iScaleDirection != -1 && previousPoint.getX() > x : (iLabelLocation == 1 || iLabelLocation == 2) && (this.iScaleDirection == 1 && previousPoint.getY() > y || this.iScaleDirection != 1 && previousPoint.getY() < y));
    }

    final void resetShifts() {
        this.dStartShift = 0.0;
        this.dEndShift = 0.0;
    }

    public final double getStart() {
        return this.dStart;
    }

    public final double getEnd() {
        return this.dEnd;
    }

    final double getStartShift() {
        return this.dStartShift;
    }

    final double getEndShift() {
        return this.dEndShift;
    }

    static final AutoScale computeScale(IDisplayServer xs, OneAxis ax, DataSetIterator dsi, int iType, double dStart, double dEnd, DataElement oMinimum, DataElement oMaximum, Double oStep, FormatSpecifier fs, RunTimeContext rtc, int direction) throws ChartException {
        return AutoScale.computeScale(xs, ax, dsi, iType, dStart, dEnd, oMinimum, oMaximum, oStep, fs, rtc, direction, 1.0);
    }

    static final AutoScale computeScale(IDisplayServer xs, OneAxis ax, DataSetIterator dsi, int iType, double dStart, double dEnd, DataElement oMinimum, DataElement oMaximum, Double oStep, FormatSpecifier fs, RunTimeContext rtc, int direction, double zoomFactor) throws ChartException {
        Label la = ax.getLabel();
        int iLabelLocation = ax.getLabelPosition();
        int iOrientation = ax.getOrientation();
        AutoScale sc = null;
        AutoScale scCloned = null;
        if ((iType & 0x10) == 16 || ax.isCategoryScale()) {
            sc = new AutoScale(iType);
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bCategoryScale = true;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.dZoomFactor = zoomFactor;
            sc.setData(dsi);
            sc.setDirection(direction);
            sc.computeTicks(xs, ax.getLabel(), iLabelLocation, iOrientation, dStart, dEnd, false, null);
        } else if ((iType & 2) == 2) {
            boolean bFirstFit;
            double dMinValue = Double.MAX_VALUE;
            double dMaxValue = -1.7976931348623157E308;
            dsi.reset();
            double dPrecision = 0.0;
            while (dsi.hasNext()) {
                Object oValue = dsi.next();
                if (oValue == null) continue;
                double dValue = (Double)oValue;
                if (dValue < dMinValue) {
                    dMinValue = dValue;
                }
                if (dValue > dMaxValue) {
                    dMaxValue = dValue;
                }
                dPrecision = AutoScale.getPrecision(dPrecision, dValue);
            }
            double dDelta = dMaxValue - dMinValue;
            if (dDelta == 0.0) {
                dDelta = 1.0;
            }
            double dAbsMax = Math.abs(dMaxValue);
            double dAbsMin = Math.abs(dMinValue);
            double dStep = Math.max(dAbsMax, dAbsMin);
            dStep = Math.floor(Math.log(dDelta) / LOG_10);
            if ((dStep = Math.pow(10.0, dStep)) < dPrecision) {
                dStep = dPrecision;
            }
            sc = new AutoScale(iType, new Double(0.0), new Double(0.0), new Double(dStep));
            sc.setData(dsi);
            sc.setDirection(direction);
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.dZoomFactor = zoomFactor;
            sc.dPrecision = dPrecision;
            if (oMinimum != null) {
                if (!(oMinimum instanceof NumberDataElement)) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.minimum.scale.value", new Object[]{sc.oMinimum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
                }
                sc.oMinimum = new Double(((NumberDataElement)oMinimum).getValue());
                sc.bMinimumFixed = true;
            }
            if (oMaximum != null) {
                if (!(oMaximum instanceof NumberDataElement)) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.maximum.scale.value", new Object[]{sc.oMaximum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
                }
                sc.oMaximum = new Double(((NumberDataElement)oMaximum).getValue());
                sc.bMaximumFixed = true;
            }
            if (oStep != null) {
                sc.oStep = oStep;
                sc.bStepFixed = true;
                if ((Double)sc.oStep <= 0.0) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.step.value", new Object[]{oStep}, Messages.getResourceBundle(rtc.getULocale()));
                }
            }
            if (sc.bMaximumFixed && sc.bMinimumFixed && (Double)sc.oMinimum > (Double)sc.oMaximum) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.min.largerthan.max", new Object[]{sc.oMinimum, sc.oMaximum}, Messages.getResourceBundle(rtc.getULocale()));
            }
            Double oMinValue = new Double(dMinValue);
            Double oMaxValue = new Double(dMaxValue);
            sc.updateAxisMinMax(oMinValue, oMaxValue);
            sc.computeTicks(xs, ax.getLabel(), iLabelLocation, iOrientation, dStart, dEnd, false, null);
            dStart = sc.dStart;
            dEnd = sc.dEnd;
            boolean bFits = bFirstFit = sc.checkFit(xs, la, iLabelLocation);
            boolean bZoomSuccess = false;
            while (bFits == bFirstFit) {
                bZoomSuccess = true;
                scCloned = (AutoScale)sc.clone();
                if (sc.bStepFixed) break;
                if (bFirstFit) {
                    if (!bFits) break;
                    bZoomSuccess = sc.zoomIn();
                } else {
                    if (!bFits && sc.getTickCordinates().length == 2) break;
                    bZoomSuccess = sc.zoomOut();
                }
                if (!bZoomSuccess) break;
                sc.updateAxisMinMax(oMinValue, oMaxValue);
                sc.computeTicks(xs, ax.getLabel(), iLabelLocation, iOrientation, dStart, dEnd, false, null);
                bFits = sc.checkFit(xs, la, iLabelLocation);
                if (bFits || sc.getTickCordinates().length != 2) continue;
                sc = scCloned;
                break;
            }
            if (scCloned != null && bFirstFit && bZoomSuccess) {
                sc = scCloned;
            }
        } else if ((iType & 4) == 4) {
            boolean bFirstFit;
            double dMinValue = Double.MAX_VALUE;
            double dMaxValue = -1.7976931348623157E308;
            if ((iType & 0x20) == 32) {
                dMinValue = 0.0;
                dMaxValue = 100.0;
            } else {
                dsi.reset();
                while (dsi.hasNext()) {
                    Object oValue = dsi.next();
                    if (oValue == null) continue;
                    double dValue = (Double)oValue;
                    if (dValue < dMinValue) {
                        dMinValue = dValue;
                    }
                    if (!(dValue > dMaxValue)) continue;
                    dMaxValue = dValue;
                }
            }
            Double oMinValue = new Double(dMinValue);
            Double oMaxValue = new Double(dMaxValue);
            sc = new AutoScale(iType, new Double(0.0), new Double(0.0), new Double(10.0));
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.dZoomFactor = zoomFactor;
            sc.setData(dsi);
            sc.setDirection(direction);
            sc.updateAxisMinMax(oMinValue, oMaxValue);
            if ((iType & 0x20) == 32) {
                sc.bStepFixed = true;
                sc.bMaximumFixed = true;
                sc.bMinimumFixed = true;
            }
            sc.computeTicks(xs, ax.getLabel(), iLabelLocation, iOrientation, dStart, dEnd, false, null);
            if ((iType & 0x20) == 32) {
                return sc;
            }
            dStart = sc.dStart;
            dEnd = sc.dEnd;
            boolean bFits = bFirstFit = sc.checkFit(xs, la, iLabelLocation);
            boolean bZoomSuccess = false;
            while (bFits == bFirstFit) {
                bZoomSuccess = true;
                scCloned = (AutoScale)sc.clone();
                if (sc.bStepFixed) break;
                if (bFirstFit) {
                    if (!bFits) break;
                    bZoomSuccess = sc.zoomIn();
                } else {
                    if (!bFits && sc.getTickCordinates().length == 2) break;
                    bZoomSuccess = sc.zoomOut();
                }
                if (!bZoomSuccess) break;
                sc.updateAxisMinMax(oMinValue, oMaxValue);
                sc.computeTicks(xs, ax.getLabel(), iLabelLocation, iOrientation, dStart, dEnd, false, null);
                bFits = sc.checkFit(xs, la, iLabelLocation);
                if (bFits || sc.getTickCordinates().length != 2) continue;
                sc = scCloned;
                break;
            }
            if (scCloned != null && bFirstFit && bZoomSuccess) {
                sc = scCloned;
            }
        } else if ((iType & 8) == 8) {
            boolean bFirstFit;
            Calendar caMin = null;
            Calendar caMax = null;
            dsi.reset();
            while (dsi.hasNext()) {
                Calendar cValue = (Calendar)dsi.next();
                if (cValue == null) continue;
                if (caMin == null) {
                    caMin = cValue;
                }
                if (caMax == null) {
                    caMax = cValue;
                }
                if (cValue.before((Object)caMin)) {
                    caMin = cValue;
                    continue;
                }
                if (!cValue.after((Object)caMax)) continue;
                caMax = cValue;
            }
            CDateTime cdtMinValue = new CDateTime(caMin);
            CDateTime cdtMaxValue = new CDateTime(caMax);
            int iUnit = CDateTime.getDifference(cdtMinValue, cdtMaxValue);
            if (iUnit == 0) {
                iUnit = 13;
            }
            CDateTime cdtMinAxis = cdtMinValue.backward(iUnit, 1);
            CDateTime cdtMaxAxis = cdtMaxValue.forward(iUnit, 1);
            cdtMinAxis.clearBelow(iUnit);
            cdtMaxAxis.clearBelow(iUnit);
            sc = new AutoScale(8, (Object)cdtMinAxis, (Object)cdtMaxAxis, new Integer(iUnit), new Integer(1));
            sc.setDirection(direction);
            sc.fs = fs;
            sc.rtc = rtc;
            sc.bAxisLabelStaggered = ax.isAxisLabelStaggered();
            sc.iLabelShowingInterval = ax.getLableShowingInterval();
            sc.dZoomFactor = zoomFactor;
            sc.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, false, null);
            dStart = sc.dStart;
            dEnd = sc.dEnd;
            if (oMinimum != null) {
                if (!(oMinimum instanceof DateTimeDataElement)) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.minimum.scale.value", new Object[]{oMinimum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
                }
                sc.oMinimum = ((DateTimeDataElement)oMinimum).getValueAsCDateTime();
                sc.bMinimumFixed = true;
            }
            if (oMaximum != null) {
                if (!(oMaximum instanceof DateTimeDataElement)) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.maximum.scale.value", new Object[]{sc.oMaximum, ax.getModelAxis().getType().getName()}, Messages.getResourceBundle(rtc.getULocale()));
                }
                sc.oMaximum = ((DateTimeDataElement)oMaximum).getValueAsCDateTime();
                sc.bMaximumFixed = true;
            }
            if (sc.bMaximumFixed && sc.bMinimumFixed && ((CDateTime)((Object)sc.oMinimum)).after(sc.oMaximum)) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.min.largerthan.max", new Object[]{sc.oMinimum, sc.oMaximum}, Messages.getResourceBundle(rtc.getULocale()));
            }
            boolean bFits = bFirstFit = sc.checkFit(xs, la, iLabelLocation);
            boolean bZoomSuccess = false;
            while (bFits == bFirstFit) {
                bZoomSuccess = true;
                scCloned = (AutoScale)sc.clone();
                if (sc.bStepFixed) break;
                if (bFirstFit) {
                    if (!bFits) break;
                    bZoomSuccess = sc.zoomIn();
                } else {
                    if (!bFits && sc.getTickCordinates().length == 2) break;
                    bZoomSuccess = sc.zoomOut();
                }
                if (!bZoomSuccess) break;
                sc.adjustAxisMinMax(cdtMinValue, cdtMaxValue);
                sc.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, false, null);
                bFits = sc.checkFit(xs, la, iLabelLocation);
                if (bFits || sc.getTickCordinates().length != 2) continue;
                sc = scCloned;
                break;
            }
            if (scCloned != null && bFirstFit && bZoomSuccess) {
                sc = scCloned;
            }
        }
        sc.setData(dsi);
        return sc;
    }

    protected static double getPrecision(double precision, double pValue) {
        int loopCounter;
        double value = Math.abs(pValue);
        if (value == 0.0) {
            if (precision < 0.0) {
                return precision;
            }
            if (precision >= 0.0) {
                return 1.0;
            }
        }
        if (precision == 0.0) {
            precision = Math.pow(10.0, Math.floor(Math.log(value) / Math.log(10.0)));
        }
        double check = value / precision;
        for (loopCounter = 0; Math.floor(check) != check && loopCounter < 20; ++loopCounter) {
            check = value / (precision /= 10.0);
        }
        if (loopCounter == 20) {
            logger.log(2, "Autoscale precision not found for " + value);
        }
        return precision;
    }

    public final int computeTicks(IDisplayServer xs, Label la, int iLabelLocation, int iOrientation, double dStart, double dEnd, boolean bConsiderStartEndLabels, AllAxes aax) throws ChartException {
        return this.computeTicks(xs, la, iLabelLocation, iOrientation, dStart, dEnd, bConsiderStartEndLabels, bConsiderStartEndLabels, aax);
    }

    public final int computeTicks(IDisplayServer xs, Label la, int iLabelLocation, int iOrientation, double dStart, double dEnd, boolean bConsiderStartLabel, boolean bConsiderEndLabel, AllAxes aax) throws ChartException {
        int nTicks = 0;
        double dLength = 0.0;
        double dTickGap = 0.0;
        int iDirection = this.iScaleDirection == 0 ? (iOrientation == 0 ? 1 : -1) : this.iScaleDirection;
        DataSetIterator dsi = this.getData();
        if (bConsiderStartLabel || bConsiderEndLabel) {
            this.computeAxisStartEndShifts(xs, la, iOrientation, iLabelLocation, aax);
            if (bConsiderStartLabel) {
                dStart += this.dStartShift * (double)iDirection;
            }
            if (bConsiderEndLabel) {
                dEnd += this.dEndShift * (double)(-iDirection);
            }
        }
        if ((this.iType & 0x10) == 16 || this.bCategoryScale) {
            nTicks = dsi.size() + 1;
            dLength = Math.abs(dStart - dEnd);
        } else if ((this.iType & 1) == 1) {
            nTicks = this.getTickCount();
            dLength = Math.abs(dStart - dEnd);
        } else if ((this.iType & 8) == 8) {
            CDateTime cdt1 = (CDateTime)((Object)this.oMinimum);
            CDateTime cdt2 = (CDateTime)((Object)this.oMaximum);
            double dNumberOfSteps = Math.ceil(CDateTime.computeDifference(cdt2, cdt1, AutoScale.asInteger(this.oUnit)));
            nTicks = (int)(dNumberOfSteps / (double)AutoScale.asInteger(this.oStep)) + 1;
            dLength = Math.abs(dStart - dEnd);
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unknown.axis.type.tick.computations", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (!this.bCategoryScale && (this.iType & 1) == 1 && (this.iType & 2) == 2) {
            double dMax = AutoScale.asDouble(this.oMaximum);
            double dMin = AutoScale.asDouble(this.oMinimum);
            double dStep = AutoScale.asDouble(this.oStep);
            dTickGap = Math.min(Math.abs(dStep / (dMax - dMin) * dLength), dLength) * (double)iDirection;
        } else {
            dTickGap = dLength / (double)(nTicks - 1) * (double)iDirection;
        }
        double d = dStart + dTickGap;
        double[] da = new double[nTicks];
        int i = 1;
        while (i < nTicks - 1) {
            da[i] = d;
            ++i;
            d += dTickGap;
        }
        da[0] = dStart;
        da[nTicks - 1] = dEnd;
        this.setTickCordinates(null);
        this.setEndPoints(dStart, dEnd);
        this.setTickCordinates(da);
        this.baTickLabelVisible = this.checkTickLabelsVisibility(xs, la, iLabelLocation);
        return nTicks;
    }

    public final String formatCategoryValue(int iType, Object oValue, int iDateTimeUnit) {
        if (oValue == null) {
            return IConstants.NULL_STRING;
        }
        if (iType == 16) {
            return oValue.toString();
        }
        if (iType == 8) {
            Calendar ca = (Calendar)oValue;
            IDateFormatWrapper sdf = null;
            if (this.fs == null) {
                sdf = DateFormatWrapperFactory.getPreferredDateFormat(iDateTimeUnit, this.rtc.getULocale());
            }
            try {
                return ValueFormatter.format(ca, this.fs, this.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                return IConstants.NULL_STRING;
            }
        }
        if ((iType & 1) == 1) {
            DecimalFormat df = null;
            if (this.fs == null) {
                df = new DecimalFormat(this.getNumericPattern());
            }
            try {
                return ValueFormatter.format(oValue, this.fs, this.rtc.getULocale(), df);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                return IConstants.NULL_STRING;
            }
        }
        return IConstants.NULL_STRING;
    }

    final void computeAxisStartEndShifts(IDisplayServer xs, Label la, int iOrientation, int iLocation, AllAxes aax) throws ChartException {
        double dMaxES;
        double dMaxSS = aax != null && iOrientation == aax.getOrientation() ? aax.getMaxStartShift() : 0.0;
        double d = dMaxES = aax != null && iOrientation == aax.getOrientation() ? aax.getMaxEndShift() : 0.0;
        if (!la.isVisible()) {
            this.dStartShift = dMaxSS;
            this.dEndShift = dMaxES;
            return;
        }
        if (this.getType() == 16 || this.bCategoryScale) {
            boolean bCenter;
            int iDateTimeUnit;
            double dUnitSize = this.getUnitSize();
            DataSetIterator dsi = this.getData();
            BoundingBox bb = null;
            try {
                iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
            }
            catch (ClassCastException e) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.dataset.non.datetime", Messages.getResourceBundle(this.rtc.getULocale()));
            }
            double rotation = la.getCaption().getFont().getRotation();
            boolean bl = bCenter = rotation == 0.0 || rotation == 90.0 || rotation == -90.0;
            if (!this.isTickLabelVisible(0)) {
                this.dStartShift = dMaxSS;
            } else {
                la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.first(), iDateTimeUnit));
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dStartShift = bCenter ? Math.max(dMaxSS, dUnitSize > bb.getHeight() ? 0.0 : (bb.getHeight() - dUnitSize) / 2.0) : (this.iScaleDirection == 1 ? Math.max(dMaxSS, bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint() - dUnitSize / 2.0));
                } else if (iOrientation == 0) {
                    this.dStartShift = bCenter ? Math.max(dMaxSS, dUnitSize > bb.getWidth() ? 0.0 : (bb.getWidth() - dUnitSize) / 2.0) : (this.iScaleDirection == -1 ? Math.max(dMaxSS, bb.getWidth() - bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxSS, bb.getHotPoint() - dUnitSize / 2.0));
                }
            }
            if (!this.isTickLabelVisible(dsi.size() - 1)) {
                this.dEndShift = dMaxES;
            } else {
                la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.last(), iDateTimeUnit));
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, this.dEnd);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dEndShift = bCenter ? Math.max(dMaxES, dUnitSize > bb.getHeight() ? 0.0 : (bb.getHeight() - dUnitSize) / 2.0) : (this.iScaleDirection == 1 ? Math.max(dMaxES, bb.getHeight() - bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxES, bb.getHotPoint() - dUnitSize / 2.0));
                } else if (iOrientation == 0) {
                    this.dEndShift = bCenter ? Math.max(dMaxES, dUnitSize > bb.getWidth() ? 0.0 : (bb.getWidth() - dUnitSize) / 2.0) : (this.iScaleDirection == -1 ? Math.max(dMaxES, bb.getHotPoint() - dUnitSize / 2.0) : Math.max(dMaxES, bb.getWidth() - bb.getHotPoint() - dUnitSize / 2.0));
                }
            }
        } else if ((this.iType & 1) == 1) {
            if ((this.iType & 2) == 2) {
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = new DecimalFormat(this.getNumericPattern());
                }
                String sValue = null;
                try {
                    sValue = ValueFormatter.format(this.getMinimum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                BoundingBox bb = null;
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
                }
                try {
                    sValue = ValueFormatter.format(this.getMaximum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
                }
            } else if ((this.iType & 4) == 4) {
                double dMinimum = AutoScale.asDouble(this.getMinimum());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = new DecimalFormat(this.getNumericPattern(dMinimum));
                }
                String sValue = null;
                try {
                    sValue = ValueFormatter.format(this.getMinimum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                BoundingBox bb = null;
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
                }
                double dMaximum = AutoScale.asDouble(this.getMaximum());
                if (this.fs == null) {
                    df = new DecimalFormat(this.getNumericPattern(dMaximum));
                }
                try {
                    sValue = ValueFormatter.format(this.getMaximum(), this.fs, this.rtc.getULocale(), df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sValue = IConstants.NULL_STRING;
                }
                la.getCaption().setValue(sValue);
                try {
                    bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                }
                if (iOrientation == 1) {
                    this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
                } else if (iOrientation == 0) {
                    this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
                }
            }
        } else if (this.getType() == 8) {
            CDateTime cdt = AutoScale.asDateTime(this.getMinimum());
            int iUnit = AutoScale.asInteger(this.oUnit);
            IDateFormatWrapper sdf = null;
            String sText = null;
            if (this.fs == null) {
                sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
            }
            try {
                sText = ValueFormatter.format((Object)cdt, this.fs, this.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                sText = IConstants.NULL_STRING;
            }
            la.getCaption().setValue(sText);
            BoundingBox bb = null;
            try {
                bb = AutoScale.computeBox(xs, iLocation, la, 0.0, 0.0);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
            }
            if (iOrientation == 1) {
                this.dStartShift = Math.max(dMaxSS, bb.getHeight() - bb.getHotPoint());
            } else if (iOrientation == 0) {
                this.dStartShift = Math.max(dMaxSS, bb.getHotPoint());
            }
            cdt = AutoScale.asDateTime(this.getMaximum());
            try {
                sText = ValueFormatter.format((Object)cdt, this.fs, this.rtc.getULocale(), sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                sText = IConstants.NULL_STRING;
            }
            la.getCaption().setValue(sText);
            try {
                bb = AutoScale.computeBox(xs, iLocation, la, 0.0, this.dEnd);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
            }
            if (iOrientation == 1) {
                this.dEndShift = Math.max(dMaxES, bb.getHotPoint());
            } else if (iOrientation == 0) {
                this.dEndShift = Math.max(dMaxES, bb.getWidth() - bb.getHotPoint());
            }
        }
    }

    final double computeAxisLabelThickness(IDisplayServer xs, Label la, int iOrientation) throws ChartException {
        if (!la.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unset.label.visibility", new Object[]{la.getCaption().getValue()}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (!la.isVisible()) {
            return 0.0;
        }
        double[] da = this.getTickCordinates();
        if (iOrientation == 1) {
            double dMaxW = 0.0;
            double dMaxW2 = 0.0;
            if ((this.getType() & 0x10) == 16 || this.bCategoryScale) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    double dW = this.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = new DecimalFormat(this.getNumericPattern());
                }
                for (int i = 0; i < da.length; ++i) {
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dW = this.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue += dAxisStep;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                for (int i = 0; i < da.length; ++i) {
                    String sText;
                    if (this.fs == null) {
                        df = new DecimalFormat(this.getNumericPattern(dAxisValue));
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dW = this.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue *= dAxisStep;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                for (int i = 0; i < da.length; ++i) {
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dW = this.computeWidth(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxW2 = Math.max(dW, dMaxW2);
                    } else if (dW > dMaxW) {
                        dMaxW = dW;
                    }
                    cdtAxisValue = cdtAxisValue.forward(iUnit, iStep);
                }
            }
            return dMaxW + dMaxW2;
        }
        if (iOrientation == 0) {
            double dMaxH = 0.0;
            double dMaxH2 = 0.0;
            if ((this.getType() & 0x10) == 16 || this.bCategoryScale) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    double dH = this.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = new DecimalFormat(this.getNumericPattern());
                }
                for (int i = 0; i < da.length; ++i) {
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = this.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue += dAxisStep;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                for (int i = 0; i < da.length; ++i) {
                    String sText;
                    if (this.fs == null) {
                        df = new DecimalFormat(this.getNumericPattern(dAxisValue));
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = this.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue *= dAxisStep;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                for (int i = 0; i < da.length; ++i) {
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    double dH = this.computeHeight(xs, la);
                    if (this.isAxisLabelStaggered() && this.baTickLabelStaggered[i]) {
                        dMaxH2 = Math.max(dH, dMaxH2);
                    } else if (dH > dMaxH) {
                        dMaxH = dH;
                    }
                    cdtAxisValue.forward(iUnit, iStep);
                }
            }
            return dMaxH + dMaxH2;
        }
        return 0.0;
    }

    public final double computeStaggeredAxisLabelOffset(IDisplayServer xs, Label la, int iOrientation) throws ChartException {
        if (!la.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.unset.label.visibility", new Object[]{la.getCaption().getValue()}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (!la.isVisible() || !this.isAxisLabelStaggered()) {
            return 0.0;
        }
        double[] da = this.getTickCordinates();
        if (iOrientation == 1) {
            double dMaxW = 0.0;
            if ((this.getType() & 0x10) == 16 || this.bCategoryScale) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    double dW;
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    if (!this.baTickLabelStaggered[i] && (dW = this.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = new DecimalFormat(this.getNumericPattern());
                }
                for (int i = 0; i < da.length; ++i) {
                    double dW;
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dW = this.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue += dAxisStep;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                for (int i = 0; i < da.length; ++i) {
                    double dW;
                    String sText;
                    if (this.fs == null) {
                        df = new DecimalFormat(this.getNumericPattern(dAxisValue));
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dW = this.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    dAxisValue *= dAxisStep;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                for (int i = 0; i < da.length; ++i) {
                    double dW;
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dW = this.computeWidth(xs, la)) > dMaxW) {
                        dMaxW = dW;
                    }
                    cdtAxisValue = cdtAxisValue.forward(iUnit, iStep);
                }
            }
            return dMaxW;
        }
        if (iOrientation == 0) {
            double dMaxH = 0.0;
            if ((this.getType() & 0x10) == 16 || this.bCategoryScale) {
                DataSetIterator dsi = this.getData();
                int iDateTimeUnit = this.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                dsi.reset();
                int i = 0;
                while (dsi.hasNext()) {
                    double dH;
                    la.getCaption().setValue(this.formatCategoryValue(this.getType(), dsi.next(), iDateTimeUnit));
                    if (!this.baTickLabelStaggered[i] && (dH = this.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    ++i;
                }
            } else if ((this.getType() & 2) == 2) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                if (this.fs == null) {
                    df = new DecimalFormat(this.getNumericPattern());
                }
                for (int i = 0; i < da.length; ++i) {
                    double dH;
                    String sText;
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dH = this.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue += dAxisStep;
                }
            } else if ((this.getType() & 4) == 4) {
                NumberDataElement nde = NumberDataElementImpl.create(0.0);
                double dAxisValue = AutoScale.asDouble(this.getMinimum());
                double dAxisStep = AutoScale.asDouble(this.getStep());
                DecimalFormat df = null;
                for (int i = 0; i < da.length; ++i) {
                    double dH;
                    String sText;
                    if (this.fs == null) {
                        df = new DecimalFormat(this.getNumericPattern(dAxisValue));
                    }
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, this.fs, this.rtc.getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dH = this.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    dAxisValue *= dAxisStep;
                }
            } else if ((this.getType() & 8) == 8) {
                CDateTime cdtAxisValue = AutoScale.asDateTime(this.getMinimum());
                int iStep = AutoScale.asInteger(this.getStep());
                int iUnit = AutoScale.asInteger(this.getUnit());
                IDateFormatWrapper sdf = null;
                if (this.fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, this.rtc.getULocale());
                }
                for (int i = 0; i < da.length; ++i) {
                    double dH;
                    String sText;
                    try {
                        sText = ValueFormatter.format((Object)cdtAxisValue, this.fs, this.rtc.getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    if (!this.baTickLabelStaggered[i] && (dH = this.computeHeight(xs, la)) > dMaxH) {
                        dMaxH = dH;
                    }
                    cdtAxisValue.forward(iUnit, iStep);
                }
            }
            return dMaxH;
        }
        return 0.0;
    }

    public final boolean isStepFixed() {
        return this.bStepFixed;
    }

    public final void setStepFixed(boolean v) {
        this.bStepFixed = v;
    }

    public final boolean isMinimumFixed() {
        return this.bMinimumFixed;
    }

    public final void setMinimumFixed(boolean v) {
        this.bMinimumFixed = v;
    }

    public final boolean isMaximumFixed() {
        return this.bMaximumFixed;
    }

    public final void setMaximumFixed(boolean v) {
        this.bMaximumFixed = v;
    }

    public final boolean isCategoryScale() {
        return this.bCategoryScale;
    }

    public final double[] getMinorCoordinates(int iMinorUnitsPerMajor) {
        if (this.daTickCoordinates == null || iMinorUnitsPerMajor <= 0) {
            return null;
        }
        double[] da = new double[iMinorUnitsPerMajor];
        double dUnit = this.getUnitSize();
        if ((this.iType & 4) != 4) {
            double dEach = dUnit / (double)iMinorUnitsPerMajor;
            for (int i = 1; i < iMinorUnitsPerMajor; ++i) {
                da[i - 1] = dEach * (double)i;
            }
        } else {
            double dCount = iMinorUnitsPerMajor;
            double dMax = Math.log(dCount);
            for (int i = 0; i < iMinorUnitsPerMajor; ++i) {
                da[i] = Math.log(i + 1) * dUnit / dMax;
            }
        }
        da[iMinorUnitsPerMajor - 1] = dUnit;
        return da;
    }

    public final RunTimeContext getRunTimeContext() {
        return this.rtc;
    }

    public final void setRunTimeContext(RunTimeContext context) {
        this.rtc = context;
    }
}

