/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.birt.chart.event.ChartEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;

public final class InteractionEvent
extends ChartEvent {
    private static final long serialVersionUID = -3554746649816942383L;
    private PrimitiveRenderEvent _pre = null;
    private final LinkedHashMap _lhmTriggers = new LinkedHashMap();

    public InteractionEvent(Object source) {
        super(source);
        if (!(source instanceof StructureSource)) {
            throw new IllegalArgumentException();
        }
    }

    public StructureSource getStructureSource() {
        return (StructureSource)super.getSource();
    }

    public final void setHotSpot(PrimitiveRenderEvent pre) {
        this._pre = pre;
    }

    public final PrimitiveRenderEvent getHotSpot() {
        return this._pre;
    }

    public final void addTrigger(Trigger t) {
        this._lhmTriggers.put(t.getCondition(), t.getAction());
    }

    public final Action getAction(TriggerCondition tc) {
        return (Action)this._lhmTriggers.get((Object)tc);
    }

    public final Trigger[] getTriggers() {
        if (this._lhmTriggers.isEmpty()) {
            return null;
        }
        Trigger[] tga = new Trigger[this._lhmTriggers.size()];
        Iterator it = this._lhmTriggers.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            TriggerCondition tcKey = (TriggerCondition)((Object)it.next());
            Action acValue = (Action)this._lhmTriggers.get((Object)tcKey);
            tga[i++] = TriggerImpl.create(tcKey, acValue);
        }
        return tga;
    }

    public void reset() {
        this._pre = null;
        this._lhmTriggers.clear();
    }

    public final void reuse(StructureSource oNewSource) {
        this.source = oNewSource;
        this._lhmTriggers.clear();
    }
}

