/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import com.ibm.icu.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.Grid;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWith2DAxes;
import org.eclipse.birt.chart.computation.withaxes.PlotWith3DAxes;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.BlockGenerationEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.Oval3DRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.TransformationEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.factory.DateFormatWrapperFactory;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.internal.model.FittingCalculator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.CurveFitting;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataElement;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.render.MarkerRenderer;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;

public abstract class AxesRenderer
extends BaseRenderer {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/render");
    private Axis ax;
    private boolean leftWallFill = false;
    private boolean rightWallFill = false;
    private boolean floorFill = false;

    public final void render(Map htRenderers, Bounds bo) throws ChartException {
        Enumeration e;
        Block bl;
        boolean bFirstInSequence = this.iSeriesIndex == 0;
        boolean bLastInSequence = this.iSeriesIndex == this.iSeriesCount - 1;
        long lTimer = System.currentTimeMillis();
        Chart cm = this.getModel();
        IDeviceRenderer idr = this.getDevice();
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        if (bFirstInSequence) {
            lTimer = System.currentTimeMillis();
            htRenderers.put("T", new Long(lTimer));
            bl = cm.getBlock();
            e = bl.children(true);
            BlockGenerationEvent bge = new BlockGenerationEvent(bl);
            ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
            bge.updateBlock(bl);
            this.renderChartBlock(idr, bl, StructureSource.createChartBlock(bl));
            ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
            while (e.hasMoreElements()) {
                bl = (Block)e.nextElement();
                bge.updateBlock(bl);
                if (bl instanceof Plot) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderPlot(idr, (Plot)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    if (bLastInSequence) continue;
                    break;
                }
                if (bl instanceof TitleBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderTitle(idr, (TitleBlock)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof LabelBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLabel(idr, bl, StructureSource.createUnknown(bl));
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof Legend) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLegend(idr, (Legend)bl, htRenderers);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderBlock(idr, bl, StructureSource.createUnknown(bl));
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
            }
        } else if (bLastInSequence) {
            bl = cm.getBlock();
            e = bl.children(true);
            BlockGenerationEvent bge = new BlockGenerationEvent(this);
            boolean bStarted = false;
            while (e.hasMoreElements()) {
                bl = (Block)e.nextElement();
                if (!bStarted && !bl.isPlot()) continue;
                bStarted = true;
                bge.updateBlock(bl);
                if (bl instanceof Plot) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderPlot(idr, (Plot)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof TitleBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderTitle(idr, (TitleBlock)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof LabelBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLabel(idr, bl, StructureSource.createUnknown(bl));
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof Legend) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLegend(idr, (Legend)bl, htRenderers);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderBlock(idr, bl, StructureSource.createUnknown(bl));
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
            }
        } else {
            BlockGenerationEvent bge = new BlockGenerationEvent(this);
            Plot p = cm.getPlot();
            bge.updateBlock(p);
            ScriptHandler.callFunction(sh, "beforeDrawBlock", p, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", p);
            this.renderPlot(idr, p);
            ScriptHandler.callFunction(sh, "afterDrawBlock", p, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawBlock", p);
        }
        lTimer = System.currentTimeMillis() - lTimer;
        if (htRenderers.containsKey("T")) {
            Long l = (Long)htRenderers.get("T");
            htRenderers.put("T", new Long(l + lTimer));
        } else {
            htRenderers.put("T", new Long(lTimer));
        }
        if (bLastInSequence) {
            Object obj = this.getComputations();
            if (obj instanceof PlotWith2DAxes) {
                PlotWith2DAxes pw2da = (PlotWith2DAxes)this.getComputations();
                pw2da.getStackedSeriesLookup().resetSubUnits();
            }
            logger.log(1, Messages.getString("info.elapsed.render.time", new Object[]{new Long(lTimer)}, this.getRunTimeContext().getULocale()));
            htRenderers.remove("T");
        }
    }

    private final int compare(DataElement de1, DataElement de2) throws ChartException {
        Class<?> c2;
        if (de1 == null && de2 == null) {
            return 0;
        }
        if (de1 == null || de2 == null) {
            return -2;
        }
        Class<?> c1 = de1.getClass();
        if (c1.equals(c2 = de2.getClass())) {
            if (de1 instanceof NumberDataElement) {
                return Double.compare(((NumberDataElement)de1).getValue(), ((NumberDataElement)de2).getValue());
            }
            if (de1 instanceof DateTimeDataElement) {
                long l1 = ((DateTimeDataElement)de1).getValue();
                long l2 = ((DateTimeDataElement)de1).getValue();
                return l1 < l1 ? -1 : (l1 == l2 ? 0 : 1);
            }
            if (de1 instanceof TextDataElement) {
                throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.unsupported.compare.text", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.unsupported.compare.unknown.objects", new Object[]{de1, de2}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.unsupported.compare.different.objects", new Object[]{de1, de2}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
    }

    private static final TextAlignment anchorToAlignment(Anchor anc) {
        TextAlignment ta = TextAlignmentImpl.create();
        if (anc == null) {
            return ta;
        }
        switch (anc.getValue()) {
            case 0: 
            case 1: 
            case 7: {
                ta.setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                ta.setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
                break;
            }
            default: {
                ta.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            }
        }
        switch (anc.getValue()) {
            case 1: 
            case 2: 
            case 3: {
                ta.setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                ta.setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
                break;
            }
            default: {
                ta.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            }
        }
        return ta;
    }

    private void sort(double[] a, double[] b, final boolean sortFirstArray) {
        int i;
        double[][] sa = new double[a.length][2];
        for (i = 0; i < a.length; ++i) {
            double[] ca = new double[]{a[i], b[i]};
            sa[i] = ca;
        }
        Arrays.sort(sa, new Comparator(){

            public int compare(Object o1, Object o2) {
                double[] l1 = (double[])o1;
                double[] l2 = (double[])o2;
                if (sortFirstArray) {
                    if (l1[0] == l2[0]) {
                        return 0;
                    }
                    if (l1[0] < l2[0]) {
                        return -1;
                    }
                } else {
                    if (l1[1] == l2[1]) {
                        return 0;
                    }
                    if (l1[1] < l2[1]) {
                        return -1;
                    }
                }
                return 1;
            }
        });
        for (i = 0; i < a.length; ++i) {
            a[i] = sa[i][0];
            b[i] = sa[i][1];
        }
    }

    protected final void renderFittingCurve(IPrimitiveRenderer ipr, Location[] points, CurveFitting curve, boolean bShowAsTape, boolean bDeferred) throws ChartException {
        if (!curve.getLineAttributes().isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.curve.line.visibility.not.defined", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean isTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        if (curve.getLineAttributes().isVisible()) {
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "beforeDrawFittingCurve", curve, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawFittingCurve", curve);
            double[] xArray = new double[points.length];
            double[] yArray = new double[points.length];
            for (int i = 0; i < xArray.length; ++i) {
                xArray[i] = points[i].getX();
                yArray[i] = points[i].getY();
            }
            this.sort(xArray, yArray, !isTransposed);
            double[] baseArray = xArray;
            double[] orthogonalArray = yArray;
            if (isTransposed) {
                baseArray = yArray;
                orthogonalArray = xArray;
            }
            FittingCalculator fc = new FittingCalculator(baseArray, orthogonalArray, 0.33);
            double[] fitYarray = fc.getFittedValue();
            orthogonalArray = fitYarray;
            if (isTransposed) {
                baseArray = fitYarray;
                orthogonalArray = yArray;
                this.sort(baseArray, orthogonalArray, false);
            }
            if (curve.getLineAttributes().getColor() != null) {
                CurveRenderer crdr = new CurveRenderer((ChartWithAxes)this.getModel(), this, curve.getLineAttributes(), LocationImpl.create(baseArray, orthogonalArray), bShowAsTape, -1.0, bDeferred, false, null, false, true);
                crdr.draw(ipr);
            }
            if (curve.getLabel().isSetVisible() && curve.getLabel().isVisible()) {
                double xs;
                double ys;
                Label lb = LabelImpl.copyInstance(curve.getLabel());
                String sPreviousValue = lb.getCaption().getValue();
                lb.getCaption().setValue(this.getRunTimeContext().externalizedMessage(sPreviousValue));
                BoundingBox bb = Methods.computeBox(this.getXServer(), 1, lb, 0.0, 0.0);
                Anchor lbAnchor = curve.getLabelAnchor();
                if (lbAnchor == null) {
                    lbAnchor = Anchor.NORTH_LITERAL;
                }
                int horizontal = 3;
                int vertical = 3;
                switch (lbAnchor.getValue()) {
                    case 5: 
                    case 6: 
                    case 7: {
                        horizontal = 1;
                        break;
                    }
                    case 0: 
                    case 4: {
                        horizontal = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        horizontal = 2;
                    }
                }
                switch (lbAnchor.getValue()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: {
                        vertical = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        vertical = 4;
                    }
                }
                if (isTransposed) {
                    if (horizontal == 1) {
                        ys = orthogonalArray[orthogonalArray.length - 1] - bb.getHeight();
                        horizontal = 2;
                    } else if (horizontal == 2) {
                        ys = orthogonalArray[0];
                        horizontal = 1;
                    } else {
                        ys = orthogonalArray[0] + (orthogonalArray[orthogonalArray.length - 1] - orthogonalArray[0]) / 2.0 - bb.getHeight() / 2.0;
                    }
                    xs = this.getFitYPosition(orthogonalArray, baseArray, horizontal, bb.getHeight(), bb.getWidth(), vertical == 4);
                } else {
                    xs = horizontal == 1 ? xArray[0] : (horizontal == 2 ? xArray[xArray.length - 1] - bb.getWidth() : xArray[0] + (xArray[xArray.length - 1] - xArray[0]) / 2.0 - bb.getWidth() / 2.0);
                    ys = this.getFitYPosition(xArray, fitYarray, horizontal, bb.getWidth(), bb.getHeight(), vertical == 3);
                }
                bb.setLeft(xs);
                bb.setTop(ys);
                if (ChartUtil.isShadowDefined(lb)) {
                    this.renderLabel(StructureSource.createSeries(this.getSeries()), 1, lb, Position.RIGHT_LITERAL, LocationImpl.create(bb.getLeft(), bb.getTop()), BoundsImpl.create(bb.getLeft(), bb.getTop(), bb.getWidth(), bb.getHeight()));
                }
                this.renderLabel(StructureSource.createSeries(this.getSeries()), 3, lb, Position.RIGHT_LITERAL, LocationImpl.create(bb.getLeft(), bb.getTop()), BoundsImpl.create(bb.getLeft(), bb.getTop(), bb.getWidth(), bb.getHeight()));
            }
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "afterDrawFittingCurve", curve, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawFittingCurve", curve);
        }
    }

    private double getFitYPosition(double[] xa, double[] ya, int align, double width, double height, boolean above) {
        int gap = 10;
        double rt = 0.0;
        if (align == 1) {
            rt = ya[0];
        } else if (align == 2) {
            rt = ya[ya.length - 1];
        } else if (ya.length % 2 == 1) {
            rt = ya[ya.length / 2];
        } else {
            int x = ya.length / 2;
            rt = (ya[x] + ya[x - 1]) / 2.0;
        }
        return above ? rt - height - (double)gap : rt + (double)gap;
    }

    private final void renderMarkerRanges(OneAxis[] oaxa, Bounds boPlotClientArea) throws ChartException {
        int iAxisCount = oaxa.length;
        double dMin = 0.0;
        double dMax = 0.0;
        int iCompare = 0;
        Bounds bo = BoundsImpl.create(0.0, 0.0, 0.0, 0.0);
        IDeviceRenderer idr = this.getDevice();
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        boolean bTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        StringBuffer sb = new StringBuffer();
        Bounds boText = BoundsImpl.create(0.0, 0.0, 0.0, 0.0);
        Anchor anc = null;
        Label la = null;
        double dOriginalAngle = 0.0;
        for (int i = 0; i < iAxisCount; ++i) {
            Axis ax = oaxa[i].getModelAxis();
            int iOrientation = ax.getOrientation().getValue();
            if (bTransposed) {
                iOrientation = iOrientation == 0 ? 1 : 0;
            }
            AutoScale asc = oaxa[i].getScale();
            EList el = ax.getMarkerRanges();
            int iRangeCount = el.size();
            for (int j = 0; j < iRangeCount; ++j) {
                EList elTriggers;
                MarkerRange mr = (MarkerRange)el.get(j);
                ScriptHandler.callFunction(sh, "beforeDrawMarkerRange", ax, mr, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawMarkerRange", mr);
                DataElement deStart = mr.getStartValue();
                DataElement deEnd = mr.getEndValue();
                try {
                    iCompare = this.compare(deStart, deEnd);
                }
                catch (ChartException dfex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)dfex));
                }
                if (iCompare == 1) {
                    DataElement deTemp = deStart;
                    deStart = deEnd;
                    deEnd = deTemp;
                }
                if (this.isDimension3D()) {
                    return;
                }
                try {
                    dMin = deStart == null ? (iOrientation == 0 ? boPlotClientArea.getLeft() : boPlotClientArea.getTop() + boPlotClientArea.getHeight()) : PlotWith2DAxes.getLocation(asc, deStart);
                }
                catch (Exception ex) {
                    logger.log(2, Messages.getString("exception.cannot.locate.start.marker.range", new Object[]{deStart, mr}, this.getRunTimeContext().getULocale()));
                    continue;
                }
                try {
                    dMax = deEnd == null ? (iOrientation == 0 ? boPlotClientArea.getLeft() + boPlotClientArea.getWidth() : boPlotClientArea.getTop()) : PlotWith2DAxes.getLocation(asc, deEnd);
                }
                catch (Exception ex) {
                    logger.log(2, Messages.getString("exception.cannot.locate.end.marker.range", new Object[]{deEnd, mr}, this.getRunTimeContext().getULocale()));
                    continue;
                }
                RectangleRenderEvent rre = (RectangleRenderEvent)((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerRange(mr), class$org$eclipse$birt$chart$event$RectangleRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.RectangleRenderEvent") : class$org$eclipse$birt$chart$event$RectangleRenderEvent);
                if (iOrientation == 0) {
                    if (dMax > boPlotClientArea.getLeft() + boPlotClientArea.getWidth()) {
                        dMax = boPlotClientArea.getLeft() + boPlotClientArea.getWidth();
                    }
                    if (dMin < boPlotClientArea.getLeft()) {
                        dMax = boPlotClientArea.getLeft();
                    }
                    bo.set(dMin, boPlotClientArea.getTop(), dMax - dMin, boPlotClientArea.getHeight());
                } else {
                    if (dMax < boPlotClientArea.getTop()) {
                        dMax = boPlotClientArea.getTop();
                    }
                    if (dMin > boPlotClientArea.getTop() + boPlotClientArea.getHeight()) {
                        dMin = boPlotClientArea.getTop() + boPlotClientArea.getHeight();
                    }
                    bo.set(boPlotClientArea.getLeft(), dMax, boPlotClientArea.getWidth(), dMin - dMax);
                }
                if (pwa.getDimension() == 1) {
                    if (iOrientation == 0) {
                        bo.translate(pwa.getSeriesThickness(), 0.0);
                    } else {
                        bo.translate(0.0, -pwa.getSeriesThickness());
                    }
                }
                rre.setBounds(bo);
                rre.setOutline(mr.getOutline());
                rre.setBackground(mr.getFill());
                idr.fillRectangle(rre);
                idr.drawRectangle(rre);
                la = LabelImpl.copyInstance(mr.getLabel());
                if (la.isVisible()) {
                    if (la.getCaption().getValue() != null && !"".equals(la.getCaption().getValue()) && la.getCaption().getValue().length() > 0) {
                        la.getCaption().setValue(oaxa[i].getRunTimeContext().externalizedMessage(la.getCaption().getValue()));
                    } else {
                        try {
                            sb.delete(0, sb.length());
                            sb.append(Messages.getString("prefix.marker.range.caption", this.getRunTimeContext().getULocale()));
                            sb.append(ValueFormatter.format(deStart, mr.getFormatSpecifier(), oaxa[i].getRunTimeContext().getULocale(), null));
                            sb.append(Messages.getString("separator.marker.range.caption", this.getRunTimeContext().getULocale()));
                            sb.append(ValueFormatter.format(deEnd, mr.getFormatSpecifier(), oaxa[i].getRunTimeContext().getULocale(), null));
                            sb.append(Messages.getString("suffix.marker.range.caption", this.getRunTimeContext().getULocale()));
                            la.getCaption().setValue(sb.toString());
                        }
                        catch (ChartException dfex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)dfex));
                        }
                    }
                    anc = this.switchAnchor(mr.getLabelAnchor());
                    if (bTransposed) {
                        Orientation or = ax.getOrientation() == Orientation.HORIZONTAL_LITERAL ? Orientation.VERTICAL_LITERAL : Orientation.HORIZONTAL_LITERAL;
                        dOriginalAngle = la.getCaption().getFont().getRotation();
                        try {
                            la.getCaption().getFont().setRotation(pwa.getTransposedAngle(dOriginalAngle));
                            anc = pwa.transposedAnchor(or, anc);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                        }
                    }
                    BoundingBox bb = null;
                    try {
                        bb = Methods.computeBox(idr.getDisplayServer(), 1, la, 0.0, 0.0);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                    }
                    boText.set(0.0, 0.0, bb.getWidth(), bb.getHeight());
                    TextRenderEvent tre = (TextRenderEvent)((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerRange(mr), class$org$eclipse$birt$chart$event$TextRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.TextRenderEvent") : class$org$eclipse$birt$chart$event$TextRenderEvent);
                    tre.setBlockBounds(bo);
                    tre.setBlockAlignment(AxesRenderer.anchorToAlignment(anc));
                    tre.setLabel(la);
                    tre.setAction(3);
                    idr.drawText(tre);
                }
                if (this.isInteractivityEnabled() && !(elTriggers = mr.getTriggers()).isEmpty()) {
                    InteractionEvent iev = (InteractionEvent)((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerRange(mr), class$org$eclipse$birt$chart$event$InteractionEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.InteractionEvent") : class$org$eclipse$birt$chart$event$InteractionEvent);
                    for (int t = 0; t < elTriggers.size(); ++t) {
                        Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                        this.processTrigger(tg, StructureSource.createMarkerRange(mr));
                        iev.addTrigger(tg);
                    }
                    iev.setHotSpot(rre);
                    idr.enableInteraction(iev);
                }
                ScriptHandler.callFunction(sh, "afterDrawMarkerRange", ax, mr, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawMarkerRange", mr);
            }
        }
    }

    protected void renderBackground(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        LineRenderEvent lre;
        int j;
        Line3DRenderEvent lre3d;
        AutoScale sc;
        LineAttributes lia;
        int i;
        PolygonRenderEvent pre;
        Location[] loa;
        super.renderBackground(ipr, p);
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        ClientArea ca = p.getClientArea();
        Bounds bo = pwa.getPlotBounds();
        RectangleRenderEvent rre = (RectangleRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), RectangleRenderEvent.class);
        if (!this.isDimension3D()) {
            if (ca.getShadowColor() != null) {
                rre.setBounds(bo.translateInstance(3.0, 3.0));
                rre.setBackground(ca.getShadowColor());
                ipr.fillRectangle(rre);
            }
            rre.setBounds(bo);
            rre.setOutline(ca.getOutline());
            rre.setBackground(ca.getBackground());
            ipr.fillRectangle(rre);
        }
        double dSeriesThickness = pwa.getSeriesThickness();
        double[] daX = new double[]{bo.getLeft() - dSeriesThickness, bo.getLeft() + bo.getWidth() - dSeriesThickness};
        double[] daY = new double[]{bo.getTop() + bo.getHeight() + dSeriesThickness, bo.getTop() + dSeriesThickness};
        AllAxes aax = pwa.getAxes();
        AutoScale scPrimaryBase = null;
        AutoScale scPrimaryOrthogonal = null;
        AutoScale scAncillaryBase = null;
        double dXStart = 0.0;
        double dYStart = 0.0;
        double dZStart = 0.0;
        double dXEnd = 0.0;
        double dYEnd = 0.0;
        double dZEnd = 0.0;
        int baseTickCount = 0;
        int ancillaryTickCount = 0;
        int orthogonalTickCount = 0;
        double xStep = 0.0;
        double yStep = 0.0;
        double zStep = 0.0;
        if (this.isDimension3D()) {
            scPrimaryBase = aax.getPrimaryBase().getScale();
            scPrimaryOrthogonal = aax.getPrimaryOrthogonal().getScale();
            scAncillaryBase = aax.getAncillaryBase().getScale();
            dXStart = scPrimaryBase.getStart();
            dYStart = scPrimaryOrthogonal.getStart();
            dZStart = scAncillaryBase.getStart();
            dXEnd = scPrimaryBase.getEnd();
            dYEnd = scPrimaryOrthogonal.getEnd();
            dZEnd = scAncillaryBase.getEnd();
            baseTickCount = scPrimaryBase.getTickCordinates().length;
            ancillaryTickCount = scAncillaryBase.getTickCordinates().length;
            orthogonalTickCount = scPrimaryOrthogonal.getTickCordinates().length;
            xStep = scPrimaryBase.getUnitSize();
            yStep = scPrimaryOrthogonal.getUnitSize();
            zStep = scAncillaryBase.getUnitSize();
        }
        if (pwa.getDimension() == 1) {
            loa = null;
            if (cwa.getWallFill() == null) {
                this.renderPlane(ipr, StructureSource.createPlot(p), new Location[]{LocationImpl.create(daX[0], daY[0]), LocationImpl.create(daX[0], daY[1])}, ca.getBackground(), ca.getOutline(), cwa.getDimension(), dSeriesThickness, false);
            } else {
                loa = new Location[]{LocationImpl.create(daX[0], daY[0]), LocationImpl.create(daX[0], daY[1]), LocationImpl.create(daX[0] + dSeriesThickness, daY[1] - dSeriesThickness), LocationImpl.create(daX[0] + dSeriesThickness, daY[0] - dSeriesThickness)};
                pre = (PolygonRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), PolygonRenderEvent.class);
                pre.setPoints(loa);
                pre.setBackground(cwa.getWallFill());
                pre.setOutline(ca.getOutline());
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
            if (cwa.getFloorFill() == null) {
                this.renderPlane(ipr, StructureSource.createPlot(p), new Location[]{LocationImpl.create(daX[0], daY[0]), LocationImpl.create(daX[1], daY[0])}, ca.getBackground(), ca.getOutline(), cwa.getDimension(), dSeriesThickness, false);
            } else {
                if (loa == null) {
                    loa = new Location[]{LocationImpl.create(daX[0], daY[0]), LocationImpl.create(daX[1], daY[0]), LocationImpl.create(daX[1] + dSeriesThickness, daY[0] - dSeriesThickness), LocationImpl.create(daX[0] + dSeriesThickness, daY[0] - dSeriesThickness)};
                }
                pre = (PolygonRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), PolygonRenderEvent.class);
                pre.setPoints(loa);
                pre.setBackground(cwa.getFloorFill());
                pre.setOutline(ca.getOutline());
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
        } else if (pwa.getDimension() == 2) {
            loa = null;
            pre = (Polygon3DRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), Polygon3DRenderEvent.class);
            ((Polygon3DRenderEvent)pre).setDoubleSided(true);
            if (cwa.getWallFill() instanceof ColorDefinition && ((ColorDefinition)cwa.getWallFill()).getTransparency() > 0 || !(cwa.getWallFill() instanceof ColorDefinition) && cwa.getWallFill() != null) {
                loa = new Location3D[]{Location3DImpl.create(dXStart, dYStart, dZStart), Location3DImpl.create(dXStart, dYEnd, dZStart), Location3DImpl.create(dXStart, dYEnd, dZEnd), Location3DImpl.create(dXStart, dYStart, dZEnd)};
                ((Polygon3DRenderEvent)pre).setPoints3D((Location3D[])loa);
                ((Polygon3DRenderEvent)pre).setBackground(cwa.getWallFill());
                ((Polygon3DRenderEvent)pre).setDoubleSided(true);
                pre.setOutline(ca.getOutline());
                this.getDeferredCache().addPlane(pre, 3);
                this.leftWallFill = true;
                loa[0] = Location3DImpl.create(dXStart, dYStart, dZStart);
                loa[1] = Location3DImpl.create(dXEnd, dYStart, dZStart);
                loa[2] = Location3DImpl.create(dXEnd, dYEnd, dZStart);
                loa[3] = Location3DImpl.create(dXStart, dYEnd, dZStart);
                ((Polygon3DRenderEvent)pre).setPoints3D((Location3D[])loa);
                ((Polygon3DRenderEvent)pre).setBackground(cwa.getWallFill());
                ((Polygon3DRenderEvent)pre).setDoubleSided(true);
                pre.setOutline(ca.getOutline());
                this.getDeferredCache().addPlane(pre, 3);
                this.rightWallFill = true;
            }
            if (cwa.getFloorFill() instanceof ColorDefinition && ((ColorDefinition)cwa.getFloorFill()).getTransparency() > 0 || !(cwa.getFloorFill() instanceof ColorDefinition) && cwa.getFloorFill() != null) {
                if (loa == null) {
                    loa = new Location3D[]{Location3DImpl.create(dXStart, dYStart, dZStart), Location3DImpl.create(dXStart, dYStart, dZEnd), Location3DImpl.create(dXEnd, dYStart, dZEnd), Location3DImpl.create(dXEnd, dYStart, dZStart)};
                }
                ((Polygon3DRenderEvent)pre).setPoints3D((Location3D[])loa);
                ((Polygon3DRenderEvent)pre).setBackground(cwa.getFloorFill());
                ((Polygon3DRenderEvent)pre).setDoubleSided(true);
                pre.setOutline(ca.getOutline());
                this.getDeferredCache().addPlane(pre, 3);
                this.floorFill = true;
            }
        }
        OneAxis[] oaxa = new OneAxis[2 + aax.getOverlayCount() + (aax.getAncillaryBase() != null ? 1 : 0)];
        oaxa[0] = aax.getPrimaryBase();
        oaxa[1] = aax.getPrimaryOrthogonal();
        for (int i2 = 0; i2 < aax.getOverlayCount(); ++i2) {
            oaxa[2 + i2] = aax.getOverlay(i2);
        }
        if (aax.getAncillaryBase() != null) {
            oaxa[2 + aax.getOverlayCount()] = aax.getAncillaryBase();
        }
        this.renderMarkerRanges(oaxa, bo);
        double x = 0.0;
        double y = 0.0;
        double vnext = 0.0;
        Insets insCA = aax.getInsets();
        double[] doaMinor = null;
        block11: for (i = 0; i < oaxa.length; ++i) {
            int k;
            int j2;
            double[] da;
            Grid g = oaxa[i].getGrid();
            int iCount = g.getMinorCountPerMajor();
            lia = oaxa[i].getGrid().getLineAttributes(1);
            if (lia == null || !lia.isSetStyle() || !lia.isVisible()) continue;
            if (iCount <= 0) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.cannot.split.major", new Object[]{new Integer(iCount)}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
            sc = oaxa[i].getScale();
            doaMinor = sc.getMinorCoordinates(iCount);
            if (this.isDimension3D()) {
                lre3d = (Line3DRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), class$org$eclipse$birt$chart$event$Line3DRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.Line3DRenderEvent") : class$org$eclipse$birt$chart$event$Line3DRenderEvent);
                lre3d.setLineAttributes(lia);
                switch (oaxa[i].getAxisType()) {
                    case 5: {
                        int n;
                        int j3;
                        int k2;
                        double[] xa = scPrimaryBase.getTickCordinates();
                        if (this.floorFill) {
                            for (k2 = 0; k2 < xa.length - 1; ++k2) {
                                for (j3 = 0; j3 < doaMinor.length - 1; ++j3) {
                                    for (n = 0; n < ancillaryTickCount - 1; ++n) {
                                        if (ChartUtil.mathGE(xa[k2] + doaMinor[j3], xa[k2 + 1])) continue;
                                        lre3d.setStart3D(Location3DImpl.create(xa[k2] + doaMinor[j3], dYStart, dZStart + (double)n * zStep));
                                        lre3d.setEnd3D(Location3DImpl.create(xa[k2] + doaMinor[j3], dYStart, dZStart + (double)(n + 1) * zStep));
                                        this.getDeferredCache().addLine(lre3d);
                                    }
                                }
                            }
                        }
                        if (!this.rightWallFill) break;
                        for (k2 = 0; k2 < xa.length - 1; ++k2) {
                            for (j3 = 0; j3 < doaMinor.length - 1; ++j3) {
                                for (n = 0; n < orthogonalTickCount - 1; ++n) {
                                    if (ChartUtil.mathGE(xa[k2] + doaMinor[j3], xa[k2 + 1])) continue;
                                    lre3d.setStart3D(Location3DImpl.create(xa[k2] + doaMinor[j3], dYStart + (double)n * yStep, dZStart));
                                    lre3d.setEnd3D(Location3DImpl.create(xa[k2] + doaMinor[j3], dYStart + (double)(n + 1) * yStep, dZStart));
                                    this.getDeferredCache().addLine(lre3d);
                                }
                            }
                        }
                        continue block11;
                    }
                    case 9: {
                        int n;
                        double[] ya = scPrimaryOrthogonal.getTickCordinates();
                        if (this.leftWallFill) {
                            for (int k3 = 0; k3 < ya.length - 1; ++k3) {
                                for (int j4 = 0; j4 < doaMinor.length - 1; ++j4) {
                                    for (n = 0; n < ancillaryTickCount - 1; ++n) {
                                        if (ChartUtil.mathGE(ya[k3] + doaMinor[j4], ya[k3 + 1])) continue;
                                        lre3d.setStart3D(Location3DImpl.create(dXStart, ya[k3] + doaMinor[j4], dZStart + (double)n * zStep));
                                        lre3d.setEnd3D(Location3DImpl.create(dXStart, ya[k3] + doaMinor[j4], dZStart + (double)(n + 1) * zStep));
                                        this.getDeferredCache().addLine(lre3d);
                                    }
                                }
                            }
                        }
                        if (!this.rightWallFill) break;
                        for (int k4 = 0; k4 < ya.length - 1; ++k4) {
                            for (int j5 = 0; j5 < doaMinor.length - 1; ++j5) {
                                for (n = 0; n < baseTickCount - 1; ++n) {
                                    if (ChartUtil.mathGE(ya[k4] + doaMinor[j5], ya[k4 + 1])) continue;
                                    lre3d.setStart3D(Location3DImpl.create(dXStart + (double)n * xStep, ya[k4] + doaMinor[j5], dZStart));
                                    lre3d.setEnd3D(Location3DImpl.create(dXStart + (double)(n + 1) * xStep, ya[k4] + doaMinor[j5], dZStart));
                                    this.getDeferredCache().addLine(lre3d);
                                }
                            }
                        }
                        continue block11;
                    }
                    case 17: {
                        int n;
                        double[] za = scAncillaryBase.getTickCordinates();
                        if (this.leftWallFill) {
                            for (int k5 = 0; k5 < za.length - 1; ++k5) {
                                for (j = 0; j < doaMinor.length - 1; ++j) {
                                    for (n = 0; n < orthogonalTickCount - 1; ++n) {
                                        if (ChartUtil.mathGE(za[k5] + doaMinor[j], za[k5 + 1])) continue;
                                        lre3d.setStart3D(Location3DImpl.create(dXStart, dYStart + (double)n * yStep, za[k5] + doaMinor[j]));
                                        lre3d.setEnd3D(Location3DImpl.create(dXStart, dYStart + (double)(n + 1) * yStep, za[k5] + doaMinor[j]));
                                        this.getDeferredCache().addLine(lre3d);
                                    }
                                }
                            }
                        }
                        if (!this.floorFill) break;
                        for (int k6 = 0; k6 < za.length - 1; ++k6) {
                            for (j = 0; j < doaMinor.length - 1; ++j) {
                                for (n = 0; n < baseTickCount - 1; ++n) {
                                    if (ChartUtil.mathGE(za[k6] + doaMinor[j], za[k6 + 1])) continue;
                                    lre3d.setStart3D(Location3DImpl.create(dXStart + (double)n * xStep, dYStart, za[k6] + doaMinor[j]));
                                    lre3d.setEnd3D(Location3DImpl.create(dXStart + (double)(n + 1) * xStep, dYStart, za[k6] + doaMinor[j]));
                                    this.getDeferredCache().addLine(lre3d);
                                }
                            }
                        }
                        continue block11;
                    }
                }
                continue;
            }
            if (oaxa[i].getOrientation() == 0) {
                int iDirection = sc.getDirection() == -1 ? -1 : 1;
                da = sc.getTickCordinates();
                double dY2 = bo.getTop() + 1.0;
                double dY1 = bo.getTop() + bo.getHeight() - 2.0;
                if (pwa.getDimension() == 1) {
                    for (j2 = 0; j2 < da.length - 1; ++j2) {
                        x = da[j2];
                        for (k = 0; k < doaMinor.length; ++k) {
                            if (iDirection == 1 && ChartUtil.mathGE(x + doaMinor[k], da[j2 + 1]) || iDirection == -1 && ChartUtil.mathLE(x - doaMinor[k], da[j2 + 1])) continue;
                            lre = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                            lre.setLineAttributes(lia);
                            lre.setStart(LocationImpl.create(x + (double)iDirection * doaMinor[k], dY1 + pwa.getSeriesThickness()));
                            lre.setEnd(LocationImpl.create(x + (double)iDirection * doaMinor[k] + pwa.getSeriesThickness(), dY1));
                            ipr.drawLine(lre);
                        }
                    }
                }
                for (j2 = 0; j2 < da.length - 1; ++j2) {
                    x = da[j2];
                    vnext = da[j2 + 1];
                    if (pwa.getDimension() == 1) {
                        x += pwa.getSeriesThickness();
                        vnext += pwa.getSeriesThickness();
                    }
                    for (k = 0; k < doaMinor.length; ++k) {
                        if (iDirection == 1 && ChartUtil.mathGE(x + doaMinor[k], vnext) || iDirection == -1 && ChartUtil.mathLE(x - doaMinor[k], vnext)) continue;
                        lre = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                        lre.setLineAttributes(lia);
                        lre.setStart(LocationImpl.create(x + (double)iDirection * doaMinor[k], dY1));
                        lre.setEnd(LocationImpl.create(x + (double)iDirection * doaMinor[k], dY2));
                        ipr.drawLine(lre);
                    }
                }
                continue;
            }
            if (oaxa[i].getOrientation() != 1) continue;
            int iDirection = sc.getDirection() != 1 ? -1 : 1;
            da = sc.getTickCordinates();
            double dX1 = bo.getLeft() + 1.0;
            double dX2 = bo.getLeft() + bo.getWidth() - 2.0;
            if (pwa.getDimension() == 1) {
                for (j2 = 0; j2 < da.length - 1; ++j2) {
                    y = da[j2] - pwa.getSeriesThickness();
                    vnext = da[j2 + 1] - pwa.getSeriesThickness();
                    for (k = 0; k < doaMinor.length; ++k) {
                        if (iDirection == 1 && ChartUtil.mathGE(y + doaMinor[k], vnext) || iDirection == -1 && ChartUtil.mathLE(y - doaMinor[k], vnext)) continue;
                        lre = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                        lre.setLineAttributes(lia);
                        lre.setStart(LocationImpl.create(dX1, y + (double)iDirection * doaMinor[k]));
                        lre.setEnd(LocationImpl.create(dX1 - pwa.getSeriesThickness(), y + (double)iDirection * doaMinor[k] + pwa.getSeriesThickness()));
                        ipr.drawLine(lre);
                    }
                }
            }
            for (j2 = 0; j2 < da.length - 1; ++j2) {
                y = da[j2];
                vnext = da[j2 + 1];
                if (pwa.getDimension() == 1) {
                    y -= pwa.getSeriesThickness();
                    vnext -= pwa.getSeriesThickness();
                }
                for (k = 0; k < doaMinor.length; ++k) {
                    if (iDirection == 1 && ChartUtil.mathGE(y + doaMinor[k], vnext) || iDirection == -1 && ChartUtil.mathLE(y - doaMinor[k], vnext)) continue;
                    lre = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                    lre.setLineAttributes(lia);
                    lre.setStart(LocationImpl.create(dX1, y + (double)iDirection * doaMinor[k]));
                    lre.setEnd(LocationImpl.create(dX2, y + (double)iDirection * doaMinor[k]));
                    ipr.drawLine(lre);
                }
            }
        }
        block38: for (i = 0; i < oaxa.length; ++i) {
            double[] da;
            lia = oaxa[i].getGrid().getLineAttributes(0);
            if (lia == null || !lia.isSetStyle() || !lia.isVisible()) continue;
            sc = oaxa[i].getScale();
            if (this.isDimension3D()) {
                lre3d = (Line3DRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), class$org$eclipse$birt$chart$event$Line3DRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.Line3DRenderEvent") : class$org$eclipse$birt$chart$event$Line3DRenderEvent);
                lre3d.setLineAttributes(lia);
                switch (oaxa[i].getAxisType()) {
                    case 5: {
                        double[] xa = scPrimaryBase.getTickCordinates();
                        if (this.floorFill) {
                            for (int k = 0; k < xa.length; ++k) {
                                for (int j6 = 0; j6 < ancillaryTickCount - 1; ++j6) {
                                    lre3d.setStart3D(Location3DImpl.create(xa[k], dYStart, dZStart + (double)j6 * zStep));
                                    lre3d.setEnd3D(Location3DImpl.create(xa[k], dYStart, dZStart + (double)(j6 + 1) * zStep));
                                    this.getDeferredCache().addLine(lre3d);
                                }
                            }
                        }
                        if (!this.rightWallFill) break;
                        for (int k = 0; k < xa.length; ++k) {
                            for (int j7 = 0; j7 < orthogonalTickCount - 1; ++j7) {
                                lre3d.setStart3D(Location3DImpl.create(xa[k], dYStart + (double)j7 * yStep, dZStart));
                                lre3d.setEnd3D(Location3DImpl.create(xa[k], dYStart + (double)(j7 + 1) * yStep, dZStart));
                                this.getDeferredCache().addLine(lre3d);
                            }
                        }
                        continue block38;
                    }
                    case 9: {
                        double[] ya = scPrimaryOrthogonal.getTickCordinates();
                        if (this.leftWallFill) {
                            for (int k = 0; k < ya.length; ++k) {
                                for (int j8 = 0; j8 < ancillaryTickCount - 1; ++j8) {
                                    lre3d.setStart3D(Location3DImpl.create(dXStart, ya[k], dZStart + (double)j8 * zStep));
                                    lre3d.setEnd3D(Location3DImpl.create(dXStart, ya[k], dZStart + (double)(j8 + 1) * zStep));
                                    this.getDeferredCache().addLine(lre3d);
                                }
                            }
                        }
                        if (!this.rightWallFill) break;
                        for (int k = 0; k < ya.length; ++k) {
                            for (int j9 = 0; j9 < baseTickCount - 1; ++j9) {
                                lre3d.setStart3D(Location3DImpl.create(dXStart + (double)j9 * xStep, ya[k], dZStart));
                                lre3d.setEnd3D(Location3DImpl.create(dXStart + (double)(j9 + 1) * xStep, ya[k], dZStart));
                                this.getDeferredCache().addLine(lre3d);
                            }
                        }
                        continue block38;
                    }
                    case 17: {
                        int k;
                        double[] za = scAncillaryBase.getTickCordinates();
                        if (this.leftWallFill) {
                            for (k = 0; k < za.length; ++k) {
                                for (j = 0; j < orthogonalTickCount - 1; ++j) {
                                    lre3d.setStart3D(Location3DImpl.create(dXStart, dYStart + (double)j * yStep, za[k]));
                                    lre3d.setEnd3D(Location3DImpl.create(dXStart, dYStart + (double)(j + 1) * yStep, za[k]));
                                    this.getDeferredCache().addLine(lre3d);
                                }
                            }
                        }
                        if (!this.floorFill) break;
                        for (k = 0; k < za.length; ++k) {
                            for (j = 0; j < baseTickCount - 1; ++j) {
                                lre3d.setStart3D(Location3DImpl.create(dXStart + (double)j * xStep, dYStart, za[k]));
                                lre3d.setEnd3D(Location3DImpl.create(dXStart + (double)(j + 1) * xStep, dYStart, za[k]));
                                this.getDeferredCache().addLine(lre3d);
                            }
                        }
                        continue block38;
                    }
                }
                continue;
            }
            if (oaxa[i].getOrientation() == 0) {
                da = sc.getTickCordinates();
                double dY2 = bo.getTop() + 1.0;
                double dY1 = bo.getTop() + bo.getHeight() - 2.0;
                if (pwa.getDimension() == 1) {
                    for (j = 0; j < da.length; ++j) {
                        if (j == 0 && insCA.getBottom() < (double)lia.getThickness() || j == da.length - 1 && insCA.getTop() < (double)lia.getThickness()) continue;
                        x = da[j];
                        lre = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                        lre.setLineAttributes(lia);
                        lre.setStart(LocationImpl.create(x, dY1 + pwa.getSeriesThickness()));
                        lre.setEnd(LocationImpl.create(x + pwa.getSeriesThickness(), dY1));
                        ipr.drawLine(lre);
                    }
                }
                for (j = 0; j < da.length; ++j) {
                    if (j == 0 && insCA.getBottom() < (double)lia.getThickness() || j == da.length - 1 && insCA.getTop() < (double)lia.getThickness()) continue;
                    x = da[j];
                    if (pwa.getDimension() == 1) {
                        x += pwa.getSeriesThickness();
                    }
                    lre = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                    lre.setLineAttributes(lia);
                    lre.setStart(LocationImpl.create(x, dY1));
                    lre.setEnd(LocationImpl.create(x, dY2));
                    ipr.drawLine(lre);
                }
                continue;
            }
            if (oaxa[i].getOrientation() != 1) continue;
            da = sc.getTickCordinates();
            double dX1 = bo.getLeft() + 1.0;
            double dX2 = bo.getLeft() + bo.getWidth() - 2.0;
            if (pwa.getDimension() == 1) {
                for (j = 0; j < da.length; ++j) {
                    if (j == 0 && insCA.getLeft() < (double)lia.getThickness() || j == da.length - 1 && insCA.getRight() < (double)lia.getThickness()) continue;
                    y = da[j] - pwa.getSeriesThickness();
                    lre = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                    lre.setLineAttributes(lia);
                    lre.setStart(LocationImpl.create(dX1, y));
                    lre.setEnd(LocationImpl.create(dX1 - pwa.getSeriesThickness(), y + pwa.getSeriesThickness()));
                    ipr.drawLine(lre);
                }
            }
            for (j = 0; j < da.length; ++j) {
                if (j == 0 && insCA.getLeft() < (double)lia.getThickness() || j == da.length - 1 && insCA.getRight() < (double)lia.getThickness()) continue;
                y = da[j];
                if (pwa.getDimension() == 1) {
                    y -= pwa.getSeriesThickness();
                }
                lre = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                lre.setLineAttributes(lia);
                lre.setStart(LocationImpl.create(dX1, y));
                lre.setEnd(LocationImpl.create(dX2, y));
                ipr.drawLine(lre);
            }
        }
        if (!this.isDimension3D() && p.getClientArea().getOutline().isVisible()) {
            rre.setBounds(bo);
            ipr.drawRectangle(rre);
        }
    }

    private final void renderAxesStructure(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        AllAxes aax = pwa.getAxes();
        if (pwa.getDimension() == 2) {
            this.renderEachAxis(ipr, p, aax.getPrimaryBase(), 5);
            this.renderEachAxis(ipr, p, aax.getAncillaryBase(), 17);
            this.renderEachAxis(ipr, p, aax.getPrimaryOrthogonal(), 9);
        } else {
            int i;
            int iCount = aax.getOverlayCount() + 2;
            OneAxis[] oaxa = new OneAxis[iCount];
            oaxa[0] = aax.getPrimaryBase();
            oaxa[1] = aax.getPrimaryOrthogonal();
            for (i = 0; i < iCount - 2; ++i) {
                oaxa[i + 2] = aax.getOverlay(i);
            }
            for (i = 0; i < iCount; ++i) {
                this.renderEachAxis(ipr, p, oaxa[i], 1);
            }
        }
    }

    private final void renderAxesLabels(IPrimitiveRenderer ipr, Plot p, OneAxis[] oaxa) throws ChartException {
        for (int i = 0; i < oaxa.length; ++i) {
            this.renderEachAxis(ipr, p, oaxa[i], 2);
        }
    }

    public final void renderPlot(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        if (!p.isVisible()) {
            return;
        }
        boolean bFirstInSequence = this.iSeriesIndex == 0;
        boolean bLastInSequence = this.iSeriesIndex == this.iSeriesCount - 1;
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        if (bFirstInSequence) {
            this.renderBackground(ipr, p);
            this.renderAxesStructure(ipr, p);
        }
        if (this.getSeries() != null) {
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "beforeDrawSeries", this.getSeries(), this, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawSeries", this.getSeries());
            this.renderSeries(ipr, p, this.srh);
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "afterDrawSeries", this.getSeries(), this, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawSeries", this.getSeries());
        }
        if (bLastInSequence) {
            Location panningOffset = this.getPanningOffset();
            try {
                if (this.isDimension3D()) {
                    this.getDeferredCache().process3DEvent(this.get3DEngine(), panningOffset.getX(), panningOffset.getY());
                }
                this.getDeferredCache().flush();
            }
            catch (ChartException ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)ex));
            }
            AllAxes aax = pwa.getAxes();
            OneAxis[] oaxa = new OneAxis[2 + aax.getOverlayCount() + (aax.getAncillaryBase() != null ? 1 : 0)];
            oaxa[0] = aax.getPrimaryBase();
            oaxa[1] = aax.getPrimaryOrthogonal();
            for (int i = 0; i < aax.getOverlayCount(); ++i) {
                oaxa[2 + i] = aax.getOverlay(i);
            }
            if (aax.getAncillaryBase() != null) {
                oaxa[2 + aax.getOverlayCount()] = aax.getAncillaryBase();
            }
            Bounds bo = pwa.getPlotBounds();
            this.renderMarkerLines(oaxa, bo);
            this.renderAxesLabels(ipr, p, oaxa);
            try {
                if (this.isDimension3D()) {
                    this.getDeferredCache().process3DEvent(this.get3DEngine(), panningOffset.getX(), panningOffset.getY());
                }
                this.getDeferredCache().flush();
            }
            catch (ChartException ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)ex));
            }
        }
    }

    protected final void renderMarker(Object oParent, IPrimitiveRenderer ipr, Marker m, Location lo, LineAttributes lia, Fill fPaletteEntry, DataPointHints dph, int markerSize, boolean bDeferred, boolean bConsiderTranspostion) throws ChartException {
        EList elTriggers;
        if (dph != null && AxesRenderer.isNaN(dph.getOrthogonalValue())) {
            return;
        }
        Series se = this.getSeries();
        StructureSource oSource = oParent instanceof Legend ? StructureSource.createLegend((Legend)oParent) : WrappedStructureSource.createSeriesDataPoint(se, dph);
        boolean bTransposed = bConsiderTranspostion && ((ChartWithAxes)this.getModel()).isTransposed();
        Location panningOffset = this.getPanningOffset();
        PrimitiveRenderEvent preCopy = null;
        if (m == null || m != null && (!m.isSetVisible() || !m.isVisible())) {
            OvalRenderEvent ore;
            int iSize = 5;
            if (m != null) {
                iSize = m.getSize();
            }
            if (lo instanceof Location3D) {
                ore = (Oval3DRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(oSource, Oval3DRenderEvent.class);
                Location3D lo3d = (Location3D)lo;
                ((Oval3DRenderEvent)ore).setLocation3D(new Location3D[]{Location3DImpl.create(lo3d.getX() - (double)iSize, lo3d.getY() + (double)iSize, lo3d.getZ()), Location3DImpl.create(lo3d.getX() - (double)iSize, lo3d.getY() - (double)iSize, lo3d.getZ()), Location3DImpl.create(lo3d.getX() + (double)iSize, lo3d.getY() - (double)iSize, lo3d.getZ()), Location3DImpl.create(lo3d.getX() + (double)iSize, lo3d.getY() + (double)iSize, lo3d.getZ())});
                preCopy = ((Oval3DRenderEvent)ore).copy();
            } else {
                ore = (OvalRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(oSource, OvalRenderEvent.class);
                ore.setBounds(BoundsImpl.create(lo.getX() - (double)iSize, lo.getY() - (double)iSize, iSize * 2, iSize * 2));
                preCopy = ore.copy();
            }
        } else if (m.isSetVisible() && m.isVisible()) {
            MarkerRenderer mr = new MarkerRenderer(this.getDevice(), oSource, lo, lia, fPaletteEntry, m, markerSize, this.getDeferredCache(), bDeferred, bTransposed);
            mr.draw(ipr);
            preCopy = mr.getRenderArea();
        }
        if (this.isInteractivityEnabled() && dph != null && (!(lo instanceof Location3D) || lo instanceof Location3D && this.get3DEngine().processEvent(preCopy, panningOffset.getX(), panningOffset.getY()) != null) && !(elTriggers = se.getTriggers()).isEmpty()) {
            StructureSource iSource = oParent instanceof Legend ? StructureSource.createSeries(se) : WrappedStructureSource.createSeriesDataPoint(se, dph);
            InteractionEvent iev = (InteractionEvent)((EventObjectCache)((Object)ipr)).getEventObject(iSource, InteractionEvent.class);
            for (int t = 0; t < elTriggers.size(); ++t) {
                Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                this.processTrigger(tg, iSource);
                iev.addTrigger(tg);
            }
            iev.setHotSpot(preCopy);
            ipr.enableInteraction(iev);
        }
    }

    private final void renderMarkerLines(OneAxis[] oaxa, Bounds boPlotClientArea) throws ChartException {
        int iAxisCount = oaxa.length;
        double dCoordinate = 0.0;
        IDeviceRenderer idr = this.getDevice();
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        Location loStart = LocationImpl.create(0.0, 0.0);
        Location loEnd = LocationImpl.create(0.0, 0.0);
        TextRenderEvent tre = null;
        Label la = null;
        double dOriginalAngle = 0.0;
        boolean bTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        Bounds boText = BoundsImpl.create(0.0, 0.0, 0.0, 0.0);
        for (int i = 0; i < iAxisCount; ++i) {
            Axis ax = oaxa[i].getModelAxis();
            int iOrientation = ax.getOrientation().getValue();
            if (bTransposed) {
                iOrientation = iOrientation == 0 ? 1 : 0;
            }
            AutoScale asc = oaxa[i].getScale();
            EList el = ax.getMarkerLines();
            int iLineCount = el.size();
            for (int j = 0; j < iLineCount; ++j) {
                EList elTriggers;
                MarkerLine ml = (MarkerLine)el.get(j);
                ScriptHandler.callFunction(sh, "beforeDrawMarkerLine", ax, ml, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawMarkerLine", ml);
                DataElement deValue = ml.getValue();
                if (deValue == null) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.marker.line.null.value", new Object[]{ml}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                }
                la = LabelImpl.copyInstance(ml.getLabel());
                if (la.getCaption().getValue() != null && !"".equals(la.getCaption().getValue()) && la.getCaption().getValue().length() > 0) {
                    la.getCaption().setValue(oaxa[i].getRunTimeContext().externalizedMessage(la.getCaption().getValue()));
                } else {
                    try {
                        la.getCaption().setValue(ValueFormatter.format(deValue, ml.getFormatSpecifier(), oaxa[i].getRunTimeContext().getULocale(), null));
                    }
                    catch (ChartException dfex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)dfex));
                    }
                }
                if (this.isDimension3D()) {
                    return;
                }
                try {
                    dCoordinate = PlotWith2DAxes.getLocation(asc, deValue);
                }
                catch (Exception ex) {
                    logger.log(2, Messages.getString("exception.cannot.locate.value.marker.line", new Object[]{deValue, ml}, this.getRunTimeContext().getULocale()));
                    continue;
                }
                LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerLine(ml), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                if (iOrientation == 0) {
                    if (dCoordinate > boPlotClientArea.getLeft() + boPlotClientArea.getWidth()) {
                        dCoordinate = boPlotClientArea.getLeft() + boPlotClientArea.getWidth();
                    }
                    if (dCoordinate < boPlotClientArea.getLeft()) {
                        dCoordinate = boPlotClientArea.getLeft();
                    }
                    loStart.set(dCoordinate, boPlotClientArea.getTop());
                    loEnd.set(dCoordinate, boPlotClientArea.getTop() + boPlotClientArea.getHeight());
                } else {
                    if (dCoordinate < boPlotClientArea.getTop()) {
                        dCoordinate = boPlotClientArea.getTop();
                    }
                    if (dCoordinate > boPlotClientArea.getTop() + boPlotClientArea.getHeight()) {
                        dCoordinate = boPlotClientArea.getTop() + boPlotClientArea.getHeight();
                    }
                    loStart.set(boPlotClientArea.getLeft(), dCoordinate);
                    loEnd.set(boPlotClientArea.getLeft() + boPlotClientArea.getWidth(), dCoordinate);
                }
                if (pwa.getDimension() == 1) {
                    if (iOrientation == 0) {
                        loStart.translate(0.0, pwa.getSeriesThickness());
                        loEnd.translate(0.0, pwa.getSeriesThickness());
                    } else {
                        loStart.translate(-pwa.getSeriesThickness(), 0.0);
                        loEnd.translate(-pwa.getSeriesThickness(), 0.0);
                    }
                }
                lre.setStart(loStart);
                lre.setEnd(loEnd);
                lre.setLineAttributes(ml.getLineAttributes());
                idr.drawLine(lre);
                if (la.isVisible()) {
                    Anchor anc = this.switchAnchor(ml.getLabelAnchor());
                    if (bTransposed) {
                        Orientation or = ax.getOrientation() == Orientation.HORIZONTAL_LITERAL ? Orientation.VERTICAL_LITERAL : Orientation.HORIZONTAL_LITERAL;
                        dOriginalAngle = la.getCaption().getFont().getRotation();
                        try {
                            la.getCaption().getFont().setRotation(pwa.getTransposedAngle(dOriginalAngle));
                            anc = pwa.transposedAnchor(or, anc);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                        }
                    }
                    BoundingBox bb = null;
                    try {
                        bb = Methods.computeBox(idr.getDisplayServer(), 1, la, 0.0, 0.0);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                    }
                    boText.set(0.0, 0.0, bb.getWidth(), bb.getHeight());
                    if (iOrientation == 1) {
                        if (anc != null) {
                            switch (anc.getValue()) {
                                case 0: 
                                case 1: 
                                case 7: {
                                    boText.setTop(loStart.getY() - boText.getHeight());
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: {
                                    boText.setTop(loStart.getY());
                                    break;
                                }
                                default: {
                                    boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                                }
                            }
                            switch (anc.getValue()) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    boText.setLeft(loEnd.getX() - boText.getWidth());
                                    break;
                                }
                                case 5: 
                                case 6: 
                                case 7: {
                                    boText.setLeft(loStart.getX());
                                    break;
                                }
                                default: {
                                    boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                                    break;
                                }
                            }
                        } else {
                            boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                            boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                        }
                    } else if (anc != null) {
                        switch (anc.getValue()) {
                            case 0: 
                            case 1: 
                            case 7: {
                                boText.setTop(loStart.getY());
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                boText.setTop(loEnd.getY() - boText.getHeight());
                                break;
                            }
                            default: {
                                boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                            }
                        }
                        switch (anc.getValue()) {
                            case 1: 
                            case 2: 
                            case 3: {
                                boText.setLeft(loStart.getX());
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 7: {
                                boText.setLeft(loEnd.getX() - boText.getWidth());
                                break;
                            }
                            default: {
                                boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                                break;
                            }
                        }
                    } else {
                        boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                        boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                    }
                    tre = (TextRenderEvent)((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerLine(ml), class$org$eclipse$birt$chart$event$TextRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.TextRenderEvent") : class$org$eclipse$birt$chart$event$TextRenderEvent);
                    tre.setBlockBounds(boText);
                    tre.setBlockAlignment(null);
                    tre.setLabel(la);
                    tre.setAction(3);
                    idr.drawText(tre);
                }
                if (this.isInteractivityEnabled() && !(elTriggers = ml.getTriggers()).isEmpty()) {
                    InteractionEvent iev = (InteractionEvent)((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerLine(ml), class$org$eclipse$birt$chart$event$InteractionEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.InteractionEvent") : class$org$eclipse$birt$chart$event$InteractionEvent);
                    for (int t = 0; t < elTriggers.size(); ++t) {
                        Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                        this.processTrigger(tg, StructureSource.createMarkerLine(ml));
                        iev.addTrigger(tg);
                    }
                    Location[] loaHotspot = new Location[4];
                    if (iOrientation == 0) {
                        loaHotspot[0] = LocationImpl.create(loStart.getX() - 2.0, loStart.getY());
                        loaHotspot[1] = LocationImpl.create(loStart.getX() + 2.0, loStart.getY());
                        loaHotspot[2] = LocationImpl.create(loEnd.getX() + 2.0, loEnd.getY());
                        loaHotspot[3] = LocationImpl.create(loEnd.getX() - 2.0, loEnd.getY());
                    } else {
                        loaHotspot[0] = LocationImpl.create(loStart.getX(), loStart.getY() - 2.0);
                        loaHotspot[1] = LocationImpl.create(loEnd.getX(), loEnd.getY() - 2.0);
                        loaHotspot[2] = LocationImpl.create(loEnd.getX(), loEnd.getY() + 2.0);
                        loaHotspot[3] = LocationImpl.create(loStart.getX(), loStart.getY() + 2.0);
                    }
                    PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerLine(ml), class$org$eclipse$birt$chart$event$PolygonRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.PolygonRenderEvent") : class$org$eclipse$birt$chart$event$PolygonRenderEvent);
                    pre.setPoints(loaHotspot);
                    iev.setHotSpot(pre);
                    idr.enableInteraction(iev);
                }
                ScriptHandler.callFunction(sh, "afterDrawMarkerLine", ax, ml, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawMarkerLine", ml);
            }
        }
    }

    public final void renderEachAxis(IPrimitiveRenderer ipr, Plot pl, OneAxis ax, int iWhatToDraw) throws ChartException {
        RunTimeContext rtc = this.getRunTimeContext();
        Axis axModel = ax.getModelAxis();
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        Insets insCA = pwa.getAxes().getInsets();
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        double dLocation = ax.getAxisCoordinate();
        AutoScale sc = ax.getScale();
        IntersectionValue iv = ax.getIntersectionValue();
        int iMajorTickStyle = ax.getGrid().getTickStyle(0);
        int iMinorTickStyle = ax.getGrid().getTickStyle(1);
        int iLabelLocation = ax.getLabelPosition();
        int iOrientation = ax.getOrientation();
        IDisplayServer xs = this.getDevice().getDisplayServer();
        Label la = LabelImpl.copyInstance(ax.getLabel());
        double[] daEndPoints = sc.getEndPoints();
        double[] da = sc.getTickCordinates();
        double[] daMinor = sc.getMinorCoordinates(ax.getGrid().getMinorCountPerMajor());
        String sText = null;
        int iDimension = pwa.getDimension();
        double dSeriesThickness = pwa.getSeriesThickness();
        NumberDataElement nde = NumberDataElementImpl.create(0.0);
        FormatSpecifier fs = ax.getModelAxis().getFormatSpecifier();
        double dStaggeredLabelOffset = sc.computeStaggeredAxisLabelOffset(xs, la, iOrientation);
        boolean bAxisLabelStaggered = sc.isAxisLabelStaggered();
        DecimalFormat df = null;
        LineAttributes lia = ax.getLineAttributes();
        LineAttributes liaMajorTick = ax.getGrid().getTickAttributes(0);
        LineAttributes liaMinorTick = ax.getGrid().getTickAttributes(1);
        if (!lia.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.unset.axis.visibility", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bRenderAxisLabels = (iWhatToDraw & 2) == 2 && la.isVisible();
        boolean bRenderAxisTitle = (iWhatToDraw & 2) == 2;
        Location lo = LocationImpl.create(0.0, 0.0);
        TransformationEvent trae = (TransformationEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), TransformationEvent.class);
        TextRenderEvent tre = (TextRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), TextRenderEvent.class);
        tre.setLabel(la);
        tre.setTextPosition(iLabelLocation);
        tre.setLocation(lo);
        LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), LineRenderEvent.class);
        lre.setLineAttributes(lia);
        lre.setStart(LocationImpl.create(0.0, 0.0));
        lre.setEnd(LocationImpl.create(0.0, 0.0));
        boolean bRendering3D = iDimension == 2;
        boolean bRenderOrthogonal3DAxis = (iWhatToDraw & 9) == 9 && bRendering3D;
        boolean bRenderBase3DAxis = (iWhatToDraw & 5) == 5 && bRendering3D;
        boolean bRenderAncillary3DAxis = (iWhatToDraw & 0x11) == 17 && bRendering3D;
        DeferredCache dc = this.getDeferredCache();
        int axisType = ax.getAxisType();
        Location panningOffset = this.getPanningOffset();
        boolean bTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        double[] daEndPoints3D = null;
        double[] da3D = null;
        Location3D lo3d = null;
        Text3DRenderEvent t3dre = null;
        LineRenderEvent l3dre = null;
        double dXStart = 0.0;
        double dXEnd = 0.0;
        double dZStart = 0.0;
        double dZEnd = 0.0;
        if (iDimension == 2) {
            AllAxes aax = pwa.getAxes();
            dXEnd = aax.getPrimaryBase().getScale().getEnd();
            dZEnd = aax.getAncillaryBase().getScale().getEnd();
            dXStart = aax.getPrimaryBase().getScale().getStart();
            dZStart = aax.getAncillaryBase().getScale().getStart();
            daEndPoints3D = sc.getEndPoints();
            da3D = sc.getTickCordinates();
            lo3d = Location3DImpl.create(0.0, 0.0, 0.0);
            t3dre = (Text3DRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), Text3DRenderEvent.class);
            t3dre.setLabel(la);
            t3dre.setAction(2);
            t3dre.setTextPosition(iLabelLocation);
            t3dre.setLocation3D(lo3d);
            l3dre = (Line3DRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), Line3DRenderEvent.class);
            l3dre.setLineAttributes(lia);
            ((Line3DRenderEvent)l3dre).setStart3D(Location3DImpl.create(0.0, 0.0, 0.0));
            ((Line3DRenderEvent)l3dre).setEnd3D(Location3DImpl.create(0.0, 0.0, 0.0));
        }
        if (iOrientation == 1) {
            int iDirection;
            double dXTick2;
            int y3d = 0;
            double dX = dLocation;
            double dZ = 0.0;
            if (bRendering3D) {
                Location3D l3d = ax.getAxisCoordinate3D();
                dX = l3d.getX();
                dZ = l3d.getZ();
            }
            if (iv != null && iv.getType() == 1 && iDimension == 1) {
                trae.setTransform(2);
                trae.setTranslation(dSeriesThickness, -dSeriesThickness);
                ipr.applyTransformation(trae);
            }
            double dXTick1 = (iMajorTickStyle & 1) == 1 ? dX - 5.0 : dX;
            double d = dXTick2 = (iMajorTickStyle & 2) == 2 ? dX + 5.0 : dX;
            if ((iWhatToDraw & 1) == 1 && lia.isVisible()) {
                Trigger tg;
                Location[] loaHotspot;
                EList elTriggers;
                double dEnd;
                double dStart;
                if (bRenderOrthogonal3DAxis) {
                    dStart = daEndPoints3D[0];
                    dEnd = daEndPoints3D[1];
                    l3dre.setLineAttributes(lia);
                    ((Line3DRenderEvent)l3dre).setStart3D(dX, dStart, dZ);
                    ((Line3DRenderEvent)l3dre).setEnd3D(dX, dEnd, dZ);
                    dc.addLine(l3dre);
                    ((Line3DRenderEvent)l3dre).setStart3D(dX, dStart, dZEnd);
                    ((Line3DRenderEvent)l3dre).setEnd3D(dX, dEnd, dZEnd);
                    dc.addLine(l3dre);
                    ((Line3DRenderEvent)l3dre).setStart3D(dXEnd, dStart, dZ);
                    ((Line3DRenderEvent)l3dre).setEnd3D(dXEnd, dEnd, dZ);
                    dc.addLine(l3dre);
                    if (this.isInteractivityEnabled() && !(elTriggers = axModel.getTriggers()).isEmpty()) {
                        int t;
                        InteractionEvent iev;
                        ArrayList<Trigger> cachedTriggers = null;
                        loaHotspot = new Location3D[4];
                        Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), Polygon3DRenderEvent.class);
                        loaHotspot[0] = Location3DImpl.create(dX - 4.0, dStart, dZ + 4.0);
                        loaHotspot[1] = Location3DImpl.create(dX + 4.0, dStart, dZ - 4.0);
                        loaHotspot[2] = Location3DImpl.create(dX + 4.0, dEnd, dZ - 4.0);
                        loaHotspot[3] = Location3DImpl.create(dX - 4.0, dEnd, dZ + 4.0);
                        pre3d.setPoints3D((Location3D[])loaHotspot);
                        pre3d.setDoubleSided(true);
                        if (this.get3DEngine().processEvent(pre3d, panningOffset.getX(), panningOffset.getY()) != null) {
                            iev = (InteractionEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), InteractionEvent.class);
                            cachedTriggers = new ArrayList<Trigger>();
                            for (t = 0; t < elTriggers.size(); ++t) {
                                tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                                this.processTrigger(tg, StructureSource.createAxis(axModel));
                                cachedTriggers.add(tg);
                                iev.addTrigger(TriggerImpl.copyInstance(tg));
                            }
                            iev.setHotSpot(pre3d);
                            ipr.enableInteraction(iev);
                        }
                        pre3d = (Polygon3DRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), Polygon3DRenderEvent.class);
                        loaHotspot = new Location3D[]{Location3DImpl.create(dXStart - 4.0, dStart, dZEnd + 4.0), Location3DImpl.create(dXStart + 4.0, dStart, dZEnd - 4.0), Location3DImpl.create(dXStart + 4.0, dEnd, dZEnd - 4.0), Location3DImpl.create(dXStart - 4.0, dEnd, dZEnd + 4.0)};
                        pre3d.setPoints3D((Location3D[])loaHotspot);
                        pre3d.setDoubleSided(true);
                        if (this.get3DEngine().processEvent(pre3d, panningOffset.getX(), panningOffset.getY()) != null) {
                            iev = (InteractionEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), InteractionEvent.class);
                            if (cachedTriggers == null) {
                                cachedTriggers = new ArrayList();
                                for (t = 0; t < elTriggers.size(); ++t) {
                                    tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                                    this.processTrigger(tg, StructureSource.createAxis(axModel));
                                    cachedTriggers.add(tg);
                                    iev.addTrigger(TriggerImpl.copyInstance(tg));
                                }
                            } else {
                                for (t = 0; t < cachedTriggers.size(); ++t) {
                                    iev.addTrigger(TriggerImpl.copyInstance((Trigger)cachedTriggers.get(t)));
                                }
                            }
                            iev.setHotSpot(pre3d);
                            ipr.enableInteraction(iev);
                        }
                        pre3d = (Polygon3DRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), Polygon3DRenderEvent.class);
                        loaHotspot = new Location3D[]{Location3DImpl.create(dXEnd - 4.0, dStart, dZStart + 4.0), Location3DImpl.create(dXEnd + 4.0, dStart, dZStart - 4.0), Location3DImpl.create(dXEnd + 4.0, dEnd, dZStart - 4.0), Location3DImpl.create(dXEnd - 4.0, dEnd, dZStart + 4.0)};
                        pre3d.setPoints3D((Location3D[])loaHotspot);
                        pre3d.setDoubleSided(true);
                        if (this.get3DEngine().processEvent(pre3d, panningOffset.getX(), panningOffset.getY()) != null) {
                            iev = (InteractionEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), InteractionEvent.class);
                            if (cachedTriggers == null) {
                                for (t = 0; t < elTriggers.size(); ++t) {
                                    tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                                    this.processTrigger(tg, StructureSource.createAxis(axModel));
                                    iev.addTrigger(tg);
                                }
                            } else {
                                for (t = 0; t < cachedTriggers.size(); ++t) {
                                    iev.addTrigger((Trigger)cachedTriggers.get(t));
                                }
                            }
                            iev.setHotSpot(pre3d);
                            ipr.enableInteraction(iev);
                        }
                    }
                } else {
                    dStart = daEndPoints[0] + insCA.getBottom();
                    dEnd = daEndPoints[1] - insCA.getTop();
                    if (sc.getDirection() == 1) {
                        dStart = daEndPoints[1] + insCA.getBottom();
                        dEnd = daEndPoints[0] - insCA.getTop();
                    }
                    if (iv != null && iv.getType() == 3 && iDimension == 1) {
                        Location[] loa = new Location[]{LocationImpl.create(dX, dStart), LocationImpl.create(dX + dSeriesThickness, dStart - dSeriesThickness), LocationImpl.create(dX + dSeriesThickness, dEnd - dSeriesThickness), LocationImpl.create(dX, dEnd)};
                        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), PolygonRenderEvent.class);
                        pre.setPoints(loa);
                        pre.setBackground(ColorDefinitionImpl.create(255, 255, 255, 127));
                        pre.setOutline(lia);
                        ipr.fillPolygon(pre);
                    }
                    lre.setLineAttributes(lia);
                    lre.getStart().set(dX, dStart);
                    lre.getEnd().set(dX, dEnd);
                    ipr.drawLine(lre);
                    if (this.isInteractivityEnabled() && !(elTriggers = axModel.getTriggers()).isEmpty()) {
                        InteractionEvent iev = (InteractionEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), InteractionEvent.class);
                        for (int t = 0; t < elTriggers.size(); ++t) {
                            tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                            this.processTrigger(tg, StructureSource.createAxis(axModel));
                            iev.addTrigger(tg);
                        }
                        loaHotspot = new Location[]{LocationImpl.create(dX - 2.0, dStart), LocationImpl.create(dX + 2.0, dStart), LocationImpl.create(dX + 2.0, dEnd), LocationImpl.create(dX - 2.0, dEnd)};
                        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), PolygonRenderEvent.class);
                        pre.setPoints(loaHotspot);
                        iev.setHotSpot(pre);
                        ipr.enableInteraction(iev);
                    }
                }
            }
            int n = iDirection = sc.getDirection() != 1 ? -1 : 1;
            if ((sc.getType() & 0x10) == 16 || sc.isCategoryScale()) {
                double dUnitSize = (double)iDirection * sc.getUnitSize();
                double dOffset = dUnitSize / 2.0;
                DataSetIterator dsi = sc.getData();
                int iDateTimeUnit = sc.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                ITextMetrics itmText = xs.getTextMetrics(la);
                double x = iLabelLocation == 1 ? dXTick1 - 1.0 : dXTick2 + 1.0;
                dsi.reset();
                for (int i = 0; i < da.length - 1; ++i) {
                    if (bRenderAxisLabels) {
                        la.getCaption().setValue(sc.formatCategoryValue(sc.getType(), dsi.next(), iDateTimeUnit));
                        if (sc.isTickLabelVisible(i)) {
                            ScriptHandler.callFunction(sh, "beforeDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                            this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", la);
                            itmText.reuse(la);
                        }
                    }
                    int y = (int)da[i];
                    if (bRendering3D) {
                        y3d = (int)da3D[i];
                    }
                    if ((iWhatToDraw & 1) == 1) {
                        double dXMinorTick2;
                        double dXMinorTick1 = (iMinorTickStyle & 1) == 1 ? dX - 5.0 : dX;
                        double d2 = dXMinorTick2 = (iMinorTickStyle & 2) == 2 ? dX + 5.0 : dX;
                        if (dXMinorTick1 != dXMinorTick2 && i != da.length - 1 && !bRenderOrthogonal3DAxis) {
                            LineRenderEvent lreMinor = null;
                            for (int k = 0; k < daMinor.length - 1; ++k) {
                                lreMinor = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                                lreMinor.setLineAttributes(liaMinorTick);
                                lreMinor.setStart(LocationImpl.create(dXMinorTick1, (double)y + (double)iDirection * daMinor[k]));
                                lreMinor.setEnd(LocationImpl.create(dXMinorTick2, (double)y + (double)iDirection * daMinor[k]));
                                ipr.drawLine(lreMinor);
                            }
                        }
                        if (dXTick1 != dXTick2) {
                            if (!bRenderOrthogonal3DAxis) {
                                lre.setLineAttributes(liaMajorTick);
                                lre.getStart().set(dXTick1, y);
                                lre.getEnd().set(dXTick2, y);
                                ipr.drawLine(lre);
                            }
                            if (iv != null && iDimension == 1 && iv.getType() == 3) {
                                lre.setStart(LocationImpl.create(dX, y));
                                lre.setEnd(LocationImpl.create(dX + dSeriesThickness, (double)y - dSeriesThickness));
                                ipr.drawLine(lre);
                            }
                        }
                    }
                    if (!bRenderAxisLabels || !sc.isTickLabelVisible(i)) continue;
                    double sx = x;
                    double sx2 = dXEnd;
                    if (bAxisLabelStaggered && sc.isTickLabelStaggered(i)) {
                        if (iLabelLocation == 1) {
                            sx -= dStaggeredLabelOffset;
                            sx2 += dStaggeredLabelOffset;
                        } else {
                            sx += dStaggeredLabelOffset;
                            sx2 -= dStaggeredLabelOffset;
                        }
                    }
                    if (ax.getLabel().isVisible() && la.isVisible()) {
                        if (bRendering3D) {
                            lo3d.set(sx - pwa.getHorizontalSpacingInPixels(), (double)y3d + dOffset, dZEnd + pwa.getHorizontalSpacingInPixels());
                            t3dre.setLocation3D(lo3d);
                            t3dre.setTextPosition(1);
                            t3dre.setAction(2);
                            dc.addLabel(t3dre);
                            lo3d.set(sx2 + pwa.getHorizontalSpacingInPixels(), (double)y3d + dOffset, dZ - pwa.getHorizontalSpacingInPixels());
                            t3dre.setLocation3D(lo3d);
                            t3dre.setTextPosition(2);
                            t3dre.setAction(2);
                            dc.addLabel(t3dre);
                        } else {
                            lo.set(sx, (double)y + dOffset);
                            tre.setAction(2);
                            ipr.drawText(tre);
                        }
                    }
                    ScriptHandler.callFunction(sh, "afterDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", la);
                }
                int y = (int)da[da.length - 1];
                if (bRendering3D) {
                    y3d = (int)da3D[da3D.length - 1];
                }
                if (dXTick1 != dXTick2) {
                    if (!bRenderOrthogonal3DAxis) {
                        lre.setLineAttributes(liaMajorTick);
                        lre.getStart().set(dXTick1, y);
                        lre.getEnd().set(dXTick2, y);
                        ipr.drawLine(lre);
                    }
                    if (iv != null && iDimension == 1 && iv.getType() == 3) {
                        lre.setStart(LocationImpl.create(dX, y));
                        lre.setEnd(LocationImpl.create(dX + dSeriesThickness, (double)y - dSeriesThickness));
                        ipr.drawLine(lre);
                    }
                }
                itmText.dispose();
            } else if ((sc.getType() & 2) == 2) {
                double dAxisValue = Methods.asDouble(sc.getMinimum());
                double dAxisStep = Methods.asDouble(sc.getStep());
                if (fs == null) {
                    df = new DecimalFormat(sc.getNumericPattern());
                }
                dAxisValue = Methods.asDouble(sc.getMinimum());
                double x = iLabelLocation == 1 ? dXTick1 - 1.0 : dXTick2 + 1.0;
                for (int i = 0; i < da.length; ++i) {
                    nde.setValue(dAxisValue);
                    try {
                        sText = ValueFormatter.format(nde, fs, ax.getRunTimeContext().getULocale(), df);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    int y = (int)da[i];
                    if (bRendering3D) {
                        y3d = (int)da3D[i];
                    }
                    if ((iWhatToDraw & 1) == 1) {
                        double dXMinorTick2;
                        double dXMinorTick1 = (iMinorTickStyle & 1) == 1 ? dX - 5.0 : dX;
                        double d3 = dXMinorTick2 = (iMinorTickStyle & 2) == 2 ? dX + 5.0 : dX;
                        if (dXMinorTick1 != dXMinorTick2 && i != da.length - 1 && !bRenderOrthogonal3DAxis) {
                            LineRenderEvent lreMinor = null;
                            for (int k = 0; k < daMinor.length - 1; ++k) {
                                if (iDirection == -1 && (double)y - daMinor[k] <= da[i + 1] || iDirection == 1 && (double)y + daMinor[k] >= da[i + 1]) continue;
                                lreMinor = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                                lreMinor.setLineAttributes(liaMinorTick);
                                lreMinor.setStart(LocationImpl.create(dXMinorTick1, (double)y + (double)iDirection * daMinor[k]));
                                lreMinor.setEnd(LocationImpl.create(dXMinorTick2, (double)y + (double)iDirection * daMinor[k]));
                                ipr.drawLine(lreMinor);
                            }
                        }
                        if (dXTick1 != dXTick2) {
                            if (!bRenderOrthogonal3DAxis) {
                                lre.setLineAttributes(liaMajorTick);
                                lre.getStart().set(dXTick1, y);
                                lre.getEnd().set(dXTick2, y);
                                ipr.drawLine(lre);
                            }
                            if (iv != null && iDimension == 1 && iv.getType() == 3) {
                                lre.setLineAttributes(lia);
                                lre.setStart(LocationImpl.create(dX, y));
                                lre.setEnd(LocationImpl.create(dX + dSeriesThickness, (double)y - dSeriesThickness));
                                ipr.drawLine(lre);
                            }
                        }
                    }
                    if (bRenderAxisLabels && sc.isTickLabelVisible(i)) {
                        double sx = x;
                        double sx2 = dXEnd;
                        if (bAxisLabelStaggered && sc.isTickLabelStaggered(i)) {
                            if (iLabelLocation == 1) {
                                sx -= dStaggeredLabelOffset;
                                sx2 += dStaggeredLabelOffset;
                            } else {
                                sx += dStaggeredLabelOffset;
                                sx2 -= dStaggeredLabelOffset;
                            }
                        }
                        ScriptHandler.callFunction(sh, "beforeDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", la);
                        if (ax.getLabel().isVisible() && la.isVisible()) {
                            if (bRendering3D) {
                                lo3d.set(sx - pwa.getHorizontalSpacingInPixels(), y3d, dZEnd + pwa.getHorizontalSpacingInPixels());
                                t3dre.setLocation3D(lo3d);
                                t3dre.setTextPosition(1);
                                t3dre.setAction(2);
                                dc.addLabel(t3dre);
                                lo3d.set(sx2 + pwa.getHorizontalSpacingInPixels(), y3d, dZ - pwa.getHorizontalSpacingInPixels());
                                la.getCaption().setValue(sText);
                                t3dre.setLocation3D(lo3d);
                                t3dre.setTextPosition(2);
                                t3dre.setAction(2);
                                dc.addLabel(t3dre);
                            } else {
                                lo.set(sx, y);
                                tre.setAction(2);
                                ipr.drawText(tre);
                            }
                        }
                        ScriptHandler.callFunction(sh, "afterDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", la);
                    }
                    if (i == da.length - 2) {
                        dAxisValue = Methods.asDouble(sc.getMaximum());
                        continue;
                    }
                    dAxisValue += dAxisStep;
                }
            } else if ((sc.getType() & 4) == 4) {
                double dAxisValue = Methods.asDouble(sc.getMinimum());
                double dAxisStep = Methods.asDouble(sc.getStep());
                dAxisValue = Methods.asDouble(sc.getMinimum());
                double x = iLabelLocation == 1 ? dXTick1 - 1.0 : dXTick2 + 1.0;
                for (int i = 0; i < da.length; ++i) {
                    if (bRenderAxisLabels) {
                        if (fs == null) {
                            df = new DecimalFormat(sc.getNumericPattern(dAxisValue));
                        }
                        nde.setValue(dAxisValue);
                        try {
                            sText = ValueFormatter.format(nde, fs, ax.getRunTimeContext().getULocale(), df);
                        }
                        catch (ChartException dfex) {
                            logger.log((Exception)((Object)dfex));
                            sText = IConstants.NULL_STRING;
                        }
                        la.getCaption().setValue(sText);
                    }
                    int y = (int)da[i];
                    if (bRendering3D) {
                        y3d = (int)da3D[i];
                    }
                    if ((iWhatToDraw & 1) == 1) {
                        double dXMinorTick2;
                        double dXMinorTick1 = (iMinorTickStyle & 1) == 1 ? dX - 5.0 : dX;
                        double d4 = dXMinorTick2 = (iMinorTickStyle & 2) == 2 ? dX + 5.0 : dX;
                        if (dXMinorTick1 != dXMinorTick2 && i != da.length - 1 && !bRenderOrthogonal3DAxis) {
                            LineRenderEvent lreMinor = null;
                            for (int k = 0; k < daMinor.length - 1; ++k) {
                                lreMinor = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                                lreMinor.setLineAttributes(liaMinorTick);
                                lreMinor.setStart(LocationImpl.create(dXMinorTick1, (double)y + (double)iDirection * daMinor[k]));
                                lreMinor.setEnd(LocationImpl.create(dXMinorTick2, (double)y + (double)iDirection * daMinor[k]));
                                ipr.drawLine(lreMinor);
                            }
                        }
                        if (dXTick1 != dXTick2) {
                            if (!bRenderOrthogonal3DAxis) {
                                lre.setLineAttributes(liaMajorTick);
                                lre.getStart().set(dXTick1, y);
                                lre.getEnd().set(dXTick2, y);
                                ipr.drawLine(lre);
                            }
                            if (iv != null && iDimension == 1 && iv.getType() == 3) {
                                lre.setLineAttributes(lia);
                                lre.setStart(LocationImpl.create(dX, y));
                                lre.setEnd(LocationImpl.create(dX + dSeriesThickness, (double)y - dSeriesThickness));
                                ipr.drawLine(lre);
                            }
                        }
                    }
                    if (bRenderAxisLabels && sc.isTickLabelVisible(i)) {
                        double sx = x;
                        double sx2 = dXEnd;
                        if (bAxisLabelStaggered && sc.isTickLabelStaggered(i)) {
                            if (iLabelLocation == 1) {
                                sx -= dStaggeredLabelOffset;
                                sx2 += dStaggeredLabelOffset;
                            } else {
                                sx += dStaggeredLabelOffset;
                                sx2 -= dStaggeredLabelOffset;
                            }
                        }
                        ScriptHandler.callFunction(sh, "beforeDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", la);
                        if (ax.getLabel().isVisible() && la.isVisible()) {
                            if (bRendering3D) {
                                lo3d.set(sx - pwa.getHorizontalSpacingInPixels(), y3d, dZEnd + pwa.getHorizontalSpacingInPixels());
                                la.getCaption().setValue(sText);
                                t3dre.setLocation3D(lo3d);
                                t3dre.setTextPosition(1);
                                t3dre.setAction(2);
                                dc.addLabel(t3dre);
                                lo3d.set(sx2 + pwa.getHorizontalSpacingInPixels(), y3d, dZ - pwa.getHorizontalSpacingInPixels());
                                t3dre.setLocation3D(lo3d);
                                t3dre.setTextPosition(2);
                                t3dre.setAction(2);
                                dc.addLabel(t3dre);
                            } else {
                                lo.set(sx, y);
                                tre.setAction(2);
                                ipr.drawText(tre);
                            }
                        }
                        ScriptHandler.callFunction(sh, "afterDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", la);
                    }
                    dAxisValue *= dAxisStep;
                }
            } else if ((sc.getType() & 8) == 8) {
                CDateTime cdtAxisValue = Methods.asDateTime(sc.getMinimum());
                int iUnit = Methods.asInteger(sc.getUnit());
                int iStep = Methods.asInteger(sc.getStep());
                IDateFormatWrapper sdf = null;
                if (fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, rtc.getULocale());
                }
                CDateTime cdt = cdtAxisValue;
                double x = iLabelLocation == 1 ? dXTick1 - 1.0 : dXTick2 + 1.0;
                for (int i = 0; i < da.length; ++i) {
                    try {
                        sText = ValueFormatter.format((Object)cdt, ax.getFormatSpecifier(), ax.getRunTimeContext().getULocale(), sdf);
                    }
                    catch (ChartException dfex) {
                        logger.log((Exception)((Object)dfex));
                        sText = IConstants.NULL_STRING;
                    }
                    la.getCaption().setValue(sText);
                    int y = (int)da[i];
                    if (bRendering3D) {
                        y3d = (int)da3D[i];
                    }
                    if ((iWhatToDraw & 1) == 1) {
                        double dXMinorTick2;
                        double dXMinorTick1 = (iMinorTickStyle & 1) == 1 ? dX - 5.0 : dX;
                        double d5 = dXMinorTick2 = (iMinorTickStyle & 2) == 2 ? dX + 5.0 : dX;
                        if (dXMinorTick1 != dXMinorTick2 && i != da.length - 1 && !bRenderOrthogonal3DAxis) {
                            LineRenderEvent lreMinor = null;
                            for (int k = 0; k < daMinor.length - 1; ++k) {
                                lreMinor = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                                lreMinor.setLineAttributes(liaMinorTick);
                                lreMinor.setStart(LocationImpl.create(dXMinorTick1, (double)y + (double)iDirection * daMinor[k]));
                                lreMinor.setEnd(LocationImpl.create(dXMinorTick2, (double)y + (double)iDirection * daMinor[k]));
                                ipr.drawLine(lreMinor);
                            }
                        }
                        if (dXTick1 != dXTick2) {
                            if (!bRenderOrthogonal3DAxis) {
                                lre.setLineAttributes(liaMajorTick);
                                lre.getStart().set(dXTick1, y);
                                lre.getEnd().set(dXTick2, y);
                                ipr.drawLine(lre);
                            }
                            if (iv != null && iDimension == 1 && iv.getType() == 3) {
                                lre.setStart(LocationImpl.create(dX, y));
                                lre.setEnd(LocationImpl.create(dX + dSeriesThickness, (double)y - dSeriesThickness));
                                ipr.drawLine(lre);
                            }
                        }
                    }
                    if (bRenderAxisLabels && sc.isTickLabelVisible(i)) {
                        double sx = x;
                        double sx2 = dXEnd;
                        if (bAxisLabelStaggered && sc.isTickLabelStaggered(i)) {
                            if (iLabelLocation == 1) {
                                sx -= dStaggeredLabelOffset;
                                sx2 += dStaggeredLabelOffset;
                            } else {
                                sx += dStaggeredLabelOffset;
                                sx2 -= dStaggeredLabelOffset;
                            }
                        }
                        ScriptHandler.callFunction(sh, "beforeDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", la);
                        if (ax.getLabel().isVisible() && la.isVisible()) {
                            if (bRendering3D) {
                                lo3d.set(sx - pwa.getHorizontalSpacingInPixels(), y3d, dZEnd + pwa.getHorizontalSpacingInPixels());
                                t3dre.setLocation3D(lo3d);
                                t3dre.setTextPosition(1);
                                t3dre.setAction(2);
                                dc.addLabel(t3dre);
                                lo3d.set(sx2 + pwa.getHorizontalSpacingInPixels(), y3d, dZ - pwa.getHorizontalSpacingInPixels());
                                la.getCaption().setValue(sText);
                                t3dre.setLocation3D(lo3d);
                                t3dre.setTextPosition(2);
                                t3dre.setAction(2);
                                dc.addLabel(t3dre);
                            } else {
                                lo.set(sx, y);
                                tre.setAction(2);
                                ipr.drawText(tre);
                            }
                        }
                        ScriptHandler.callFunction(sh, "afterDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", la);
                    }
                    cdt = cdtAxisValue.forward(iUnit, iStep * (i + 1));
                }
            }
            la = LabelImpl.copyInstance(ax.getTitle());
            if (la.isVisible() && bRenderAxisTitle) {
                ScriptHandler.callFunction(sh, "beforeDrawAxisTitle", axModel, la, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawAxisTitle", la);
                String sRestoreValue = la.getCaption().getValue();
                la.getCaption().setValue(rtc.externalizedMessage(sRestoreValue));
                BoundingBox bb = null;
                try {
                    bb = Methods.computeBox(xs, ax.getTitlePosition(), la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                }
                if (ax.getTitle().isVisible() && la.isVisible()) {
                    if (bRendering3D) {
                        Bounds cbo = this.getPlotBounds();
                        tre.setBlockBounds(BoundsImpl.create(cbo.getLeft() + (cbo.getWidth() / 3.0 - bb.getWidth()) / 2.0, cbo.getTop() + 30.0, bb.getWidth(), bb.getHeight()));
                        tre.setLabel(la);
                        tre.setBlockAlignment(la.getCaption().getFont().getAlignment());
                        tre.setAction(3);
                        ipr.drawText(tre);
                        tre.setBlockBounds(BoundsImpl.create(cbo.getLeft() + cbo.getWidth() - bb.getWidth(), cbo.getTop() + 60.0, bb.getWidth(), bb.getHeight()));
                        ipr.drawText(tre);
                    } else {
                        Bounds bo = BoundsImpl.create(ax.getTitleCoordinate(), daEndPoints[1], bb.getWidth(), daEndPoints[0] - daEndPoints[1]);
                        tre.setBlockBounds(bo);
                        tre.setLabel(la);
                        tre.setBlockAlignment(la.getCaption().getFont().getAlignment());
                        tre.setAction(3);
                        if (ax.getTitle().isVisible()) {
                            ipr.drawText(tre);
                        }
                    }
                }
                la.getCaption().setValue(sRestoreValue);
                ScriptHandler.callFunction(sh, "afterDrawAxisTitle", axModel, la, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawAxisTitle", la);
            }
            la = LabelImpl.copyInstance(ax.getLabel());
            if (iv != null && iv.getType() == 1 && iDimension == 1) {
                trae.setTranslation(-dSeriesThickness, dSeriesThickness);
                ipr.applyTransformation(trae);
            }
        } else if (iOrientation == 0) {
            int iDirection;
            double dYTick2;
            double dYTick1;
            int x3d = 0;
            int z3d = 0;
            double dY = dLocation;
            double dX = 0.0;
            double dZ = 0.0;
            if (bRendering3D) {
                Location3D l3d = ax.getAxisCoordinate3D();
                dX = l3d.getX();
                dY = l3d.getY();
                dZ = l3d.getZ();
            }
            double d = (iMajorTickStyle & 1) == 1 ? (bRendering3D ? dY + 5.0 : dY - 5.0) : (dYTick1 = dY);
            double d6 = (iMajorTickStyle & 2) == 2 ? (bRendering3D ? dY - 5.0 : dY + 5.0) : (dYTick2 = dY);
            if (iv != null && iDimension == 1 && (bTransposed && this.isRightToLeft() && iv.getType() == 2 || !this.isRightToLeft() && iv.getType() == 1)) {
                trae.setTransform(2);
                trae.setTranslation(dSeriesThickness, -dSeriesThickness);
                ipr.applyTransformation(trae);
            }
            if ((iWhatToDraw & 1) == 1 && lia.isVisible()) {
                Trigger tg;
                int t;
                InteractionEvent iev;
                Location[] loaHotspot;
                Polygon3DRenderEvent pre3d;
                EList elTriggers;
                double dEnd;
                double dStart;
                if (bRenderBase3DAxis) {
                    dStart = daEndPoints3D[0];
                    dEnd = daEndPoints3D[1];
                    l3dre.setLineAttributes(lia);
                    ((Line3DRenderEvent)l3dre).setStart3D(dStart, dY, dZ);
                    ((Line3DRenderEvent)l3dre).setEnd3D(dEnd, dY, dZ);
                    dc.addLine(l3dre);
                    if (this.isInteractivityEnabled() && !(elTriggers = axModel.getTriggers()).isEmpty()) {
                        pre3d = (Polygon3DRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), Polygon3DRenderEvent.class);
                        loaHotspot = new Location3D[]{Location3DImpl.create(dStart, dY - 4.0, dZ), Location3DImpl.create(dStart, dY + 4.0, dZ), Location3DImpl.create(dEnd, dY + 4.0, dZ), Location3DImpl.create(dEnd, dY - 4.0, dZ)};
                        pre3d.setPoints3D((Location3D[])loaHotspot);
                        pre3d.setDoubleSided(true);
                        if (this.get3DEngine().processEvent(pre3d, panningOffset.getX(), panningOffset.getY()) != null) {
                            iev = (InteractionEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), InteractionEvent.class);
                            for (t = 0; t < elTriggers.size(); ++t) {
                                tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                                this.processTrigger(tg, StructureSource.createAxis(axModel));
                                iev.addTrigger(tg);
                            }
                            iev.setHotSpot(pre3d);
                            ipr.enableInteraction(iev);
                        }
                    }
                } else if (bRenderAncillary3DAxis) {
                    dStart = daEndPoints3D[0];
                    dEnd = daEndPoints3D[1];
                    l3dre.setLineAttributes(lia);
                    ((Line3DRenderEvent)l3dre).setStart3D(dX, dY, dStart);
                    ((Line3DRenderEvent)l3dre).setEnd3D(dX, dY, dEnd);
                    dc.addLine(l3dre);
                    if (this.isInteractivityEnabled() && !(elTriggers = axModel.getTriggers()).isEmpty()) {
                        pre3d = (Polygon3DRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), Polygon3DRenderEvent.class);
                        loaHotspot = new Location3D[]{Location3DImpl.create(dX, dY - 4.0, dStart), Location3DImpl.create(dX, dY + 4.0, dStart), Location3DImpl.create(dX, dY + 4.0, dEnd), Location3DImpl.create(dX, dY - 4.0, dEnd)};
                        pre3d.setPoints3D((Location3D[])loaHotspot);
                        pre3d.setDoubleSided(true);
                        if (this.get3DEngine().processEvent(pre3d, panningOffset.getX(), panningOffset.getY()) != null) {
                            iev = (InteractionEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), InteractionEvent.class);
                            for (t = 0; t < elTriggers.size(); ++t) {
                                tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                                this.processTrigger(tg, StructureSource.createAxis(axModel));
                                iev.addTrigger(tg);
                            }
                            iev.setHotSpot(pre3d);
                            ipr.enableInteraction(iev);
                        }
                    }
                } else {
                    dStart = daEndPoints[0] - insCA.getLeft();
                    dEnd = daEndPoints[1] + insCA.getRight();
                    if (sc.getDirection() == -1) {
                        dStart = daEndPoints[1] - insCA.getLeft();
                        dEnd = daEndPoints[0] + insCA.getRight();
                    }
                    if (iv != null && iv.getType() == 3 && iDimension == 1) {
                        Location[] loa = new Location[]{LocationImpl.create(dStart, dY), LocationImpl.create(dStart + dSeriesThickness, dY - dSeriesThickness), LocationImpl.create(dEnd + dSeriesThickness, dY - dSeriesThickness), LocationImpl.create(dEnd, dY)};
                        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), PolygonRenderEvent.class);
                        pre.setPoints(loa);
                        pre.setBackground(ColorDefinitionImpl.create(255, 255, 255, 127));
                        pre.setOutline(lia);
                        ipr.fillPolygon(pre);
                    }
                    lre.setLineAttributes(lia);
                    lre.getStart().set(dStart, dY);
                    lre.getEnd().set(dEnd, dY);
                    ipr.drawLine(lre);
                    if (this.isInteractivityEnabled() && !(elTriggers = axModel.getTriggers()).isEmpty()) {
                        InteractionEvent iev2 = (InteractionEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), InteractionEvent.class);
                        for (int t2 = 0; t2 < elTriggers.size(); ++t2) {
                            tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t2));
                            this.processTrigger(tg, StructureSource.createAxis(axModel));
                            iev2.addTrigger(tg);
                        }
                        loaHotspot = new Location[]{LocationImpl.create(dStart, dY - 2.0), LocationImpl.create(dEnd, dY - 2.0), LocationImpl.create(dEnd, dY + 2.0), LocationImpl.create(dStart, dY + 2.0)};
                        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), PolygonRenderEvent.class);
                        pre.setPoints(loaHotspot);
                        iev2.setHotSpot(pre);
                        ipr.enableInteraction(iev2);
                    }
                }
            }
            int n = iDirection = sc.getDirection() == -1 ? -1 : 1;
            if ((sc.getType() & 0x10) == 16 || sc.isCategoryScale()) {
                double dUnitSize = (double)iDirection * sc.getUnitSize();
                double dOffset = dUnitSize / 2.0;
                DataSetIterator dsi = sc.getData();
                int iDateTimeUnit = sc.getType() == 8 ? CDateTime.computeUnit(dsi) : 0;
                ITextMetrics itmText = xs.getTextMetrics(la);
                double y = iLabelLocation == 3 ? (bRendering3D ? dYTick1 + 1.0 : dYTick1 - 1.0) : (bRendering3D ? dYTick2 - 1.0 : dYTick2 + 1.0);
                dsi.reset();
                for (int i = 0; i < da.length - 1; ++i) {
                    int x = (int)da[i];
                    if (bRendering3D) {
                        x3d = (int)da3D[i];
                        z3d = (int)da3D[i];
                    }
                    if ((iWhatToDraw & 1) == 1) {
                        double dYMinorTick2;
                        double dYMinorTick1;
                        double d7 = (iMinorTickStyle & 1) == 1 ? (bRendering3D ? dY + 5.0 : dY - 5.0) : (dYMinorTick1 = dY);
                        double d8 = (iMinorTickStyle & 2) == 2 ? (bRendering3D ? dY - 5.0 : dY + 5.0) : (dYMinorTick2 = dY);
                        if (dYMinorTick1 != -dYMinorTick2 && i != da.length - 1 && !bRenderBase3DAxis && !bRenderAncillary3DAxis) {
                            LineRenderEvent lreMinor = null;
                            for (int k = 0; k < daMinor.length - 1; ++k) {
                                lreMinor = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                                lreMinor.setLineAttributes(liaMinorTick);
                                lreMinor.setStart(LocationImpl.create((double)x + (double)iDirection * daMinor[k], dYMinorTick1));
                                lreMinor.setEnd(LocationImpl.create((double)x + (double)iDirection * daMinor[k], dYMinorTick2));
                                ipr.drawLine(lreMinor);
                            }
                        }
                        if (dYTick1 != dYTick2) {
                            if (!bRenderBase3DAxis && !bRenderAncillary3DAxis) {
                                lre.setLineAttributes(liaMajorTick);
                                lre.getStart().set(x, dYTick1);
                                lre.getEnd().set(x, dYTick2);
                                ipr.drawLine(lre);
                            }
                            if (iv != null && iDimension == 1 && iv.getType() == 3) {
                                lre.getStart().set(x, dY);
                                lre.getEnd().set((double)x + dSeriesThickness, dY - dSeriesThickness);
                                ipr.drawLine(lre);
                            }
                        }
                    }
                    if (!bRenderAxisLabels) continue;
                    la.getCaption().setValue(sc.formatCategoryValue(sc.getType(), dsi.next(), iDateTimeUnit));
                    if (!sc.isTickLabelVisible(i)) continue;
                    ScriptHandler.callFunction(sh, "beforeDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", la);
                    itmText.reuse(la);
                    double sy = y;
                    if (bAxisLabelStaggered && sc.isTickLabelStaggered(i)) {
                        sy = iLabelLocation == 3 ? (sy -= dStaggeredLabelOffset) : (sy += dStaggeredLabelOffset);
                    }
                    if (ax.getLabel().isVisible() && la.isVisible()) {
                        if (bRendering3D) {
                            if (axisType == 5) {
                                lo3d.set((double)x3d + dOffset, sy - pwa.getVerticalSpacingInPixels(), dZEnd + pwa.getVerticalSpacingInPixels());
                            } else {
                                lo3d.set(dXEnd + pwa.getVerticalSpacingInPixels(), sy - pwa.getVerticalSpacingInPixels(), (double)z3d + dOffset);
                            }
                            t3dre.setLocation3D(lo3d);
                            t3dre.setAction(2);
                            dc.addLabel(t3dre);
                        } else {
                            lo.set((double)x + dOffset, sy);
                            tre.setAction(2);
                            ipr.drawText(tre);
                        }
                    }
                    ScriptHandler.callFunction(sh, "afterDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", la);
                }
                int x = (int)da[da.length - 1];
                if ((iWhatToDraw & 1) == 1 && dYTick1 != dYTick2) {
                    if (!bRenderBase3DAxis && !bRenderAncillary3DAxis) {
                        lre.setLineAttributes(liaMajorTick);
                        lre.getStart().set(x, dYTick1);
                        lre.getEnd().set(x, dYTick2);
                        ipr.drawLine(lre);
                    }
                    if (iv != null && iDimension == 1 && iv.getType() == 3) {
                        lre.getStart().set(x, dY);
                        lre.getEnd().set((double)x + dSeriesThickness, dY - dSeriesThickness);
                        ipr.drawLine(lre);
                    }
                }
                itmText.dispose();
            } else if ((sc.getType() & 2) == 2) {
                double dAxisValue = Methods.asDouble(sc.getMinimum());
                double dAxisStep = Methods.asDouble(sc.getStep());
                if (fs == null) {
                    df = new DecimalFormat(sc.getNumericPattern());
                }
                dAxisValue = Methods.asDouble(sc.getMinimum());
                double y = iLabelLocation == 3 ? (bRendering3D ? dYTick1 + 1.0 : dYTick1 - 1.0) : (bRendering3D ? dYTick2 - 1.0 : dYTick2 + 1.0);
                for (int i = 0; i < da.length; ++i) {
                    int x = (int)da[i];
                    if (bRendering3D) {
                        x3d = (int)da3D[i];
                        z3d = (int)da3D[i];
                    }
                    if ((iWhatToDraw & 1) == 1) {
                        double dYMinorTick2;
                        double dYMinorTick1;
                        double d9 = (iMinorTickStyle & 1) == 1 ? (bRendering3D ? dY + 5.0 : dY - 5.0) : (dYMinorTick1 = dY);
                        double d10 = (iMinorTickStyle & 2) == 2 ? (bRendering3D ? dY - 5.0 : dY + 5.0) : (dYMinorTick2 = dY);
                        if (dYMinorTick1 != -dYMinorTick2 && i != da.length - 1 && !bRenderBase3DAxis && !bRenderAncillary3DAxis) {
                            LineRenderEvent lreMinor = null;
                            for (int k = 0; k < daMinor.length - 1; ++k) {
                                if (iDirection == 1 && (double)x + daMinor[k] >= da[i + 1] || iDirection == -1 && (double)x - daMinor[k] <= da[i + 1]) continue;
                                lreMinor = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                                lreMinor.setLineAttributes(liaMinorTick);
                                lreMinor.setStart(LocationImpl.create((double)x + (double)iDirection * daMinor[k], dYMinorTick1));
                                lreMinor.setEnd(LocationImpl.create((double)x + (double)iDirection * daMinor[k], dYMinorTick2));
                                ipr.drawLine(lreMinor);
                            }
                        }
                        if (dYTick1 != dYTick2) {
                            if (!bRenderBase3DAxis && !bRenderAncillary3DAxis) {
                                lre.setLineAttributes(liaMajorTick);
                                lre.getStart().set(x, dYTick1);
                                lre.getEnd().set(x, dYTick2);
                                ipr.drawLine(lre);
                            }
                            if (iv != null && iDimension == 1 && iv.getType() == 3) {
                                lre.getStart().set(x, dY);
                                lre.getEnd().set((double)x + dSeriesThickness, dY - dSeriesThickness);
                                ipr.drawLine(lre);
                            }
                        }
                    }
                    if (bRenderAxisLabels && sc.isTickLabelVisible(i)) {
                        nde.setValue(dAxisValue);
                        try {
                            sText = ValueFormatter.format(nde, ax.getFormatSpecifier(), ax.getRunTimeContext().getULocale(), df);
                        }
                        catch (ChartException dfex) {
                            logger.log((Exception)((Object)dfex));
                            sText = IConstants.NULL_STRING;
                        }
                        la.getCaption().setValue(sText);
                        ScriptHandler.callFunction(sh, "beforeDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", la);
                        double sy = y;
                        if (bAxisLabelStaggered && sc.isTickLabelStaggered(i)) {
                            sy = iLabelLocation == 3 ? (sy -= dStaggeredLabelOffset) : (sy += dStaggeredLabelOffset);
                        }
                        if (ax.getLabel().isVisible() && la.isVisible()) {
                            if (bRendering3D) {
                                if (axisType == 5) {
                                    lo3d.set(x3d, sy - pwa.getVerticalSpacingInPixels(), dZEnd + pwa.getVerticalSpacingInPixels());
                                } else {
                                    lo3d.set(dXEnd + pwa.getVerticalSpacingInPixels(), sy - pwa.getVerticalSpacingInPixels(), z3d);
                                }
                                t3dre.setLocation3D(lo3d);
                                t3dre.setAction(2);
                                dc.addLabel(t3dre);
                            } else {
                                lo.set(x, sy);
                                tre.setAction(2);
                                ipr.drawText(tre);
                            }
                        }
                        ScriptHandler.callFunction(sh, "afterDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", la);
                    }
                    if (i == da.length - 2) {
                        dAxisValue = Methods.asDouble(sc.getMaximum());
                        continue;
                    }
                    dAxisValue += dAxisStep;
                }
            } else if ((sc.getType() & 4) == 4) {
                double dAxisValue = Methods.asDouble(sc.getMinimum());
                double dAxisStep = Methods.asDouble(sc.getStep());
                dAxisValue = Methods.asDouble(sc.getMinimum());
                double y = iLabelLocation == 3 ? (bRendering3D ? dYTick1 + 1.0 : dYTick1 - 1.0) : (bRendering3D ? dYTick2 - 1.0 : dYTick2 + 1.0);
                for (int i = 0; i < da.length; ++i) {
                    int x = (int)da[i];
                    if (bRendering3D) {
                        x3d = (int)da3D[i];
                        z3d = (int)da3D[i];
                    }
                    if ((iWhatToDraw & 1) == 1) {
                        double dYMinorTick2;
                        double dYMinorTick1;
                        double d11 = (iMinorTickStyle & 1) == 1 ? (bRendering3D ? dY + 5.0 : dY - 5.0) : (dYMinorTick1 = dY);
                        double d12 = (iMinorTickStyle & 2) == 2 ? (bRendering3D ? dY - 5.0 : dY + 5.0) : (dYMinorTick2 = dY);
                        if (dYMinorTick1 != -dYMinorTick2 && i != da.length - 1 && !bRenderBase3DAxis && !bRenderAncillary3DAxis) {
                            LineRenderEvent lreMinor = null;
                            for (int k = 0; k < daMinor.length - 1; ++k) {
                                lreMinor = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                                lreMinor.setLineAttributes(liaMinorTick);
                                lreMinor.setStart(LocationImpl.create((double)x + (double)iDirection * daMinor[k], dYMinorTick1));
                                lreMinor.setEnd(LocationImpl.create((double)x + (double)iDirection * daMinor[k], dYMinorTick2));
                                ipr.drawLine(lreMinor);
                            }
                        }
                        if (dYTick1 != dYTick2) {
                            if (!bRenderBase3DAxis && !bRenderAncillary3DAxis) {
                                lre.setLineAttributes(lia);
                                lre.getStart().set(x, dYTick1);
                                lre.getEnd().set(x, dYTick2);
                                ipr.drawLine(lre);
                            }
                            if (iv != null && iDimension == 1 && iv.getType() == 3) {
                                lre.getStart().set(x, dY);
                                lre.getEnd().set((double)x + dSeriesThickness, dY - dSeriesThickness);
                                ipr.drawLine(lre);
                            }
                        }
                    }
                    if (bRenderAxisLabels && sc.isTickLabelVisible(i)) {
                        if (fs == null) {
                            df = new DecimalFormat(sc.getNumericPattern(dAxisValue));
                        }
                        nde.setValue(dAxisValue);
                        try {
                            sText = ValueFormatter.format(nde, ax.getFormatSpecifier(), ax.getRunTimeContext().getULocale(), df);
                        }
                        catch (ChartException dfex) {
                            logger.log((Exception)((Object)dfex));
                            sText = IConstants.NULL_STRING;
                        }
                        la.getCaption().setValue(sText);
                        ScriptHandler.callFunction(sh, "beforeDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", la);
                        double sy = y;
                        if (bAxisLabelStaggered && sc.isTickLabelStaggered(i)) {
                            sy = iLabelLocation == 3 ? (sy -= dStaggeredLabelOffset) : (sy += dStaggeredLabelOffset);
                        }
                        if (ax.getLabel().isVisible() && la.isVisible()) {
                            if (bRendering3D) {
                                if (axisType == 5) {
                                    lo3d.set(x3d, sy - pwa.getVerticalSpacingInPixels(), dZEnd + pwa.getVerticalSpacingInPixels());
                                } else {
                                    lo3d.set(dXEnd + pwa.getVerticalSpacingInPixels(), sy - pwa.getVerticalSpacingInPixels(), z3d);
                                }
                                t3dre.setLocation3D(lo3d);
                                t3dre.setAction(2);
                                dc.addLabel(t3dre);
                            } else {
                                lo.set(x, sy);
                                tre.setAction(2);
                                ipr.drawText(tre);
                            }
                        }
                        ScriptHandler.callFunction(sh, "afterDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", la);
                    }
                    dAxisValue *= dAxisStep;
                }
            } else if ((sc.getType() & 8) == 8) {
                CDateTime cdtAxisValue = Methods.asDateTime(sc.getMinimum());
                int iUnit = Methods.asInteger(sc.getUnit());
                int iStep = Methods.asInteger(sc.getStep());
                IDateFormatWrapper sdf = null;
                if (fs == null) {
                    sdf = DateFormatWrapperFactory.getPreferredDateFormat(iUnit, rtc.getULocale());
                }
                CDateTime cdt = cdtAxisValue;
                double y = iLabelLocation == 3 ? (bRendering3D ? dYTick1 + 1.0 : dYTick1 - 1.0) : (bRendering3D ? dYTick2 - 1.0 : dYTick2 + 1.0);
                for (int i = 0; i < da.length; ++i) {
                    int x = (int)da[i];
                    if (bRendering3D) {
                        x3d = (int)da3D[i];
                        z3d = (int)da3D[i];
                    }
                    if ((iWhatToDraw & 1) == 1) {
                        double dYMinorTick2;
                        double dYMinorTick1;
                        double d13 = (iMinorTickStyle & 1) == 1 ? (bRendering3D ? dY + 5.0 : dY - 5.0) : (dYMinorTick1 = dY);
                        double d14 = (iMinorTickStyle & 2) == 2 ? (bRendering3D ? dY - 5.0 : dY + 5.0) : (dYMinorTick2 = dY);
                        if (dYMinorTick1 != -dYMinorTick2 && i != da.length - 1 && !bRenderBase3DAxis && !bRenderAncillary3DAxis) {
                            LineRenderEvent lreMinor = null;
                            for (int k = 0; k < daMinor.length - 1; ++k) {
                                lreMinor = (LineRenderEvent)((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(axModel), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? AxesRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                                lreMinor.setLineAttributes(liaMinorTick);
                                lreMinor.setStart(LocationImpl.create((double)x + (double)iDirection * daMinor[k], dYMinorTick1));
                                lreMinor.setEnd(LocationImpl.create((double)x + (double)iDirection * daMinor[k], dYMinorTick2));
                                ipr.drawLine(lreMinor);
                            }
                        }
                        if (dYTick1 != dYTick2) {
                            if (!bRenderBase3DAxis && !bRenderAncillary3DAxis) {
                                lre.setLineAttributes(liaMajorTick);
                                lre.getStart().set(x, dYTick1);
                                lre.getEnd().set(x, dYTick2);
                                ipr.drawLine(lre);
                            }
                            if (iv != null && iDimension == 1 && iv.getType() == 3) {
                                lre.getStart().set(x, dY);
                                lre.getEnd().set((double)x + dSeriesThickness, dY - dSeriesThickness);
                                ipr.drawLine(lre);
                            }
                        }
                    }
                    if (bRenderAxisLabels && sc.isTickLabelVisible(i)) {
                        try {
                            sText = ValueFormatter.format((Object)cdt, ax.getFormatSpecifier(), ax.getRunTimeContext().getULocale(), sdf);
                        }
                        catch (ChartException dfex) {
                            logger.log((Exception)((Object)dfex));
                            sText = IConstants.NULL_STRING;
                        }
                        la.getCaption().setValue(sText);
                        ScriptHandler.callFunction(sh, "beforeDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", la);
                        double sy = y;
                        if (bAxisLabelStaggered && sc.isTickLabelStaggered(i)) {
                            sy = iLabelLocation == 3 ? (sy -= dStaggeredLabelOffset) : (sy += dStaggeredLabelOffset);
                        }
                        if (ax.getLabel().isVisible() && la.isVisible()) {
                            if (bRendering3D) {
                                if (axisType == 5) {
                                    lo3d.set(x3d, sy - pwa.getVerticalSpacingInPixels(), dZEnd + pwa.getVerticalSpacingInPixels());
                                } else {
                                    lo3d.set(dXEnd + pwa.getVerticalSpacingInPixels(), sy - pwa.getVerticalSpacingInPixels(), z3d);
                                }
                                t3dre.setLocation3D(lo3d);
                                t3dre.setAction(2);
                                dc.addLabel(t3dre);
                            } else {
                                lo.set(x, sy);
                                tre.setAction(2);
                                ipr.drawText(tre);
                            }
                        }
                        ScriptHandler.callFunction(sh, "afterDrawAxisLabel", axModel, la, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", la);
                    }
                    cdt = cdtAxisValue.forward(iUnit, iStep * (i + 1));
                }
            }
            la = LabelImpl.copyInstance(ax.getTitle());
            if (la.isVisible() && bRenderAxisTitle) {
                ScriptHandler.callFunction(sh, "beforeDrawAxisTitle", axModel, la, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawAxisTitle", la);
                String sRestoreValue = la.getCaption().getValue();
                la.getCaption().setValue(rtc.externalizedMessage(sRestoreValue));
                la.getCaption().getFont().setAlignment(this.switchTextAlignment(la.getCaption().getFont().getAlignment()));
                BoundingBox bb = null;
                try {
                    bb = Methods.computeBox(xs, ax.getTitlePosition(), la, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                }
                if (ax.getTitle().isVisible() && la.isVisible()) {
                    if (bRendering3D) {
                        Bounds cbo = this.getPlotBounds();
                        if (axisType == 5) {
                            tre.setBlockBounds(BoundsImpl.create(cbo.getLeft() + (cbo.getWidth() / 3.0 - bb.getWidth()), cbo.getTop() + cbo.getHeight() - Math.min(bb.getHeight(), bb.getWidth()), bb.getWidth(), bb.getHeight()));
                        } else {
                            tre.setBlockBounds(BoundsImpl.create(cbo.getLeft() + cbo.getWidth() * 2.0 / 3.0 + (cbo.getWidth() / 3.0 - bb.getWidth()) / 2.0, cbo.getTop() + cbo.getHeight() - Math.min(bb.getHeight(), bb.getWidth()), bb.getWidth(), bb.getHeight()));
                        }
                        tre.setLabel(la);
                        tre.setBlockAlignment(la.getCaption().getFont().getAlignment());
                        tre.setAction(3);
                        ipr.drawText(tre);
                    } else {
                        Bounds bo = BoundsImpl.create(daEndPoints[0], ax.getTitleCoordinate(), daEndPoints[1] - daEndPoints[0], bb.getHeight());
                        tre.setBlockBounds(bo);
                        tre.setLabel(la);
                        tre.setBlockAlignment(la.getCaption().getFont().getAlignment());
                        tre.setAction(3);
                        ipr.drawText(tre);
                    }
                }
                ScriptHandler.callFunction(sh, "afterDrawAxisTitle", axModel, la, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawAxisTitle", la);
            }
            la = LabelImpl.copyInstance(ax.getLabel());
            if (iv != null && iDimension == 1 && (bTransposed && this.isRightToLeft() && iv.getType() == 2 || !this.isRightToLeft() && iv.getType() == 1)) {
                trae.setTranslation(-dSeriesThickness, dSeriesThickness);
                ipr.applyTransformation(trae);
            }
        }
    }

    public final void set(Chart _cm, Object _o, Series _se, Axis _ax, SeriesDefinition _sd) {
        super.set(_cm, _o, _se, _sd);
        this.ax = _ax;
    }

    public final boolean isDimension3D() {
        return this.getModel().getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL;
    }

    public final boolean isTransposed() {
        return ((ChartWithAxes)this.getModel()).isTransposed();
    }

    protected int getPrevVisibleSiblingSeriesIndex(int currentIndex) {
        SeriesDefinition sd = null;
        Series se = this.getSeries();
        if (se.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)se.eContainer();
        }
        if (sd != null) {
            int count = 0;
            int idx = sd.getRunTimeSeries().indexOf(se);
            if (idx > 0) {
                for (int i = idx - 1; i >= 0; --i) {
                    ++count;
                    if (!((Series)sd.getRunTimeSeries().get(i)).isVisible()) continue;
                    return currentIndex - count;
                }
            }
            Axis cax = this.getAxis();
            int iDefintionIndex = cax.getSeriesDefinitions().indexOf((Object)sd);
            int iDefinitionCount = cax.getSeriesDefinitions().size();
            if (iDefinitionCount > 0) {
                for (int i = iDefintionIndex - 1; i >= 0; --i) {
                    sd = (SeriesDefinition)cax.getSeriesDefinitions().get(i);
                    int runtimeSeriesCount = sd.getRunTimeSeries().size();
                    for (int j = runtimeSeriesCount - 1; j >= 0; --j) {
                        ++count;
                        if (!((Series)sd.getRunTimeSeries().get(j)).isVisible()) continue;
                        return currentIndex - count;
                    }
                }
            }
        }
        return -1;
    }

    public final boolean isLastRuntimeSeriesInAxis() {
        SeriesDefinition sd = null;
        Series se = this.getSeries();
        if (se.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)se.eContainer();
        }
        if (sd != null) {
            Axis cax = this.getAxis();
            int iDefintionIndex = cax.getSeriesDefinitions().indexOf((Object)sd);
            int iDefinitionCount = cax.getSeriesDefinitions().size();
            if (iDefinitionCount > 0 && iDefintionIndex == iDefinitionCount - 1) {
                int iThisSeriesIndex = sd.getRunTimeSeries().indexOf(se);
                int iSeriesCount = sd.getRunTimeSeries().size();
                if (iSeriesCount > 0 && iThisSeriesIndex == iSeriesCount - 1) {
                    return true;
                }
            }
        }
        return false;
    }

    protected Engine3D get3DEngine() {
        if (this.isDimension3D()) {
            return ((PlotWith3DAxes)this.oComputations).get3DEngine();
        }
        return null;
    }

    protected Location getPanningOffset() {
        if (this.isDimension3D()) {
            return ((PlotWith3DAxes)this.oComputations).getPanningOffset();
        }
        return null;
    }

    public final Axis getAxis() {
        return this.ax;
    }
}

