/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.layout;

import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.BirtContext;
import org.eclipse.birt.report.presentation.aggregation.BirtBaseFragment;
import org.eclipse.birt.report.presentation.aggregation.layout.DocumentFragment;
import org.eclipse.birt.report.presentation.aggregation.layout.SidebarFragment;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.actionhandler.BirtExtractDataActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtGetReportletActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRenderImageActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRenderReportActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunAndRenderActionHandler;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class EngineFragment
extends BirtBaseFragment {
    protected void doPreService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = ParameterAccessor.getFormat(httpServletRequest);
        if ("/download".equalsIgnoreCase(httpServletRequest.getServletPath())) {
            httpServletResponse.setContentType("text/plain; charset=utf-8");
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=exportdata.csv");
        } else if ("pdf".equalsIgnoreCase(string)) {
            httpServletResponse.setContentType("application/pdf");
            String string2 = ParameterAccessor.generateFileName(httpServletRequest);
            httpServletResponse.setHeader("Content-Disposition", "inline; filename=\"" + string2 + "\"");
        } else {
            String string3 = ReportEngineService.getInstance().getMIMEType(string);
            if (string3 != null && string3.length() > 0) {
                httpServletResponse.setContentType(string3);
            } else {
                httpServletResponse.setContentType("application/octet-stream");
            }
        }
    }

    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        GetUpdatedObjectsResponse getUpdatedObjectsResponse = new GetUpdatedObjectsResponse();
        BirtContext birtContext = new BirtContext(httpServletRequest, httpServletResponse);
        Operation operation = null;
        try {
            if ("/download".equalsIgnoreCase(httpServletRequest.getServletPath())) {
                BirtExtractDataActionHandler birtExtractDataActionHandler = new BirtExtractDataActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                birtExtractDataActionHandler.execute();
            } else if (ParameterAccessor.isGetImageOperator(httpServletRequest)) {
                BirtRenderImageActionHandler birtRenderImageActionHandler = new BirtRenderImageActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                birtRenderImageActionHandler.execute();
            } else if (ParameterAccessor.isGetReportlet(httpServletRequest)) {
                BirtGetReportletActionHandler birtGetReportletActionHandler = new BirtGetReportletActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                birtGetReportletActionHandler.execute();
            } else if (birtContext.getBean().documentInUrl) {
                BirtRenderReportActionHandler birtRenderReportActionHandler = new BirtRenderReportActionHandler(birtContext, operation, getUpdatedObjectsResponse, (OutputStream)servletOutputStream);
                birtRenderReportActionHandler.execute();
            } else {
                BirtRunAndRenderActionHandler birtRunAndRenderActionHandler = new BirtRunAndRenderActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                birtRunAndRenderActionHandler.execute();
            }
        }
        catch (RemoteException remoteException) {
            AxisFault axisFault = (AxisFault)remoteException;
            String string = "<html><head><title>" + BirtResources.getMessage("birt.viewer.title.error") + "</title><body><font color=\"red\">" + ParameterAccessor.htmlEncode(axisFault.getFaultString()) + "</font></body></html>";
            servletOutputStream.write(string.getBytes());
        }
    }

    protected String doPostService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        return null;
    }

    protected void build() {
        this.addChild(new SidebarFragment());
        this.addChild(new DocumentFragment());
    }
}

