/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.builders.BuildErrorReporter;
import org.eclipse.pde.internal.core.builders.BundleErrorReporter;
import org.eclipse.pde.internal.core.builders.ExtensionsErrorReporter;
import org.eclipse.pde.internal.core.builders.FragmentErrorReporter;
import org.eclipse.pde.internal.core.builders.PDEMarkerFactory;
import org.eclipse.pde.internal.core.builders.PluginErrorReporter;
import org.eclipse.pde.internal.core.builders.ValidatingSAXParser;
import org.eclipse.pde.internal.core.builders.XMLErrorReporter;

public class ManifestConsistencyChecker
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        boolean shouldBuild;
        if (PDECore.getDefault().getBundle().getState() != 32 || monitor.isCanceled()) {
            return new IProject[0];
        }
        IProject project = this.getProject();
        IResourceDelta delta = this.getDelta(project);
        boolean bl = shouldBuild = delta == null || delta.getAffectedChildren().length > 0;
        if (shouldBuild && !WorkspaceModelManager.isBinaryPluginProject(project)) {
            this.checkThisProject(monitor);
        }
        return new IProject[0];
    }

    private void checkThisProject(IProgressMonitor monitor) {
        IProject project = this.getProject();
        IFile file = project.getFile("plugin.xml");
        if (!file.exists()) {
            file = project.getFile("fragment.xml");
        }
        if (file.exists()) {
            this.checkFile(file, monitor);
        } else {
            IFile manifestFile = project.getFile("META-INF/MANIFEST.MF");
            if (manifestFile.exists()) {
                this.checkManifestFile(manifestFile, monitor);
            }
        }
        this.checkProjectDescription(monitor);
        this.checkBuildProperties(monitor);
    }

    private void checkManifestFile(IFile file, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String message = NLS.bind((String)PDECoreMessages.Builders_verifying, (Object)file.getFullPath().toString());
        monitor.subTask(message);
        BundleErrorReporter reporter = new BundleErrorReporter(file);
        if (reporter != null) {
            reporter.validateContent(monitor);
            monitor.subTask(PDECoreMessages.Builders_updating);
        }
        monitor.done();
    }

    private void checkFile(IFile file, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String message = NLS.bind((String)PDECoreMessages.Builders_verifying, (Object)file.getFullPath().toString());
        monitor.subTask(message);
        IFile bundleManifest = file.getProject().getFile("META-INF/MANIFEST.MF");
        ExtensionsErrorReporter reporter = null;
        BundleErrorReporter bundleReporter = null;
        if (bundleManifest.exists()) {
            reporter = new ExtensionsErrorReporter(file);
            bundleReporter = new BundleErrorReporter(bundleManifest);
        } else if (file.getName().equals("plugin.xml")) {
            reporter = new PluginErrorReporter(file);
        } else if (file.getName().equals("fragment.xml")) {
            reporter = new FragmentErrorReporter(file);
        }
        if (reporter != null) {
            ValidatingSAXParser.parse(file, reporter);
            ((XMLErrorReporter)reporter).validateContent(monitor);
            monitor.subTask(PDECoreMessages.Builders_updating);
        }
        if (bundleReporter != null) {
            bundleReporter.validateContent(monitor);
            monitor.subTask(PDECoreMessages.Builders_updating);
        }
        monitor.done();
    }

    private void checkProjectDescription(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(NLS.bind((String)PDECoreMessages.Builders_verifying, (Object)".project"));
        IProject project = this.getProject();
        IFile file = project.getFile(".project");
        if (!file.exists()) {
            return;
        }
        try {
            file.deleteMarkers("org.eclipse.pde.validation-marker", true, 0);
            IProject[] refProjects = project.getDescription().getReferencedProjects();
            if (refProjects.length > 0) {
                try {
                    IMarker marker = new PDEMarkerFactory().createMarker(file, 4101);
                    marker.setAttribute("message", (Object)PDECoreMessages.ManifestConsistencyChecker_projectCheck);
                    marker.setAttribute("severity", 1);
                    marker.setAttribute("lineNumber", 5);
                }
                catch (CoreException e) {
                    PDECore.logException(e);
                }
            }
        }
        catch (CoreException coreException) {}
        monitor.done();
    }

    private void checkBuildProperties(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        IProject project = this.getProject();
        IFile file = project.getFile("build.properties");
        if (!file.exists()) {
            return;
        }
        monitor.subTask(PDECoreMessages.ManifestConsistencyChecker_buildPropertiesSubtask);
        BuildErrorReporter ber = new BuildErrorReporter(file);
        ber.validateContent(monitor);
    }
}

