/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.withaxes.AxisSubUnit;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints3D;
import org.eclipse.birt.chart.computation.withaxes.StackGroup;
import org.eclipse.birt.chart.computation.withaxes.StackedSeriesLookup;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class Bar
extends AxesRenderer {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    static /* synthetic */ Class class$org$eclipse$birt$chart$event$Polygon3DRenderEvent;
    static /* synthetic */ Class class$org$eclipse$birt$chart$event$PolygonRenderEvent;
    static /* synthetic */ Class class$org$eclipse$birt$chart$event$Text3DRenderEvent;

    protected double[] computeStackPosition(AxisSubUnit au, double dValue, Axis ax) {
        if (ax.isPercent()) {
            dValue = au.valuePercentage(dValue);
        }
        double dStart = 0.0;
        double dEnd = 0.0;
        if (dValue > 0.0) {
            dStart = au.getValueMax();
            dEnd = dStart + dValue;
            au.setValueMax(dEnd);
        } else if (dValue < 0.0) {
            dStart = au.getValueMin();
            dEnd = dStart + dValue;
            au.setValueMin(dEnd);
        } else {
            dStart = au.getLastValue();
            dEnd = au.getLastValue();
        }
        au.setLastValue(dEnd);
        return new double[]{dStart, dEnd};
    }

    public final void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        double dUnitSpacing;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)vex);
        }
        boolean bRendering3D = this.isDimension3D();
        SeriesRenderingHints srh = null;
        SeriesRenderingHints3D srh3d = null;
        if (bRendering3D) {
            srh3d = (SeriesRenderingHints3D)isrh;
        } else {
            srh = (SeriesRenderingHints)isrh;
        }
        if (!bRendering3D && !srh.isCategoryScale() || bRendering3D && !srh3d.isXCategoryScale()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.xvalue.scale.bars", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        Bounds boClientArea = isrh.getClientAreaBounds(true);
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        logger.log(1, Messages.getString("info.render.series", new Object[]{((Object)((Object)this)).getClass().getName(), new Integer(this.iSeriesIndex + 1), new Integer(this.iSeriesCount)}, this.getRunTimeContext().getULocale()));
        BarSeries bs = (BarSeries)this.getSeries();
        if (!bs.isSetRiser()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.undefined.riser", new Object[]{bs}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!bs.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.series.visibility", new Object[]{bs}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!bs.isVisible()) {
            return;
        }
        RiserType rt = bs.getRiser();
        double dSeriesThickness = bRendering3D ? 0.0 : srh.getSeriesThickness();
        double dZeroLocation = bRendering3D ? srh3d.getPlotZeroLocation() : srh.getZeroLocation();
        double dBaseLocation = -1.0;
        DataPointHints[] dpha = isrh.getDataPoints();
        this.validateNullDatapoint(dpha);
        ColorDefinition cd = bs.getRiserOutline();
        LineAttributes lia = LineAttributesImpl.create((ColorDefinition)(cd == null ? null : ColorDefinitionImpl.copyInstance((ColorDefinition)cd)), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
        double dX = 0.0;
        double dY = 0.0;
        double dZ = 0.0;
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dSpacing = 0.0;
        double dValue = 0.0;
        double dWidthZ = 0.0;
        double dSpacingZ = 0.0;
        Location[] loaFrontFace = null;
        ArrayList<Location3D[]> loa3dFace = null;
        Location3D[] a3dFace = null;
        boolean bInverted = false;
        double d = dUnitSpacing = !cwa.isSetUnitSpacing() ? 50.0 : cwa.getUnitSpacing();
        if (cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
            boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
        }
        Axis ax = this.getAxis();
        StackedSeriesLookup ssl = null;
        StackGroup sg = null;
        if (!bRendering3D) {
            ssl = srh.getStackedSeriesLookup();
            sg = ssl.getStackGroup((Series)bs);
        }
        int iSharedUnitIndex = sg == null ? 0 : sg.getSharedIndex();
        int iSharedUnitCount = sg == null ? 1 : sg.getSharedCount();
        Label laDataPoint = null;
        Position pDataPoint = null;
        Location loDataPoint = null;
        Location3D loDataPoint3d = null;
        Bounds boDataPoint = null;
        try {
            Label label = laDataPoint = bRendering3D ? srh3d.getLabelAttributes((Series)bs) : srh.getLabelAttributes((Series)bs);
            if (laDataPoint.isVisible()) {
                pDataPoint = bRendering3D ? srh3d.getLabelPosition((Series)bs) : srh.getLabelPosition((Series)bs);
                loDataPoint = LocationImpl.create((double)0.0, (double)0.0);
                loDataPoint3d = Location3DImpl.create((double)0.0, (double)0.0, (double)0.0);
                boDataPoint = BoundsImpl.create((double)0.0, (double)0.0, (double)0.0, (double)0.0);
            }
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
        }
        SeriesDefinition sd = this.getSeriesDefinition();
        EList elPalette = sd.getSeriesPalette().getEntries();
        int iPaletteSize = elPalette.size();
        if (iPaletteSize == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{bs}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = cwa.getLegend().getItemType().getValue() == 1;
        int iThisSeriesIndex = -1;
        if (!bPaletteByCategory && (iThisSeriesIndex = sd.getRunTimeSeries().indexOf(bs)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{bs, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        double[] faX = new double[dpha.length];
        double[] faY = new double[dpha.length];
        for (int i = 0; i < dpha.length; ++i) {
            block97: {
                block98: {
                    block99: {
                        block100: {
                            Location3D[] loa3d;
                            EList elTriggers;
                            double dEnd;
                            double dStart;
                            AxisSubUnit au;
                            faX[i] = Double.NaN;
                            faY[i] = Double.NaN;
                            Fill f = null;
                            if (bPaletteByCategory) {
                                f = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(i % iPaletteSize)));
                            } else if (iThisSeriesIndex >= 0) {
                                f = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
                            }
                            this.updateTranslucency(f, (Series)bs);
                            if (bRendering3D) {
                                Location3D lo3d = dpha[i].getLocation3D();
                                dX = lo3d.getX();
                                dY = lo3d.getY();
                                dZ = lo3d.getZ();
                                dSpacing = dpha[i].getSize2D().getWidth() * dUnitSpacing / 200.0;
                                dSpacingZ = dpha[i].getSize2D().getHeight() * dUnitSpacing / 200.0;
                            } else {
                                Location lo = dpha[i].getLocation();
                                dX = lo.getX();
                                dY = lo.getY();
                                dSpacing = dpha[i].getSize() * dUnitSpacing / 200.0;
                            }
                            if (cwa.isTransposed()) {
                                dHeight = dpha[i].getSize();
                                dHeight -= 2.0 * dSpacing;
                                dY += dSpacing + (double)iSharedUnitIndex * (dHeight /= (double)iSharedUnitCount);
                                if (bs.isStacked() || ax.isPercent()) {
                                    au = ssl.getUnit((Series)bs, i);
                                    dValue = Bar.isNaN((Object)dpha[i].getOrthogonalValue()) ? 0.0 : (Double)dpha[i].getOrthogonalValue();
                                    double[] values = this.computeStackPosition(au, dValue, ax);
                                    dStart = values[0];
                                    dEnd = values[1];
                                    try {
                                        dX = Math.ceil(srh.getLocationOnOrthogonal((Object)new Double(dEnd)));
                                        dBaseLocation = Math.ceil(srh.getLocationOnOrthogonal((Object)new Double(dStart)));
                                    }
                                    catch (Exception ex) {
                                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                                    }
                                } else {
                                    dBaseLocation = dZeroLocation;
                                }
                                if (ChartUtil.mathLT((double)dX, (double)boClientArea.getLeft())) {
                                    if (ChartUtil.mathLT((double)dBaseLocation, (double)boClientArea.getLeft())) continue;
                                    dX = boClientArea.getLeft();
                                } else if (ChartUtil.mathLT((double)dBaseLocation, (double)boClientArea.getLeft())) {
                                    dBaseLocation = boClientArea.getLeft();
                                }
                                if (ChartUtil.mathGT((double)dX, (double)(boClientArea.getLeft() + boClientArea.getWidth()))) {
                                    if (ChartUtil.mathGT((double)dBaseLocation, (double)(boClientArea.getLeft() + boClientArea.getWidth()))) continue;
                                    dX = boClientArea.getLeft() + boClientArea.getWidth();
                                } else if (ChartUtil.mathGT((double)dBaseLocation, (double)(boClientArea.getLeft() + boClientArea.getWidth()))) {
                                    dBaseLocation = boClientArea.getLeft() + boClientArea.getWidth();
                                }
                                dWidth = dBaseLocation - dX;
                                boolean bl = bInverted = dWidth <= 0.0;
                                if (bInverted) {
                                    dX = dBaseLocation;
                                    dWidth = -dWidth;
                                }
                            } else {
                                if (bRendering3D) {
                                    dWidth = dpha[i].getSize2D().getWidth();
                                    dWidth -= 2.0 * dSpacing;
                                    dWidthZ = dpha[i].getSize2D().getHeight();
                                    dWidthZ -= 2.0 * dSpacingZ;
                                    dX += dSpacing;
                                    dZ += dSpacingZ;
                                } else {
                                    dWidth = dpha[i].getSize();
                                    dWidth -= 2.0 * dSpacing;
                                    dX += dSpacing + (double)iSharedUnitIndex * (dWidth /= (double)iSharedUnitCount);
                                }
                                if (bs.isStacked() || ax.isPercent()) {
                                    if (bRendering3D) {
                                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 15, "exception.no.stack.percent.3D.chart", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                                    }
                                    au = ssl.getUnit((Series)bs, i);
                                    dValue = Bar.isNaN((Object)dpha[i].getOrthogonalValue()) ? 0.0 : (Double)dpha[i].getOrthogonalValue();
                                    double[] values = this.computeStackPosition(au, dValue, ax);
                                    dStart = values[0];
                                    dEnd = values[1];
                                    try {
                                        dY = Math.floor(srh.getLocationOnOrthogonal((Object)new Double(dEnd)));
                                        dBaseLocation = Math.floor(srh.getLocationOnOrthogonal((Object)new Double(dStart)));
                                    }
                                    catch (Exception ex) {
                                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                                    }
                                } else {
                                    dBaseLocation = dZeroLocation;
                                }
                                if (bRendering3D) {
                                    double plotBaseLocation = srh3d.getPlotBaseLocation();
                                    if (dY < plotBaseLocation) {
                                        if (dBaseLocation < plotBaseLocation) continue;
                                        dY = plotBaseLocation;
                                    } else if (dBaseLocation < plotBaseLocation) {
                                        dBaseLocation = plotBaseLocation;
                                    }
                                    if (dY > plotBaseLocation + srh3d.getPlotHeight()) {
                                        if (dBaseLocation > plotBaseLocation + srh3d.getPlotHeight()) continue;
                                        dY = plotBaseLocation + srh3d.getPlotHeight();
                                    } else if (dBaseLocation > plotBaseLocation + srh3d.getPlotHeight()) {
                                        dBaseLocation = plotBaseLocation + srh3d.getPlotHeight();
                                    }
                                } else {
                                    if (dY < boClientArea.getTop()) {
                                        if (dBaseLocation < boClientArea.getTop()) continue;
                                        dY = boClientArea.getTop();
                                    } else if (dBaseLocation < boClientArea.getTop()) {
                                        dBaseLocation = boClientArea.getTop();
                                    }
                                    if (dY > boClientArea.getTop() + boClientArea.getHeight()) {
                                        if (dBaseLocation > boClientArea.getTop() + boClientArea.getHeight()) continue;
                                        dY = boClientArea.getTop() + boClientArea.getHeight();
                                    } else if (dBaseLocation > boClientArea.getTop() + boClientArea.getHeight()) {
                                        dBaseLocation = boClientArea.getTop() + boClientArea.getHeight();
                                    }
                                }
                                dHeight = dBaseLocation - dY;
                                boolean bl = bInverted = dHeight < 0.0;
                                if (bInverted) {
                                    dY = dBaseLocation;
                                    dHeight = -dHeight;
                                }
                            }
                            if (rt.getValue() == 0) {
                                if (bRendering3D) {
                                    loa3dFace = new ArrayList<Location3D[]>();
                                    if (!bInverted) {
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)dZ)};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ)};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ)};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ))};
                                        loa3dFace.add(a3dFace);
                                    } else {
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ)};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ)};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ)};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ))};
                                        loa3dFace.add(a3dFace);
                                    }
                                } else {
                                    loaFrontFace = new Location[]{LocationImpl.create((double)dX, (double)dY), LocationImpl.create((double)dX, (double)(dY + dHeight)), LocationImpl.create((double)(dX + dWidth), (double)(dY + dHeight)), LocationImpl.create((double)(dX + dWidth), (double)dY)};
                                    if (cwa.isTransposed()) {
                                        faX[i] = bInverted ? dX + dWidth : dX;
                                        faY[i] = dY + dHeight / 2.0;
                                    } else {
                                        faX[i] = dX + dWidth / 2.0;
                                        faY[i] = bInverted ? dY + dHeight : dY;
                                    }
                                }
                            } else if (rt.getValue() == 1) {
                                if (bRendering3D) {
                                    loa3dFace = new ArrayList();
                                    if (!bInverted) {
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)dY, (double)(dZ + dWidthZ / 2.0))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)dY, (double)(dZ + dWidthZ / 2.0))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)dY, (double)(dZ + dWidthZ / 2.0))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)dY, (double)(dZ + dWidthZ / 2.0))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ)};
                                        loa3dFace.add(a3dFace);
                                    } else {
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)(dY + dHeight), (double)(dZ + dWidthZ / 2.0))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)(dY + dHeight), (double)(dZ + dWidthZ / 2.0))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)(dY + dHeight), (double)(dZ + dWidthZ / 2.0))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)(dY + dHeight), (double)(dZ + dWidthZ / 2.0))};
                                        loa3dFace.add(a3dFace);
                                        a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ))};
                                        loa3dFace.add(a3dFace);
                                    }
                                } else {
                                    loaFrontFace = new Location[3];
                                    if (cwa.isTransposed()) {
                                        double dX1 = bInverted ? dX : dX + dWidth;
                                        double dX2 = bInverted ? dX + dWidth : dX;
                                        loaFrontFace[0] = LocationImpl.create((double)dX1, (double)dY);
                                        loaFrontFace[1] = LocationImpl.create((double)dX2, (double)(dY + dHeight / 2.0));
                                        loaFrontFace[2] = LocationImpl.create((double)dX1, (double)(dY + dHeight));
                                        faX[i] = dX2;
                                        faY[i] = dY + dHeight / 2.0;
                                    } else {
                                        double dY1 = bInverted ? dY : dY + dHeight;
                                        double dY2 = bInverted ? dY + dHeight : dY;
                                        loaFrontFace[0] = LocationImpl.create((double)dX, (double)dY1);
                                        loaFrontFace[1] = LocationImpl.create((double)(dX + dWidth / 2.0), (double)dY2);
                                        loaFrontFace[2] = LocationImpl.create((double)(dX + dWidth), (double)dY1);
                                        faX[i] = dX + dWidth / 2.0;
                                        faY[i] = dY2;
                                    }
                                }
                            } else {
                                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.unspecified.riser.type", new Object[]{rt.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                            }
                            if (Bar.isNaN((Object)dpha[i].getOrthogonalValue())) {
                                faX[i] = Double.NaN;
                                faY[i] = Double.NaN;
                                continue;
                            }
                            if (this.isInteractivityEnabled() && !(elTriggers = bs.getTriggers()).isEmpty()) {
                                StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]);
                                if (bRendering3D) {
                                    for (int j = 0; j < loa3dFace.size(); ++j) {
                                        InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
                                        Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)bs), class$org$eclipse$birt$chart$event$Polygon3DRenderEvent == null ? Bar.class$("org.eclipse.birt.chart.event.Polygon3DRenderEvent") : class$org$eclipse$birt$chart$event$Polygon3DRenderEvent);
                                        pre3d.setPoints3D((Location3D[])loa3dFace.get(j));
                                        Location panningOffset = this.getPanningOffset();
                                        if (this.get3DEngine().processEvent((PrimitiveRenderEvent)pre3d, panningOffset.getX(), panningOffset.getY()) == null) continue;
                                        iev.setHotSpot((PrimitiveRenderEvent)pre3d);
                                        ipr.enableInteraction(iev);
                                    }
                                } else {
                                    InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
                                    PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)bs), class$org$eclipse$birt$chart$event$PolygonRenderEvent == null ? Bar.class$("org.eclipse.birt.chart.event.PolygonRenderEvent") : class$org$eclipse$birt$chart$event$PolygonRenderEvent);
                                    pre.setPoints(loaFrontFace);
                                    iev.setHotSpot((PrimitiveRenderEvent)pre);
                                    ipr.enableInteraction(iev);
                                }
                            }
                            ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i], (Object)f);
                            ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)f, (Object)this.getRunTimeContext().getScriptContext());
                            this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i]);
                            this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
                            if (bRendering3D) {
                                this.render3DPlane(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loa3dFace, f, lia);
                            } else {
                                this.renderPlane(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loaFrontFace, f, lia, cwa.getDimension(), dSeriesThickness, true);
                            }
                            ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i], (Object)f);
                            ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)f, (Object)this.getRunTimeContext().getScriptContext());
                            this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i]);
                            this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
                            if (!laDataPoint.isVisible()) continue;
                            laDataPoint.getCaption().setValue(dpha[i].getDisplayValue());
                            ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                            this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)laDataPoint);
                            if (!laDataPoint.isVisible()) break block97;
                            if (cwa.isTransposed()) break block98;
                            if (!bRendering3D) break block99;
                            if (pDataPoint.getValue() != 5) break block100;
                            if (!bInverted) {
                                loDataPoint3d.set(dX + dWidth / 2.0, dY - (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0);
                                Text3DRenderEvent tre = (Text3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), class$org$eclipse$birt$chart$event$Text3DRenderEvent == null ? Bar.class$("org.eclipse.birt.chart.event.Text3DRenderEvent") : class$org$eclipse$birt$chart$event$Text3DRenderEvent);
                                tre.setLabel(laDataPoint);
                                tre.setTextPosition(4);
                                tre.setAction(2);
                                loa3d = new Location3D[]{loDataPoint3d, Location3DImpl.create((double)dX, (double)(dY - (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)dX, (double)(dY - (double)p.getVerticalSpacing() - 16.0), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)(dX + dWidth), (double)(dY - (double)p.getVerticalSpacing() - 16.0), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)(dX + dWidth), (double)(dY - (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0))};
                                tre.setBlockBounds3D(loa3d);
                                this.getDeferredCache().addLabel((TextRenderEvent)tre);
                            } else {
                                loDataPoint3d.set(dX + dWidth / 2.0, dY + dHeight + (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0);
                                Text3DRenderEvent tre = (Text3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), class$org$eclipse$birt$chart$event$Text3DRenderEvent == null ? Bar.class$("org.eclipse.birt.chart.event.Text3DRenderEvent") : class$org$eclipse$birt$chart$event$Text3DRenderEvent);
                                tre.setAction(2);
                                tre.setLabel(laDataPoint);
                                tre.setTextPosition(3);
                                loa3d = new Location3D[]{loDataPoint3d, Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight + (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight + 16.0 + (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)dX, (double)(dY + dHeight + 16.0 + (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)dX, (double)(dY + dHeight + (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0))};
                                tre.setBlockBounds3D(loa3d);
                                this.getDeferredCache().addLabel((TextRenderEvent)tre);
                            }
                            break block97;
                        }
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.bar3d", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                    }
                    switch (pDataPoint.getValue()) {
                        case 5: {
                            if (!bInverted) {
                                loDataPoint.set(dX + dWidth / 2.0, dY - (double)p.getVerticalSpacing());
                                this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.ABOVE_LITERAL, loDataPoint, null);
                            } else {
                                loDataPoint.set(dX + dWidth / 2.0, dY + dHeight + (double)p.getVerticalSpacing());
                                this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.BELOW_LITERAL, loDataPoint, null);
                            }
                            break block97;
                        }
                        case 4: {
                            boDataPoint.updateFrom(loaFrontFace);
                            this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 3, laDataPoint, null, null, boDataPoint);
                            break block97;
                        }
                        default: {
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.bar", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                    }
                }
                switch (pDataPoint.getValue()) {
                    case 5: {
                        if (!bInverted) {
                            loDataPoint.set(dX - (double)p.getHorizontalSpacing(), dY + dHeight / 2.0);
                            this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.LEFT_LITERAL, loDataPoint, null);
                            break;
                        }
                        loDataPoint.set(dX + dWidth + (double)p.getHorizontalSpacing(), dY + dHeight / 2.0);
                        this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.RIGHT_LITERAL, loDataPoint, null);
                        break;
                    }
                    case 4: {
                        boDataPoint.updateFrom(loaFrontFace);
                        this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 3, laDataPoint, null, null, boDataPoint);
                        break;
                    }
                    default: {
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.bar", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                    }
                }
            }
            ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)laDataPoint);
        }
        if (!bRendering3D) {
            List<Object> points = new ArrayList<double[]>();
            for (int i = 0; i < faX.length; ++i) {
                points.add(new double[]{faX[i], faY[i]});
            }
            points = Bar.filterNull(points);
            if (this.isLastRuntimeSeriesInAxis()) {
                this.getRunTimeContext().putState((Object)AreaSeries.class, null);
            } else {
                this.getRunTimeContext().putState((Object)AreaSeries.class, points);
            }
            if (this.getSeries().getCurveFitting() != null) {
                Location[] larray = this.createLocationArray(points);
                this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL, true);
            }
        }
    }

    protected InteractionEvent createEvent(StructureSource iSource, List elTriggers, IPrimitiveRenderer ipr) {
        InteractionEvent iev = new InteractionEvent((Object)iSource);
        for (int t = 0; t < elTriggers.size(); ++t) {
            Trigger tg = TriggerImpl.copyInstance((Trigger)((Trigger)elTriggers.get(t)));
            this.processTrigger(tg, iSource);
            iev.addTrigger(tg);
        }
        return iev;
    }

    public final void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        BarSeries bs = (BarSeries)this.getSeries();
        ColorDefinition cd = bs.getRiserOutline();
        LineAttributes lia = LineAttributesImpl.create((ColorDefinition)(cd == null ? null : ColorDefinitionImpl.copyInstance((ColorDefinition)cd)), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
        if (fPaletteEntry == null) {
            fPaletteEntry = ColorDefinitionImpl.RED();
        }
        Location[] loaFrontFace = null;
        if (bs.getRiser().getValue() == 0) {
            loaFrontFace = new Location[]{LocationImpl.create((double)bo.getLeft(), (double)bo.getTop()), LocationImpl.create((double)bo.getLeft(), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)bo.getTop())};
        } else if (bs.getRiser().getValue() == 1) {
            loaFrontFace = new Location[]{LocationImpl.create((double)bo.getLeft(), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth() / 2.0), (double)bo.getTop()), LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)(bo.getTop() + bo.getHeight()))};
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.legend.graphic.unknown.riser", new Object[]{bs.getRiser().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        this.renderPlane(ipr, StructureSource.createLegend((Legend)lg), loaFrontFace, fPaletteEntry, lia, this.getModel().getDimension(), 3.0 * this.getDeviceScale(), false);
    }

    private Location[] createLocationArray(List ll) {
        Location[] loa = new Location[ll.size()];
        for (int i = 0; i < loa.length; ++i) {
            double[] obj = (double[])ll.get(i);
            loa[i] = LocationImpl.create((double)obj[0], (double)obj[1]);
        }
        return loa;
    }

    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
    }
}

