/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.withoutaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.render.PieRenderer;

public final class Pie
extends BaseRenderer {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    private PieRenderer pr = null;

    public final void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 3, (Throwable)vex);
        }
        ChartWithoutAxes cwoa = (ChartWithoutAxes)this.getModel();
        SeriesDefinition sd = this.getSeriesDefinition();
        Bounds boCB = this.getCellBounds();
        try {
            this.pr = new PieRenderer(cwoa, this, srh.getDataPoints(), srh.asPrimitiveDoubleValues(), sd.getSeriesPalette());
            this.pr.computeInsets(boCB);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 3, (Throwable)ex);
        }
    }

    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        PieSeries ps;
        ChartWithoutAxes cwoa = (ChartWithoutAxes)this.getModel();
        if (cwoa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL && cwoa.getDimension() != ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.pie.dimension", new Object[]{cwoa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (this.isFirstPie()) {
            int i;
            Insets ins = null;
            boolean first = true;
            for (i = 1; i < this.iSeriesCount; ++i) {
                if (!(this.getRenderer(i) instanceof Pie)) continue;
                if (first) {
                    ins = ((Pie)this.getRenderer(i)).getActualRenderer().getFittingInsets();
                    first = false;
                    continue;
                }
                ins = InsetsImpl.max((Insets)ins, (Insets)((Pie)this.getRenderer(i)).getActualRenderer().getFittingInsets());
            }
            try {
                for (i = 1; i < this.iSeriesCount; ++i) {
                    if (!(this.getRenderer(i) instanceof Pie)) continue;
                    ((Pie)this.getRenderer(i)).getActualRenderer().setFittingInsets(ins);
                }
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)uiex);
            }
        }
        if (!(ps = (PieSeries)this.getSeries()).isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.series.visibility", new Object[]{ps}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!ps.isVisible()) {
            return;
        }
        logger.log(1, Messages.getString("info.render.series", this.getRunTimeContext().getULocale()) + ((Object)((Object)this)).getClass().getName() + (this.iSeriesIndex + 1) + this.iSeriesCount);
        Bounds boCB = this.getCellBounds();
        this.pr.render(this.getDevice(), boCB);
    }

    protected final boolean isFirstPie() {
        for (int i = 1; i < this.iSeriesCount; ++i) {
            if (!(this.getRenderer(i) instanceof Pie)) continue;
            return this.getRenderer(i) == this;
        }
        return false;
    }

    private final PieRenderer getActualRenderer() {
        return this.pr;
    }

    public int[] getFilteredMinSliceEntry(DataSetIterator dsi) {
        ChartWithoutAxes cwoa = (ChartWithoutAxes)this.getModel();
        if (!cwoa.isSetMinSlice()) {
            return null;
        }
        boolean bPercentageMinSlice = cwoa.isSetMinSlicePercent() && cwoa.isMinSlicePercent();
        double dMinSlice = cwoa.getMinSlice();
        double[] da = new double[dsi.size()];
        dsi.reset();
        int idx = 0;
        while (dsi.hasNext()) {
            Object obj = dsi.next();
            if (obj instanceof Number) {
                da[idx] = ((Number)obj).doubleValue();
            }
            ++idx;
        }
        if (bPercentageMinSlice) {
            double total = 0.0;
            for (int i = 0; i < da.length; ++i) {
                if (da[i] < 0.0) {
                    total -= da[i];
                    continue;
                }
                total += da[i];
            }
            dMinSlice = total * dMinSlice / 100.0;
        }
        ArrayList<Integer> idxList = new ArrayList<Integer>();
        for (int i = 0; i < da.length; ++i) {
            if (!(Math.abs(da[i]) < Math.abs(dMinSlice))) continue;
            idxList.add(new Integer(i));
        }
        if (idxList.size() > 0) {
            Integer[] ia = idxList.toArray(new Integer[idxList.size()]);
            int[] pia = new int[ia.length];
            for (int i = 0; i < pia.length; ++i) {
                pia[i] = ia[i];
            }
            return pia;
        }
        return null;
    }

    public final void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        PieSeries bs = (PieSeries)this.getSeries();
        ColorDefinition cd = bs.getSliceOutline();
        LineAttributes lia = LineAttributesImpl.create((ColorDefinition)(cd == null ? null : ColorDefinitionImpl.copyInstance((ColorDefinition)cd)), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
        Location[] loaFrontFace = new Location[]{LocationImpl.create((double)bo.getLeft(), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + 0.8 * bo.getWidth()), (double)bo.getTop())};
        this.renderPlane(ipr, StructureSource.createLegend((Legend)lg), loaFrontFace, fPaletteEntry, lia, this.getModel().getDimension(), 3.0 * this.getDeviceScale(), false);
    }
}

