/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.render.Line;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class Scatter
extends Line {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");

    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        int i;
        int i2;
        int iThisSeriesIndex;
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        if (cwa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL && cwa.getDimension() != ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.scatter.dimension", new Object[]{cwa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        logger.log(1, Messages.getString("info.render.series", new Object[]{((Object)((Object)this)).getClass().getName(), new Integer(this.iSeriesIndex + 1), new Integer(this.iSeriesCount)}, this.getRunTimeContext().getULocale()));
        ScatterSeries ss = (ScatterSeries)this.getSeries();
        if (!ss.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.series.visibility", new Object[]{ss}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!ss.isVisible()) {
            return;
        }
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        DataPointHints[] dpha = srh.getDataPoints();
        LineAttributes lia = ss.getLineAttributes();
        double[] faX = new double[dpha.length];
        double[] faY = new double[dpha.length];
        SeriesDefinition sd = this.getSeriesDefinition();
        EList elPalette = sd.getSeriesPalette().getEntries();
        int iPaletteSize = elPalette.size();
        if (iPaletteSize == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{ss}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && ss.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)ss.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ss)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ss, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Marker m = null;
        if (ss.getMarkers().size() > 0) {
            m = (Marker)ss.getMarkers().get(iThisSeriesIndex % ss.getMarkers().size());
        }
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
            this.updateTranslucency(fPaletteEntry, (Series)ss);
        }
        for (int i3 = 0; i3 < dpha.length; ++i3) {
            Location lo = dpha[i3].getLocation();
            faX[i3] = lo.getX();
            faY[i3] = lo.getY();
        }
        if (ss.isSetCurve() && ss.isCurve()) {
            CurveRenderer cr = new CurveRenderer(cwa, (BaseRenderer)this, ss.getLineAttributes(), LocationImpl.create((double[])faX, (double[])faY), false, -1.0, false, true, fPaletteEntry, ss.isSetPaletteLineColor() && ss.isPaletteLineColor(), true);
            cr.draw(ipr);
            this.renderShadowAsCurve(ipr, lia, (ISeriesRenderingHints)srh, LocationImpl.create((double[])faX, (double[])faY), false, -1.0);
            if (m != null && m.isSetType()) {
                for (int i4 = 0; i4 < dpha.length; ++i4) {
                    fPaletteEntry = bPaletteByCategory ? (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(i4 % iPaletteSize))) : (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
                    this.updateTranslucency(fPaletteEntry, (Series)ss);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i4], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i4], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i4]);
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i4]);
                    this.renderMarker(ss, ipr, m, LocationImpl.create((double)faX[i4], (double)faY[i4]), ss.getLineAttributes(), fPaletteEntry, dpha[i4], -1, false, true);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i4], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i4], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i4]);
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i4]);
                }
            }
        } else {
            if (!lia.isSetVisible()) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.visibility.line.unset", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
            Location positionDelta = cwa.isTransposed() ? LocationImpl.create((double)(-3.0 * this.getDeviceScale()), (double)0.0) : LocationImpl.create((double)0.0, (double)(3.0 * this.getDeviceScale()));
            Location[] loaShadow = null;
            LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)ss), LineRenderEvent.class);
            ColorDefinition cLineShadow = ss.getShadowColor();
            if (!ChartUtil.isColorTransparent((ColorDefinition)cLineShadow)) {
                for (i2 = 1; i2 < dpha.length; ++i2) {
                    int pindex;
                    if (Scatter.isNaN((Object)dpha[i2].getOrthogonalValue()) || (pindex = this.getPreviousNonNullIndex(i2, dpha)) == -1) continue;
                    if (loaShadow == null) {
                        loaShadow = new Location[]{LocationImpl.create((double)(faX[pindex] + positionDelta.getX()), (double)(faY[pindex] + positionDelta.getY())), LocationImpl.create((double)(faX[i2] + positionDelta.getX()), (double)(faY[i2] + positionDelta.getY()))};
                    } else {
                        loaShadow[0].set(faX[pindex] + positionDelta.getX(), faY[pindex] + positionDelta.getY());
                        loaShadow[1].set(faX[i2] + positionDelta.getX(), faY[i2] + positionDelta.getY());
                    }
                    lre.setStart(loaShadow[0]);
                    lre.setEnd(loaShadow[1]);
                    LineAttributes liaShadow = LineAttributesImpl.copyInstance((LineAttributes)lia);
                    liaShadow.setColor(cLineShadow);
                    lre.setLineAttributes(liaShadow);
                    ipr.drawLine(lre);
                }
            }
            if (lia.isVisible()) {
                Location[] loa = new Location[2];
                for (i = 1; i < dpha.length; ++i) {
                    int pindex;
                    if (Scatter.isNaN((Object)dpha[i].getOrthogonalValue()) || (pindex = this.getPreviousNonNullIndex(i, dpha)) == -1) continue;
                    loa[0] = LocationImpl.create((double)faX[pindex], (double)faY[pindex]);
                    loa[1] = LocationImpl.create((double)faX[i], (double)faY[i]);
                    lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)ss), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? Scatter.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                    if (ss.isSetPaletteLineColor() && ss.isPaletteLineColor() && fPaletteEntry instanceof ColorDefinition) {
                        LineAttributes newLia = LineAttributesImpl.copyInstance((LineAttributes)lia);
                        newLia.setColor((ColorDefinition)fPaletteEntry);
                        lre.setLineAttributes(newLia);
                    } else {
                        lre.setLineAttributes(lia);
                    }
                    lre.setStart(loa[0]);
                    lre.setEnd(loa[1]);
                    ipr.drawLine(lre);
                }
            }
            if (m != null && m.isSetType()) {
                for (i2 = 0; i2 < dpha.length; ++i2) {
                    fPaletteEntry = bPaletteByCategory ? (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(i2 % iPaletteSize))) : (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
                    this.updateTranslucency(fPaletteEntry, (Series)ss);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i2], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i2], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i2]);
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i2]);
                    this.renderMarker(ss, ipr, m, LocationImpl.create((double)faX[i2], (double)faY[i2]), ss.getLineAttributes(), fPaletteEntry, dpha[i2], -1, false, true);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i2], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i2], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i2]);
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i2]);
                }
            }
        }
        Label laDataPoint = null;
        Position pDataPoint = null;
        Location loDataPoint = null;
        try {
            laDataPoint = srh.getLabelAttributes((Series)ss);
            pDataPoint = srh.getLabelPosition((Series)ss);
            loDataPoint = LocationImpl.create((double)0.0, (double)0.0);
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
        }
        if (laDataPoint.isVisible()) {
            double dSize = m == null ? 0.0 : (double)m.getSize();
            for (i = 0; i < dpha.length; ++i) {
                if (Scatter.isNaN((Object)dpha[i].getOrthogonalValue())) continue;
                laDataPoint.getCaption().setValue(dpha[i].getDisplayValue());
                switch (pDataPoint.getValue()) {
                    case 0: {
                        loDataPoint.set(faX[i], faY[i] - dSize - (double)p.getVerticalSpacing());
                        break;
                    }
                    case 1: {
                        loDataPoint.set(faX[i], faY[i] + dSize + (double)p.getVerticalSpacing());
                        break;
                    }
                    case 2: {
                        loDataPoint.set(faX[i] - dSize - (double)p.getHorizontalSpacing(), faY[i]);
                        break;
                    }
                    case 3: {
                        loDataPoint.set(faX[i] + dSize + (double)p.getHorizontalSpacing(), faY[i]);
                        break;
                    }
                    default: {
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.invalid.data.point.position.scatter", new Object[]{pDataPoint}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                    }
                }
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)dpha[i]);
                if (laDataPoint.isVisible()) {
                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)ss, (DataPointHints)dpha[i]), 2, laDataPoint, pDataPoint, loDataPoint, null);
                }
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)dpha[i]);
            }
        }
        if (this.getSeries().getCurveFitting() != null) {
            Location[] larray = new Location[faX.length];
            for (i2 = 0; i2 < larray.length; ++i2) {
                larray[i2] = LocationImpl.create((double)faX[i2], (double)faY[i2]);
            }
            larray = Scatter.filterNull((Location[])larray);
            this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), false, true);
        }
    }
}

