/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.IRequestConvert;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.lib.commands.SetCurrentEditModelCommand;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.IDEMultiPageReportEditor;
import org.eclipse.birt.report.designer.ui.editors.pages.ReportXMLSourceEditorFormPage;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.api.TemplateParameterDefinitionHandle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;

class BIRTGotoMarker
implements IGotoMarker {
    protected IDEMultiPageReportEditor editorPart;

    public BIRTGotoMarker(IDEMultiPageReportEditor editorPart) {
        this.editorPart = editorPart;
    }

    public void gotoMarker(IMarker marker) {
        Assert.isNotNull((Object)((Object)this.editorPart));
        if (!marker.exists()) {
            return;
        }
        ModuleHandle moduleHandle = this.editorPart.getModel();
        ReportElementHandle reportElementHandle = null;
        reportElementHandle = this.getReportElementHandle(moduleHandle, marker);
        if (reportElementHandle == null || reportElementHandle != null && this.isElementTemplateParameterDefinition((DesignElementHandle)reportElementHandle)) {
            this.gotoXMLSourcePage(moduleHandle, marker);
        } else if (moduleHandle instanceof ReportDesignHandle) {
            if (this.isElementInMasterPage((DesignElementHandle)reportElementHandle)) {
                this.gotoLayoutPage("org.eclipse.birt.report.designer.ui.editors.masterpage", marker, reportElementHandle);
            } else {
                this.gotoLayoutPage("org.eclipse.birt.report.designer.ui.editors.layout", marker, reportElementHandle);
            }
        } else if (moduleHandle instanceof LibraryHandle) {
            if (this.isElementInMasterPage((DesignElementHandle)reportElementHandle)) {
                this.gotoLayoutPage("org.eclipse.birt.report.designer.ui.editors.masterpage", marker, reportElementHandle);
            } else {
                this.gotoLibraryLayoutPage(marker, reportElementHandle);
            }
        }
    }

    protected void gotoLibraryLayoutPage(IMarker marker, ReportElementHandle reportElementHandle) {
        String pageId = "org.eclipse.birt.report.designer.ui.editors.library.layout";
        if (!this.activatePage(pageId)) {
            return;
        }
        ModuleHandle moduleHandle = this.editorPart.getModel();
        reportElementHandle = this.getReportElementHandle(moduleHandle, marker);
        if (reportElementHandle != null && !this.isElementInMasterPage((DesignElementHandle)reportElementHandle)) {
            SetCurrentEditModelCommand command = new SetCurrentEditModelCommand((Object)reportElementHandle);
            command.execute();
        } else {
            MessageDialog.openError((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"BIRTGotoMarker.Error.Title"), (String)Messages.getString((String)"BIRTGotoMarker.Error.Message"));
        }
    }

    protected void gotoLayoutPage(String pageId, final IMarker marker, final ReportElementHandle reportElementHandle) {
        if (!this.activatePage(pageId)) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                BIRTGotoMarker.this.gotoLayoutMarker(marker, reportElementHandle);
            }
        });
    }

    protected void gotoXMLSourcePage(ModuleHandle moduleHandle, final IMarker marker) {
        String pageId = "org.eclipse.birt.report.designer.ui.editors.xmlsource";
        if (!this.activatePage(pageId)) {
            return;
        }
        final ReportXMLSourceEditorFormPage xmlSourceEditorFormPage = (ReportXMLSourceEditorFormPage)this.editorPart.getActivePageInstance();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                BIRTGotoMarker.this.gotoXMLSourceMarker((AbstractTextEditor)xmlSourceEditorFormPage, marker);
            }
        });
    }

    protected boolean activatePage(String pageId) {
        String currentId = this.editorPart.getActivePageInstance().getId();
        if (pageId.equals(currentId)) {
            return true;
        }
        IFormPage formPage = this.editorPart.setActivePage(pageId);
        return formPage != null;
    }

    protected ReportElementHandle getReportElementHandle(ModuleHandle moduleHandle, IMarker marker) {
        Integer elementId = new Integer(0);
        try {
            elementId = (Integer)marker.getAttribute("ElementId");
        }
        catch (CoreException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        DesignElementHandle elementHandle = null;
        if (elementId != null && elementId > 0) {
            elementHandle = moduleHandle.getElementByID((long)elementId.intValue());
            if (elementHandle == null || !(elementHandle instanceof ReportElementHandle)) {
                return null;
            }
            if (elementHandle instanceof CellHandle || elementHandle instanceof ColumnHandle || elementHandle instanceof MasterPageHandle || elementHandle instanceof ReportItemHandle || elementHandle instanceof RowHandle || elementHandle instanceof TemplateElementHandle) {
                return (ReportElementHandle)elementHandle;
            }
        }
        return null;
    }

    protected void gotoLayoutMarker(IMarker marker, ReportElementHandle reportElementHandle) {
        ModuleHandle moduleHandle = this.editorPart.getModel();
        reportElementHandle = this.getReportElementHandle(moduleHandle, marker);
        if (reportElementHandle == null) {
            MessageDialog.openError((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"BIRTGotoMarker.Error.Title"), (String)Messages.getString((String)"BIRTGotoMarker.Error.Message"));
            return;
        }
        ArrayList<ReportElementHandle> list = new ArrayList<ReportElementHandle>();
        list.add(reportElementHandle);
        ReportRequest r = new ReportRequest();
        r.setType((Object)"selection");
        r.setRequestConvert(new IRequestConvert(){

            public List convertSelectionToModelLisr(List list) {
                ArrayList lst = new ArrayList();
                Iterator itr = list.iterator();
                while (itr.hasNext()) {
                    Object obj = itr.next();
                    lst.add(obj);
                }
                return lst;
            }
        });
        r.setSelectionObject(list);
        SessionHandleAdapter.getInstance().getMediator().notifyRequest(r);
    }

    protected void gotoXMLSourceMarker(AbstractTextEditor editorFormPage, IMarker marker) {
        int length;
        int start = MarkerUtilities.getCharStart((IMarker)marker);
        int end = MarkerUtilities.getCharEnd((IMarker)marker);
        boolean selectLine = start < 0 || end < 0;
        IAnnotationModel model = editorFormPage.getDocumentProvider().getAnnotationModel((Object)editorFormPage.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
            Position pos = markerModel.getMarkerPosition(marker);
            if (pos != null && !pos.isDeleted()) {
                start = pos.getOffset();
                end = pos.getOffset() + pos.getLength();
            }
            if (pos != null && pos.isDeleted()) {
                return;
            }
        }
        IDocument document = editorFormPage.getDocumentProvider().getDocument((Object)editorFormPage.getEditorInput());
        if (selectLine) {
            try {
                int line;
                if (start >= 0) {
                    line = document.getLineOfOffset(start);
                } else {
                    line = MarkerUtilities.getLineNumber((IMarker)marker);
                    if (line >= 1) {
                        --line;
                    }
                    start = document.getLineOffset(line);
                }
                end = start + document.getLineLength(line) - 1;
            }
            catch (BadLocationException e) {
                return;
            }
        }
        if (end - 1 < (length = document.getLength()) && start < length) {
            editorFormPage.selectAndReveal(start, end - start);
        }
    }

    protected boolean isElementInMasterPage(DesignElementHandle elementHandle) {
        ModuleHandle root = elementHandle.getRoot();
        for (DesignElementHandle container = elementHandle; container != null && container != root; container = container.getContainer()) {
            if (!(container instanceof MasterPageHandle)) continue;
            return true;
        }
        return false;
    }

    protected boolean isElementTemplateParameterDefinition(DesignElementHandle elementHandle) {
        ModuleHandle root = elementHandle.getRoot();
        for (DesignElementHandle container = elementHandle; container != null && container != root; container = container.getContainer()) {
            if (!(container instanceof TemplateParameterDefinitionHandle)) continue;
            return true;
        }
        return false;
    }
}

