/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.navigator;

import java.io.File;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.wizards.PublishLibraryWizard;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class PublishLibraryNavigatorAction
implements IViewActionDelegate {
    protected ResourceNavigator navigator;

    public void init(IViewPart view) {
        if (view instanceof ResourceNavigator) {
            this.navigator = (ResourceNavigator)view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IAction action) {
        IFile file = this.getSelectedFile();
        if (file == null) {
            return;
        }
        String url = file.getLocation().toOSString();
        LibraryHandle handle = null;
        try {
            handle = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(url);
            if (!(handle instanceof LibraryHandle)) {
                action.setEnabled(false);
                return;
            }
            String filePath = handle.getFileName();
            String fileName = null;
            if (filePath != null && filePath.length() != 0) {
                fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            }
            PublishLibraryWizard publishLibrary = new PublishLibraryWizard(handle, fileName, ReportPlugin.getDefault().getResourceFolder());
            WizardDialog dialog = new WizardDialog(UIUtil.getDefaultShell(), (IWizard)publishLibrary);
            dialog.setPageSize(500, 250);
            dialog.open();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return;
        }
        finally {
            if (handle != null) {
                handle.close();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected IFile getSelectedFile() {
        IStructuredSelection selection;
        if (this.navigator != null && (selection = (IStructuredSelection)this.navigator.getTreeViewer().getSelection()).size() == 1 && selection.getFirstElement() instanceof IFile) {
            return (IFile)selection.getFirstElement();
        }
        return null;
    }
}

