/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.wizards;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardTemplateChoicePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.ide.wizards.WizardNewReportCreationPage;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.osgi.framework.Bundle;

public class NewReportWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewReportWizard.text.OpenFileForEditing");
    private static final String CREATING = Messages.getString((String)"NewReportWizard.text.Creating");
    private static final String NEW_REPORT_FILE_NAME_PREFIX = Messages.getString((String)"NewReportWizard.displayName.NewReportFileNamePrefix");
    private static final String NEW_REPORT_FILE_EXTENSION = Messages.getString((String)"NewReportWizard.displayName.NewReportFileExtension");
    private static final String SELECT_A_REPORT_TEMPLATE = Messages.getString((String)"NewReportWizard.text.SelectTemplate");
    private static final String CREATE_A_NEW_REPORT = Messages.getString((String)"NewReportWizard.text.CreateReport");
    String REPORT = Messages.getString((String)"NewReportWizard.title.Report");
    private static final String TEMPLATECHOICEPAGE = Messages.getString((String)"NewReportWizard.title.Template");
    private static final String WIZARDPAGE = Messages.getString((String)"NewReportWizard.title.WizardPage");
    private static final String NEW = Messages.getString((String)"NewReportWizard.title.New");
    private IStructuredSelection selection;
    WizardNewReportCreationPage newReportFileWizardPage;
    WizardReportSettingPage settingPage;
    private WizardTemplateChoicePage templateChoicePage;
    private int UNIQUE_COUNTER = 0;
    private String fileExtension = "rptdesign";
    private static final List tmpList = new ArrayList();
    private IConfigurationElement configElement;

    public NewReportWizard() {
    }

    public NewReportWizard(String fileType) {
        this.fileExtension = fileType;
    }

    public boolean performFinish() {
        final IPath containerName = this.newReportFileWizardPage.getContainerFullPath();
        String fn = this.newReportFileWizardPage.getFileName();
        final String fileName = !fn.endsWith("." + this.fileExtension) ? fn + "." + this.fileExtension : fn;
        InputStream streamFromPage = null;
        String cheatSheetIdFromPage = "";
        boolean showCheatSheetFromPage = false;
        WizardTemplateChoicePage.Template selTemplate = this.templateChoicePage.getTemplate();
        String fullName = selTemplate.getReportFullName();
        URL url = Platform.find((Bundle)Platform.getBundle((String)"org.eclipse.birt.report.designer.ui"), (IPath)new Path(fullName));
        if (url != null) {
            try {
                streamFromPage = url.openStream();
            }
            catch (IOException e1) {}
        } else {
            try {
                streamFromPage = new FileInputStream(fullName);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        cheatSheetIdFromPage = this.templateChoicePage.getTemplate().getCheatSheetId();
        showCheatSheetFromPage = this.templateChoicePage.getShowCheatSheet();
        final InputStream stream = streamFromPage;
        final String cheatSheetId = cheatSheetIdFromPage;
        final boolean showCheatSheet = showCheatSheetFromPage;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    NewReportWizard.this.doFinish(containerName, fileName, stream, cheatSheetId, showCheatSheet, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionHandler.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        boolean foundOpenProject = false;
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].isOpen()) continue;
            foundOpenProject = true;
            break;
        }
        if (!foundOpenProject) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"NewReportWizard.title.Error"), (String)Messages.getString((String)"NewReportWizard.error.NoProject"));
        }
        this.selection = selection;
        this.setWindowTitle(NEW);
    }

    public Image getDefaultPageImage() {
        return ReportPlugin.getImage((String)"/icons/wizban/create_report_wizard.gif");
    }

    public void addPages() {
        this.newReportFileWizardPage = new WizardNewReportCreationPage(WIZARDPAGE, this.selection, this.fileExtension);
        this.addPage((IWizardPage)this.newReportFileWizardPage);
        this.templateChoicePage = new WizardTemplateChoicePage(TEMPLATECHOICEPAGE);
        this.addPage((IWizardPage)this.templateChoicePage);
        this.newReportFileWizardPage.setTitle(this.REPORT);
        this.newReportFileWizardPage.setDescription(CREATE_A_NEW_REPORT);
        this.templateChoicePage.setTitle(this.REPORT);
        this.templateChoicePage.setDescription(SELECT_A_REPORT_TEMPLATE);
        this.resetUniqueCount();
        this.newReportFileWizardPage.setFileName(this.getUniqueReportName(NEW_REPORT_FILE_NAME_PREFIX, NEW_REPORT_FILE_EXTENSION));
        this.newReportFileWizardPage.setContainerFullPath(this.getDefaultContainerPath());
    }

    void resetUniqueCount() {
        this.UNIQUE_COUNTER = 0;
    }

    IPath getDefaultContainerPath() {
        IEditorPart editor;
        IWorkbenchWindow benchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPart part = benchWindow.getPartService().getActivePart();
        Object selection = null;
        if (part instanceof IEditorPart) {
            selection = ((IEditorPart)part).getEditorInput();
        } else {
            ISelection sel = benchWindow.getSelectionService().getSelection();
            if (sel != null && sel instanceof IStructuredSelection) {
                selection = ((IStructuredSelection)sel).getFirstElement();
            }
        }
        IContainer ct = this.getDefaultContainer(selection);
        if (ct == null && (editor = UIUtil.getActiveEditor((boolean)true)) != null) {
            ct = this.getDefaultContainer(editor.getEditorInput());
        }
        if (ct != null) {
            return ct.getFullPath();
        }
        return null;
    }

    private IContainer getDefaultContainer(Object selection) {
        IContainer ct = null;
        if (selection instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)selection).getAdapter(IResource.class);
            if (resource instanceof IContainer && resource.isAccessible()) {
                ct = (IContainer)resource;
            } else if (resource != null && resource.getParent() != null && resource.getParent().isAccessible()) {
                ct = resource.getParent();
            }
        }
        return ct;
    }

    String getUniqueReportName(String prefix, String ext) {
        int counter = this.getCounter(prefix, ext);
        return counter == 0 ? prefix + ext : prefix + "_" + counter + ext;
    }

    int getCounter(String prefix, String ext) {
        IProject[] pjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.resetUniqueCount();
        boolean goon = true;
        block0: while (goon) {
            goon = false;
            for (int i = 0; i < pjs.length; ++i) {
                if (!pjs[i].isAccessible() || this.validDuplicate(prefix, ext, this.UNIQUE_COUNTER, (IResource)pjs[i])) continue;
                ++this.UNIQUE_COUNTER;
                goon = true;
                continue block0;
            }
        }
        return this.UNIQUE_COUNTER;
    }

    boolean validDuplicate(String prefix, String ext, int count, IResource res) {
        if (res != null && res.isAccessible()) {
            final String name = count == 0 ? prefix + ext : prefix + "_" + count + ext;
            try {
                tmpList.clear();
                res.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource.getType() == 1 && name.equals(((IFile)resource).getName())) {
                            tmpList.add(Boolean.TRUE);
                        }
                        return true;
                    }
                }, 2, true);
                if (tmpList.size() > 0) {
                    return false;
                }
            }
            catch (CoreException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return true;
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return workspaceRoot.getFolder(folderPath);
    }

    private void doFinish(IPath containerName, String fileName, InputStream stream, String cheatSheetId, boolean showCheatSheet, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CREATING + fileName, 2);
        IContainer resource = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(containerName);
        IContainer container = null;
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            IFolder folder = this.createFolderHandle(containerName);
            UIUtil.createFolder((IFolder)folder, (IProgressMonitor)monitor);
            container = folder;
        } else {
            container = resource;
        }
        final IFile file = container.getFile((IPath)new Path(fileName));
        final String cheatId = cheatSheetId;
        final boolean showCheat = showCheatSheet;
        try {
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
                    if (ReportPlugin.getDefault().getEnableCommentPreference()) {
                        model.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference());
                        model.save();
                        editorPart.doSave(null);
                    }
                    BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)NewReportWizard.this.configElement);
                    if (showCheat && !cheatId.equals("")) {
                        OpenCheatSheetAction action = null;
                        action = new OpenCheatSheetAction(cheatId);
                        action.run();
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
    }

    public boolean canFinish() {
        return this.templateChoicePage.isPageComplete() && this.newReportFileWizardPage.isPageComplete();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }
}

