/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.wizards;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ide.wizards.WizardSaveAsPage;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class SaveReportAsWizard
extends Wizard {
    private ModuleHandle model;
    private IFile orginalFile;
    private WizardSaveAsPage saveAsPage;
    private WizardReportSettingPage settingPage;
    private IPath saveAsPath;

    public SaveReportAsWizard(ModuleHandle model, IFile orginalFile) {
        this.setWindowTitle(Messages.getString((String)"SaveReportAsWizard.SaveAsPageTitle"));
        this.model = model;
        this.orginalFile = orginalFile;
    }

    public void addPages() {
        this.saveAsPage = new WizardSaveAsPage("WizardSaveAsPage");
        this.saveAsPage.setModel(this.model);
        this.saveAsPage.setOriginalFile(this.orginalFile);
        this.saveAsPage.setTitle(Messages.getString((String)"SaveReportAsWizard.SaveAsPageTitle"));
        if (this.model instanceof ReportDesignHandle) {
            this.saveAsPage.setDescription(Messages.getString((String)"SaveReportAsWizard.SaveAsReportorTemplateMessage"));
        } else if (this.model instanceof LibraryHandle) {
            this.saveAsPage.setDescription(Messages.getString((String)"SaveReportAsWizard.SaveAsLibraryMessage"));
        }
        this.addPage((IWizardPage)this.saveAsPage);
        if (this.model instanceof ReportDesignHandle) {
            this.settingPage = new WizardReportSettingPage((ReportDesignHandle)this.model);
            this.settingPage.setTitle(Messages.getString((String)"SaveReportAsWizard.SettingPage.title"));
            this.settingPage.setMessage(Messages.getString((String)"SaveReportAsWizard.SettingPage.message"));
            this.addPage((IWizardPage)this.settingPage);
        }
    }

    public boolean canFinish() {
        return this.saveAsPage.validatePage();
    }

    public boolean performFinish() {
        this.saveAsPath = this.saveAsPage.getResult();
        if (this.saveAsPath != null && this.model instanceof ReportDesignHandle) {
            ReportDesignHandle reportHandle = (ReportDesignHandle)this.model;
            try {
                reportHandle.setDisplayName(this.settingPage.getDisplayName());
                reportHandle.setDescription(this.settingPage.getDescription());
                reportHandle.setIconFile(this.settingPage.getPreviewImagePath());
                reportHandle.setFileName(this.saveAsPath.toOSString());
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return true;
    }

    public IPath getSaveAsPath() {
        return this.saveAsPath;
    }
}

