/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    int scope = 0;
    int startPage = 1;
    int endPage = 1;
    boolean printToFile = false;
    static /* synthetic */ Class class$0;

    public PrintDialog(Shell parent) {
        this(parent, 32768);
    }

    public PrintDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    public boolean getPrintToFile() {
        return this.printToFile;
    }

    public void setPrintToFile(boolean printToFile) {
        this.printToFile = printToFile;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.PrintDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            SWT.error(43);
        }
    }

    public PrinterData open() {
        PRINTDLG pd = new PRINTDLG();
        pd.lStructSize = 66;
        Shell parent = this.getParent();
        if (parent != null) {
            pd.hwndOwner = parent.handle;
        }
        pd.Flags = 262144;
        if (this.printToFile) {
            pd.Flags |= 0x20;
        }
        switch (this.scope) {
            case 1: {
                pd.Flags |= 2;
                break;
            }
            case 2: {
                pd.Flags |= 1;
                break;
            }
            default: {
                pd.Flags |= 0;
            }
        }
        pd.nMinPage = 1;
        pd.nMaxPage = (short)-1;
        pd.nFromPage = (short)Math.min(65535, Math.max(1, this.startPage));
        pd.nToPage = (short)Math.min(65535, Math.max(1, this.endPage));
        Display display = parent.getDisplay();
        Shell[] shells = display.getShells();
        if ((this.getStyle() & 0x30000) != 0) {
            int i = 0;
            while (i < shells.length) {
                if (shells[i].isEnabled() && shells[i] != parent) {
                    shells[i].setEnabled(false);
                } else {
                    shells[i] = null;
                }
                ++i;
            }
        }
        PrinterData data = null;
        String key = "org.eclipse.swt.internal.win32.runMessagesInIdle";
        Object oldValue = display.getData(key);
        display.setData(key, new Boolean(true));
        boolean success = OS.PrintDlg(pd);
        display.setData(key, oldValue);
        if ((this.getStyle() & 0x30000) != 0) {
            int i = 0;
            while (i < shells.length) {
                if (shells[i] != null && !shells[i].isDisposed()) {
                    shells[i].setEnabled(true);
                }
                ++i;
            }
        }
        if (success) {
            int hMem = pd.hDevNames;
            int size = OS.GlobalSize(hMem) / TCHAR.sizeof * TCHAR.sizeof;
            int ptr = OS.GlobalLock(hMem);
            short[] offsets = new short[4];
            OS.MoveMemory(offsets, ptr, 2 * offsets.length);
            TCHAR buffer = new TCHAR(0, size);
            OS.MoveMemory(buffer, ptr, size);
            OS.GlobalUnlock(hMem);
            short driverOffset = offsets[0];
            int i = 0;
            while (driverOffset + i < size) {
                if (buffer.tcharAt(driverOffset + i) == 0) break;
                ++i;
            }
            String driver = buffer.toString(driverOffset, i);
            short deviceOffset = offsets[1];
            i = 0;
            while (deviceOffset + i < size) {
                if (buffer.tcharAt(deviceOffset + i) == 0) break;
                ++i;
            }
            String device = buffer.toString(deviceOffset, i);
            short outputOffset = offsets[2];
            i = 0;
            while (outputOffset + i < size) {
                if (buffer.tcharAt(outputOffset + i) == 0) break;
                ++i;
            }
            String output = buffer.toString(outputOffset, i);
            data = new PrinterData(driver, device);
            if ((pd.Flags & 2) != 0) {
                data.scope = 1;
                data.startPage = pd.nFromPage & 0xFFFF;
                data.endPage = pd.nToPage & 0xFFFF;
            } else if ((pd.Flags & 1) != 0) {
                data.scope = 2;
            }
            boolean bl = data.printToFile = (pd.Flags & 0x20) != 0;
            if (data.printToFile) {
                data.fileName = output;
            }
            data.copyCount = pd.nCopies;
            data.collate = (pd.Flags & 0x10) != 0;
            hMem = pd.hDevMode;
            size = OS.GlobalSize(hMem);
            ptr = OS.GlobalLock(hMem);
            data.otherData = new byte[size];
            OS.MoveMemory(data.otherData, ptr, size);
            OS.GlobalUnlock(hMem);
            this.endPage = data.endPage;
            this.printToFile = data.printToFile;
            this.scope = data.scope;
            this.startPage = data.startPage;
        }
        return data;
    }
}

