/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.ui.wizards;

import java.util.List;
import org.eclipse.birt.report.data.oda.xml.ui.Messages;
import org.eclipse.birt.report.data.oda.xml.ui.UiPlugin;
import org.eclipse.birt.report.data.oda.xml.ui.utils.ExceptionHandler;
import org.eclipse.birt.report.data.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.birt.report.data.oda.xml.ui.wizards.ColumnMappingPage;
import org.eclipse.birt.report.data.oda.xml.ui.wizards.DataSetDesignPopulator;
import org.eclipse.birt.report.data.oda.xml.ui.wizards.RowMappingDialog;
import org.eclipse.birt.report.data.oda.xml.ui.wizards.XMLInformationHolder;
import org.eclipse.birt.report.data.oda.xml.util.ui.ATreeNode;
import org.eclipse.birt.report.data.oda.xml.util.ui.SchemaPopulationUtil;
import org.eclipse.birt.report.data.oda.xml.util.ui.XPathPopulationUtil;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class XPathChoosePage
extends DataSetWizardPage {
    private static String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectXPath");
    private transient Tree availableXmlTree;
    private transient Button btnAdd;
    private transient Composite btnComposite;
    private transient Text xmlPathText;
    private transient Group treeGroup;
    private transient Group rightGroup;
    private ATreeNode treeNode;
    private TreeItem selectedItem;
    private String fileName;
    private String rootPath;
    private String initRootPath;
    private boolean isInitialized = false;

    public XPathChoosePage() {
        this(Messages.getString("wizard.title.newDataSet"));
    }

    public XPathChoosePage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(false);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        this.populateXMLTree();
        XMLRelationInfoUtil.setSystemHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_XMLXPath_ID");
        this.isInitialized = true;
    }

    private void initializeControl() {
        String queryText;
        String tableName;
        this.fileName = XMLInformationHolder.getPropertyValue("SCHEMAFILELIST");
        if (this.fileName == null || this.fileName.trim().equals("")) {
            this.fileName = XMLInformationHolder.getPropertyValue("FILELIST");
        }
        this.rootPath = (tableName = XMLRelationInfoUtil.getTableName(queryText = XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"))) != null ? XMLRelationInfoUtil.getXPathExpression(queryText, tableName) : "";
        this.backupRootPath();
        this.xmlPathText.setText(this.rootPath);
    }

    private void backupRootPath() {
        this.initRootPath = this.rootPath;
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        DEFAULT_MESSAGE = Messages.getString("xPathChoosePage.messages.rowMapping");
        XMLInformationHolder.start(dataSetDesign);
        this.fileName = XMLInformationHolder.getPropertyValue("SCHEMAFILELIST");
        if (this.fileName == null || this.fileName.trim().equals("")) {
            this.fileName = XMLInformationHolder.getPropertyValue("FILELIST");
        }
        this.populateXMLTree();
        this.backupRootPath();
        this.setMessage(DEFAULT_MESSAGE);
    }

    public Control createPageControl(Composite parent) {
        DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectXPath");
        this.setMessage(DEFAULT_MESSAGE);
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        this.createLeftGroup(composite);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.treeGroup, 5);
        data.bottom = new FormAttachment(50);
        this.btnComposite = new Composite(composite, 0);
        this.btnComposite.setLayoutData((Object)data);
        FillLayout btnLayout = new FillLayout(512);
        btnLayout.spacing = 3;
        this.btnComposite.setLayout((Layout)btnLayout);
        this.btnAdd = new Button(this.btnComposite, 0);
        this.btnAdd.setText(">");
        this.btnAdd.setEnabled(false);
        this.btnAdd.setToolTipText("Use the selected node as XPath expression");
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowMappingDialog dialog;
                List xpathList = XPathChoosePage.this.getSelectedXPath();
                if (xpathList != null && (dialog = new RowMappingDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString("RowMappingDialog.title"), xpathList)).open() == 0) {
                    XPathChoosePage.this.rootPath = dialog.getSelectedPath();
                    XPathChoosePage.this.xmlPathText.setText(XPathChoosePage.this.rootPath);
                }
            }
        });
        this.createRightGroup(composite);
        return composite;
    }

    private void createLeftGroup(Composite composite2) {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(47, -5);
        data.bottom = new FormAttachment(100, -5);
        this.treeGroup = new Group(composite2, 0);
        this.treeGroup.setLayout((Layout)new FillLayout());
        this.treeGroup.setLayoutData((Object)data);
        this.availableXmlTree = new Tree((Composite)this.treeGroup, 2818);
        this.availableXmlTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = XPathChoosePage.this.availableXmlTree.getSelection();
                for (int i = 0; i < items.length; ++i) {
                    XPathChoosePage.this.selectedItem = items[0];
                    if (!items[i].getGrayed()) continue;
                    XPathChoosePage.this.availableXmlTree.setRedraw(false);
                    XPathChoosePage.this.availableXmlTree.deselectAll();
                    XPathChoosePage.this.availableXmlTree.setRedraw(true);
                    XPathChoosePage.this.availableXmlTree.redraw();
                }
                if (XPathChoosePage.this.selectedItem != null) {
                    XPathChoosePage.this.btnAdd.setEnabled(true);
                } else {
                    XPathChoosePage.this.btnAdd.setEnabled(false);
                }
            }
        });
        this.treeGroup.setText(Messages.getString("xPathChoosePage.messages.xmlStructure"));
    }

    private void createRightGroup(Composite composite2) {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.btnComposite, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        this.rightGroup = new Group(composite2, 0);
        this.rightGroup.setLayout((Layout)new FormLayout());
        this.rightGroup.setText(Messages.getString("xPathChoosePage.messages.rowMapping"));
        this.rightGroup.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        Label label = new Label((Composite)this.rightGroup, 0);
        label.setText(Messages.getString("xPathChoosePage.messages.xPathExpression"));
        label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 25);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.xmlPathText = new Text((Composite)this.rightGroup, 2048);
        this.xmlPathText.setLayoutData((Object)data);
        this.xmlPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XPathChoosePage.this.rootPath = XPathChoosePage.this.xmlPathText.getText();
                XPathChoosePage.this.setPageStatus();
            }
        });
    }

    protected List getSelectedXPath() {
        ATreeNode node;
        TreeItem selected = this.selectedItem;
        if (selected.getData() instanceof ATreeNode) {
            node = (ATreeNode)selected.getData();
            if (node.getType() == 2) {
                return null;
            }
            this.rootPath = "/" + selected.getText();
        }
        while (selected.getParentItem() != null) {
            if (!((selected = selected.getParentItem()).getData() instanceof ATreeNode) || (node = (ATreeNode)selected.getData()).getType() != 1) continue;
            this.rootPath = "/" + selected.getText() + this.rootPath;
        }
        return XPathPopulationUtil.populateRootPath((String)this.rootPath);
    }

    private void populateXMLTree() {
        try {
            this.availableXmlTree.removeAll();
            if (this.fileName != null && this.fileName.trim().length() > 0) {
                int numberOfElement = 0;
                Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
                if (preferences.contains("user_max_num_of_element_passed")) {
                    numberOfElement = preferences.getInt("user_max_num_of_element_passed");
                } else {
                    numberOfElement = 100000;
                    preferences.setValue("user_max_num_of_element_passed", numberOfElement);
                }
                this.treeNode = SchemaPopulationUtil.getSchemaTree((String)this.fileName, (boolean)false, (int)numberOfElement);
                if (this.treeNode == null || this.treeNode.getChildren().length == 0) {
                    OdaException ex = new OdaException(Messages.getString("dataset.error.populateXMLTree"));
                    ExceptionHandler.showException(this.getShell(), Messages.getString("error.label"), ex.getMessage(), ex);
                } else {
                    Object[] childs = this.treeNode.getChildren();
                    this.populateTreeItems(this.availableXmlTree, childs, 0);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.showException(this.getShell(), Messages.getString("error.label"), e.getMessage(), e);
        }
    }

    private void populateTreeItems(Object tree, Object[] node, int level) {
        if (++level > 10) {
            return;
        }
        for (int i = 0; i < node.length; ++i) {
            TreeItem treeItem = tree instanceof Tree ? new TreeItem((Tree)tree, 0) : new TreeItem((TreeItem)tree, 0);
            ATreeNode treeNode = (ATreeNode)node[i];
            treeItem.setData((Object)treeNode);
            int type = treeNode.getType();
            if (type == 2) {
                treeItem.setText("@" + treeNode.getValue().toString());
            } else {
                treeItem.setText(treeNode.getValue().toString());
            }
            if (treeNode.getChildren() == null || treeNode.getChildren().length <= 0) continue;
            this.populateTreeItems(treeItem, treeNode.getChildren(), level);
        }
    }

    private void setPageStatus() {
        if (!this.isRootPathValid()) {
            this.setPageComplete(false);
            this.setMessage(Messages.getFormattedString("error.invalidXpath", new Object[]{this.rootPath == null ? "" : this.rootPath}), 3);
        } else {
            if (this.initRootPath != null && !this.initRootPath.equals("") && !this.initRootPath.equals(this.rootPath)) {
                this.setMessage(Messages.getString("xPathChoosePage.messages.xpathChange"), 1);
            } else {
                this.setMessage(DEFAULT_MESSAGE);
            }
            this.setPageComplete(true);
        }
    }

    private boolean isRootPathValid() {
        return this.rootPath != null && this.rootPath.trim().length() != 0 && !this.rootPath.matches(".*\\Q[\\E.*\\Q]\\E.*") && !this.rootPath.matches(".*\\Q@\\E.*");
    }

    private void resetXPathText(String pathStr) {
        if (pathStr != null && pathStr.trim().length() > 0) {
            XMLInformationHolder.setPropertyValue("XPATHTEXT", pathStr);
            if (XMLInformationHolder.getPropertyValue("TABLENAME") != null) {
                String relationInfo = XMLInformationHolder.getPropertyValue("RELATIONINFORMATION");
                if (relationInfo == null || relationInfo.trim().length() == 0) {
                    return;
                }
                String tableName = XMLInformationHolder.getPropertyValue("TABLENAME");
                String infoStr = XMLRelationInfoUtil.replaceXpathExpression(tableName, relationInfo, pathStr);
                XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", infoStr);
            }
        }
    }

    public IWizardPage getNextPage() {
        if (this.isValid()) {
            IWizardPage page = super.getNextPage();
            if (page instanceof ColumnMappingPage) {
                ((ColumnMappingPage)page).refresh();
            }
            return page;
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        return this.rootPath != null && this.rootPath.trim().length() != 0;
    }

    private boolean isValid() {
        this.rootPath = this.xmlPathText.getText();
        if (!this.isRootPathValid()) {
            this.setMessage(Messages.getFormattedString("error.invalidXpath", new Object[]{this.rootPath == null ? "" : this.rootPath}), 3);
            return false;
        }
        this.resetXPathText(this.rootPath);
        return true;
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        try {
            this.savePage(design);
        }
        catch (OdaException odaException) {
            // empty catch block
        }
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) throws OdaException {
        if (dataSetDesign != null && dataSetDesign.getQueryText() != null && !dataSetDesign.getQueryText().equals(XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"))) {
            DataSetDesignPopulator.populateResultSet(dataSetDesign);
            dataSetDesign.setQueryText(XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
        }
    }

    protected boolean canLeave() {
        if (this.isInitialized) {
            return this.isValid();
        }
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }
}

