/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.computations;

import org.eclipse.birt.chart.internal.computations.Matrix;

public class MatrixDecomposition {
    private double[][] data;
    private int m;

    public MatrixDecomposition(Matrix A) {
        this.data = A.getArrayCopy();
        this.m = A.getRowDimension();
    }

    protected Matrix decomposition() {
        return this.ludecomposition();
    }

    private Matrix ludecomposition() {
        int k;
        double multiple;
        int j;
        int i;
        double[][] temp = new double[this.m][2 * this.m];
        for (i = 0; i < this.m; ++i) {
            temp[i][this.m + i] = 1.0;
            for (j = 0; j < this.m; ++j) {
                temp[i][j] = this.data[i][j];
            }
        }
        for (i = 0; i < this.m; ++i) {
            for (j = 0; j < i; ++j) {
                if (temp[i][j] == 0.0) continue;
                multiple = temp[i][j] / temp[j][j];
                for (k = 0; k < 2 * this.m; ++k) {
                    double[] dArray = temp[i];
                    int n = k;
                    dArray[n] = dArray[n] - temp[j][k] * multiple;
                }
            }
        }
        for (i = this.m - 1; i >= 0; --i) {
            for (j = this.m - 1; j > i; --j) {
                if (temp[i][j] == 0.0) continue;
                multiple = temp[i][j] / temp[j][j];
                for (k = 0; k < 2 * this.m; ++k) {
                    double[] dArray = temp[i];
                    int n = k;
                    dArray[n] = dArray[n] - temp[j][k] * multiple;
                }
            }
        }
        for (i = 0; i < this.m; ++i) {
            if (temp[i][i] == 0.0) {
                throw new IllegalArgumentException("Matrix is singular.");
            }
            if (temp[i][i] == 1.0) continue;
            double multiple2 = temp[i][i];
            int j2 = 0;
            while (j2 < 2 * this.m) {
                double[] dArray = temp[i];
                int n = j2++;
                dArray[n] = dArray[n] / multiple2;
            }
        }
        for (i = 0; i < this.m; ++i) {
            for (int j3 = 0; j3 < this.m; ++j3) {
                this.data[i][j3] = temp[i][j3 + this.m];
            }
        }
        return new Matrix(this.data, this.m, this.m);
    }
}

