/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.log;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.birt.chart.log.ILogger;

public class JavaUtilLoggerImpl
implements ILogger {
    private Logger logger;
    private Level javaLevel = Level.WARNING;

    public JavaUtilLoggerImpl(String name) {
        this.logger = Logger.getLogger(name);
        if (this.logger.getLevel() == null) {
            this.logger.setLevel(this.javaLevel);
        }
    }

    public JavaUtilLoggerImpl(String name, int verboseLevel) {
        this.logger = Logger.getLogger(name);
        this.setVerboseLevel(verboseLevel);
    }

    public Logger getJavaLogger() {
        return this.logger;
    }

    public void setVerboseLevel(int iVerboseLevel) {
        this.javaLevel = JavaUtilLoggerImpl.toJavaUtilLevel(iVerboseLevel);
        this.logger.setLevel(this.javaLevel);
    }

    public void log(int iCode, String sMessage) {
        Level level = JavaUtilLoggerImpl.toJavaUtilLevel(iCode);
        if (this.logger.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, sMessage);
            String[] rt = this.inferCaller();
            lr.setSourceClassName(rt[0]);
            lr.setSourceMethodName(rt[1]);
            this.logger.log(lr);
        }
    }

    public void log(Exception ex) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            LogRecord lr = new LogRecord(Level.SEVERE, "Exception");
            lr.setThrown(ex);
            String[] rt = this.inferCaller();
            lr.setSourceClassName(rt[0]);
            lr.setSourceMethodName(rt[1]);
            this.logger.log(lr);
        }
    }

    private String[] inferCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        String[] rt = new String[]{this.getClass().getName(), "log"};
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(this.getClass().getName()); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(this.getClass().getName())) {
                rt[0] = cname;
                rt[1] = frame.getMethodName();
                return rt;
            }
            ++ix;
        }
        return rt;
    }

    private static Level toJavaUtilLevel(int chartLevel) {
        if (chartLevel <= -1) {
            return Level.ALL;
        }
        if (chartLevel <= 0) {
            return Level.FINER;
        }
        if (chartLevel <= 1) {
            return Level.INFO;
        }
        if (chartLevel <= 2) {
            return Level.WARNING;
        }
        return Level.SEVERE;
    }
}

