/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;

public final class SwingImageCache {
    private final Panel p = new Panel();
    private final Hashtable htCache;
    private final IDisplayServer idsSWING;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swing");

    SwingImageCache(IDisplayServer idsSWING) {
        this.idsSWING = idsSWING;
        this.htCache = new Hashtable();
    }

    final Image loadImage(URL url) throws ChartException {
        Image img = (Image)this.htCache.get(url);
        if (img != null) {
            logger.log(1, Messages.getString("SwingImageCache.info.using.swing.cached.image", new Object[]{url}, this.idsSWING.getULocale()));
        } else {
            logger.log(1, Messages.getString("SwingImageCache.info.loading.swing.image", new Object[]{url}, this.idsSWING.getULocale()));
            img = new ImageIcon(url).getImage();
            try {
                MediaTracker tracker = new MediaTracker(this.p);
                tracker.addImage(img, 0);
                tracker.waitForAll();
                if ((tracker.statusAll(true) & 4) != 0) {
                    StringBuffer sb = new StringBuffer();
                    Object[] oa = tracker.getErrorsAny();
                    sb.append('[');
                    for (int i = 0; i < oa.length; ++i) {
                        sb.append(oa[i]);
                        if (i >= oa.length - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(']');
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 4, "SwingImageCache.exception.media.tracker", new Object[]{sb.toString()}, Messages.getResourceBundle(this.idsSWING.getULocale()));
                }
            }
            catch (InterruptedException ex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 4, (Throwable)ex);
            }
            this.htCache.put(url, img);
        }
        return img;
    }

    final void flush() {
        if (this.htCache.isEmpty()) {
            return;
        }
        int n = this.htCache.size();
        Enumeration eV = this.htCache.elements();
        while (eV.hasMoreElements()) {
            Image img = (Image)eV.nextElement();
            img.flush();
        }
        this.htCache.clear();
        logger.log(1, Messages.getString("SwingImageCache.info.flushed.swing.images", new Object[]{new Integer(n)}, this.idsSWING.getULocale()));
    }

    final Object getObserver() {
        return this.p;
    }
}

